/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.plain;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import org.xmind.core.IBoundary;
import org.xmind.core.IIdentifiable;
import org.xmind.core.IImage;
import org.xmind.core.INotes;
import org.xmind.core.INumbering;
import org.xmind.core.ISheet;
import org.xmind.core.ISummary;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicPath;
import org.xmind.core.IWorkbook;
import org.xmind.core.event.CoreEvent;
import org.xmind.core.event.ICoreEventListener;
import org.xmind.core.event.ICoreEventRegistration;
import org.xmind.core.event.ICoreEventSource;
import org.xmind.core.event.ICoreEventSupport;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.plain.Boundary;
import org.xmind.core.plain.Image;
import org.xmind.core.plain.MarkerRef;
import org.xmind.core.plain.Notes;
import org.xmind.core.plain.Numbering;
import org.xmind.core.plain.Sheet;
import org.xmind.core.plain.Summary;
import org.xmind.core.plain.TopicExtension;
import org.xmind.core.plain.TopicPath;
import org.xmind.core.plain.Workbook;
import org.xmind.core.util.IteratorProxy;
import org.xmind.core.util.Point;

public class Topic
implements ITopic,
ICoreEventSource {
    public static final String ExtensionAdd = "extensionAdd";
    public static final String ExtensionRemove = "extensionRemove";
    private final Workbook ownerWorkbook;
    private final String id;
    private boolean orphan;
    private String titleText;
    private int titleWidth;
    private Sheet parentSheet;
    private Topic parentTopic;
    private final Map<String, List<Topic>> topicLists;
    private String type;
    private String hyperlink;
    private String structureClass;
    private String styleId;
    private Point position;
    private boolean folded;
    private final TopicPath path;
    private final Image image;
    private final Numbering numbering;
    private final Notes notes;
    private final Set<String> labels;
    private final Map<String, MarkerRef> markerRefs;
    private final Map<String, Boundary> boundaries;
    private final Map<String, Summary> summaries;
    private final List<TopicExtension> extensions;
    private long modificationTime;
    private String modifiedBy;

    public Topic(Workbook ownerWorkbook, String id) {
        this.ownerWorkbook = ownerWorkbook;
        this.id = id;
        this.orphan = true;
        this.titleText = null;
        this.titleWidth = -1;
        this.parentSheet = null;
        this.parentTopic = null;
        this.topicLists = new HashMap<String, List<Topic>>();
        this.type = null;
        this.hyperlink = null;
        this.structureClass = null;
        this.styleId = null;
        this.position = null;
        this.folded = false;
        this.path = new TopicPath(this);
        this.image = new Image(this);
        this.numbering = new Numbering(this);
        this.notes = new Notes(this);
        this.labels = new HashSet<String>();
        this.markerRefs = new HashMap<String, MarkerRef>();
        this.boundaries = new HashMap<String, Boundary>();
        this.summaries = new HashMap<String, Summary>();
        this.extensions = new ArrayList<TopicExtension>();
        this.modifiedBy = null;
        this.modificationTime = 0L;
    }

    public String getId() {
        return this.id;
    }

    public IWorkbook getOwnedWorkbook() {
        return this.ownerWorkbook;
    }

    public boolean isOrphan() {
        return this.orphan;
    }

    public ITopic getParent() {
        return this.parentTopic;
    }

    public ISheet getOwnedSheet() {
        if (this.parentSheet != null) {
            return this.parentSheet;
        }
        return this.parentTopic == null ? null : this.parentTopic.getOwnedSheet();
    }

    protected Sheet getParentSheet() {
        return this.parentSheet;
    }

    protected Topic getParentTopic() {
        return this.parentTopic;
    }

    protected void setParent(Sheet parentSheet, Topic parentTopic, String type) {
        this.parentSheet = parentSheet;
        this.parentTopic = parentTopic;
        this.type = type;
    }

    public ICoreEventSupport getCoreEventSupport() {
        return this.ownerWorkbook.getCoreEventSupport();
    }

    public ICoreEventRegistration registerCoreEventListener(String type, ICoreEventListener listener) {
        return this.ownerWorkbook.getCoreEventSupport().registerCoreEventListener((ICoreEventSource)this, type, listener);
    }

    public void setTitleText(String titleText) {
        String oldTitleText = this.titleText;
        if (oldTitleText == titleText || oldTitleText != null && oldTitleText.equals(titleText)) {
            return;
        }
        this.titleText = titleText;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "titleText", (Object)oldTitleText, (Object)titleText);
    }

    public String getTitleText() {
        return this.titleText == null ? "" : this.titleText;
    }

    public boolean hasTitle() {
        return this.titleText != null;
    }

    public String getStyleId() {
        return this.styleId;
    }

    public void setStyleId(String styleId) {
        String oldStyleId = this.styleId;
        if (styleId == oldStyleId || styleId != null && styleId.equals(oldStyleId)) {
            return;
        }
        this.styleId = styleId;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "style", (Object)oldStyleId, (Object)styleId);
    }

    public String getStyleType() {
        return "topic";
    }

    public <T> T getAdapter(Class<T> adapter) {
        if (ICoreEventSource.class.equals(adapter)) {
            return adapter.cast(this);
        }
        if (ISheet.class.equals(adapter)) {
            return adapter.cast(this.getOwnedSheet());
        }
        if (IWorkbook.class.equals(adapter)) {
            return adapter.cast(this.ownerWorkbook);
        }
        return null;
    }

    public Set<String> getLabels() {
        return Collections.unmodifiableSet(this.labels);
    }

    public void setLabels(Collection<String> labels) {
        HashSet<String> oldLabels = new HashSet<String>(this.labels);
        HashSet<String> newLabels = new HashSet<String>(labels);
        if (oldLabels.equals(newLabels)) {
            return;
        }
        this.labels.clear();
        this.labels.addAll(labels);
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "labels", oldLabels, newLabels);
    }

    public void addLabel(String label) {
        if (label == null) {
            return;
        }
        HashSet<String> oldLabels = new HashSet<String>(this.labels);
        if (!this.labels.add(label)) {
            return;
        }
        HashSet<String> newLabels = new HashSet<String>(this.labels);
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "labels", oldLabels, newLabels);
    }

    public void removeLabel(String label) {
        if (label == null) {
            return;
        }
        HashSet<String> oldLabels = new HashSet<String>(this.labels);
        if (!this.labels.remove(label)) {
            return;
        }
        HashSet<String> newLabels = new HashSet<String>(this.labels);
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "labels", oldLabels, newLabels);
    }

    public void removeAllLabels() {
        HashSet<String> oldLabels = new HashSet<String>(this.labels);
        if (this.labels.isEmpty()) {
            return;
        }
        this.labels.clear();
        HashSet<String> newLabels = new HashSet<String>(this.labels);
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "labels", oldLabels, newLabels);
    }

    public void setPosition(int x, int y) {
        Point newPosition = new Point(x, y);
        Point oldPosition = this.copyPosition(this.position);
        if (newPosition.equals((Object)oldPosition)) {
            return;
        }
        this.position = newPosition;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "position", (Object)oldPosition, (Object)newPosition);
    }

    private Point copyPosition(Point p) {
        return p == null ? null : new Point(p.x, p.y);
    }

    public Point getPosition() {
        return this.copyPosition(this.position);
    }

    public void setPosition(Point position) {
        Point newPosition;
        Point oldPosition = this.copyPosition(this.position);
        if (oldPosition == (newPosition = this.copyPosition(position)) || oldPosition != null && oldPosition.equals((Object)newPosition)) {
            return;
        }
        this.position = newPosition;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "position", (Object)oldPosition, (Object)newPosition);
    }

    public boolean hasPosition() {
        return this.position != null;
    }

    public String getModifiedBy() {
        return this.modifiedBy;
    }

    public boolean isFolded() {
        return this.folded;
    }

    public void setFolded(boolean folded) {
        boolean oldFolded = this.folded;
        if (folded == oldFolded) {
            return;
        }
        this.folded = folded;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "topicFolded", (Object)oldFolded, (Object)folded);
    }

    public String getType() {
        return this.type;
    }

    public boolean isAttached() {
        return "attached".equals(this.type);
    }

    public List<ITopic> getAllChildren() {
        ArrayList<ITopic> allList = new ArrayList<ITopic>();
        for (List<Topic> topicList : this.topicLists.values()) {
            allList.addAll(topicList);
        }
        return allList;
    }

    public Iterator<ITopic> getAllChildrenIterator() {
        final Iterator<List<Topic>> topicListIter = this.topicLists.values().iterator();
        return new Iterator<ITopic>(){
            Iterator<Topic> topicIter;
            ITopic next;
            {
                this.topicIter = iterator.hasNext() ? ((List)iterator.next()).iterator() : null;
                this.next = this.findNext();
            }

            private ITopic findNext() {
                while (this.topicIter != null) {
                    if (this.topicIter.hasNext()) {
                        return this.topicIter.next();
                    }
                    this.topicIter = topicListIter.hasNext() ? ((List)topicListIter.next()).iterator() : null;
                }
                return null;
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException();
            }

            @Override
            public ITopic next() {
                ITopic n = this.next;
                if (n == null) {
                    throw new NoSuchElementException();
                }
                this.next = this.findNext();
                return n;
            }

            @Override
            public boolean hasNext() {
                return this.next != null;
            }
        };
    }

    public List<ITopic> getChildren(String type) {
        List<Topic> topicList = this.topicLists.get(type);
        if (topicList != null) {
            return Collections.unmodifiableList(topicList);
        }
        return Collections.emptyList();
    }

    public Iterator<ITopic> getChildrenIterator(String type) {
        List<Topic> topicList = this.topicLists.get(type);
        if (topicList != null) {
            return new IteratorProxy<ITopic>(topicList.iterator());
        }
        return new IteratorProxy<ITopic>(null);
    }

    public boolean hasChildren(String type) {
        return this.topicLists.containsKey(type);
    }

    public Set<String> getChildrenTypes() {
        return this.topicLists.keySet();
    }

    public void add(ITopic child) {
        this.add(child, -1, "attached");
    }

    public void add(ITopic child, String type) {
        this.add(child, -1, type);
    }

    public void add(ITopic child, int index, String type) {
        if (child == null || !(child instanceof Topic) || child.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        Topic childTopic = (Topic)child;
        List<Topic> topicList = this.topicLists.get(type);
        if (topicList == null) {
            topicList = new ArrayList<Topic>();
            this.topicLists.put(type, topicList);
        }
        if (index >= 0 && index < topicList.size()) {
            topicList.add(index, childTopic);
        } else {
            topicList.add(childTopic);
        }
        childTopic.setParent(null, this, type);
        if (!this.isOrphan()) {
            childTopic.onParented();
        }
        CoreEvent event = new CoreEvent((ICoreEventSource)this, "topicAdd", (Object)childTopic, index);
        event.setData((Object)type);
        this.getCoreEventSupport().dispatch((ICoreEventSource)this, event);
    }

    public void remove(ITopic child) {
        if (child == null || !(child instanceof Topic) || child.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        Topic childTopic = (Topic)child;
        String type = childTopic.getType();
        List<Topic> topicList = this.topicLists.get(type);
        if (topicList == null) {
            return;
        }
        int index = topicList.indexOf(childTopic);
        if (index < 0) {
            return;
        }
        if (!this.isOrphan()) {
            childTopic.onOrphan();
        }
        childTopic.setParent(null, null, null);
        topicList.remove(childTopic);
        CoreEvent event = new CoreEvent((ICoreEventSource)this, "topicRemove", (Object)childTopic, index);
        event.setData((Object)type);
        this.getCoreEventSupport().dispatch((ICoreEventSource)this, event);
    }

    public ITopicPath getPath() {
        return this.path;
    }

    public int getIndex() {
        if (this.parentTopic != null) {
            return this.parentTopic.getChildren(this.type).indexOf(this);
        }
        if (this.parentSheet != null) {
            return 0;
        }
        return -1;
    }

    public void setHyperlink(String hyperlink) {
        String oldHyperlink = this.hyperlink;
        if (hyperlink == oldHyperlink || hyperlink != null && hyperlink.equals(oldHyperlink)) {
            return;
        }
        this.hyperlink = hyperlink;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "topicHyperlink", (Object)oldHyperlink, (Object)hyperlink);
    }

    public String getHyperlink() {
        return this.hyperlink;
    }

    public INotes getNotes() {
        return this.notes;
    }

    public INumbering getNumbering() {
        return this.numbering;
    }

    public boolean isRoot() {
        return "root".equals(this.type);
    }

    public void addMarker(String markerId) {
        if (markerId == null) {
            return;
        }
        if (this.markerRefs.containsKey(markerId)) {
            return;
        }
        MarkerRef markerRef = new MarkerRef(this.ownerWorkbook, markerId);
        this.markerRefs.put(markerId, markerRef);
        markerRef.setParent(this);
        if (!this.isOrphan()) {
            markerRef.onParented();
        }
        this.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this, "markerRefAdd", (Object)markerId);
    }

    public void removeMarker(String markerId) {
        if (markerId == null) {
            return;
        }
        MarkerRef markerRef = this.markerRefs.get(markerId);
        if (markerRef == null) {
            return;
        }
        if (!this.isOrphan()) {
            markerRef.onOrphan();
        }
        markerRef.setParent(null);
        this.markerRefs.remove(markerId);
        this.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this, "markerRefRemove", (Object)markerId);
    }

    public boolean hasMarker(String markerId) {
        return this.markerRefs.containsKey(markerId);
    }

    public Set<IMarkerRef> getMarkerRefs() {
        return new HashSet<IMarkerRef>(this.markerRefs.values());
    }

    public void addBoundary(IBoundary boundary) {
        if (boundary == null || !(boundary instanceof Boundary) || boundary.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        Boundary b = (Boundary)boundary;
        if (this.boundaries.containsKey(b.getId())) {
            return;
        }
        this.boundaries.put(b.getId(), b);
        b.setParent(this);
        if (!this.isOrphan()) {
            b.onParented();
        }
        this.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this, "boundaryAdd", (Object)b);
    }

    public void removeBoundary(IBoundary boundary) {
        if (boundary == null || !(boundary instanceof Boundary) || boundary.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        Boundary b = (Boundary)boundary;
        if (!this.boundaries.containsKey(b.getId())) {
            return;
        }
        if (!this.isOrphan()) {
            b.onOrphan();
        }
        b.setParent(null);
        this.boundaries.remove(b.getId());
        this.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this, "boundaryRemove", (Object)b);
    }

    public Set<IBoundary> getBoundaries() {
        return new HashSet<IBoundary>(this.boundaries.values());
    }

    public void addSummary(ISummary summary) {
        if (summary == null || !(summary instanceof Summary) || summary.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        Summary s = (Summary)summary;
        if (this.summaries.containsKey(s.getId())) {
            return;
        }
        this.summaries.put(s.getId(), s);
        s.setParent(this);
        if (!this.isOrphan()) {
            s.onParented();
        }
        this.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this, "summaryAdd", (Object)s);
    }

    public void removeSummary(ISummary summary) {
        if (summary == null || !(summary instanceof Summary) || summary.getOwnedWorkbook() != this.getOwnedWorkbook()) {
            throw new IllegalArgumentException();
        }
        Summary s = (Summary)summary;
        if (!this.summaries.containsKey(s.getId())) {
            return;
        }
        if (!this.isOrphan()) {
            s.onOrphan();
        }
        s.setParent(null);
        this.summaries.remove(s.getId());
        this.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this, "summaryRemove", (Object)s);
    }

    public Set<ISummary> getSummaries() {
        return new HashSet<ISummary>(this.summaries.values());
    }

    public String getStructureClass() {
        return this.structureClass;
    }

    public void setStructureClass(String structureClass) {
        String oldStructureClass = this.structureClass;
        if (structureClass == oldStructureClass || structureClass != null && structureClass.equals(oldStructureClass)) {
            return;
        }
        this.structureClass = structureClass;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "structureClass", (Object)oldStructureClass, (Object)structureClass);
    }

    public IImage getImage() {
        return this.image;
    }

    public int getTitleWidth() {
        return this.titleWidth;
    }

    public void setTitleWidth(int width) {
        int oldWidth = this.titleWidth;
        if (width == oldWidth) {
            return;
        }
        this.titleWidth = width;
        this.getCoreEventSupport().dispatchValueChange((ICoreEventSource)this, "titleWidth", (Object)oldWidth, (Object)width);
    }

    public List<ITopicExtension> getExtensions() {
        return Collections.unmodifiableList(this.extensions);
    }

    public ITopicExtension getExtension(String providerName) {
        if (providerName == null) {
            return null;
        }
        for (TopicExtension extension : this.extensions) {
            if (!providerName.equals(extension.getProviderName())) continue;
            return extension;
        }
        return null;
    }

    public ITopicExtension createExtension(String providerName) {
        if (providerName == null) {
            throw new IllegalArgumentException();
        }
        TopicExtension extension = null;
        for (TopicExtension ext : this.extensions) {
            if (!providerName.equals(ext.getProviderName())) continue;
            extension = ext;
            break;
        }
        if (extension == null) {
            extension = new TopicExtension(this, providerName);
            this.extensions.add(extension);
            if (!this.isOrphan()) {
                extension.onParented();
            }
            this.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this, ExtensionAdd, (Object)extension);
        }
        return extension;
    }

    public void deleteExtension(String providerName) {
        if (providerName == null) {
            return;
        }
        Iterator<TopicExtension> extIt = this.extensions.iterator();
        while (extIt.hasNext()) {
            TopicExtension ext = extIt.next();
            if (!providerName.equals(ext.getProviderName())) continue;
            if (!this.isOrphan()) {
                ext.onOrphan();
            }
            extIt.remove();
            this.getCoreEventSupport().dispatchTargetChange((ICoreEventSource)this, ExtensionRemove, (Object)ext);
            break;
        }
    }

    public long getModifiedTime() {
        return this.modificationTime;
    }

    protected void onParented() {
        this.orphan = false;
        this.ownerWorkbook.getObjectRegistry().register(this);
        this.notes.onParented();
        for (MarkerRef markerRef : this.markerRefs.values()) {
            markerRef.onParented();
        }
        for (Boundary boundary : this.boundaries.values()) {
            boundary.onParented();
        }
        for (Summary summary : this.summaries.values()) {
            summary.onParented();
        }
        for (TopicExtension ext : this.extensions) {
            ext.onParented();
        }
        for (String type : this.topicLists.keySet()) {
            for (Topic child : this.topicLists.get(type)) {
                child.onParented();
            }
        }
    }

    protected void onOrphan() {
        for (String type : this.topicLists.keySet()) {
            for (Topic child : this.topicLists.get(type)) {
                child.onOrphan();
            }
        }
        for (TopicExtension ext : this.extensions) {
            ext.onOrphan();
        }
        for (Summary summary : this.summaries.values()) {
            summary.onOrphan();
        }
        for (Boundary boundary : this.boundaries.values()) {
            boundary.onOrphan();
        }
        for (MarkerRef markerRef : this.markerRefs.values()) {
            markerRef.onOrphan();
        }
        this.notes.onOrphan();
        this.ownerWorkbook.getObjectRegistry().unregister((IIdentifiable)this);
        this.orphan = true;
    }
}

