/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.internal.gallery;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Assert;
import org.xmind.core.internal.gallery.DownloadedGalleryGroup;
import org.xmind.core.internal.gallery.GalleryCore;
import org.xmind.core.internal.gallery.IGalleryGroup;
import org.xmind.core.internal.gallery.IGalleryItem;
import org.xmind.core.internal.gallery.LocalGalleryGroup;
import org.xmind.core.internal.gallery.LocalGalleryItem;

public class GalleryItemPropertyTester
extends PropertyTester {
    private static final String PROP_GROUP = "group";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof LocalGalleryItem) {
            LocalGalleryItem item = (LocalGalleryItem)receiver;
            if (PROP_GROUP.equals(property)) {
                return this.matchGroup(item, expectedValue) && !item.getFile().getAbsolutePath().contains("org.xmind.ui.gallery.resources");
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private boolean matchGroup(IGalleryItem item, Object value) {
        IGalleryGroup group = item.getParent();
        if (group == null) {
            return "none".equals(value);
        }
        if (group instanceof LocalGalleryGroup) {
            return GalleryCore.getInstance().getUserGalleryGroups().contains(group);
        }
        if (group instanceof DownloadedGalleryGroup) {
            return ("downloaded:" + ((DownloadedGalleryGroup)group).getSymbolicName()).equals(value);
        }
        return false;
    }
}

