/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.spelling;

import com.swabunga.spell.event.SpellCheckEvent;
import com.swabunga.spell.event.SpellCheckListener;
import com.swabunga.spell.event.SpellChecker;
import com.swabunga.spell.event.StringWordTokenizer;
import com.swabunga.spell.event.WordTokenizer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.text.ITextListener;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.TextEvent;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.xmind.ui.internal.spelling.ISpellCheckerVisitor;
import org.xmind.ui.internal.spelling.Messages;
import org.xmind.ui.internal.spelling.SpellCheckerAgent;
import org.xmind.ui.texteditor.IControlContentAdapter2;
import org.xmind.ui.texteditor.IMenuContributor;
import org.xmind.ui.texteditor.ISpellingActivation;
import org.xmind.ui.texteditor.ISpellingSupport;
import org.xmind.ui.texteditor.StyledTextContentAdapter;

public class SpellingHelper
implements ISpellingActivation,
Listener,
ITextListener {
    private static final long CHECK_DELAY = 200L;
    private ISpellingSupport support;
    private ITextViewer viewer;
    private Control control;
    private IControlContentAdapter2 contentAdapter;
    private SpellChecker spellChecker;
    private Map<Integer, SpellCheckEvent> ranges = new HashMap<Integer, SpellCheckEvent>();
    private SpellingMenuContributor contributor;
    private CheckJob job = null;
    private boolean disposed = false;
    private static Map<Integer, Line> lineCache = new HashMap<Integer, Line>();
    private ISpellCheckerVisitor visitor = null;

    public SpellingHelper(ISpellingSupport support, ITextViewer viewer) {
        this.support = support;
        this.viewer = viewer;
        this.control = viewer.getTextWidget();
        this.contentAdapter = new StyledTextContentAdapter();
        this.init(viewer);
    }

    public SpellingHelper(ISpellingSupport support, Control control, IControlContentAdapter2 adapter) {
        this.support = support;
        this.viewer = null;
        this.control = control;
        this.contentAdapter = adapter;
        this.init(control);
    }

    private void init(ITextViewer viewer) {
        viewer.addTextListener((ITextListener)this);
        this.init();
    }

    private void init(Control control) {
        control.addListener(24, (Listener)this);
        this.init();
    }

    private void init() {
        this.control.addListener(9, (Listener)this);
        this.control.addListener(12, (Listener)this);
        final Display display = Display.getCurrent();
        this.visitor = new ISpellCheckerVisitor(){

            public void handleWith(SpellChecker spellChecker) {
                if (SpellingHelper.this.control == null || SpellingHelper.this.control.isDisposed() || SpellingHelper.this.disposed) {
                    return;
                }
                SpellingHelper.this.spellChecker = spellChecker;
                SpellingHelper.this.check(display);
            }
        };
        SpellCheckerAgent.visitSpellChecker(this.visitor);
        SpellCheckerAgent.addListener(this.visitor);
    }

    private void addToDict(final Display display, final SpellCheckEvent range) {
        SpellCheckerAgent.visitSpellChecker(new ISpellCheckerVisitor(){

            public void handleWith(SpellChecker spellChecker) {
                if (!SpellingHelper.this.isActive()) {
                    return;
                }
                spellChecker.addToDictionary(range.getInvalidWord());
                SpellingHelper.this.check(display);
            }
        });
    }

    private void paintSpellError(GC gc) {
        if (this.ranges.isEmpty()) {
            return;
        }
        int lineStyle = gc.getLineStyle();
        int lineWidth = gc.getLineWidth();
        Color lineColor = gc.getForeground();
        gc.setLineWidth(2);
        gc.setLineStyle(3);
        gc.setForeground(gc.getDevice().getSystemColor(3));
        int charCount = this.contentAdapter.getControlContents(this.control).length();
        Rectangle clipping = gc.getClipping();
        lineCache.clear();
        Object[] objectArray = this.ranges.values().toArray();
        int n = objectArray.length;
        int n2 = 0;
        while (n2 < n) {
            int length;
            Object obj = objectArray[n2];
            SpellCheckEvent range = (SpellCheckEvent)obj;
            int start = range.getWordContextPosition();
            if (start >= 0 && start < charCount && (length = Math.min(range.getInvalidWord().length(), charCount - start)) > 0) {
                this.drawLines(gc, start, start + length - 1, clipping);
            }
            ++n2;
        }
        gc.setLineWidth(lineWidth);
        gc.setLineStyle(lineStyle);
        gc.setForeground(lineColor);
    }

    private void drawLines(GC gc, int start, int end, Rectangle clipping) {
        Line startLine = this.getLine(gc, start);
        Line endLine = this.getLine(gc, end);
        if (startLine.y == endLine.y) {
            gc.drawLine(startLine.x1, startLine.y, endLine.x2, endLine.y);
        } else if (start < end) {
            int mid = (start + end) / 2;
            this.drawLines(gc, start, mid, clipping);
            if (mid < end) {
                this.drawLines(gc, mid + 1, end, clipping);
            }
        }
    }

    private Line getLine(GC gc, int offset) {
        Line p = lineCache.get(offset);
        if (p == null) {
            p = new Line();
            Point loc = this.contentAdapter.getLocationAtOffset(this.control, offset + 1);
            int h = this.contentAdapter.getLineHeightAtOffset(this.control, offset + 1);
            p.y = loc.y + h - 1;
            p.x2 = loc.x;
            p.x1 = p.x2 - gc.stringExtent((String)this.contentAdapter.getControlContents((Control)this.control, (int)offset, (int)1)).x;
            lineCache.put(offset, p);
        }
        return p;
    }

    private void check(Display display) {
        if (!this.isActive()) {
            return;
        }
        if (this.job == null) {
            this.job = new CheckJob();
        }
        this.job.check(display);
    }

    public void handleEvent(Event event) {
        if (this.control.isDisposed()) {
            return;
        }
        int type = event.type;
        switch (type) {
            case 24: {
                this.handleTextModified(event);
                break;
            }
            case 9: {
                this.paintSpellError(event.gc);
                break;
            }
            case 12: {
                this.handleWidgetDispose();
            }
        }
    }

    public ISpellingSupport getSpellingSupport() {
        return this.support;
    }

    public boolean isActive() {
        return !this.disposed && this.spellChecker != null && this.control != null && !this.control.isDisposed();
    }

    public Object getAdapter(Class adapter) {
        if (adapter == IMenuContributor.class) {
            if (this.contributor == null) {
                this.contributor = new SpellingMenuContributor();
            }
            return this.contributor;
        }
        return null;
    }

    private void handleTextModified(Event event) {
        this.check(event.display);
    }

    private void handleWidgetDispose() {
        this.deactivate();
    }

    private void deactivate() {
        SpellCheckerAgent.removeListener(this.visitor);
        if (this.viewer != null) {
            this.viewer.removeTextListener((ITextListener)this);
            this.viewer = null;
        }
        if (this.control != null && !this.control.isDisposed()) {
            this.control.removeListener(24, (Listener)this);
            this.control.removeListener(9, (Listener)this);
            this.control.removeListener(12, (Listener)this);
            this.redraw(this.control.getDisplay());
            this.control = null;
        }
        if (this.job != null) {
            this.job.dispose();
            this.job = null;
        }
        this.ranges.clear();
    }

    void dispose() {
        this.deactivate();
        this.disposed = true;
    }

    private void redraw(Display display) {
        display.asyncExec(new Runnable(){

            public void run() {
                if (SpellingHelper.this.control != null && !SpellingHelper.this.control.isDisposed()) {
                    SpellingHelper.this.control.redraw();
                }
            }
        });
    }

    public void textChanged(TextEvent event) {
        this.check(Display.getCurrent());
    }

    static /* synthetic */ void access$5(SpellingHelper spellingHelper, Display display) {
        spellingHelper.redraw(display);
    }

    static /* synthetic */ SpellChecker access$6(SpellingHelper spellingHelper) {
        return spellingHelper.spellChecker;
    }

    private class CheckJob
    extends Job
    implements SpellCheckListener {
        private Display display;
        private long start;
        private boolean rescheduling;

        public CheckJob() {
            super(Messages.spellCheckProgress_Text);
            this.start = -1L;
            this.rescheduling = false;
            this.setSystem(true);
        }

        public synchronized void check(Display display) {
            if (display == null || display.isDisposed() || !SpellingHelper.this.isActive()) {
                return;
            }
            if (this.start == -1L) {
                this.display = display;
                this.schedule();
            } else if (this.start == -2L) {
                this.rescheduling = true;
            } else {
                this.start = System.currentTimeMillis();
            }
        }

        public void dispose() {
            this.rescheduling = false;
            this.cancel();
        }

        protected IStatus run(IProgressMonitor monitor) {
            try {
                IStatus iStatus = this.doRun(monitor);
                return iStatus;
            }
            finally {
                this.start = -1L;
                if (this.rescheduling) {
                    this.rescheduling = false;
                    this.schedule();
                }
            }
        }

        /*
         * Unable to fully structure code
         */
        protected IStatus doRun(final IProgressMonitor monitor) {
            this.start = System.currentTimeMillis();
            if (monitor.isCanceled() || this.display.isDisposed() || !SpellingHelper.this.isActive()) {
                return Status.CANCEL_STATUS;
            }
            context = new String[1];
            this.display.syncExec(new Runnable(){

                public void run() {
                    if (monitor.isCanceled() || CheckJob.this.display.isDisposed() || !SpellingHelper.this.isActive()) {
                        return;
                    }
                    context[0] = SpellingHelper.this.contentAdapter.getControlContents(SpellingHelper.this.control);
                }
            });
            if (monitor.isCanceled() || this.display.isDisposed() || !SpellingHelper.this.isActive()) {
                return Status.CANCEL_STATUS;
            }
            if (context[0] != null && !"".equals(context[0])) ** GOTO lbl20
            if (!SpellingHelper.access$4(SpellingHelper.this).isEmpty()) {
                SpellingHelper.access$4(SpellingHelper.this).clear();
                SpellingHelper.access$5(SpellingHelper.this, this.display);
            }
            return Status.OK_STATUS;
lbl-1000:
            // 1 sources

            {
                if (monitor.isCanceled() || this.display.isDisposed() || !SpellingHelper.this.isActive()) {
                    return Status.CANCEL_STATUS;
                }
                try {
                    Thread.sleep(1L);
                    continue;
                }
                catch (InterruptedException v0) {
                    return Status.CANCEL_STATUS;
                }
lbl20:
                // 2 sources

                ** while (System.currentTimeMillis() < this.start + 200L)
            }
lbl21:
            // 1 sources

            this.start = -2L;
            if (monitor.isCanceled() || this.display.isDisposed() || !SpellingHelper.this.isActive()) {
                return Status.CANCEL_STATUS;
            }
            this.display.syncExec(new Runnable(){

                public void run() {
                    if (monitor.isCanceled() || CheckJob.this.display.isDisposed() || !SpellingHelper.this.isActive()) {
                        return;
                    }
                    context[0] = SpellingHelper.this.contentAdapter.getControlContents(SpellingHelper.this.control);
                }
            });
            if (monitor.isCanceled() || this.display.isDisposed() || !SpellingHelper.this.isActive()) {
                return Status.CANCEL_STATUS;
            }
            if (context[0] != null) {
                SpellingHelper.access$4(SpellingHelper.this).clear();
                if (!"".equals(context[0])) {
                    theSpellChecker = SpellingHelper.access$6(SpellingHelper.this);
                    theSpellChecker.addSpellCheckListener((SpellCheckListener)this);
                    theSpellChecker.checkSpelling((WordTokenizer)new StringWordTokenizer(context[0]));
                    theSpellChecker.removeSpellCheckListener((SpellCheckListener)this);
                }
                if (monitor.isCanceled() || this.display.isDisposed() || !SpellingHelper.this.isActive()) {
                    return Status.CANCEL_STATUS;
                }
                SpellingHelper.access$5(SpellingHelper.this, this.display);
            }
            return Status.OK_STATUS;
        }

        public void spellingError(SpellCheckEvent event) {
            int start = event.getWordContextPosition();
            SpellingHelper.this.ranges.put(start, event);
        }
    }

    private static class Line {
        int x1;
        int x2;
        int y;

        private Line() {
        }
    }

    private class NewWordAction
    extends Action {
        private SpellCheckEvent range;

        public NewWordAction(SpellCheckEvent range) {
            super(Messages.addToDictionary);
            this.range = range;
        }

        public void run() {
            SpellingHelper.this.addToDict(Display.getCurrent(), this.range);
        }
    }

    private static class NoSuggestionAction
    extends Action {
        public NoSuggestionAction() {
            super(Messages.noSpellSuggestion);
            this.setEnabled(false);
        }
    }

    private class SpellingMenuContributor
    implements IMenuContributor {
        private SpellingMenuContributor() {
        }

        private SpellCheckEvent getCurrentRange() {
            int pos = SpellingHelper.this.contentAdapter.getCursorPosition(SpellingHelper.this.control);
            for (Map.Entry en : SpellingHelper.this.ranges.entrySet()) {
                SpellCheckEvent range = (SpellCheckEvent)en.getValue();
                int start = (Integer)en.getKey();
                int length = range.getInvalidWord().length();
                if (start > pos || pos > start + length) continue;
                return range;
            }
            return null;
        }

        public void fillMenu(IMenuManager menu) {
            SpellCheckEvent range = this.getCurrentRange();
            if (range != null) {
                List list = range.getSuggestions();
                if (list.isEmpty()) {
                    menu.add((IAction)new NoSuggestionAction());
                } else {
                    for (Object o : list) {
                        String suggestion = o.toString();
                        menu.add((IAction)new SuggestionAction(range, suggestion));
                    }
                }
                menu.add((IContributionItem)new Separator());
                menu.add((IAction)new NewWordAction(range));
            }
        }
    }

    private class SuggestionAction
    extends Action {
        private SpellCheckEvent range;
        private String suggestion;

        public SuggestionAction(SpellCheckEvent range, String suggestion) {
            super(String.valueOf(range.getInvalidWord()) + " -> " + suggestion);
            this.range = range;
            this.suggestion = suggestion;
        }

        public void run() {
            if (!SpellingHelper.this.isActive()) {
                return;
            }
            String old = SpellingHelper.this.contentAdapter.getControlContents(SpellingHelper.this.control);
            int oldLength = old.length();
            int start = this.range.getWordContextPosition();
            String invalidWord = this.range.getInvalidWord();
            int invalidLength = invalidWord.length();
            if (start < oldLength && start + invalidLength <= oldLength) {
                SpellingHelper.this.contentAdapter.replaceControlContents(SpellingHelper.this.control, start, invalidLength, this.suggestion);
                SpellingHelper.this.check(Display.getCurrent());
            }
        }
    }
}

