/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.styleeditor;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Assert;
import org.xmind.ui.internal.styleeditor.StyleEditModel;

public class StyleEditModelPropertyTester
extends PropertyTester {
    private static final String PROP_CAN_UNDO = "canUndo";
    private static final String PROP_CAN_REDO = "canRedo";

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof StyleEditModel) {
            if (PROP_CAN_UNDO.equals(property)) {
                return this.matchCanUndo((StyleEditModel)receiver, expectedValue);
            }
            if (PROP_CAN_REDO.equals(property)) {
                return this.matchCanRedo((StyleEditModel)receiver, expectedValue);
            }
        }
        Assert.isTrue((boolean)false);
        return false;
    }

    private boolean matchCanUndo(StyleEditModel model, Object value) {
        boolean canUndo = model.canUndo();
        if (value == null) {
            return canUndo;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value) == canUndo;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == canUndo;
        }
        return false;
    }

    private boolean matchCanRedo(StyleEditModel model, Object value) {
        boolean canRedo = model.canRedo();
        if (value == null) {
            return canRedo;
        }
        if (value instanceof String) {
            return Boolean.parseBoolean((String)value) == canRedo;
        }
        if (value instanceof Boolean) {
            return (Boolean)value == canRedo;
        }
        return false;
    }
}

