/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.net.internal;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.xmind.core.net.http.HttpException;
import org.xmind.core.net.http.HttpRequest;

public class FixedLengthInputStream
extends FilterInputStream {
    private final HttpRequest request;
    private final long expectedCount;
    private long actualCount;

    public FixedLengthInputStream(InputStream in, HttpRequest request, long expectedCount) {
        super(in);
        this.request = request;
        this.expectedCount = expectedCount;
        this.actualCount = 0L;
    }

    @Override
    public int read() throws IOException {
        if (this.actualCount >= this.expectedCount) {
            return -1;
        }
        int b = this.in.read();
        if (b < 0) {
            if (this.actualCount < this.expectedCount) {
                throw new HttpException(this.request, 4, "Insufficient data received", null);
            }
            return b;
        }
        ++this.actualCount;
        return b;
    }

    @Override
    public int read(byte[] b) throws IOException {
        if (this.actualCount >= this.expectedCount) {
            return -1;
        }
        int num = this.in.read(b);
        if (num < 0) {
            if (this.actualCount < this.expectedCount) {
                throw new HttpException(this.request, 4, "Insufficient data received", null);
            }
            return num;
        }
        long oldCount = this.actualCount;
        this.actualCount = Math.min(this.actualCount + (long)num, this.expectedCount);
        return (int)(this.actualCount - oldCount);
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        if (this.actualCount >= this.expectedCount) {
            return -1;
        }
        int num = this.in.read(b, off, len);
        if (num < 0) {
            if (this.actualCount < this.expectedCount) {
                throw new HttpException(this.request, 4, "Insufficient data received", null);
            }
            return num;
        }
        long oldCount = this.actualCount;
        this.actualCount = Math.min(this.actualCount + (long)num, this.expectedCount);
        return (int)(this.actualCount - oldCount);
    }

    @Override
    public int available() throws IOException {
        int num = super.available();
        if (num < 0) {
            return num;
        }
        return Math.min(num, (int)(this.expectedCount - this.actualCount));
    }
}

