/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.audio.internal;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.xmind.core.audio.IAudioDevice;
import org.xmind.core.audio.internal.CoreAudioPlugin;
import org.xmind.core.audio.internal.CoreAudioService;

public class AudioDeviceManager {
    private static final String EXT_AUDIO_DEVICES = "devices";
    private static final String TAG_AUDIO_DEVICE = "device";
    private static final String ATT_ID = "id";
    private static final String ATT_CLASS = "class";
    private static final AudioDeviceManager instance = new AudioDeviceManager();
    private Map<String, AudioDeviceDescriptor> deviceDescriptors;

    private AudioDeviceManager() {
    }

    private AudioDeviceDescriptor getDeviceDescriptor(String deviceId) {
        this.ensureLoaded();
        return this.deviceDescriptors.get(deviceId);
    }

    private void ensureLoaded() {
        if (this.deviceDescriptors != null) {
            return;
        }
        this.lazyLoad();
        if (this.deviceDescriptors == null) {
            this.deviceDescriptors = Collections.emptyMap();
        }
    }

    private void lazyLoad() {
        if (Platform.isRunning()) {
            IExtension[] extensions;
            IExtensionPoint extensionPoint = Platform.getExtensionRegistry().getExtensionPoint("org.xmind.core.audio", EXT_AUDIO_DEVICES);
            if (extensionPoint == null) {
                return;
            }
            IExtension[] iExtensionArray = extensions = extensionPoint.getExtensions();
            int n = extensions.length;
            int n2 = 0;
            while (n2 < n) {
                IExtension extension = iExtensionArray[n2];
                this.readExtension(extension);
                ++n2;
            }
        }
    }

    private void readExtension(IExtension extension) {
        IConfigurationElement[] elements;
        IConfigurationElement[] iConfigurationElementArray = elements = extension.getConfigurationElements();
        int n = elements.length;
        int n2 = 0;
        while (n2 < n) {
            IConfigurationElement element = iConfigurationElementArray[n2];
            this.readElement(element);
            ++n2;
        }
    }

    private void readElement(IConfigurationElement element) {
        String name = element.getName();
        if (TAG_AUDIO_DEVICE.equals(name)) {
            this.readAudioDevice(element);
        }
    }

    private void readAudioDevice(IConfigurationElement element) {
        String id = element.getAttribute(ATT_ID);
        if (id == null) {
            return;
        }
        String clazz = element.getAttribute(ATT_CLASS);
        if (clazz == null) {
            return;
        }
        this.registerDescriptor(new AudioDeviceDescriptor(id, element));
    }

    private void registerDescriptor(AudioDeviceDescriptor descriptor) {
        if (this.deviceDescriptors == null) {
            this.deviceDescriptors = new HashMap<String, AudioDeviceDescriptor>();
        }
        this.deviceDescriptors.put(descriptor.getId(), descriptor);
    }

    public IAudioDevice getDevice(String deviceId, CoreAudioService service) {
        AudioDeviceDescriptor descriptor = this.getDeviceDescriptor(deviceId);
        if (descriptor == null) {
            return null;
        }
        IAudioDevice device = descriptor.getDeviceInstance();
        if (device == null) {
            return null;
        }
        service.installDevice(deviceId, device);
        return device;
    }

    public static AudioDeviceManager getInstance() {
        return instance;
    }

    private static class AudioDeviceDescriptor {
        private String id;
        private IConfigurationElement element;
        private IAudioDevice instance;
        private boolean failed = false;

        public AudioDeviceDescriptor(String id, IConfigurationElement element) {
            this.id = id;
            this.element = element;
        }

        public String getId() {
            return this.id;
        }

        public IAudioDevice getDeviceInstance() {
            if (this.instance == null && !this.failed) {
                this.instance = this.createInstance();
                if (this.instance == null) {
                    this.failed = true;
                }
            }
            return this.instance;
        }

        private IAudioDevice createInstance() {
            try {
                return (IAudioDevice)this.element.createExecutableExtension(AudioDeviceManager.ATT_CLASS);
            }
            catch (Throwable e) {
                CoreAudioPlugin.getDefault().getLog().log((IStatus)new Status(4, this.element.getNamespaceIdentifier(), "Unable to create audio device.", e));
                return null;
            }
        }
    }
}

