/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.presentation.slide;

import java.util.List;
import net.xmind.verify.ui.VerifyUI20141031;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.menus.IWorkbenchContribution;
import org.eclipse.ui.services.IServiceLocator;
import org.xmind.core.IWorkbook;
import org.xmind.gef.IViewer;
import org.xmind.gef.ui.editor.IGraphicalEditor;
import org.xmind.ui.internal.MindMapUIPlugin;
import org.xmind.ui.internal.editor.IEditorLayout;
import org.xmind.ui.internal.editor.IEditorLayoutManager;
import org.xmind.ui.internal.presentation.PresentationMessages;
import org.xmind.ui.internal.presentation.slide.PresentationEditorLayout;
import org.xmind.ui.internal.presentation.slide.PresentationStory;
import org.xmind.ui.internal.presentation.slide.PresentationStoryManager;

public class StoryMenu2
extends ContributionItem
implements IWorkbenchContribution {
    private IWorkbenchWindow window;

    public boolean isDynamic() {
        return true;
    }

    public void fill(Menu menu, int index) {
        MenuManager manager = new MenuManager();
        this.fillMenu(manager);
        IContributionItem[] items = manager.getItems();
        if (items.length > 0) {
            int i = 0;
            while (i < items.length) {
                items[i].fill(menu, index++);
                ++i;
            }
        }
    }

    public void fillMenu(MenuManager menuManager) {
        IWorkbook workbook = this.getWorkbook();
        IWorkbenchPage page = this.window.getActivePage();
        if (workbook != null) {
            List<PresentationStory> stories = PresentationStoryManager.instance.getStories(workbook);
            for (PresentationStory story : stories) {
                String name = story.getName();
                if (name == null || "".equals(name)) continue;
                menuManager.add((IAction)new StoryAction(story, page));
            }
            if (!stories.isEmpty()) {
                menuManager.add((IContributionItem)new Separator());
            }
        }
    }

    private IWorkbook getWorkbook() {
        if (this.window == null) {
            return null;
        }
        IWorkbenchPage page = this.window.getActivePage();
        if (page == null) {
            return null;
        }
        IEditorPart editor = page.getActiveEditor();
        if (editor == null) {
            return null;
        }
        IViewer viewer = (IViewer)MindMapUIPlugin.getAdapter((Object)editor, IViewer.class);
        if (viewer == null) {
            return null;
        }
        return (IWorkbook)viewer.getAdapter(IWorkbook.class);
    }

    public void initialize(IServiceLocator serviceLocator) {
        this.window = (IWorkbenchWindow)serviceLocator.getService(IWorkbenchWindow.class);
    }

    private static class StoryAction
    extends Action {
        private PresentationStory story;
        private IWorkbenchPage page;

        public StoryAction(PresentationStory story, IWorkbenchPage page) {
            this.story = story;
            this.page = page;
            this.setText(story.getName());
        }

        public void run() {
            VerifyUI20141031.runAction20141031((String)"StoryPresentation", (String)PresentationMessages.ShowPresentationAction_name, (int)3, (Runnable)new Runnable(){

                public void run() {
                    IEditorPart editor = StoryAction.this.page.getActiveEditor();
                    if (editor instanceof IGraphicalEditor && StoryAction.this.story != null) {
                        IEditorLayoutManager layoutManager = (IEditorLayoutManager)editor.getAdapter(IEditorLayoutManager.class);
                        IEditorLayout currentEditorLayout = layoutManager.getActiveLayout();
                        if (currentEditorLayout instanceof PresentationEditorLayout) {
                            PresentationEditorLayout layout = (PresentationEditorLayout)currentEditorLayout;
                            layout.setCurrentStory(StoryAction.this.story);
                        } else {
                            layoutManager.restoreDefault();
                            PresentationEditorLayout layout = new PresentationEditorLayout(layoutManager, StoryAction.this.story, (IGraphicalEditor)editor);
                            layout.setSelectionProvider(editor.getSite().getSelectionProvider());
                            layoutManager.setActiveLayout((IEditorLayout)layout);
                        }
                    }
                }
            }, null);
        }
    }
}

