/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.gef.draw2d.geometry;

import org.xmind.gef.draw2d.geometry.AbstractPrecisionTransformer;
import org.xmind.gef.draw2d.geometry.PrecisionDimension;
import org.xmind.gef.draw2d.geometry.PrecisionInsets;
import org.xmind.gef.draw2d.geometry.PrecisionPoint;
import org.xmind.gef.draw2d.geometry.PrecisionPolygon;
import org.xmind.gef.draw2d.geometry.PrecisionRectangle;

public class PrecisionRotator
extends AbstractPrecisionTransformer {
    private static final PrecisionPoint P = new PrecisionPoint();
    private static final PrecisionDimension D = new PrecisionDimension();
    private static final PrecisionRectangle R = new PrecisionRectangle();
    private double angle = 0.0;
    private double sin = 0.0;
    private double cos = 1.0;
    double cos2a = 1.0;

    public PrecisionRotator() {
    }

    public PrecisionRotator(PrecisionPoint origin) {
        this.setOrigin(origin);
    }

    public double cos() {
        return this.cos;
    }

    public double getAngle() {
        return this.angle;
    }

    public void setAngle(double angle) {
        this.angle = angle;
        double rad = Math.toRadians(angle);
        this.sin = Math.sin(rad);
        this.cos = Math.cos(rad);
        this.cos2a = Math.cos(rad * 2.0);
    }

    public double sin() {
        return this.sin;
    }

    public PrecisionDimension t(PrecisionDimension d) {
        if (this.isEnabled()) {
            double width = this.tWidth(d.width, d.height);
            d.height = this.tHeight(d.width, d.height);
            d.width = width;
        }
        return d;
    }

    public double tWidth(double w, double h) {
        return Math.abs(w * this.cos) + Math.abs(h * this.sin);
    }

    public double tHeight(double w, double h) {
        return Math.abs(w * this.sin) + Math.abs(h * this.cos);
    }

    public PrecisionInsets t(PrecisionInsets i) {
        if (this.isEnabled()) {
            double x0 = this.getOrigin().x;
            double y0 = this.getOrigin().y;
            PrecisionRectangle r = this.t(R.setBounds(x0 - i.left, y0 - i.top, i.getWidth(), i.getHeight()));
            i.top = y0 - r.y;
            i.left = x0 - r.x;
            i.bottom = r.bottom() - y0;
            i.right = r.right() - x0;
        }
        return i;
    }

    public PrecisionPoint t(PrecisionPoint p) {
        if (this.isEnabled()) {
            double ox = this.getOrigin().x;
            double oy = this.getOrigin().y;
            double dx = p.x - ox;
            double dy = p.y - oy;
            p.x = ox + dx * this.cos - dy * this.sin;
            p.y = oy + dx * this.sin + dy * this.cos;
        }
        return p;
    }

    public PrecisionRectangle t(PrecisionRectangle r) {
        if (this.isEnabled()) {
            PrecisionPoint c = this.t(P.setLocation(r.x + r.width * 0.5, r.y + r.height * 0.5));
            PrecisionDimension d = this.t(D.setSize(r.width, r.height));
            r.x = c.x - d.width / 2.0;
            r.y = c.y - d.height / 2.0;
            r.width = d.width;
            r.height = d.height;
        }
        return r;
    }

    public PrecisionPolygon tPolygon(PrecisionRectangle r) {
        PrecisionPolygon polygon = PrecisionPolygon.createFromRect(r);
        int i = 0;
        while (i < polygon.size()) {
            polygon.setPoint(this.t(polygon.getPoint(i)), i);
            ++i;
        }
        return polygon;
    }

    public PrecisionDimension r(PrecisionDimension d) {
        return this.r(d, -1.0, -1.0);
    }

    public PrecisionDimension r(PrecisionDimension d, double wHint, double hHint) {
        if (this.isEnabled()) {
            double w;
            double h;
            if (this.cos2a == 0.0) {
                h = hHint;
                w = wHint;
                if (d.width == d.height) {
                    double diag = Math.abs(d.width / this.sin);
                    if (hHint > 0.0 && wHint < 0.0) {
                        w = diag - h;
                    } else if (wHint > 0.0 && hHint < 0.0) {
                        h = diag - w;
                    } else if (wHint < 0.0 && hHint < 0.0) {
                        w = h = diag / 2.0;
                    }
                }
            } else {
                w = (d.width * Math.abs(this.cos) - d.height * Math.abs(this.sin)) / this.cos2a;
                h = (d.height * Math.abs(this.cos) - d.width * Math.abs(this.sin)) / this.cos2a;
            }
            d.width = w;
            d.height = h;
        }
        return d;
    }

    public PrecisionInsets r(PrecisionInsets i) {
        return this.r(i, -1.0, -1.0);
    }

    public PrecisionInsets r(PrecisionInsets i, double wHint, double hHint) {
        if (this.isEnabled()) {
            double ox = this.getOrigin().x;
            double oy = this.getOrigin().y;
            PrecisionRectangle r = this.r(R.setBounds(ox - i.left, oy - i.top, i.getWidth(), i.getHeight()), wHint, hHint);
            i.top = oy - r.y;
            i.left = ox - r.x;
            i.bottom = r.bottom() - oy;
            i.right = r.right() - ox;
        }
        return i;
    }

    public PrecisionPoint r(PrecisionPoint p) {
        if (this.isEnabled()) {
            double ox = this.getOrigin().x;
            double oy = this.getOrigin().y;
            double dx = p.x - ox;
            double dy = p.y - oy;
            p.x = ox + dx * this.cos + dy * this.sin;
            p.y = oy - dx * this.sin + dy * this.cos;
        }
        return p;
    }

    public PrecisionRectangle r(PrecisionRectangle r) {
        return this.r(r, -1.0, -1.0);
    }

    public PrecisionRectangle r(PrecisionRectangle r, double wHint, double hHint) {
        if (this.isEnabled()) {
            PrecisionPoint c = this.r(P.setLocation(r.x + r.width * 0.5, r.y + r.height * 0.5));
            PrecisionDimension d = this.r(D.setSize(r.width, r.height), wHint, hHint);
            r.x = c.x - d.width / 2.0;
            r.y = c.y - d.height / 2.0;
            r.width = d.width;
            r.height = d.height;
        }
        return r;
    }

    public PrecisionPoint rp(PrecisionPoint p) {
        if (!this.isEnabled()) {
            return new PrecisionPoint(p);
        }
        this.setAngle(-this.getAngle());
        PrecisionPoint p2 = this.tp(p);
        this.setAngle(-this.getAngle());
        return p2;
    }
}

