/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.ui.internal.seawind;

import java.beans.PropertyChangeListener;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.ListenerList;
import org.eclipse.core.runtime.Platform;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.osgi.util.NLS;
import org.eclipse.ui.IMemento;
import org.json.JSONObject;
import org.osgi.framework.Bundle;
import org.xmind.core.Core;
import org.xmind.core.io.IInputSource;
import org.xmind.core.io.IStorage;
import org.xmind.core.io.PrefixedStorage;
import org.xmind.core.net.internal.EncodingUtils;
import org.xmind.core.util.FileUtils;
import org.xmind.seawind.internal.core.JSON;
import org.xmind.seawind.internal.core.SeawindFile;
import org.xmind.seawind.internal.core.SeawindFolder;
import org.xmind.seawind.internal.core.SeawindSheet;
import org.xmind.seawind.internal.core.SeawindWorkbook;
import org.xmind.seawind.internal.core.SeawindWorkingSet;
import org.xmind.ui.internal.seawind.ISeawindLibraryListener;
import org.xmind.ui.internal.seawind.ISeawindSyncer;
import org.xmind.ui.internal.seawind.SeawindFolderManager;
import org.xmind.ui.internal.seawind.SeawindLibraryEvent;
import org.xmind.ui.internal.seawind.SeawindUIPlugin;
import org.xmind.ui.internal.seawind.SeawindWorkbookRef;
import org.xmind.ui.internal.seawind.SyncConstraint;
import org.xmind.ui.internal.seawind.URIUtils;
import org.xmind.ui.mindmap.IWorkbookRef;

public final class SeawindLibrary {
    public static final int UNAUTHORIZED = 1;
    public static final int CONNECTING = 2;
    public static final int UNACTIVATED = 3;
    public static final int FATAL_ERROR = 4;
    public static final int SYNCING = 10;
    public static final int SYNCED = 11;
    private static final String KEY_X_CLIENT_ID = "xClientId";
    private final IStorage rootStorage;
    private JSONObject info;
    private SeawindWorkingSet workingSet;
    private SeawindWorkingSet pendingWorkingSet;
    private final Object workingSetLock;
    private Map<URI, SeawindWorkbookRef> workbookRefPool;
    private IPropertyChangeListener workbookRefObserver;
    private ListenerList<ISeawindLibraryListener> listenerManager;
    private ISeawindSyncer syncer;
    private int status;
    private String globalSyncError;
    private SeawindFolderManager seawindFolderManager;
    private Object seawindFolderLock;
    private SyncConstraint syncConstraint;

    SeawindLibrary(IStorage rootStorage) {
        this.rootStorage = rootStorage;
        this.workingSetLock = new Object();
        this.listenerManager = new ListenerList();
        this.workbookRefPool = new HashMap<URI, SeawindWorkbookRef>();
        this.workbookRefObserver = new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                SeawindLibrary.this.handleWorkbookRefPropertyChange((SeawindWorkbookRef)((Object)event.getSource()), event.getProperty(), event.getOldValue(), event.getNewValue());
            }
        };
        this.syncer = null;
        this.globalSyncError = null;
        this.info = SeawindLibrary.readJSONFrom(rootStorage, "info.json", "Failed to load seawind library info");
        this.pendingWorkingSet = new SeawindWorkingSet(new JSONObject());
        PrefixedStorage workingSetStorage = new PrefixedStorage(rootStorage, "repo/");
        this.status = this.isActive() && workingSetStorage.getInputSource().hasEntry("workbooks.json") ? 11 : 2;
        JSONObject workingSetObject = SeawindLibrary.readJSONFromWithSpare((IStorage)workingSetStorage, "workbooks.json", "Failed to load working set object from: " + rootStorage + "/" + "workbooks.json", (IStorage)workingSetStorage, "base.json");
        this.workingSet = new SeawindWorkingSet(workingSetObject);
        this.workingSet.setDebugName("local working set");
        this.workingSet.setStorage((IStorage)workingSetStorage);
        this.workingSet.setPath("workbooks.json");
        this.workingSet.getPropertySupport().addPropertyChangeListener(new PropertyChangeListener(){

            @Override
            public void propertyChange(java.beans.PropertyChangeEvent evt) {
                SeawindLibrary.this.handleSeawindEvent(evt.getSource(), evt.getPropertyName(), evt.getOldValue(), evt.getNewValue());
            }
        });
        this.pendingWorkingSet.setDebugName("pending working set");
        this.pendingWorkingSet.setStorage(this.workingSet.getStorage());
        this.pendingWorkingSet.setPath("workbooks.json");
        PrefixedStorage folderStorage = new PrefixedStorage((IStorage)workingSetStorage, "folders/");
        JSONObject foldersObject = SeawindLibrary.readJSONFromWithSpare((IStorage)folderStorage, "folders.json", "Failed to load folders object from: " + folderStorage + "/" + "folders.json", (IStorage)folderStorage, "folders_base.json");
        this.seawindFolderManager = new SeawindFolderManager(foldersObject);
        this.seawindFolderManager.init(this.workingSet);
        this.seawindFolderManager.setStorage((IStorage)folderStorage);
        this.seawindFolderManager.setPath("folders.json");
        this.seawindFolderLock = new Object();
        this.syncConstraint = new SyncConstraint((IStorage)workingSetStorage);
    }

    private static JSONObject readJSONFrom(IStorage storage, String path, String errorMessage) {
        try {
            return JSON.readOrCreateObjectWithDamageCheck((IStorage)storage, (String)path);
        }
        catch (IOException e) {
            SeawindUIPlugin.log(e, errorMessage);
            return new JSONObject();
        }
    }

    private static JSONObject readJSONFromWithSpare(IStorage storage, String path, String errorMessage, IStorage spareStorage, String sparePath) {
        if (!storage.getInputSource().hasEntry(path) && !spareStorage.getInputSource().hasEntry(sparePath)) {
            return new JSONObject();
        }
        try {
            return JSON.readObjectWithDamageCheck((IStorage)storage, (String)path);
        }
        catch (IOException e) {
            SeawindUIPlugin.log(e, errorMessage);
            try {
                return JSON.readObjectWithDamageCheck((IStorage)spareStorage, (String)sparePath);
            }
            catch (IOException iOException) {
                SeawindUIPlugin.log(e, errorMessage);
                return new JSONObject();
            }
        }
    }

    public IStorage getRootStorage() {
        return this.rootStorage;
    }

    public SyncConstraint getSyncConstraint() {
        return this.syncConstraint;
    }

    public Object getWorkingSetLock() {
        return this.workingSetLock;
    }

    public Object getSeawindFolderLock() {
        return this.seawindFolderLock;
    }

    public SeawindWorkingSet getWorkingSet() {
        return this.workingSet;
    }

    public SeawindFolderManager getSeawindFolderManager() {
        return this.seawindFolderManager;
    }

    public synchronized String getUserName() {
        return this.info.optString("user_name", null);
    }

    public synchronized void setUserName(String userName) {
        if (userName == null) {
            if (this.info.has("user_name")) {
                this.info.remove("user_name");
            }
        } else {
            this.info.put("user_name", (Object)userName);
        }
        this.saveInfo();
    }

    public synchronized long getCapacity() {
        return this.info.optLong("capacity_max", 0L);
    }

    public synchronized long getCapacityUsed() {
        return this.info.optLong("capacity_used", 0L);
    }

    public synchronized void setCapacities(long max, long used) {
        this.info.put("capacity_max", max);
        this.info.put("capacity_used", used);
        this.saveInfo();
    }

    public synchronized boolean isResourceUploaded(String hash) {
        JSONObject resourceMap = this.info.optJSONObject("synced_resources");
        return resourceMap != null && resourceMap.has(hash);
    }

    public synchronized void setResourceUploaded(String hash) {
        JSONObject resourceMap = this.info.optJSONObject("synced_resources");
        if (resourceMap == null) {
            resourceMap = new JSONObject();
            this.info.put("synced_resources", (Object)resourceMap);
        }
        if (resourceMap.has(hash)) {
            return;
        }
        resourceMap.put(hash, (Object)new JSONObject().put("time", System.currentTimeMillis()));
        this.saveInfo();
    }

    public synchronized void setActive(boolean active) {
        this.info.put("active", active);
        this.saveInfo();
    }

    public synchronized boolean isActive() {
        return this.info.optBoolean("active", false);
    }

    private synchronized void saveInfo() {
        try (OutputStream stream = this.rootStorage.getOutputTarget().openEntryStream("info.json");
             OutputStreamWriter writer = new OutputStreamWriter(stream, "UTF-8");){
            this.info.write((Writer)writer);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Collection<IWorkbookRef> getWorkbookRefs() {
        Object object = this.workingSetLock;
        synchronized (object) {
            ArrayList<IWorkbookRef> workbookRefs = new ArrayList<IWorkbookRef>();
            List swWorkbooks = this.workingSet.getWorkbooks();
            for (SeawindWorkbook swWorkbook : swWorkbooks) {
                workbookRefs.add((IWorkbookRef)this.getWorkbookRef(swWorkbook));
            }
            return workbookRefs;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IWorkbookRef createWorkbookRef(URI uri, IMemento state, boolean inRoot) {
        SeawindWorkbookRef workbookRef = this.workbookRefPool.get(uri);
        if (workbookRef != null) {
            return workbookRef;
        }
        String workbookId = URIUtils.getWorkbookIdFromURI(uri);
        Assert.isLegal((workbookId != null ? 1 : 0) != 0);
        Object object = this.workingSetLock;
        synchronized (object) {
            SeawindWorkbook swWorkbook = this.workingSet.findWorkbook(workbookId);
            if (swWorkbook != null) {
                return this.getWorkbookRef(swWorkbook);
            }
            this.addNewWorkbook(workbookId, null, inRoot);
        }
        return (IWorkbookRef)this.workbookRefPool.get(uri);
    }

    public static String createUniqueWorkbookId() {
        return UUID.randomUUID().toString();
    }

    public URI createNewWorkbookRefURI(String workbookName, boolean inRoot) {
        String workbookId = SeawindLibrary.createUniqueWorkbookId();
        this.addNewWorkbook(workbookId, workbookName, inRoot);
        return URIUtils.toWorkbookRefURI(workbookId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteWorkbookRef(URI uri) {
        String workbookId = URIUtils.getWorkbookIdFromURI(uri);
        Assert.isLegal((workbookId != null ? 1 : 0) != 0);
        Object object = this.seawindFolderLock;
        synchronized (object) {
            SeawindFile seawindFile = this.seawindFolderManager.getSeawindFile(workbookId);
            if (seawindFile != null) {
                this.seawindFolderManager.removeFile(seawindFile);
            }
        }
        object = this.workingSetLock;
        synchronized (object) {
            SeawindWorkbook swWorkbook = this.workingSet.findWorkbook(workbookId);
            Assert.isLegal((swWorkbook != null ? 1 : 0) != 0);
            this.workingSet.removeWorkbook(swWorkbook);
            this.workbookRefPool.remove(uri);
        }
        this.internalSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameWorkbookRef(URI uri, String newName) {
        Assert.isLegal((newName != null ? 1 : 0) != 0);
        String workbookId = URIUtils.getWorkbookIdFromURI(uri);
        Assert.isLegal((workbookId != null ? 1 : 0) != 0);
        Object object = this.workingSetLock;
        synchronized (object) {
            SeawindWorkbook swWorkbook = this.workingSet.findWorkbook(workbookId);
            if (swWorkbook == null) {
                return;
            }
            Assert.isLegal((swWorkbook != null ? 1 : 0) != 0);
            String oldName = swWorkbook.getTitle();
            if (newName == oldName || newName != null && newName.equals(oldName)) {
                return;
            }
            SeawindWorkbookRef workbookRef = this.findWorkbookRefById(workbookId);
            swWorkbook.setTitle(newName);
            if (workbookRef != null) {
                workbookRef.setSyncStatus(0, SeawindWorkbookRef.SYNC_STATUS_UPLOADING, SeawindWorkbookRef.LABEL_SYNCING);
            }
        }
        this.internalSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAll() {
        Object object = this.seawindFolderLock;
        synchronized (object) {
            this.seawindFolderManager.replaceRoot(SeawindFolderManager.createRootFolder());
            SeawindLibrary.saveFolderManager(this.seawindFolderManager);
        }
        object = this.workingSetLock;
        synchronized (object) {
            this.workingSet.removeAllWorkbooks();
            SeawindLibrary.saveWorkingSet(this.workingSet);
            for (String key : new HashSet(this.info.keySet())) {
                this.info.remove(key);
            }
            this.saveInfo();
            this.workbookRefPool.clear();
            this.rootStorage.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void postSaveWorkbookRef(SeawindWorkbookRef workbookRef) {
        this.backup(workbookRef);
        Object object = this.workingSetLock;
        synchronized (object) {
            SeawindWorkbook swWorkbook = workbookRef.getSeawindWorkbook();
            if (swWorkbook.getParent() == this.pendingWorkingSet) {
                this.pendingWorkingSet.removeWorkbook(swWorkbook);
                workbookRef.setPending(false);
                this.workingSet.addWorkbook(swWorkbook);
            }
            workbookRef.setSyncStatus(0, SeawindWorkbookRef.SYNC_STATUS_UPLOADING, SeawindWorkbookRef.LABEL_SYNCING);
        }
        this.internalSync();
    }

    private void backup(SeawindWorkbookRef workbookRef) {
        SeawindWorkbook swWorkbook = workbookRef.getSeawindWorkbook();
        this.backupSheetContents(swWorkbook);
        try {
            this.backupWorkbookExtension(swWorkbook);
        }
        catch (IOException e) {
            SeawindUIPlugin.log(e, NLS.bind((String)"back up workbook[{0}] extensions.json failed", (Object)swWorkbook.getId()));
        }
    }

    private void backupSheetContents(SeawindWorkbook swWorkbook) {
        for (SeawindSheet swSheet : swWorkbook.getSheets()) {
            try {
                this.backupSheetContent(swSheet);
            }
            catch (Exception e) {
                SeawindUIPlugin.log(e, NLS.bind((String)"back up sheet[{0}] content.json failed", (Object)swSheet.getId()));
            }
        }
    }

    private void backupSheetContent(SeawindSheet swSheet) throws IOException {
        IInputSource source = swSheet.getStorage().getInputSource();
        String contentHash = swSheet.getRevAsContentHash();
        String contentPath = contentHash != null ? EncodingUtils.format((String)"hashs/%s/content.json", (Object[])new Object[]{contentHash}) : EncodingUtils.format((String)"revs/%s/content.json", (Object[])new Object[]{swSheet.getRev()});
        InputStream inputStream = source.openEntryStream(contentPath);
        String sbPath = Core.getWorkspace().getAbsolutePath(".sBackup/" + swSheet.getParent().getId() + "=" + swSheet.getId() + ".sb");
        FileOutputStream outputStream = new FileOutputStream(sbPath);
        FileUtils.transfer((InputStream)inputStream, (OutputStream)outputStream);
    }

    private void backupWorkbookExtension(SeawindWorkbook swWorkbook) throws IOException {
        IInputSource extensionsSource = swWorkbook.getStorage().getInputSource();
        String extensionsPath = null;
        String extensionsHash = swWorkbook.getExtensionsRevAsContentHash();
        if (extensionsHash != null) {
            extensionsPath = EncodingUtils.format((String)"hashs/%s/extensions.json", (Object[])new Object[]{extensionsHash});
        } else if (swWorkbook.getExtensionsRev() != null) {
            extensionsPath = EncodingUtils.format((String)"revs/%s/extensions.json", (Object[])new Object[]{swWorkbook.getExtensionsRev()});
        }
        if (extensionsPath != null) {
            InputStream inputStream = extensionsSource.openEntryStream(extensionsPath);
            String sbPath = Core.getWorkspace().getAbsolutePath(".sBackup/" + swWorkbook.getId() + ".eb");
            FileOutputStream outputStream = new FileOutputStream(sbPath);
            FileUtils.transfer((InputStream)inputStream, (OutputStream)outputStream);
        }
    }

    public SeawindWorkbookRef findWorkbookRefById(String workbookId) {
        return this.workbookRefPool.get(URIUtils.toWorkbookRefURI(workbookId));
    }

    private SeawindWorkbookRef getWorkbookRef(SeawindWorkbook swWorkbook) {
        SeawindWorkbookRef workbookRef = this.findWorkbookRefById(swWorkbook.getId());
        if (workbookRef != null) {
            return workbookRef;
        }
        return this.loadWorkbookRef(swWorkbook);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private SeawindWorkbookRef loadWorkbookRef(SeawindWorkbook swWorkbook) {
        boolean pending;
        String workbookId = swWorkbook.getId();
        URI uri = URIUtils.toWorkbookRefURI(workbookId);
        SyncConstraint.SyncState syncState = this.syncConstraint.getSyncState(workbookId);
        Object object = this.workingSetLock;
        synchronized (object) {
            pending = this.workingSet.findWorkbook(workbookId) == null || syncState != null && (syncState.newFileDownloadUnfinished || syncState.conflictSource != null);
        }
        int syncStatusType = SeawindWorkbookRef.SYNC_STATUS_SYNCED;
        if (syncState != null) {
            if (syncState.newFileDownloadUnfinished || syncState.conflictSource != null) {
                syncStatusType = SeawindWorkbookRef.SYNC_STATUS_DOWNLOADING;
            } else if (syncState.conflicting) {
                syncStatusType = SeawindWorkbookRef.SYNC_STATUS_UPLOADING;
            }
        }
        SeawindWorkbookRef workbookRef = new SeawindWorkbookRef(this, uri, swWorkbook, syncStatusType, pending);
        this.workbookRefPool.put(uri, workbookRef);
        workbookRef.addPropertyChangeListener(this.workbookRefObserver);
        return workbookRef;
    }

    private void unloadWorkbookRef(SeawindWorkbookRef workbookRef) {
        workbookRef.setPending(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addNewWorkbook(String workbookId, String workbookName, boolean inRoot) {
        SeawindWorkbook swWorkbook = new SeawindWorkbook(workbookId);
        if (workbookName != null) {
            swWorkbook.setTitle(workbookName);
        }
        swWorkbook.setModificationTime(System.currentTimeMillis());
        Object object = this.workingSetLock;
        synchronized (object) {
            this.pendingWorkingSet.addWorkbook(swWorkbook);
            SeawindWorkbookRef workbookRef = this.findWorkbookRefById(workbookId);
            if (workbookRef != null) {
                workbookRef.setSyncStatus(0, SeawindWorkbookRef.SYNC_STATUS_UPLOADING, SeawindWorkbookRef.LABEL_SYNCING);
            } else {
                workbookRef = this.getWorkbookRef(swWorkbook);
            }
        }
        object = this.seawindFolderLock;
        synchronized (object) {
            SeawindFolder targetFolder = null;
            targetFolder = inRoot ? this.getSeawindFolderManager().getRootSeawindFolder() : this.getSeawindFolderManager().getSeawindFolder(this.getSeawindFolderManager().getCurrentFolderPath());
            targetFolder.addFile(new SeawindFile(workbookId));
        }
    }

    private void handleWorkbookRefPropertyChange(SeawindWorkbookRef workbookRef, String propName, Object oldValue, Object newValue) {
        if ("name".equals(propName)) {
            this.fireLibraryEvent(4, (Object)workbookRef);
        } else if ("state".equals(propName)) {
            this.fireLibraryEvent(4, (Object)workbookRef);
        } else if ("exists".equals(propName)) {
            this.fireLibraryEvent(4, (Object)workbookRef);
        } else if ("modificationTime".equals(propName)) {
            this.fireLibraryEvent(4, (Object)workbookRef);
        } else if ("messages".equals(propName)) {
            this.fireLibraryEvent(4, (Object)workbookRef);
        } else if ("progress".equals(propName)) {
            this.fireLibraryEvent(4, (Object)workbookRef);
        }
    }

    private void handleSeawindEvent(Object source, String propName, Object oldValue, Object newValue) {
        if ("workbooks".equals(propName)) {
            this.refreshWorkbooks((SeawindWorkingSet)source, (List)oldValue, (List)newValue);
        }
    }

    private void refreshWorkbooks(SeawindWorkingSet workingSet, List<?> oldWorkbooks, List<?> newWorkbooks) {
        SeawindWorkbookRef workbookRef;
        ArrayList workbooksToRemove = new ArrayList(oldWorkbooks);
        int i = 0;
        while (i < newWorkbooks.size()) {
            SeawindWorkbook swWorkbook = (SeawindWorkbook)newWorkbooks.get(i);
            if (workbooksToRemove.remove(swWorkbook)) {
                this.getWorkbookRef(swWorkbook);
            } else {
                workbookRef = this.getWorkbookRef(swWorkbook);
                this.fireLibraryEvent(1, (Object)workbookRef);
            }
            ++i;
        }
        for (Object swWorkbook : workbooksToRemove) {
            workbookRef = this.workbookRefPool.get(URIUtils.toWorkbookRefURI(((SeawindWorkbook)swWorkbook).getId()));
            if (workbookRef == null) continue;
            workbookRef.setPending(false);
            this.unloadWorkbookRef(workbookRef);
            workbookRef.removePropertyChangeListener(this.workbookRefObserver);
            this.fireLibraryEvent(2, (Object)workbookRef);
        }
    }

    public void addLibraryListener(ISeawindLibraryListener listener) {
        this.listenerManager.add((Object)listener);
    }

    public void removeLibraryListener(ISeawindLibraryListener listener) {
        this.listenerManager.remove((Object)listener);
    }

    protected void fireLibraryEvent(int type, Object target) {
        Object[] listeners;
        SeawindLibraryEvent event = new SeawindLibraryEvent(this, type, target);
        Object[] objectArray = listeners = this.listenerManager.getListeners();
        int n = listeners.length;
        int n2 = 0;
        while (n2 < n) {
            Object listener = objectArray[n2];
            ((ISeawindLibraryListener)listener).handleSeawindLibraryEvent(event);
            ++n2;
        }
    }

    public IStorage getSharedResourceStorage() {
        return new PrefixedStorage(this.rootStorage, "resources/");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void internalSync() {
        Object object = this.workingSetLock;
        synchronized (object) {
            SeawindLibrary.saveWorkingSet(this.workingSet);
        }
        object = this.seawindFolderLock;
        synchronized (object) {
            SeawindLibrary.saveFolderManager(this.seawindFolderManager);
        }
        if (this.syncer == null) {
            return;
        }
        this.syncer.sync();
    }

    public void sync() {
        if (this.syncer != null) {
            this.syncer.sync();
        }
    }

    public void setSyncer(ISeawindSyncer syncer) {
        this.syncer = syncer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setStatus(int status) {
        SeawindLibrary seawindLibrary = this;
        synchronized (seawindLibrary) {
            int oldStatus = this.status;
            if (oldStatus == status) {
                return;
            }
            this.status = status;
        }
        this.fireLibraryEvent(1024, null);
    }

    public synchronized int getStatus() {
        return this.status;
    }

    public synchronized boolean isSyncing() {
        return this.status == 10 || this.status == 2;
    }

    public synchronized String getGlobalSyncError() {
        return this.globalSyncError;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setGlobalSyncError(String error) {
        SeawindLibrary seawindLibrary = this;
        synchronized (seawindLibrary) {
            this.globalSyncError = error;
        }
        this.fireLibraryEvent(0x100000, null);
    }

    private static void saveWorkingSet(SeawindWorkingSet workingSet) {
        try {
            workingSet.save(null);
        }
        catch (IOException e) {
            SeawindUIPlugin.log(e, e.getMessage());
        }
        catch (InterruptedException interruptedException) {}
    }

    private static void saveFolderManager(SeawindFolderManager sfm) {
        try {
            sfm.save(null);
        }
        catch (InterruptedException e) {
            SeawindUIPlugin.log(e, e.getMessage());
        }
        catch (IOException e) {
            SeawindUIPlugin.log(e, e.getMessage());
        }
    }

    public static IStorage newStorageForWorkbook(IStorage workingSetStorage, String workbookId) {
        return new PrefixedStorage(workingSetStorage, EncodingUtils.format((String)"workbooks/%s/", (Object[])new Object[]{workbookId}));
    }

    public static IStorage newStorageForSheet(IStorage workbookStorage, String sheetId) {
        return new PrefixedStorage(workbookStorage, EncodingUtils.format((String)"sheets/%s/", (Object[])new Object[]{sheetId}));
    }

    public String getUserEmail() {
        return this.loadLocalData() == null ? null : this.loadLocalData().getProperty("TimeSmilesInMyHand");
    }

    public String getLicenseKey() {
        return this.loadLocalData() == null ? null : this.loadLocalData().getProperty("WalkingInTheMorning");
    }

    public String getUUID() {
        return this.loadLocalData() == null ? null : this.loadLocalData().getProperty("ThisDawn");
    }

    public String findXClientId() {
        String xClientId = System.getProperty(KEY_X_CLIENT_ID);
        if (xClientId == null) {
            xClientId = UUID.randomUUID().toString();
            System.setProperty(KEY_X_CLIENT_ID, xClientId);
        }
        return xClientId;
    }

    private Properties loadLocalData() {
        File stateFile = SeawindLibrary.getStateFile();
        if (stateFile != null && stateFile.exists() && stateFile.isFile()) {
            Properties store = new Properties();
            try {
                try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(stateFile), 1024);){
                    store.load(stream);
                }
                return store;
            }
            catch (IOException iOException) {}
        }
        return null;
    }

    private static File getStateFile() {
        return SeawindLibrary.getLocalFile(".poem37");
    }

    private static File getLocalFile(String name) {
        Bundle bundle = Platform.getBundle((String)"net.xmind.verify");
        if (bundle != null) {
            File root = Platform.getStateLocation((Bundle)bundle).toFile();
            return new File(root, name);
        }
        return null;
    }

    public void waitForConnection(IProgressMonitor monitor) throws InterruptedException {
        while (true) {
            if (this.status == 3 || this.status == 4) {
                throw new InterruptedException("Unactivated");
            }
            if (this.status != 1 && this.status != 2) {
                return;
            }
            if (monitor.isCanceled()) {
                throw new InterruptedException();
            }
            Thread.sleep(500L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setCurrentFolderPath(String folderPath) {
        Object object = this.seawindFolderLock;
        synchronized (object) {
            this.getSeawindFolderManager().setCurrentFolderPath(folderPath);
        }
        this.fireLibraryEvent(8, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void newFolder(SeawindFolder parentFolder, String title) {
        SeawindFolder newFolder;
        Object object = this.seawindFolderLock;
        synchronized (object) {
            newFolder = this.getSeawindFolderManager().newFolder(parentFolder, title);
        }
        this.fireLibraryEvent(1, newFolder);
        this.internalSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFolder(SeawindFolder folder) {
        Object object = this.workingSetLock;
        synchronized (object) {
            HashSet<SeawindFile> files = new HashSet<SeawindFile>();
            SeawindFolderManager.collectLeafs(folder, files);
            for (SeawindFile file : files) {
                String identifier = file.getIdentifier();
                SeawindWorkbook swWorkbook = this.workingSet.findWorkbook(identifier);
                if (swWorkbook == null) continue;
                this.workingSet.removeWorkbook(swWorkbook);
                this.workbookRefPool.remove(URIUtils.toWorkbookRefURI(swWorkbook.getId()));
            }
        }
        object = this.seawindFolderLock;
        synchronized (object) {
            this.getSeawindFolderManager().removeFolder(folder);
        }
        this.fireLibraryEvent(2, folder);
        this.internalSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void renameFolder(SeawindFolder folder, String newTitle) {
        Object object = this.seawindFolderLock;
        synchronized (object) {
            this.getSeawindFolderManager().renameFolder(folder, newTitle);
        }
        this.fireLibraryEvent(4, folder);
        this.internalSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveFolder(SeawindFolder source, String targetFolderPath) {
        SeawindFolder target = this.getSeawindFolderManager().getSeawindFolder(targetFolderPath);
        Assert.isNotNull((Object)source);
        Assert.isNotNull((Object)target);
        Object object = this.seawindFolderLock;
        synchronized (object) {
            this.getSeawindFolderManager().moveFolder(source, target);
        }
        this.fireLibraryEvent(8, null);
        this.internalSync();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void moveFile(SeawindFile source, String targetFolderPath) {
        SeawindFolder target = this.getSeawindFolderManager().getSeawindFolder(targetFolderPath);
        Assert.isNotNull((Object)source);
        Assert.isNotNull((Object)target);
        Object object = this.seawindFolderLock;
        synchronized (object) {
            this.getSeawindFolderManager().moveFile(source, target);
        }
        this.fireLibraryEvent(8, null);
        this.internalSync();
    }

    static String peekLibraryUserName(IStorage storage) {
        JSONObject info;
        if (!storage.getInputSource().hasEntry("info.json")) {
            return null;
        }
        try {
            info = JSON.readObjectWithDamageCheck((IStorage)storage, (String)"info.json");
        }
        catch (IOException e) {
            SeawindUIPlugin.log(e, "Failed to parse info.json when retrieving seawind library storage owner.");
            return null;
        }
        String userName = info.optString("user_name", null);
        if (userName == null) {
            SeawindUIPlugin.log("WARNING: Library owner is null in info.json");
        }
        return userName;
    }
}

