/*
 * Decompiled with CFR 0.152.
 */
package org.xmind.core.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.xmind.core.IBoundary;
import org.xmind.core.ICloneData;
import org.xmind.core.IComment;
import org.xmind.core.ICommentManager;
import org.xmind.core.IControlPoint;
import org.xmind.core.IFileEntry;
import org.xmind.core.IHtmlNotesContent;
import org.xmind.core.IHyperlinkSpan;
import org.xmind.core.IImage;
import org.xmind.core.IImageSpan;
import org.xmind.core.IManifest;
import org.xmind.core.IMeta;
import org.xmind.core.INotesContent;
import org.xmind.core.IParagraph;
import org.xmind.core.IPlainNotesContent;
import org.xmind.core.IRelationship;
import org.xmind.core.IResourceRef;
import org.xmind.core.ISettingEntry;
import org.xmind.core.ISheet;
import org.xmind.core.ISpan;
import org.xmind.core.ISpanList;
import org.xmind.core.ISummary;
import org.xmind.core.ITextSpan;
import org.xmind.core.ITopic;
import org.xmind.core.ITopicExtension;
import org.xmind.core.ITopicExtensionElement;
import org.xmind.core.IWorkbook;
import org.xmind.core.IWorkbookExtension;
import org.xmind.core.IWorkbookExtensionElement;
import org.xmind.core.IWorkbookExtensionManager;
import org.xmind.core.internal.CloneData;
import org.xmind.core.marker.IMarker;
import org.xmind.core.marker.IMarkerGroup;
import org.xmind.core.marker.IMarkerRef;
import org.xmind.core.marker.IMarkerResource;
import org.xmind.core.marker.IMarkerSheet;
import org.xmind.core.style.IStyle;
import org.xmind.core.style.IStyleSheet;
import org.xmind.core.util.FileUtils;
import org.xmind.core.util.HyperlinkUtils;
import org.xmind.core.util.Point;
import org.xmind.core.util.Property;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CloneHandler {
    private ICloneData mapper;
    private IWorkbook sourceWorkbook;
    private IWorkbook targetWorkbook;
    private IManifest sourceManifest;
    private IManifest targetManifest;
    private IStyleSheet sourceStyleSheet;
    private IStyleSheet targetStyleSheet;
    private IMarkerSheet sourceMarkerSheet;
    private IMarkerSheet targetMarkerSheet;

    public CloneHandler() {
        this(null);
    }

    public CloneHandler(ICloneData mapper) {
        this.mapper = mapper == null ? new CloneData(Collections.emptyList(), null) : mapper;
        this.sourceWorkbook = null;
        this.targetWorkbook = null;
        this.sourceManifest = null;
        this.targetManifest = null;
        this.sourceStyleSheet = null;
        this.targetStyleSheet = null;
        this.sourceMarkerSheet = null;
        this.targetMarkerSheet = null;
    }

    public CloneHandler withWorkbooks(IWorkbook sourceWorkbook, IWorkbook targetWorkbook) {
        if (sourceWorkbook == null) {
            throw new IllegalArgumentException();
        }
        if (targetWorkbook == null) {
            throw new IllegalArgumentException();
        }
        this.sourceWorkbook = sourceWorkbook;
        this.targetWorkbook = targetWorkbook;
        this.sourceManifest = sourceWorkbook.getManifest();
        this.targetManifest = targetWorkbook.getManifest();
        this.sourceStyleSheet = sourceWorkbook.getStyleSheet();
        this.targetStyleSheet = targetWorkbook.getStyleSheet();
        this.sourceMarkerSheet = sourceWorkbook.getMarkerSheet();
        this.targetMarkerSheet = targetWorkbook.getMarkerSheet();
        return this;
    }

    public CloneHandler withManifests(IManifest sourceManifest, IManifest targetManifest) {
        if (sourceManifest == null) {
            throw new IllegalArgumentException();
        }
        if (targetManifest == null) {
            throw new IllegalArgumentException();
        }
        this.sourceManifest = sourceManifest;
        this.targetManifest = targetManifest;
        return this;
    }

    public CloneHandler withStyleSheets(IStyleSheet sourceStyleSheet, IStyleSheet targetStyleSheet) {
        if (sourceStyleSheet == null) {
            throw new IllegalArgumentException();
        }
        if (targetStyleSheet == null) {
            throw new IllegalArgumentException();
        }
        this.sourceStyleSheet = sourceStyleSheet;
        this.targetStyleSheet = targetStyleSheet;
        this.sourceManifest = sourceStyleSheet.getAdapter(IManifest.class);
        this.targetManifest = targetStyleSheet.getAdapter(IManifest.class);
        return this;
    }

    public CloneHandler withMarkerSheets(IMarkerSheet sourceMarkerSheet, IMarkerSheet targetMarkerSheet) {
        if (sourceMarkerSheet == null) {
            throw new IllegalArgumentException();
        }
        if (targetMarkerSheet == null) {
            throw new IllegalArgumentException();
        }
        this.sourceMarkerSheet = sourceMarkerSheet;
        this.targetMarkerSheet = targetMarkerSheet;
        this.sourceManifest = sourceMarkerSheet.getAdapter(IManifest.class);
        this.targetManifest = targetMarkerSheet.getAdapter(IManifest.class);
        return this;
    }

    public ICloneData getMapper() {
        return this.mapper;
    }

    public void copyWorkbookContents() throws IOException {
        if (this.sourceWorkbook == null) {
            throw new AssertionError((Object)"sourceWorkbook is null");
        }
        if (this.targetWorkbook == null) {
            throw new AssertionError((Object)"targetWorkbook is null");
        }
        ArrayList<ISheet> oldSheets = new ArrayList<ISheet>(this.targetWorkbook.getSheets());
        for (ISheet sourceSheet : this.sourceWorkbook.getSheets()) {
            this.targetWorkbook.addSheet(this.cloneSheet(sourceSheet));
        }
        if (this.targetWorkbook.getSheets().isEmpty()) {
            this.targetWorkbook.addSheet(this.targetWorkbook.createSheet());
        }
        for (ISheet oldSheet : oldSheets) {
            this.targetWorkbook.removeSheet(oldSheet);
        }
        IMeta sourceMeta = this.sourceWorkbook.getMeta();
        IMeta targetMeta = this.targetWorkbook.getMeta();
        for (String keyPath : sourceMeta.getKeyPaths()) {
            targetMeta.setValue(keyPath, sourceMeta.getValue(keyPath));
        }
        List<ISheet> sheets = this.targetWorkbook.getSheets();
        ArrayList<ITopic> targetAllTopics = new ArrayList<ITopic>();
        for (ISheet sheet : sheets) {
            this.getAllChildrenTopic(targetAllTopics, sheet.getRootTopic());
        }
        IWorkbookExtensionManager sourceExtensionManager = this.sourceWorkbook.getAdapter(IWorkbookExtensionManager.class);
        IWorkbookExtensionManager targetExtensionManager = this.targetWorkbook.getAdapter(IWorkbookExtensionManager.class);
        if (sourceExtensionManager != null && targetExtensionManager != null) {
            for (IWorkbookExtension sourceExtension : sourceExtensionManager.getExtensions()) {
                IWorkbookExtension targetExtension = targetExtensionManager.createExtension(sourceExtension.getProviderName());
                this.copyWorkbookExtension(sourceExtension, targetExtension);
            }
        }
        this.fixInternalHyperlinkFor(targetAllTopics);
    }

    private List<ITopic> getAllChildrenTopic(List<ITopic> topics, ITopic root) {
        topics.add(root);
        for (ITopic topic : root.getAllChildren()) {
            this.getAllChildrenTopic(topics, topic);
        }
        return topics;
    }

    public Object cloneObject(Object source) throws IOException {
        Object target = this.mapper.get(source);
        if (target != null) {
            return target;
        }
        if (source instanceof ISheet) {
            if (this.sourceWorkbook == null) {
                throw new AssertionError((Object)"sourceWorkbook is null");
            }
            if (this.targetWorkbook == null) {
                throw new AssertionError((Object)"targetWorkbook is null");
            }
            if (this.sourceManifest == null) {
                throw new AssertionError((Object)"sourceManifest is null");
            }
            if (this.targetManifest == null) {
                throw new AssertionError((Object)"targetManifest is null");
            }
            return this.cloneSheet((ISheet)source);
        }
        if (source instanceof ITopic) {
            if (this.sourceWorkbook == null) {
                throw new AssertionError((Object)"sourceWorkbook is null");
            }
            if (this.targetWorkbook == null) {
                throw new AssertionError((Object)"targetWorkbook is null");
            }
            if (this.sourceManifest == null) {
                throw new AssertionError((Object)"sourceManifest is null");
            }
            if (this.targetManifest == null) {
                throw new AssertionError((Object)"targetManifest is null");
            }
            ITopic sourceTopic = (ITopic)source;
            ITopic targetTopic = this.targetWorkbook.createTopic();
            this.copyTopicContents(sourceTopic, targetTopic);
            return targetTopic;
        }
        if (source instanceof IBoundary) {
            if (this.sourceWorkbook == null) {
                throw new AssertionError((Object)"sourceWorkbook is null");
            }
            if (this.targetWorkbook == null) {
                throw new AssertionError((Object)"targetWorkbook is null");
            }
            if (this.sourceManifest == null) {
                throw new AssertionError((Object)"sourceManifest is null");
            }
            if (this.targetManifest == null) {
                throw new AssertionError((Object)"targetManifest is null");
            }
            IBoundary sourceBoundary = (IBoundary)source;
            IBoundary targetBoundary = this.targetWorkbook.createBoundary();
            this.copyBoundaryContents(sourceBoundary, targetBoundary);
            return targetBoundary;
        }
        if (source instanceof ISummary) {
            if (this.sourceWorkbook == null) {
                throw new AssertionError((Object)"sourceWorkbook is null");
            }
            if (this.targetWorkbook == null) {
                throw new AssertionError((Object)"targetWorkbook is null");
            }
            if (this.sourceManifest == null) {
                throw new AssertionError((Object)"sourceManifest is null");
            }
            if (this.targetManifest == null) {
                throw new AssertionError((Object)"targetManifest is null");
            }
            ISummary sourceSummary = (ISummary)source;
            ISummary targetSummary = this.targetWorkbook.createSummary();
            this.copySummaryContents(sourceSummary, targetSummary);
            return targetSummary;
        }
        if (source instanceof IRelationship) {
            if (this.sourceWorkbook == null) {
                throw new AssertionError((Object)"sourceWorkbook is null");
            }
            if (this.targetWorkbook == null) {
                throw new AssertionError((Object)"targetWorkbook is null");
            }
            if (this.sourceManifest == null) {
                throw new AssertionError((Object)"sourceManifest is null");
            }
            if (this.targetManifest == null) {
                throw new AssertionError((Object)"targetManifest is null");
            }
            IRelationship sourceRel = (IRelationship)source;
            IRelationship targetRel = this.targetWorkbook.createRelationship();
            this.copyRelationshipContents(sourceRel, targetRel);
            return targetRel;
        }
        if (source instanceof IStyle) {
            if (this.sourceStyleSheet == null) {
                throw new AssertionError((Object)"sourceStyleSheet is null");
            }
            if (this.targetStyleSheet == null) {
                throw new AssertionError((Object)"targetStyleSheet is null");
            }
            if (this.sourceManifest == null) {
                throw new AssertionError((Object)"sourceManifest is null");
            }
            if (this.targetManifest == null) {
                throw new AssertionError((Object)"targetManifest is null");
            }
            return this.findOrCloneStyle((IStyle)source);
        }
        if (source instanceof IImage) {
            if (this.sourceWorkbook == null) {
                throw new AssertionError((Object)"sourceWorkbook is null");
            }
            if (this.targetWorkbook == null) {
                throw new AssertionError((Object)"targetWorkbook is null");
            }
            if (this.sourceManifest == null) {
                throw new AssertionError((Object)"sourceManifest is null");
            }
            if (this.targetManifest == null) {
                throw new AssertionError((Object)"targetManifest is null");
            }
            IImage sourceImage = (IImage)source;
            ITopic sourceTopic = sourceImage.getParent();
            ITopic targetTopic = this.targetWorkbook.createTopic();
            this.copyTopicContents(sourceTopic, targetTopic);
            IImage targetImage = targetTopic.getImage();
            this.mapper.put(sourceImage, targetImage);
            return targetImage;
        }
        if (source instanceof IMarker) {
            if (this.sourceMarkerSheet == null) {
                throw new AssertionError((Object)"sourceMarkerSheet is null");
            }
            if (this.targetMarkerSheet == null) {
                throw new AssertionError((Object)"targetMarkerSheet is null");
            }
            IMarker marker = this.findOrCloneMarker((IMarker)source);
            this.mapper.put(source, marker);
            return marker;
        }
        if (source instanceof IMarkerRef) {
            if (this.sourceWorkbook == null) {
                throw new AssertionError((Object)"sourceWorkbook is null");
            }
            if (this.targetWorkbook == null) {
                throw new AssertionError((Object)"targetWorkbook is null");
            }
            IMarkerRef sourceMarkerRef = (IMarkerRef)source;
            IMarkerRef targetMarkerRef = this.cloneMarkerRef(sourceMarkerRef);
            this.mapper.put(sourceMarkerRef, targetMarkerRef);
            return targetMarkerRef;
        }
        return null;
    }

    private IMarkerRef cloneMarkerRef(IMarkerRef sourceMarkerRef) throws IOException {
        IMarkerRef targetMarkerRef;
        IMarker sourceMarker = sourceMarkerRef.getMarker();
        if (sourceMarker == null) {
            targetMarkerRef = sourceMarkerRef;
        } else {
            IMarker targetMarker = this.findOrCloneMarker(sourceMarker);
            if (targetMarker == null) {
                targetMarkerRef = null;
            } else {
                this.mapper.put(sourceMarker, targetMarker);
                this.mapper.putString("markerSheetComponents", sourceMarker.getId(), targetMarker.getId());
                ITopic tempTopic = this.targetWorkbook.createTopic();
                tempTopic.addMarker(targetMarker.getId());
                targetMarkerRef = tempTopic.getMarkerRefs().iterator().next();
            }
        }
        return targetMarkerRef;
    }

    private IMarker findOrCloneMarker(IMarker sourceMarker) throws IOException {
        if (sourceMarker == null) {
            return null;
        }
        IMarker targetMarker = (IMarker)this.mapper.get(sourceMarker);
        if (targetMarker != null) {
            return targetMarker;
        }
        String markerId = sourceMarker.getId();
        targetMarker = this.targetMarkerSheet.findMarker(markerId);
        if (targetMarker != null) {
            this.mapper.put(sourceMarker, targetMarker);
            return targetMarker;
        }
        if (sourceMarker.getOwnedSheet().isPermanent()) {
            return sourceMarker;
        }
        IMarkerGroup sourceGroup = sourceMarker.getParent();
        IMarkerGroup targetGroup = this.findOrCloneMarkerGroup(sourceGroup);
        String sourceResourcePath = sourceMarker.getResourcePath();
        String targetResourcePath = null;
        IMarkerResource sourceResource = sourceMarker.getResource();
        if (sourceResource != null) {
            InputStream input = null;
            try {
                try {
                    input = sourceResource.openInputStream();
                    targetResourcePath = this.targetMarkerSheet.allocateMarkerResource(input, sourceResourcePath);
                }
                catch (IOException e) {
                    e.printStackTrace();
                    if (input != null) {
                        input.close();
                    }
                    return null;
                }
            }
            finally {
                if (input != null) {
                    input.close();
                }
            }
        }
        targetMarker = this.targetMarkerSheet.createMarkerById(markerId, targetResourcePath);
        targetMarker.setName(sourceMarker.getName());
        if (targetGroup != null) {
            targetGroup.addMarker(targetMarker);
        }
        this.mapper.put(sourceMarker, targetMarker);
        return targetMarker;
    }

    private IMarkerGroup findOrCloneMarkerGroup(IMarkerGroup sourceMarkerGroup) {
        if (sourceMarkerGroup == null) {
            return null;
        }
        IMarkerGroup targetMarkerGroup = (IMarkerGroup)this.mapper.get(sourceMarkerGroup);
        if (targetMarkerGroup != null) {
            return targetMarkerGroup;
        }
        String groupId = sourceMarkerGroup.getId();
        targetMarkerGroup = this.targetMarkerSheet.findMarkerGroup(groupId);
        if (targetMarkerGroup == null || targetMarkerGroup.getOwnedSheet() != this.targetMarkerSheet) {
            targetMarkerGroup = this.targetMarkerSheet.createMarkerGroupById(groupId);
            targetMarkerGroup.setSingleton(sourceMarkerGroup.isSingleton());
            targetMarkerGroup.setName(sourceMarkerGroup.getName());
        }
        if (targetMarkerGroup.getParent() == null) {
            this.targetMarkerSheet.addMarkerGroup(targetMarkerGroup);
        }
        return targetMarkerGroup;
    }

    private ISheet cloneSheet(ISheet sourceSheet) throws IOException {
        ISheet targetSheet = this.targetWorkbook.createSheet();
        this.copySheetContents(sourceSheet, targetSheet);
        ArrayList<ITopic> targetAllTopics = new ArrayList<ITopic>();
        this.getAllChildrenTopic(targetAllTopics, targetSheet.getRootTopic());
        this.fixInternalHyperlinkFor(targetAllTopics);
        this.replaceProcessorOldIds(targetAllTopics);
        return targetSheet;
    }

    private void replaceProcessorOldIds(ArrayList<ITopic> targetAllTopics) {
        for (ITopic topic : targetAllTopics) {
            this.replaceProcessorOldIds(topic);
        }
    }

    private void replaceProcessorOldIds(ITopic topic) {
        ITopicExtension ext = topic.getExtension("org.xmind.ui.taskInfo");
        if (ext != null) {
            ITopicExtensionElement content = ext.getContent();
            List parentElements = content.getChildren("predecessors");
            for (ITopicExtensionElement parentElement : parentElements) {
                List elements = parentElement.getChildren("predecessor");
                for (ITopicExtensionElement element : elements) {
                    String taskId = element.getAttribute("task-id");
                    String newTaskId = this.mapper.getString("workbookComponents", taskId);
                    if (newTaskId == null) continue;
                    element.setAttribute("task-id", newTaskId);
                }
            }
        }
    }

    private void copySheetContents(ISheet sourceSheet, ISheet targetSheet) throws IOException {
        this.mapper.put(sourceSheet, targetSheet);
        this.mapper.putString("workbookComponents", sourceSheet.getId(), targetSheet.getId());
        targetSheet.setTitleText(sourceSheet.getTitleText());
        targetSheet.setStyleId(this.convertStyleId(sourceSheet.getStyleId()));
        targetSheet.setThemeId(this.convertStyleId(sourceSheet.getThemeId()));
        ITopic sourceRootTopic = sourceSheet.getRootTopic();
        if (sourceRootTopic != null) {
            ITopic targetRootTopic = targetSheet.getRootTopic();
            this.copyTopicContents(sourceRootTopic, targetRootTopic);
        }
        for (IRelationship sourceRel : sourceSheet.getRelationships()) {
            IRelationship targetRel = this.targetWorkbook.createRelationship();
            this.copyRelationshipContents(sourceRel, targetRel);
            targetSheet.addRelationship(targetRel);
        }
        targetSheet.getLegend().setVisible(sourceSheet.getLegend().isVisible());
        targetSheet.getLegend().setPosition(sourceSheet.getLegend().getPosition());
        for (String markerId : sourceSheet.getLegend().getMarkerIds()) {
            targetSheet.getLegend().setMarkerDescription(markerId, sourceSheet.getLegend().getMarkerDescription(markerId));
        }
        for (String settingPath : sourceSheet.getSettings().getPaths()) {
            for (ISettingEntry sourceSettingEntry : sourceSheet.getSettings().getEntries(settingPath)) {
                ISettingEntry targetSettingEntry = targetSheet.getSettings().createEntry(settingPath);
                for (String key : sourceSettingEntry.getAttributeKeys()) {
                    targetSettingEntry.setAttribute(key, sourceSettingEntry.getAttribute(key));
                }
                targetSheet.getSettings().addEntry(targetSettingEntry);
            }
        }
        this.copyComments(sourceSheet.getId(), targetSheet.getId());
    }

    private void copyTopicContents(ITopic sourceTopic, ITopic targetTopic) throws IOException {
        INotesContent targetHtmlContent;
        INotesContent sourceHtmlContent;
        INotesContent targetPlainContent;
        this.mapper.put(sourceTopic, targetTopic);
        this.mapper.putString("workbookComponents", sourceTopic.getId(), targetTopic.getId());
        targetTopic.setTitleText(sourceTopic.hasTitle() ? sourceTopic.getTitleText() : null);
        targetTopic.setTitleWidth(sourceTopic.getTitleWidth());
        targetTopic.setFolded(sourceTopic.isFolded());
        targetTopic.setStructureClass(sourceTopic.getStructureClass());
        targetTopic.setPosition(sourceTopic.getPosition());
        targetTopic.setHyperlink(this.convertHyperlink(sourceTopic.getHyperlink()));
        for (String label : sourceTopic.getLabels()) {
            targetTopic.addLabel(label);
        }
        for (IMarkerRef markerRef : sourceTopic.getMarkerRefs()) {
            IMarkerRef mr = (IMarkerRef)this.cloneObject(markerRef);
            if (mr == null) continue;
            targetTopic.addMarker(mr.getMarkerId());
        }
        targetTopic.setStyleId(this.convertStyleId(sourceTopic.getStyleId()));
        targetTopic.getImage().setSource(this.convertHyperlink(sourceTopic.getImage().getSource()));
        targetTopic.getImage().setWidth(sourceTopic.getImage().getWidth());
        targetTopic.getImage().setHeight(sourceTopic.getImage().getHeight());
        targetTopic.getImage().setAlignment(sourceTopic.getImage().getAlignment());
        for (String type : sourceTopic.getChildrenTypes()) {
            for (ITopic sourceChild : sourceTopic.getChildren(type)) {
                ITopic targetChild = targetTopic.getOwnedWorkbook().createTopic();
                this.copyTopicContents(sourceChild, targetChild);
                targetTopic.add(targetChild, type);
            }
        }
        for (IBoundary sourceBoundary : sourceTopic.getBoundaries()) {
            IBoundary targetBoundary = targetTopic.getOwnedWorkbook().createBoundary();
            this.copyBoundaryContents(sourceBoundary, targetBoundary);
            targetTopic.addBoundary(targetBoundary);
        }
        for (ISummary sourceSummary : sourceTopic.getSummaries()) {
            ISummary targetSummary = targetTopic.getOwnedWorkbook().createSummary();
            this.copySummaryContents(sourceSummary, targetSummary);
            targetTopic.addSummary(targetSummary);
        }
        for (ITopicExtension sourceExt : sourceTopic.getExtensions()) {
            ITopicExtension targetExt = targetTopic.createExtension(sourceExt.getProviderName());
            this.copyTopicExtension(sourceExt, targetExt);
        }
        targetTopic.getNumbering().setFormat(sourceTopic.getNumbering().getNumberFormat());
        targetTopic.getNumbering().setPrefix(sourceTopic.getNumbering().getPrefix());
        targetTopic.getNumbering().setSuffix(sourceTopic.getNumbering().getSuffix());
        targetTopic.getNumbering().setSeparator(sourceTopic.getNumbering().getSeparator());
        targetTopic.getNumbering().setPrependsParentNumbers(sourceTopic.getNumbering().prependsParentNumbers());
        targetTopic.getNumbering().setDepth(sourceTopic.getNumbering().getDepth());
        INotesContent sourcePlainContent = sourceTopic.getNotes().getContent("plain");
        if (sourcePlainContent != null && sourcePlainContent instanceof IPlainNotesContent && (targetPlainContent = this.targetWorkbook.createNotesContent("plain")) instanceof IPlainNotesContent) {
            ((IPlainNotesContent)targetPlainContent).setTextContent(((IPlainNotesContent)sourcePlainContent).getTextContent());
            targetTopic.getNotes().setContent("plain", targetPlainContent);
        }
        if ((sourceHtmlContent = sourceTopic.getNotes().getContent("html")) != null && sourceHtmlContent instanceof IHtmlNotesContent && (targetHtmlContent = this.targetWorkbook.createNotesContent("html")) instanceof IHtmlNotesContent) {
            this.copyHtmlNotesContent((IHtmlNotesContent)sourceHtmlContent, (IHtmlNotesContent)targetHtmlContent);
            targetTopic.getNotes().setContent("html", targetHtmlContent);
        }
        ArrayList<ITopic> targetAllTopics = new ArrayList<ITopic>();
        this.getAllChildrenTopic(targetAllTopics, targetTopic);
        this.fixInternalHyperlinkFor(targetAllTopics);
        this.copyComments(sourceTopic.getId(), targetTopic.getId());
    }

    private void copyComments(String sourceObjectId, String targetObjectId) {
        Set<IComment> sourceComments = this.sourceWorkbook.getCommentManager().getComments(sourceObjectId);
        if (!sourceComments.isEmpty()) {
            ICommentManager targetCommentManager = this.targetWorkbook.getCommentManager();
            for (IComment sourceComment : sourceComments) {
                IComment targetComment = targetCommentManager.createComment(sourceComment.getAuthor(), sourceComment.getTime(), targetObjectId);
                targetComment.setContent(sourceComment.getContent());
                targetCommentManager.addComment(targetComment);
            }
        }
    }

    private void fixInternalHyperlinkFor(List<ITopic> allTargetTopics) {
        for (ITopic targetTopic : allTargetTopics) {
            Object sourceElement;
            Object result;
            String hyperlink = targetTopic.getHyperlink();
            if (!HyperlinkUtils.isInternalURL(hyperlink) || (result = this.mapper.get(sourceElement = HyperlinkUtils.findElement(hyperlink, this.sourceWorkbook))) == null) continue;
            targetTopic.setHyperlink(HyperlinkUtils.toInternalURL(result));
        }
    }

    private void copyHtmlNotesContent(IHtmlNotesContent sourceNotesContent, IHtmlNotesContent targetNotesContent) throws IOException {
        for (IParagraph sourceParagraph : sourceNotesContent.getParagraphs()) {
            IParagraph targetParagraph = targetNotesContent.createParagraph();
            targetParagraph.setStyleId(this.convertStyleId(sourceParagraph.getStyleId()));
            targetNotesContent.addParagraph(targetParagraph);
            this.copySpanList(sourceParagraph, targetParagraph, targetNotesContent);
        }
    }

    private void copySpanList(ISpanList sourceSpanList, ISpanList targetSpanList, IHtmlNotesContent spanFactory) throws IOException {
        for (ISpan sourceSpan : sourceSpanList.getSpans()) {
            ISpan targetSpan;
            if (sourceSpan instanceof ITextSpan) {
                targetSpan = spanFactory.createTextSpan(((ITextSpan)sourceSpan).getTextContent());
            } else if (sourceSpan instanceof IImageSpan) {
                String source = ((IImageSpan)sourceSpan).getSource();
                String newImageSource = this.convertHyperlink(source);
                targetSpan = spanFactory.createImageSpan(newImageSource);
            } else {
                if (!(sourceSpan instanceof IHyperlinkSpan)) continue;
                targetSpan = spanFactory.createHyperlinkSpan(((IHyperlinkSpan)sourceSpan).getHref());
                this.copySpanList((IHyperlinkSpan)sourceSpan, (IHyperlinkSpan)targetSpan, spanFactory);
            }
            targetSpan.setStyleId(this.convertStyleId(sourceSpan.getStyleId()));
            targetSpanList.addSpan(targetSpan);
        }
    }

    private void copyBoundaryContents(IBoundary sourceBoundary, IBoundary targetBoundary) throws IOException {
        this.mapper.put(sourceBoundary, targetBoundary);
        this.mapper.putString("workbookComponents", sourceBoundary.getId(), targetBoundary.getId());
        targetBoundary.setTitleText(sourceBoundary.getTitleText());
        targetBoundary.setStyleId(this.convertStyleId(sourceBoundary.getStyleId()));
        if (sourceBoundary.isMasterBoundary()) {
            targetBoundary.setMasterBoundary(sourceBoundary.isMasterBoundary());
        } else {
            targetBoundary.setStartIndex(sourceBoundary.getStartIndex());
            targetBoundary.setEndIndex(sourceBoundary.getEndIndex());
        }
    }

    private void copySummaryContents(ISummary sourceSummary, ISummary targetSummary) throws IOException {
        this.mapper.put(sourceSummary, targetSummary);
        this.mapper.putString("workbookComponents", sourceSummary.getId(), targetSummary.getId());
        targetSummary.setStyleId(this.convertStyleId(sourceSummary.getStyleId()));
        targetSummary.setTopicId(this.mapper.getString("workbookComponents", sourceSummary.getTopicId()));
        targetSummary.setStartIndex(sourceSummary.getStartIndex());
        targetSummary.setEndIndex(sourceSummary.getEndIndex());
    }

    private void copyTopicExtension(ITopicExtension sourceExt, ITopicExtension targetExt) throws IOException {
        for (IResourceRef ref : sourceExt.getResourceRefs()) {
            String targetEntryPath;
            if (!"file-entry".equals(ref.getType()) || (targetEntryPath = this.convertEntryPath(ref.getResourceId())) == null) continue;
            targetExt.addResourceRef(targetExt.getOwnedWorkbook().createResourceRef("file-entry", targetEntryPath));
        }
        this.copyTopicExtensionElement(sourceExt.getContent(), targetExt.getContent());
    }

    private void copyTopicExtensionElement(ITopicExtensionElement sourceEle, ITopicExtensionElement targetEle) {
        for (String key : sourceEle.getAttributeKeys()) {
            targetEle.setAttribute(key, sourceEle.getAttribute(key));
        }
        targetEle.setTextContent(sourceEle.getTextContent());
        for (ITopicExtensionElement sourceChild : sourceEle.getChildren()) {
            ITopicExtensionElement targetChild = (ITopicExtensionElement)targetEle.createChild(sourceChild.getName());
            this.copyTopicExtensionElement(sourceChild, targetChild);
        }
    }

    private void copyRelationshipContents(IRelationship sourceRel, IRelationship targetRel) throws IOException {
        this.mapper.put(sourceRel, targetRel);
        this.mapper.putString("workbookComponents", sourceRel.getId(), targetRel.getId());
        targetRel.setTitleText(sourceRel.getTitleText());
        String end1Id = this.mapper.getString("workbookComponents", sourceRel.getEnd1Id());
        targetRel.setEnd1Id(end1Id == null ? sourceRel.getEnd1Id() : end1Id);
        String end2Id = this.mapper.getString("workbookComponents", sourceRel.getEnd2Id());
        targetRel.setEnd2Id(end2Id == null ? sourceRel.getEnd2Id() : end2Id);
        targetRel.setStyleId(this.convertStyleId(sourceRel.getStyleId()));
        this.copyControlPointContents(sourceRel, targetRel, 0);
        this.copyControlPointContents(sourceRel, targetRel, 1);
    }

    private void copyControlPointContents(IRelationship sourceRel, IRelationship targetRel, int index) {
        IControlPoint sourceControlPoint = sourceRel.getControlPoint(index);
        if (!(sourceControlPoint.hasPosition() || sourceControlPoint.hasPolarAngle() || sourceControlPoint.hasPolarAmount())) {
            return;
        }
        IControlPoint targetControlPoint = targetRel.getControlPoint(index);
        if (sourceControlPoint.hasPosition()) {
            Point position = sourceControlPoint.getPosition();
            targetControlPoint.setPosition(new Point(position.x, position.y));
        }
        if (sourceControlPoint.hasPolarAngle()) {
            targetControlPoint.setPolarAngle(sourceControlPoint.getPolarAngle());
        }
        if (sourceControlPoint.hasPolarAmount()) {
            targetControlPoint.setPolarAmount(sourceControlPoint.getPolarAmount());
        }
    }

    private void copyWorkbookExtension(IWorkbookExtension sourceExt, IWorkbookExtension targetExt) throws IOException {
        for (IResourceRef ref : sourceExt.getResourceRefs()) {
            String targetEntryPath;
            if (!"file-entry".equals(ref.getType()) || (targetEntryPath = this.convertEntryPath(ref.getResourceId())) == null) continue;
            targetExt.addResourceRef(targetExt.getOwnedWorkbook().createResourceRef("file-entry", targetEntryPath));
        }
        this.copyWorkbookExtensionElement(sourceExt.getContent(), targetExt.getContent());
    }

    private void copyWorkbookExtensionElement(IWorkbookExtensionElement sourceEle, IWorkbookExtensionElement targetEle) throws IOException {
        targetEle.setTextContent(sourceEle.getTextContent());
        for (String key : sourceEle.getAttributeKeys()) {
            String value = sourceEle.getAttribute(key);
            if ("resource-path".equals(key)) {
                value = this.convertEntryPath(value);
            } else if ("object-id".equals(key)) {
                value = this.mapper.getString("workbookComponents", value);
            }
            targetEle.setAttribute(key, value);
        }
        for (IWorkbookExtensionElement sourceE : sourceEle.getChildren()) {
            IWorkbookExtensionElement targetE = (IWorkbookExtensionElement)targetEle.createChild(sourceE.getName());
            this.copyWorkbookExtensionElement(sourceE, targetE);
        }
    }

    private String convertHyperlink(String sourceHyperlink) throws IOException {
        if (sourceHyperlink == null) {
            return null;
        }
        if (HyperlinkUtils.isAttachmentURL(sourceHyperlink)) {
            String sourceEntryPath = HyperlinkUtils.toAttachmentPath(sourceHyperlink);
            String targetEntryPath = this.convertEntryPath(sourceEntryPath);
            return targetEntryPath == null ? null : HyperlinkUtils.toAttachmentURL(targetEntryPath);
        }
        HyperlinkUtils.isInternalURL(sourceHyperlink);
        return sourceHyperlink;
    }

    private String convertEntryPath(String sourceEntryPath) throws IOException {
        String targetEntryPath;
        IFileEntry sourceEntry = this.sourceManifest.getFileEntry(sourceEntryPath);
        if (sourceEntry == null || !sourceEntry.canRead()) {
            return null;
        }
        if (sourceEntryPath.startsWith("attachments/")) {
            targetEntryPath = this.mapper.getString("fileEntries", sourceEntryPath);
            if (targetEntryPath == null) {
                IFileEntry targetEntry;
                InputStream sourceStream = sourceEntry.openInputStream();
                try {
                    targetEntry = this.targetManifest.createAttachmentFromStream(sourceStream, sourceEntryPath, sourceEntry.getMediaType());
                }
                finally {
                    sourceStream.close();
                }
                targetEntryPath = targetEntry.getPath();
                this.mapper.putString("fileEntries", sourceEntryPath, targetEntryPath);
            }
        } else {
            targetEntryPath = sourceEntryPath;
            IFileEntry targetEntry = this.targetManifest.getFileEntry(targetEntryPath);
            if (targetEntry == null) {
                targetEntry = this.targetManifest.createFileEntry(targetEntryPath, sourceEntry.getMediaType());
                InputStream sourceStream = sourceEntry.openInputStream();
                try {
                    OutputStream targetStream = targetEntry.openOutputStream();
                    try {
                        FileUtils.transfer(sourceStream, targetStream, false);
                    }
                    finally {
                        targetStream.close();
                    }
                }
                finally {
                    sourceStream.close();
                }
            }
        }
        return targetEntryPath;
    }

    private IStyle findOrCloneStyle(IStyle sourceStyle) throws IOException {
        if (sourceStyle == null) {
            return null;
        }
        String sourceStyleId = sourceStyle.getId();
        String targetStyleId = this.mapper.getString("styleSheetComponents", sourceStyleId);
        if (targetStyleId != null) {
            return this.targetStyleSheet.findStyle(targetStyleId);
        }
        String groupName = this.sourceStyleSheet.findOwnedGroup(sourceStyle);
        if (groupName == null) {
            return null;
        }
        IStyle targetStyle = this.targetStyleSheet.createStyle(sourceStyle.getType());
        targetStyle.setName(sourceStyle.getName());
        Iterator<Property> properties = sourceStyle.properties();
        while (properties.hasNext()) {
            Property p = properties.next();
            String value = p.value;
            if (HyperlinkUtils.isAttachmentURL(value)) {
                value = this.convertHyperlink(value);
            }
            targetStyle.setProperty(p.key, value);
        }
        Iterator<Property> defaultStyleIds = sourceStyle.defaultStyles();
        while (defaultStyleIds.hasNext()) {
            Property p = defaultStyleIds.next();
            targetStyle.setDefaultStyleId(p.key, this.convertStyleId(p.value));
        }
        this.targetStyleSheet.addStyle(targetStyle, groupName);
        this.mapper.put(sourceStyle, targetStyle);
        this.mapper.putString("styleSheetComponents", sourceStyleId, targetStyle.getId());
        return targetStyle;
    }

    private String convertStyleId(String sourceStyleId) throws IOException {
        if (sourceStyleId == null) {
            return null;
        }
        String targetStyleId = this.mapper.getString("styleSheetComponents", sourceStyleId);
        if (targetStyleId != null) {
            return targetStyleId;
        }
        IStyle sourceStyle = this.sourceStyleSheet.findStyle(sourceStyleId);
        if (sourceStyle == null) {
            return null;
        }
        IStyle targetStyle = this.findOrCloneStyle(sourceStyle);
        return targetStyle == null ? null : targetStyle.getId();
    }
}

