/*
 * Decompiled with CFR 0.152.
 */
package org.python.compiler;

import org.python.core.CompilerFlags;
import org.python.parser.ParseException;
import org.python.parser.PythonGrammarTreeConstants;
import org.python.parser.SimpleNode;
import org.python.parser.ast.Expr;
import org.python.parser.ast.ImportFrom;
import org.python.parser.ast.Interactive;
import org.python.parser.ast.Module;
import org.python.parser.ast.Str;
import org.python.parser.ast.modType;
import org.python.parser.ast.stmtType;

public class Future
implements PythonGrammarTreeConstants {
    private boolean division;
    private boolean generators;
    private static final String FUTURE = "__future__";

    private boolean check(ImportFrom importFrom) throws Exception {
        if (!importFrom.module.equals(FUTURE)) {
            return false;
        }
        int n = importFrom.names.length;
        if (n == 0) {
            throw new ParseException("future statement does not support import *", (SimpleNode)importFrom);
        }
        for (int i = 0; i < n; ++i) {
            String string2 = importFrom.names[i].name;
            if (string2.equals("nested_scopes")) continue;
            if (string2.equals("division")) {
                this.division = true;
                continue;
            }
            if (string2.equals("generators")) {
                this.generators = true;
                continue;
            }
            throw new ParseException("future feature " + string2 + " is not defined", (SimpleNode)importFrom);
        }
        return true;
    }

    public void preprocessFutures(modType modType2, CompilerFlags compilerFlags) throws Exception {
        stmtType stmtType2;
        if (compilerFlags != null) {
            this.division = compilerFlags.division;
        }
        int n = 0;
        stmtType[] stmtTypeArray = null;
        if (modType2 instanceof Module) {
            stmtTypeArray = ((Module)modType2).body;
            if (stmtTypeArray.length > 0 && stmtTypeArray[0] instanceof Expr && ((Expr)stmtTypeArray[0]).value instanceof Str) {
                ++n;
            }
        } else if (modType2 instanceof Interactive) {
            stmtTypeArray = ((Interactive)modType2).body;
        } else {
            return;
        }
        for (int i = n; i < stmtTypeArray.length && (stmtType2 = stmtTypeArray[i]) instanceof ImportFrom; ++i) {
            stmtType2.from_future_checked = true;
            if (!this.check((ImportFrom)stmtType2)) break;
        }
        if (compilerFlags != null) {
            boolean bl = compilerFlags.division = compilerFlags.division || this.division;
        }
        if (compilerFlags != null) {
            compilerFlags.generator_allowed = compilerFlags.generator_allowed || this.generators;
        }
    }

    public static void checkFromFuture(ImportFrom importFrom) throws Exception {
        if (importFrom.from_future_checked) {
            return;
        }
        if (importFrom.module.equals(FUTURE)) {
            throw new ParseException("from __future__ imports must occur at the beginning of the file", (SimpleNode)importFrom);
        }
        importFrom.from_future_checked = true;
    }

    public boolean areDivisionOn() {
        return this.division;
    }
}

