/*
 * Decompiled with CFR 0.152.
 */
package org.languagetool.dev;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import org.languagetool.dev.HomophoneOccurrenceDumper;

class NGramStats {
    NGramStats() {
    }

    private void lookup(File dir, String phrase) throws IOException {
        try (HomophoneOccurrenceDumper lm = new HomophoneOccurrenceDumper(dir);){
            String[] tokens = phrase.split(" ");
            if (tokens.length > 3) {
                throw new RuntimeException("Phrases of length " + tokens.length + " are not yet supported: '" + phrase + "'");
            }
            long count = lm.getCount(Arrays.asList(tokens));
            System.out.println(phrase + ": " + count);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 1 && args.length != 2) {
            System.out.println("Usage: " + NGramStats.class.getSimpleName() + " <dir> <phrase>");
            System.out.println("  'dir' is a directory with '1grams' etc sub directories with a Lucene index of ngrams");
            System.out.println("  'phrase' is a 1 to 3 word case-sensitive phrase, e.g. \"the tall boy\" (include the quotes)");
            System.exit(1);
        }
        String dir = args[0];
        String phrase = args[1];
        NGramStats stats = new NGramStats();
        stats.lookup(new File(dir), phrase);
    }
}

