/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole.rest.user;

import com.google.inject.assistedinject.Assisted;
import com.google.inject.assistedinject.AssistedInject;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Context;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.GuacamoleSecurityException;
import org.apache.guacamole.net.auth.ActivityRecord;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.net.auth.Credentials;
import org.apache.guacamole.net.auth.Directory;
import org.apache.guacamole.net.auth.Identifiable;
import org.apache.guacamole.net.auth.Permissions;
import org.apache.guacamole.net.auth.User;
import org.apache.guacamole.net.auth.UserContext;
import org.apache.guacamole.net.auth.credentials.GuacamoleCredentialsException;
import org.apache.guacamole.rest.directory.DirectoryObjectResource;
import org.apache.guacamole.rest.directory.DirectoryObjectTranslator;
import org.apache.guacamole.rest.history.APIActivityRecord;
import org.apache.guacamole.rest.identifier.RelatedObjectSetResource;
import org.apache.guacamole.rest.permission.APIPermissionSet;
import org.apache.guacamole.rest.permission.PermissionSetResource;
import org.apache.guacamole.rest.user.APIUser;
import org.apache.guacamole.rest.user.APIUserPasswordUpdate;

@Produces(value={"application/json"})
@Consumes(value={"application/json"})
public class UserResource
extends DirectoryObjectResource<User, APIUser> {
    private final UserContext userContext;
    private final Directory<User> directory;
    private final User user;

    @AssistedInject
    public UserResource(@Assisted UserContext userContext, @Assisted Directory<User> directory, @Assisted User user, DirectoryObjectTranslator<User, APIUser> translator) {
        super(userContext, directory, (Identifiable)user, translator);
        this.userContext = userContext;
        this.directory = directory;
        this.user = user;
    }

    @GET
    @Path(value="history")
    public List<APIActivityRecord> getUserHistory() throws GuacamoleException {
        ArrayList<APIActivityRecord> apiRecords = new ArrayList<APIActivityRecord>();
        for (ActivityRecord record : this.user.getHistory()) {
            apiRecords.add(new APIActivityRecord(record));
        }
        return apiRecords;
    }

    public void updateObject(APIUser modifiedObject) throws GuacamoleException {
        if (this.userContext.self().getIdentifier().equals(modifiedObject.getUsername())) {
            throw new GuacamoleSecurityException("Permission denied.");
        }
        super.updateObject((Object)modifiedObject);
    }

    @PUT
    @Path(value="password")
    public void updatePassword(APIUserPasswordUpdate userPasswordUpdate, @Context HttpServletRequest request) throws GuacamoleException {
        Credentials credentials = new Credentials(this.user.getIdentifier(), userPasswordUpdate.getOldPassword(), request);
        try {
            AuthenticationProvider authProvider = this.userContext.getAuthenticationProvider();
            if (authProvider.authenticateUser(credentials) == null) {
                throw new GuacamoleSecurityException("Permission denied.");
            }
        }
        catch (GuacamoleCredentialsException e) {
            throw new GuacamoleSecurityException("Permission denied.");
        }
        this.user.setPassword(userPasswordUpdate.getNewPassword());
        this.directory.update((Identifiable)this.user);
    }

    @Path(value="permissions")
    public PermissionSetResource getPermissions() {
        return new PermissionSetResource((Permissions)this.user);
    }

    @GET
    @Path(value="effectivePermissions")
    public APIPermissionSet getEffectivePermissions() throws GuacamoleException {
        return new APIPermissionSet(this.user.getEffectivePermissions());
    }

    @Path(value="userGroups")
    public RelatedObjectSetResource getUserGroups() throws GuacamoleException {
        return new RelatedObjectSetResource(this.user.getUserGroups());
    }
}

