/*
 * Decompiled with CFR 0.152.
 */
package org.apache.guacamole;

import com.google.inject.Guice;
import com.google.inject.Inject;
import com.google.inject.Injector;
import com.google.inject.Module;
import com.google.inject.Stage;
import com.google.inject.servlet.GuiceServletContextListener;
import java.util.List;
import javax.servlet.ServletContextEvent;
import org.apache.guacamole.EnvironmentModule;
import org.apache.guacamole.GuacamoleException;
import org.apache.guacamole.environment.Environment;
import org.apache.guacamole.environment.LocalEnvironment;
import org.apache.guacamole.extension.ExtensionModule;
import org.apache.guacamole.log.LogModule;
import org.apache.guacamole.net.auth.AuthenticationProvider;
import org.apache.guacamole.rest.RESTServiceModule;
import org.apache.guacamole.rest.auth.HashTokenSessionMap;
import org.apache.guacamole.rest.auth.TokenSessionMap;
import org.apache.guacamole.tunnel.TunnelModule;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuacamoleServletContextListener
extends GuiceServletContextListener {
    private final Logger logger = LoggerFactory.getLogger(GuacamoleServletContextListener.class);
    private Environment environment;
    private TokenSessionMap sessionMap;
    @Inject
    private List<AuthenticationProvider> authProviders;

    public void contextInitialized(ServletContextEvent servletContextEvent) {
        try {
            this.environment = new LocalEnvironment();
            this.sessionMap = new HashTokenSessionMap(this.environment);
        }
        catch (GuacamoleException e) {
            this.logger.error("Unable to read guacamole.properties: {}", (Object)e.getMessage());
            this.logger.debug("Error reading guacamole.properties.", (Throwable)e);
            throw new RuntimeException(e);
        }
        super.contextInitialized(servletContextEvent);
    }

    protected Injector getInjector() {
        Injector injector = Guice.createInjector((Stage)Stage.PRODUCTION, (Module[])new Module[]{new EnvironmentModule(this.environment), new LogModule(this.environment), new ExtensionModule(this.environment), new RESTServiceModule(this.sessionMap), new TunnelModule()});
        injector.injectMembers((Object)this);
        return injector;
    }

    public void contextDestroyed(ServletContextEvent servletContextEvent) {
        super.contextDestroyed(servletContextEvent);
        if (this.sessionMap != null) {
            this.sessionMap.shutdown();
        }
        if (this.authProviders != null) {
            for (AuthenticationProvider authProvider : this.authProviders) {
                authProvider.shutdown();
            }
        }
    }
}

