/*
 * Decompiled with CFR 0.152.
 */
package org.apache.mina.proxy;

import java.util.LinkedList;
import java.util.Queue;
import org.apache.mina.core.buffer.IoBuffer;
import org.apache.mina.core.filterchain.IoFilter;
import org.apache.mina.core.future.DefaultWriteFuture;
import org.apache.mina.core.future.WriteFuture;
import org.apache.mina.core.session.IoSession;
import org.apache.mina.core.write.DefaultWriteRequest;
import org.apache.mina.core.write.WriteRequest;
import org.apache.mina.proxy.ProxyLogicHandler;
import org.apache.mina.proxy.filter.ProxyFilter;
import org.apache.mina.proxy.filter.ProxyHandshakeIoBuffer;
import org.apache.mina.proxy.session.ProxyIoSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractProxyLogicHandler
implements ProxyLogicHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProxyLogicHandler.class);
    private ProxyIoSession proxyIoSession;
    private Queue<Event> writeRequestQueue = null;
    private boolean handshakeComplete = false;

    public AbstractProxyLogicHandler(ProxyIoSession proxyIoSession) {
        this.proxyIoSession = proxyIoSession;
    }

    protected ProxyFilter getProxyFilter() {
        return this.proxyIoSession.getProxyFilter();
    }

    protected IoSession getSession() {
        return this.proxyIoSession.getSession();
    }

    public ProxyIoSession getProxyIoSession() {
        return this.proxyIoSession;
    }

    protected WriteFuture writeData(IoFilter.NextFilter nextFilter, IoBuffer ioBuffer) {
        ProxyHandshakeIoBuffer proxyHandshakeIoBuffer = new ProxyHandshakeIoBuffer(ioBuffer);
        LOGGER.debug("   session write: {}", (Object)proxyHandshakeIoBuffer);
        DefaultWriteFuture defaultWriteFuture = new DefaultWriteFuture(this.getSession());
        this.getProxyFilter().writeData(nextFilter, this.getSession(), new DefaultWriteRequest(proxyHandshakeIoBuffer, defaultWriteFuture), true);
        return defaultWriteFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isHandshakeComplete() {
        AbstractProxyLogicHandler abstractProxyLogicHandler = this;
        synchronized (abstractProxyLogicHandler) {
            return this.handshakeComplete;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected final void setHandshakeComplete() {
        Object object = this;
        synchronized (object) {
            this.handshakeComplete = true;
        }
        object = this.getProxyIoSession();
        ((ProxyIoSession)object).getConnector().fireConnected(((ProxyIoSession)object).getSession()).awaitUninterruptibly();
        LOGGER.debug("  handshake completed");
        try {
            ((ProxyIoSession)object).getEventQueue().flushPendingSessionEvents();
            this.flushPendingWriteRequests();
        }
        catch (Exception exception) {
            LOGGER.error("Unable to flush pending write requests", (Throwable)exception);
        }
    }

    protected synchronized void flushPendingWriteRequests() throws Exception {
        Event event;
        LOGGER.debug(" flushPendingWriteRequests()");
        if (this.writeRequestQueue == null) {
            return;
        }
        while ((event = this.writeRequestQueue.poll()) != null) {
            LOGGER.debug(" Flushing buffered write request: {}", event.data);
            this.getProxyFilter().filterWrite(event.nextFilter, this.getSession(), (WriteRequest)event.data);
        }
        this.writeRequestQueue = null;
    }

    public synchronized void enqueueWriteRequest(IoFilter.NextFilter nextFilter, WriteRequest writeRequest) {
        if (this.writeRequestQueue == null) {
            this.writeRequestQueue = new LinkedList<Event>();
        }
        this.writeRequestQueue.offer(new Event(nextFilter, writeRequest));
    }

    protected void closeSession(String string, Throwable throwable) {
        if (throwable != null) {
            LOGGER.error(string, throwable);
            this.proxyIoSession.setAuthenticationFailed(true);
        } else {
            LOGGER.error(string);
        }
        this.getSession().close(true);
    }

    protected void closeSession(String string) {
        this.closeSession(string, null);
    }

    private static final class Event {
        private final IoFilter.NextFilter nextFilter;
        private final Object data;

        Event(IoFilter.NextFilter nextFilter, Object object) {
            this.nextFilter = nextFilter;
            this.data = object;
        }
    }
}

