/*
 * Decompiled with CFR 0.152.
 */
package net.beeger.squareness.delegate;

import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.LayoutManager2;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.MouseEvent;
import java.awt.event.WindowEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.JComponent;
import javax.swing.JLayeredPane;
import javax.swing.JRootPane;
import javax.swing.LookAndFeel;
import javax.swing.SwingUtilities;
import javax.swing.event.MouseInputListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicRootPaneUI;
import net.beeger.squareness.SquarenessLookAndFeel;
import net.beeger.squareness.util.SquarenessTitlePane;

public class SquarenessRootPaneUI
extends BasicRootPaneUI {
    private static final String[] borderKeys = new String[]{null, "RootPane.frameBorder", "RootPane.plainDialogBorder", "RootPane.informationDialogBorder", "RootPane.errorDialogBorder", "RootPane.colorChooserDialogBorder", "RootPane.fileChooserDialogBorder", "RootPane.questionDialogBorder", "RootPane.warningDialogBorder"};
    private static final int CORNER_DRAG_WIDTH = 16;
    private static final int BORDER_DRAG_THICKNESS = 5;
    private Window _window;
    private JComponent _titlePane;
    private MouseInputListener _mouseInputListener;
    private LayoutManager _layoutManager;
    private LayoutManager _savedOldLayout;
    private JRootPane _root;
    private Cursor _lastCursor = Cursor.getPredefinedCursor(0);
    private static final int[] cursorMapping = new int[]{6, 6, 8, 7, 7, 6, 0, 0, 0, 7, 10, 0, 0, 0, 11, 4, 0, 0, 0, 5, 4, 4, 9, 5, 5};

    public static ComponentUI createUI(JComponent c) {
        return new SquarenessRootPaneUI();
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        this._root = (JRootPane)c;
        int style = this._root.getWindowDecorationStyle();
        if (style != 0) {
            this.installClientDecorations(this._root);
        }
    }

    public void uninstallUI(JComponent c) {
        super.uninstallUI(c);
        this.uninstallClientDecorations(this._root);
        this._layoutManager = null;
        this._mouseInputListener = null;
        this._root = null;
    }

    void installBorder(JRootPane root) {
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            LookAndFeel.uninstallBorder(root);
        } else {
            LookAndFeel.installBorder(root, borderKeys[style]);
        }
    }

    private void uninstallBorder(JRootPane root) {
        LookAndFeel.uninstallBorder(root);
    }

    private void installWindowListeners(JRootPane root, Component parent) {
        this._window = parent instanceof Window ? (Window)parent : SwingUtilities.getWindowAncestor(parent);
        if (this._window != null) {
            if (this._mouseInputListener == null) {
                this._mouseInputListener = this.createWindowMouseInputListener();
            }
            this._window.addMouseListener(this._mouseInputListener);
            this._window.addMouseMotionListener(this._mouseInputListener);
        }
    }

    private void uninstallWindowListeners() {
        if (this._window != null) {
            this._window.removeMouseListener(this._mouseInputListener);
            this._window.removeMouseMotionListener(this._mouseInputListener);
        }
    }

    private void installLayout(JRootPane root) {
        if (this._layoutManager == null) {
            this._layoutManager = this.createLayoutManager();
        }
        this._savedOldLayout = root.getLayout();
        root.setLayout(this._layoutManager);
    }

    private void uninstallLayout(JRootPane root) {
        if (this._savedOldLayout != null) {
            root.setLayout(this._savedOldLayout);
            this._savedOldLayout = null;
        }
    }

    private void installClientDecorations(JRootPane root) {
        this.installBorder(root);
        JComponent titlePane = this.createTitlePane(root);
        this.setTitlePane(root, titlePane);
        this.installWindowListeners(root, root.getParent());
        this.installLayout(root);
        if (this._window != null) {
            root.revalidate();
            root.repaint();
        }
    }

    private void uninstallClientDecorations(JRootPane root) {
        this.uninstallBorder(root);
        this.uninstallWindowListeners();
        this.setTitlePane(root, null);
        this.uninstallLayout(root);
        int style = root.getWindowDecorationStyle();
        if (style == 0) {
            root.repaint();
            root.revalidate();
        }
        if (this._window != null) {
            this._window.setCursor(Cursor.getPredefinedCursor(0));
        }
        this._window = null;
    }

    private JComponent createTitlePane(JRootPane root) {
        return new SquarenessFrameTitlePane(root);
    }

    private MouseInputListener createWindowMouseInputListener() {
        return new MouseInputHandler();
    }

    private LayoutManager createLayoutManager() {
        return new MetalRootLayout();
    }

    private void setTitlePane(JRootPane root, JComponent titlePane) {
        JLayeredPane layeredPane = root.getLayeredPane();
        JComponent oldTitlePane = this.getTitlePane();
        if (oldTitlePane != null) {
            oldTitlePane.setVisible(false);
            layeredPane.remove(oldTitlePane);
        }
        if (titlePane != null) {
            layeredPane.add((Component)titlePane, JLayeredPane.FRAME_CONTENT_LAYER);
            titlePane.setVisible(true);
        }
        this._titlePane = titlePane;
    }

    private JComponent getTitlePane() {
        return this._titlePane;
    }

    private JRootPane getRootPane() {
        return this._root;
    }

    public void propertyChange(PropertyChangeEvent e) {
        super.propertyChange(e);
        String propertyName = e.getPropertyName();
        if (propertyName == null) {
            return;
        }
        if (propertyName.equals("windowDecorationStyle")) {
            JRootPane root = (JRootPane)e.getSource();
            int style = root.getWindowDecorationStyle();
            this.uninstallClientDecorations(root);
            if (style != 0) {
                this.installClientDecorations(root);
            }
        } else if (propertyName.equals("ancestor")) {
            this.uninstallWindowListeners();
            if (((JRootPane)e.getSource()).getWindowDecorationStyle() != 0) {
                this.installWindowListeners(this._root, this._root.getParent());
            }
        }
    }

    private static class SquarenessFrameTitlePane
    extends SquarenessTitlePane {
        private JRootPane _rootPane;
        private Window _window;

        public SquarenessFrameTitlePane(JRootPane rootPane) {
            this._rootPane = rootPane;
        }

        public void addNotify() {
            super.addNotify();
            this._window = SwingUtilities.getWindowAncestor(this);
            this._window.addPropertyChangeListener(new PropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent evt) {
                    this.update();
                    _window.repaint();
                }
            });
            this._rootPane.addPropertyChangeListener(new PropertyChangeListener(this){
                private final /* synthetic */ SquarenessFrameTitlePane this$0;
                {
                    this.this$0 = this$0;
                }

                public void propertyChange(PropertyChangeEvent evt) {
                    SquarenessFrameTitlePane.access$900(this.this$0);
                    SquarenessFrameTitlePane.access$800(this.this$0).repaint();
                }
            });
        }

        protected void paintComponent(Graphics g) {
            this.update();
            Color oldColor = g.getColor();
            g.setColor(SquarenessLookAndFeel.getCurrentSquarenessTheme().getWindowBackgroundColor());
            g.fillRect(0, 0, this.getWidth(), this.getHeight());
            g.setColor(oldColor);
        }

        public boolean isLeftToRight() {
            return this._window != null ? this._window.getComponentOrientation().isLeftToRight() : true;
        }

        protected boolean isIconifiable() {
            return this.isFrame();
        }

        protected boolean isMaximizable() {
            return this.isFrame() && this.getFrame().isResizable();
        }

        protected boolean isClosable() {
            return true;
        }

        protected void close() {
            if (this._window != null) {
                this._window.dispatchEvent(new WindowEvent(this._window, 201));
            }
        }

        protected void iconify() {
            Frame frame = this.getFrame();
            if (frame != null) {
                frame.setExtendedState(this.getFrame().getExtendedState() | 1);
            }
        }

        protected void maximize() {
            Frame frame = this.getFrame();
            if (frame != null) {
                frame.setExtendedState(this.getFrame().getExtendedState() | 6);
            }
        }

        protected void restore() {
            Frame frame = this.getFrame();
            if (frame == null) {
                return;
            }
            if (this.isIconified()) {
                frame.setExtendedState(this.getFrame().getExtendedState() & 0xFFFFFFFE);
            } else {
                frame.setExtendedState(this.getFrame().getExtendedState() & 0xFFFFFFF9);
            }
        }

        protected boolean isMaximized() {
            return this.isFrame() && (this.getFrame().getExtendedState() & 6) != 0;
        }

        protected boolean isIconified() {
            return this.isFrame() && (this.getFrame().getExtendedState() & 1) != 0;
        }

        protected String getTitle() {
            return this.isFrame() ? this.getFrame().getTitle() : null;
        }

        protected boolean isFrame() {
            return this._window instanceof Frame;
        }

        protected Frame getFrame() {
            return (Frame)this._window;
        }

        static /* synthetic */ void access$900(SquarenessFrameTitlePane x0) {
            x0.update();
        }
    }

    private class MouseInputHandler
    implements MouseInputListener {
        private boolean isMovingWindow;
        private int dragCursor;
        private int dragOffsetX;
        private int dragOffsetY;
        private int dragWidth;
        private int dragHeight;

        private MouseInputHandler() {
        }

        public void mousePressed(MouseEvent ev) {
            int frameState;
            JRootPane rootPane = SquarenessRootPaneUI.this.getRootPane();
            if (rootPane.getWindowDecorationStyle() == 0) {
                return;
            }
            Point dragWindowOffset = ev.getPoint();
            Window w = (Window)ev.getSource();
            if (w != null) {
                w.toFront();
            }
            Point convertedDragWindowOffset = SwingUtilities.convertPoint(w, dragWindowOffset, SquarenessRootPaneUI.this.getTitlePane());
            Frame f = null;
            Dialog d = null;
            if (w instanceof Frame) {
                f = (Frame)w;
            } else if (w instanceof Dialog) {
                d = (Dialog)w;
            }
            int n = frameState = f != null ? f.getExtendedState() : 0;
            if (SquarenessRootPaneUI.this.getTitlePane() != null && SquarenessRootPaneUI.this.getTitlePane().contains(convertedDragWindowOffset)) {
                if ((f != null && (frameState & 6) == 0 || d != null) && dragWindowOffset.y >= 5 && dragWindowOffset.x >= 5 && dragWindowOffset.x < w.getWidth() - 5) {
                    this.isMovingWindow = true;
                    this.dragOffsetX = dragWindowOffset.x;
                    this.dragOffsetY = dragWindowOffset.y;
                }
            } else if (f != null && f.isResizable() && (frameState & 6) == 0 || d != null && d.isResizable()) {
                this.dragOffsetX = dragWindowOffset.x;
                this.dragOffsetY = dragWindowOffset.y;
                this.dragWidth = w.getWidth();
                this.dragHeight = w.getHeight();
                this.dragCursor = this.getCursor(this.calculateCorner(w, dragWindowOffset.x, dragWindowOffset.y));
            }
        }

        public void mouseReleased(MouseEvent ev) {
            if (this.dragCursor != 0 && SquarenessRootPaneUI.this._window != null && !SquarenessRootPaneUI.this._window.isValid()) {
                SquarenessRootPaneUI.this._window.validate();
                SquarenessRootPaneUI.this.getRootPane().repaint();
            }
            this.isMovingWindow = false;
            this.dragCursor = 0;
        }

        public void mouseMoved(MouseEvent ev) {
            JRootPane root = SquarenessRootPaneUI.this.getRootPane();
            if (root.getWindowDecorationStyle() == 0) {
                return;
            }
            Window w = (Window)ev.getSource();
            Frame f = null;
            Dialog d = null;
            if (w instanceof Frame) {
                f = (Frame)w;
            } else if (w instanceof Dialog) {
                d = (Dialog)w;
            }
            int cursor = this.getCursor(this.calculateCorner(w, ev.getX(), ev.getY()));
            if (cursor != 0 && (f != null && f.isResizable() && (f.getExtendedState() & 6) == 0 || d != null && d.isResizable())) {
                w.setCursor(Cursor.getPredefinedCursor(cursor));
            } else {
                w.setCursor(SquarenessRootPaneUI.this._lastCursor);
            }
        }

        private void adjust(Rectangle bounds, Dimension min, int deltaX, int deltaY, int deltaWidth, int deltaHeight) {
            bounds.x += deltaX;
            bounds.y += deltaY;
            bounds.width += deltaWidth;
            bounds.height += deltaHeight;
            if (min != null) {
                int correction;
                if (bounds.width < min.width) {
                    correction = min.width - bounds.width;
                    if (deltaX != 0) {
                        bounds.x -= correction;
                    }
                    bounds.width = min.width;
                }
                if (bounds.height < min.height) {
                    correction = min.height - bounds.height;
                    if (deltaY != 0) {
                        bounds.y -= correction;
                    }
                    bounds.height = min.height;
                }
            }
        }

        public void mouseDragged(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            Point pt = ev.getPoint();
            if (this.isMovingWindow) {
                Point windowPt = w.getLocationOnScreen();
                windowPt.x += pt.x - this.dragOffsetX;
                windowPt.y += pt.y - this.dragOffsetY;
                w.setLocation(windowPt);
            } else if (this.dragCursor != 0) {
                Rectangle r = w.getBounds();
                Rectangle startBounds = new Rectangle(r);
                Dimension min = w.getMinimumSize();
                switch (this.dragCursor) {
                    case 11: {
                        this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, 0);
                        break;
                    }
                    case 9: {
                        this.adjust(r, min, 0, 0, 0, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 8: {
                        this.adjust(r, min, 0, pt.y - this.dragOffsetY, 0, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 10: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), 0);
                        break;
                    }
                    case 7: {
                        this.adjust(r, min, 0, pt.y - this.dragOffsetY, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 5: {
                        this.adjust(r, min, 0, 0, pt.x + (this.dragWidth - this.dragOffsetX) - r.width, pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                    case 6: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, pt.y - this.dragOffsetY, -(pt.x - this.dragOffsetX), -(pt.y - this.dragOffsetY));
                        break;
                    }
                    case 4: {
                        this.adjust(r, min, pt.x - this.dragOffsetX, 0, -(pt.x - this.dragOffsetX), pt.y + (this.dragHeight - this.dragOffsetY) - r.height);
                        break;
                    }
                }
                if (!r.equals(startBounds)) {
                    w.setBounds(r);
                    if (Toolkit.getDefaultToolkit().isDynamicLayoutActive()) {
                        w.validate();
                        SquarenessRootPaneUI.this.getRootPane().repaint();
                    }
                }
            }
        }

        public void mouseEntered(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            SquarenessRootPaneUI.this._lastCursor = w.getCursor();
            this.mouseMoved(ev);
        }

        public void mouseExited(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            w.setCursor(SquarenessRootPaneUI.this._lastCursor);
        }

        public void mouseClicked(MouseEvent ev) {
            Window w = (Window)ev.getSource();
            Frame f = null;
            if (!(w instanceof Frame)) {
                return;
            }
            f = (Frame)w;
            Point convertedPoint = SwingUtilities.convertPoint(w, ev.getPoint(), SquarenessRootPaneUI.this.getTitlePane());
            int state = f.getExtendedState();
            if (SquarenessRootPaneUI.this.getTitlePane() != null && SquarenessRootPaneUI.this.getTitlePane().contains(convertedPoint) && ev.getClickCount() % 2 == 0 && (ev.getModifiers() & 0x10) != 0 && f.isResizable()) {
                if ((state & 6) != 0) {
                    f.setExtendedState(state & 0xFFFFFFF9);
                } else {
                    f.setExtendedState(state | 6);
                }
                return;
            }
        }

        private int calculateCorner(Component c, int x, int y) {
            int xPosition = this.calculatePosition(x, c.getWidth());
            int yPosition = this.calculatePosition(y, c.getHeight());
            if (xPosition == -1 || yPosition == -1) {
                return -1;
            }
            return yPosition * 5 + xPosition;
        }

        private int getCursor(int corner) {
            if (corner == -1) {
                return 0;
            }
            return cursorMapping[corner];
        }

        private int calculatePosition(int spot, int width) {
            if (spot < 5) {
                return 0;
            }
            if (spot < 16) {
                return 1;
            }
            if (spot >= width - 5) {
                return 4;
            }
            if (spot >= width - 16) {
                return 3;
            }
            return 2;
        }
    }

    private static class MetalRootLayout
    implements LayoutManager2 {
        private MetalRootLayout() {
        }

        public Dimension preferredLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getPreferredSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getPreferredSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof SquarenessRootPaneUI && (titlePane = ((SquarenessRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                tpWidth = tpd.width;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpWidth + i.top + i.bottom);
        }

        public Dimension minimumLayoutSize(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            int cpWidth = 0;
            int cpHeight = 0;
            int mbWidth = 0;
            int mbHeight = 0;
            int tpWidth = 0;
            Insets i = parent.getInsets();
            JRootPane root = (JRootPane)parent;
            Dimension cpd = root.getContentPane() != null ? root.getContentPane().getMinimumSize() : root.getSize();
            if (cpd != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMinimumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof SquarenessRootPaneUI && (titlePane = ((SquarenessRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMinimumSize()) != null) {
                tpWidth = tpd.width;
            }
            return new Dimension(Math.max(Math.max(cpWidth, mbWidth), tpWidth) + i.left + i.right, cpHeight + mbHeight + tpWidth + i.top + i.bottom);
        }

        public Dimension maximumLayoutSize(Container target) {
            int maxWidth;
            int maxHeight;
            Dimension tpd;
            JComponent titlePane;
            Dimension mbd;
            Dimension cpd;
            int cpWidth = Integer.MAX_VALUE;
            int cpHeight = Integer.MAX_VALUE;
            int mbWidth = Integer.MAX_VALUE;
            int mbHeight = Integer.MAX_VALUE;
            int tpWidth = Integer.MAX_VALUE;
            int tpHeight = Integer.MAX_VALUE;
            Insets i = target.getInsets();
            JRootPane root = (JRootPane)target;
            if (root.getContentPane() != null && (cpd = root.getContentPane().getMaximumSize()) != null) {
                cpWidth = cpd.width;
                cpHeight = cpd.height;
            }
            if (root.getJMenuBar() != null && (mbd = root.getJMenuBar().getMaximumSize()) != null) {
                mbWidth = mbd.width;
                mbHeight = mbd.height;
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof SquarenessRootPaneUI && (titlePane = ((SquarenessRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getMaximumSize()) != null) {
                tpWidth = tpd.width;
                tpHeight = tpd.height;
            }
            if ((maxHeight = Math.max(Math.max(cpHeight, mbHeight), tpHeight)) != Integer.MAX_VALUE) {
                maxHeight = cpHeight + mbHeight + tpHeight + i.top + i.bottom;
            }
            if ((maxWidth = Math.max(Math.max(cpWidth, mbWidth), tpWidth)) != Integer.MAX_VALUE) {
                maxWidth += i.left + i.right;
            }
            return new Dimension(maxWidth, maxHeight);
        }

        public void layoutContainer(Container parent) {
            Dimension tpd;
            JComponent titlePane;
            JRootPane root = (JRootPane)parent;
            Rectangle b = root.getBounds();
            Insets i = root.getInsets();
            int nextY = 0;
            int w = b.width - i.right - i.left;
            int h = b.height - i.top - i.bottom;
            if (root.getLayeredPane() != null) {
                root.getLayeredPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getGlassPane() != null) {
                root.getGlassPane().setBounds(i.left, i.top, w, h);
            }
            if (root.getWindowDecorationStyle() != 0 && root.getUI() instanceof SquarenessRootPaneUI && (titlePane = ((SquarenessRootPaneUI)root.getUI()).getTitlePane()) != null && (tpd = titlePane.getPreferredSize()) != null) {
                int tpHeight = tpd.height;
                titlePane.setBounds(0, 0, w, tpHeight);
                nextY += tpHeight;
            }
            if (root.getJMenuBar() != null) {
                Dimension mbd = root.getJMenuBar().getPreferredSize();
                root.getJMenuBar().setBounds(0, nextY, w, mbd.height);
                nextY += mbd.height;
            }
            if (root.getContentPane() != null) {
                root.getContentPane().setBounds(0, nextY, w, h < nextY ? 0 : h - nextY);
            }
        }

        public void addLayoutComponent(String name, Component comp) {
        }

        public void removeLayoutComponent(Component comp) {
        }

        public void addLayoutComponent(Component comp, Object constraints) {
        }

        public float getLayoutAlignmentX(Container target) {
            return 0.0f;
        }

        public float getLayoutAlignmentY(Container target) {
            return 0.0f;
        }

        public void invalidateLayout(Container target) {
        }
    }
}

