/*
 * Decompiled with CFR 0.152.
 */
package org.apache.commons.cli2.commandline;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.prefs.BackingStoreException;
import java.util.prefs.Preferences;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.commandline.CommandLineImpl;
import org.apache.commons.cli2.option.PropertyOption;

public class PreferencesCommandLine
extends CommandLineImpl {
    private static final char NUL = '\u0000';
    private final Preferences preferences;
    private final Option root;
    private final char separator;

    public PreferencesCommandLine(Option root, Preferences preferences) {
        this(root, preferences, '\u0000');
    }

    public PreferencesCommandLine(Option root, Preferences preferences, char separator) {
        this.root = root;
        this.preferences = preferences;
        this.separator = separator;
    }

    @Override
    public boolean hasOption(Option option) {
        if (option == null) {
            return false;
        }
        try {
            return Arrays.asList(this.preferences.keys()).contains(option.getPreferredName());
        }
        catch (BackingStoreException e) {
            return false;
        }
    }

    @Override
    public Option getOption(String trigger) {
        return this.root.findOption(trigger);
    }

    @Override
    public List getValues(Option option, List defaultValues) {
        String value = this.preferences.get(option.getPreferredName(), null);
        if (value == null) {
            return defaultValues;
        }
        if (this.separator > '\u0000') {
            ArrayList<String> values = new ArrayList<String>();
            StringTokenizer tokens = new StringTokenizer(value, String.valueOf(this.separator));
            while (tokens.hasMoreTokens()) {
                values.add(tokens.nextToken());
            }
            return values;
        }
        return Collections.singletonList(value);
    }

    @Override
    public Boolean getSwitch(Option option, Boolean defaultValue) {
        String value = this.preferences.get(option.getPreferredName(), null);
        if ("true".equals(value)) {
            return Boolean.TRUE;
        }
        if ("false".equals(value)) {
            return Boolean.FALSE;
        }
        return defaultValue;
    }

    @Override
    public String getProperty(String property) {
        return this.getProperty(new PropertyOption(), property);
    }

    @Override
    public String getProperty(Option option, String property, String defaultValue) {
        return this.preferences.get(property, defaultValue);
    }

    @Override
    public Set getProperties(Option option) {
        try {
            return new HashSet<String>(Arrays.asList(this.preferences.keys()));
        }
        catch (BackingStoreException e) {
            return Collections.EMPTY_SET;
        }
    }

    @Override
    public Set getProperties() {
        return this.getProperties(new PropertyOption());
    }

    @Override
    public List getOptions() {
        try {
            ArrayList<Option> options = new ArrayList<Option>();
            for (String trigger : Arrays.asList(this.preferences.keys())) {
                Option option = this.root.findOption(trigger);
                if (option == null) continue;
                options.add(option);
            }
            return Collections.unmodifiableList(options);
        }
        catch (BackingStoreException e) {
            return Collections.EMPTY_LIST;
        }
    }

    @Override
    public Set getOptionTriggers() {
        HashSet triggers = new HashSet();
        for (Option option : this.getOptions()) {
            triggers.addAll(option.getTriggers());
        }
        return Collections.unmodifiableSet(triggers);
    }
}

