/*
 * Decompiled with CFR 0.152.
 */
package nl.ikarus.nxt.priv.imageio.icoreader.obj;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.imageio.stream.ImageInputStream;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.IconEntry;
import nl.ikarus.nxt.priv.imageio.icoreader.obj.MyReader;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ICOFile {
    private final boolean DEBUG = Boolean.valueOf(System.getProperty("nl.ikarus.nxt.priv.imageio.icoreader.debug", Boolean.toString(false)));
    private int reserved = 0;
    private int type = 1;
    private int imageCount;
    private List<IconEntry> entries = new ArrayList<IconEntry>();
    private MyReader reader;

    public ICOFile(ImageInputStream in) throws IOException {
        int len;
        ByteArrayOutputStream bout = new ByteArrayOutputStream(10240);
        byte[] buff = new byte[1024];
        while ((len = in.read(buff)) != -1) {
            bout.write(buff, 0, len);
        }
        this.reader = new MyReader(new DataInputStream(new ByteArrayInputStream(bout.toByteArray())));
        bout = null;
        this._init();
    }

    public ICOFile(byte[] data) throws IOException {
        this(new MyReader(new DataInputStream(new ByteArrayInputStream(data))));
    }

    public ICOFile(MyReader r) throws IOException {
        this.reader = r;
        this._init();
    }

    private void _init() throws IOException {
        this.readHeader();
        this.readEntries();
    }

    public int getEntryCount() {
        return this.entries.size();
    }

    public IconEntry getEntry(int nr) {
        return this.entries.get(nr);
    }

    public Iterator<IconEntry> getEntryIterator() {
        return this.entries.iterator();
    }

    private void readHeader() throws IOException {
        this.reserved = this.reader.readWORD();
        this.type = this.reader.readWORD();
        if (this.type != 1) {
            throw new IOException(new StringBuffer().append("Resource is not an ICO file??   expected value: 1, found: ").append(this.type).toString());
        }
        this.imageCount = this.reader.readWORD();
        if (this.DEBUG) {
            System.out.println(new StringBuffer().append(this.imageCount).append(" images in resource").toString());
        }
        if (this.imageCount > 500) {
            throw new IOException("More than 500 icons in resource, aborting to prevent running out of memory....");
        }
    }

    private void readEntries() throws IOException {
        for (int i = 0; i < this.imageCount; ++i) {
            try {
                IconEntry e = new IconEntry(this.reader);
                this.entries.add(e);
                continue;
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
        }
        if (this.DEBUG) {
            System.out.println(new StringBuffer().append("Parsed ").append(this.entries.size()).append(" out of ").append(this.imageCount).append(" entries").toString());
        }
    }
}

