/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers.search;

import cz.vity.freerapid.gui.managers.search.OpenSearchDescription;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.DataURI;
import java.awt.Toolkit;
import java.net.URL;
import java.util.Locale;
import java.util.logging.Logger;
import javax.swing.ImageIcon;

public class SearchItem {
    private final String id;
    private OpenSearchDescription searchDescription;
    private ImageIcon image;
    private static final Logger logger = Logger.getLogger(SearchItem.class.getName());

    public SearchItem(String id, OpenSearchDescription searchDescription) {
        this.id = id;
        this.searchDescription = searchDescription;
    }

    public String getId() {
        return this.id;
    }

    public ImageIcon getImage() {
        if (this.image == null) {
            String imagePath = this.searchDescription.getImage();
            if (imagePath != null) {
                if ((imagePath = imagePath.trim()).toLowerCase(Locale.ENGLISH).startsWith("http://")) {
                    try {
                        URL url = new URL(imagePath);
                        this.image = new ImageIcon(Toolkit.getDefaultToolkit().getImage(url));
                    }
                    catch (Exception e) {
                        logger.warning("Invalid URL for search item image: " + imagePath + " " + e.getMessage());
                    }
                } else {
                    DataURI data = DataURI.parse(imagePath);
                    if (data != null) {
                        this.image = new ImageIcon(data.toImage());
                    }
                }
            }
            if (this.image == null) {
                this.image = this.getDefaultSearchIcon();
                return this.image;
            }
        }
        return this.image;
    }

    private ImageIcon getDefaultSearchIcon() {
        return Swinger.getIconImage("searchDefaultIcon");
    }

    public OpenSearchDescription getSearchDescription() {
        return this.searchDescription;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SearchItem that = (SearchItem)o;
        return !(this.id == null ? that.id != null : !this.id.equals(that.id));
    }

    public int hashCode() {
        return this.id != null ? this.id.hashCode() : 0;
    }
}

