/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.tasks.CoreTask;
import cz.vity.freerapid.gui.managers.AbstractCustomTask;
import cz.vity.freerapid.gui.managers.DataManager;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.gui.managers.StateChangeEvent;
import cz.vity.freerapid.gui.managers.interfaces.FileStateChangeListener;
import cz.vity.freerapid.plugins.webclient.DownloadState;
import java.util.logging.Level;
import java.util.logging.Logger;
import jlibs.core.lang.RuntimeUtil;
import org.jdesktop.application.Application;
import org.jdesktop.application.TaskEvent;
import org.jdesktop.application.TaskListener;

public class ReconnectTask
extends AbstractCustomTask
implements FileStateChangeListener {
    private ManagerDirector director;
    private static final Logger logger = Logger.getLogger(ReconnectTask.class.getName());

    @Override
    public void register(ManagerDirector director) {
        this.director = director;
        director.getDataManager().addFileStateChangedListener(this);
    }

    @Override
    public void unregister(ManagerDirector director) {
        director.getDataManager().removeFileStateChangedListener(this);
        this.director = null;
    }

    @Override
    public void stateChanged(StateChangeEvent event) {
        if (event.getNewState() == DownloadState.COMPLETED) {
            boolean b = AppPrefs.getProperty("reconnectScriptEnabled", true);
            if (!b) {
                return;
            }
            String script = AppPrefs.getProperty("reconnectScript", null);
            if (script == null) {
                return;
            }
            DataManager dataManager = this.director.getDataManager();
            if (dataManager.isDownloading()) {
                this.director.getDataManager().setDownloadFilesState(DownloadState.QUEUED, DownloadState.HOLD_ON);
            } else {
                ScriptTask scriptTask = new ScriptTask(this.director.getContext().getApplication());
                scriptTask.addTaskListener(new TaskListener.Adapter<Void, Void>(){

                    @Override
                    public void doInBackground(TaskEvent<Void> event) {
                        super.doInBackground(event);
                        ReconnectTask.this.director.getDataManager().setDownloadFilesState(DownloadState.QUEUED, DownloadState.HOLD_ON);
                    }

                    @Override
                    public void finished(TaskEvent<Void> event) {
                        ReconnectTask.this.director.getDataManager().setDownloadFilesState(DownloadState.HOLD_ON, DownloadState.QUEUED);
                    }
                });
                this.director.getTaskServiceManager().runTask("workWithFile", scriptTask);
            }
        }
    }

    private class ScriptTask
    extends CoreTask<Void, Void> {
        public ScriptTask(Application application) {
            super(application);
        }

        @Override
        protected Void doInBackground() throws Exception {
            String script = AppPrefs.getProperty("reconnectScript", null);
            if (script == null) {
                return null;
            }
            String s = RuntimeUtil.runCommand(script);
            logger.info("Script output:" + s);
            return null;
        }

        @Override
        protected void failed(Throwable cause) {
            logger.log(Level.SEVERE, "Running script failed", cause);
        }
    }
}

