/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.managers;

import com.jgoodies.common.collect.ArrayListModel;
import cz.vity.freerapid.gui.managers.FileHistoryItem;
import cz.vity.freerapid.gui.managers.ManagerDirector;
import cz.vity.freerapid.model.DownloadFile;
import cz.vity.freerapid.utilities.FileUtils;
import cz.vity.freerapid.utilities.LogUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Logger;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.ApplicationContext;
import org.jdesktop.application.LocalStorage;

public class FileHistoryManager
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(FileHistoryManager.class.getName());
    private final ManagerDirector director;
    private final ApplicationContext context;
    private static final String FILES_LIST_XML = "history.xml";

    public FileHistoryManager(ManagerDirector director, ApplicationContext context) {
        this.director = director;
        this.context = context;
        this.init();
    }

    private void init() {
    }

    private List<FileHistoryItem> loadList(File srcFile) throws IOException {
        File backupFile;
        LinkedList<FileHistoryItem> list = new LinkedList<FileHistoryItem>();
        LocalStorage localStorage = this.context.getLocalStorage();
        if (!srcFile.exists() && (backupFile = FileUtils.getBackupFile(srcFile)).exists()) {
            backupFile.renameTo(srcFile);
        }
        if (!srcFile.exists()) {
            return list;
        }
        Object o = localStorage.load(FILES_LIST_XML);
        if (o instanceof ArrayListModel) {
            return (List)o;
        }
        return list;
    }

    public List<FileHistoryItem> getItems() {
        return this.loadFileHistoryList();
    }

    private List<FileHistoryItem> loadFileHistoryList() {
        List<FileHistoryItem> result = null;
        File srcFile = new File(this.context.getLocalStorage().getDirectory(), FILES_LIST_XML);
        File targetImportedFile = new File(this.context.getLocalStorage().getDirectory(), "history.xml.imported");
        if (srcFile.exists() && !targetImportedFile.exists()) {
            try {
                result = this.loadList(srcFile);
            }
            catch (Exception e) {
                LogUtils.processException(logger, e);
                logger.info("Trying to renew file from backup");
                try {
                    FileUtils.renewBackup(srcFile);
                    result = this.loadList(srcFile);
                }
                catch (FileNotFoundException ex) {
                }
                catch (Exception e1) {
                    LogUtils.processException(logger, e);
                }
            }
            if (result != null) {
                final List<FileHistoryItem> finalResult = result;
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        logger.info("Resaving file history into database from old format");
                        FileHistoryManager.this.director.getDatabaseManager().saveCollection(finalResult);
                    }
                };
                this.director.getDatabaseManager().runOnTask(runnable);
            } else {
                result = new ArrayList<FileHistoryItem>();
            }
            File backupFile = FileUtils.getBackupFile(srcFile);
            if (backupFile.exists()) {
                backupFile.renameTo(new File(this.context.getLocalStorage().getDirectory(), "history.xml.backup.imported"));
            }
            srcFile.renameTo(targetImportedFile);
            return result;
        }
        return this.director.getDatabaseManager().loadAll(FileHistoryItem.class);
    }

    public void addHistoryItem(DownloadFile file, File savedAs) {
        final FileHistoryItem item = new FileHistoryItem(file, savedAs);
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FileHistoryManager.this.director.getDatabaseManager().saveOrUpdate(item);
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable);
        this.fireDataAdded(item);
    }

    public void clearHistory(Runnable succeeded) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FileHistoryManager.this.director.getDatabaseManager().removeAll(FileHistoryItem.class);
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable, succeeded);
    }

    public void removeItems(final Collection<FileHistoryItem> items) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FileHistoryManager.this.director.getDatabaseManager().removeCollection(items);
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable, null);
    }

    public void removeItems(final Collection<FileHistoryItem> items, Runnable succeeded) {
        Runnable runnable = new Runnable(){

            @Override
            public void run() {
                FileHistoryManager.this.director.getDatabaseManager().removeCollection(items);
            }
        };
        this.director.getDatabaseManager().runOnTask(runnable, succeeded);
    }

    private void fireDataAdded(FileHistoryItem dataAdded) {
        this.firePropertyChange("dataAdded", null, dataAdded);
    }
}

