/*
 * Decompiled with CFR 0.152.
 */
package cz.vity.freerapid.gui.actions;

import cz.vity.freerapid.core.AppPrefs;
import cz.vity.freerapid.core.MainApp;
import cz.vity.freerapid.gui.dialogs.userprefs.UserPreferencesDialog;
import cz.vity.freerapid.swing.Swinger;
import cz.vity.freerapid.utilities.LogUtils;
import cz.vity.freerapid.utilities.os.OSCommand;
import cz.vity.freerapid.utilities.os.SystemCommander;
import cz.vity.freerapid.utilities.os.SystemCommanderFactory;
import java.awt.Frame;
import java.util.logging.Logger;
import java.util.prefs.PreferenceChangeEvent;
import java.util.prefs.PreferenceChangeListener;
import javax.swing.SwingUtilities;
import org.jdesktop.application.AbstractBean;
import org.jdesktop.application.Action;

public class OptionsActions
extends AbstractBean {
    private static final Logger logger = Logger.getLogger(OptionsActions.class.getName());
    private final MainApp app = MainApp.getInstance(MainApp.class);
    private static final String REFRESH_PROXY_LIST_ACTION_ENABLED_PROPERTY = "refreshProxyListActionEnabled";
    private boolean refreshProxyListActionEnabled = false;

    public OptionsActions() {
        AppPrefs.getPreferences().addPreferenceChangeListener(new PreferenceChangeListener(){

            @Override
            public void preferenceChange(final PreferenceChangeEvent evt) {
                if ("useProxyList".equals(evt.getKey())) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            OptionsActions.this.setRefreshProxyListActionEnabled(Boolean.parseBoolean(evt.getNewValue()));
                        }
                    });
                }
            }
        });
    }

    @Action
    public void options() {
        try {
            UserPreferencesDialog dialog = new UserPreferencesDialog((Frame)this.app.getMainFrame(), this.app.getContext());
            this.app.prepareDialog(dialog, true);
            this.app.getAppPrefs().store();
        }
        catch (Exception e) {
            LogUtils.processException(logger, e);
        }
    }

    @Action
    public void monitorClipboardAction() {
        AppPrefs.negateProperty("clipboardMonitoring", true);
    }

    @Action
    public void quietModeAction() {
        AppPrefs.negateProperty("quietModeEnabled", false);
    }

    @Action
    public void globalSpeedLimitAction() {
        AppPrefs.negateProperty("speedLimitEnabled", false);
    }

    @Action
    public void shutdownDisabledAction() {
        this.setShutdownProperty(0);
    }

    private void setShutdownProperty(int autoshutdownType) {
        AppPrefs.storeProperty("autoshutdown", autoshutdownType);
    }

    @Action
    public void shutdownQuitAction() {
        this.setShutdownProperty(1);
    }

    @Action
    public void shutdownHibernateAction() {
        this.updateShutdown(OSCommand.HIBERNATE, 5);
    }

    @Action
    public void shutdownShutdownAction() {
        this.updateShutdown(OSCommand.SHUTDOWN, 4);
    }

    @Action
    public void shutdownStandByAction() {
        this.updateShutdown(OSCommand.STANDBY, 2);
    }

    @Action
    public void shutdownRebootAction() {
        this.updateShutdown(OSCommand.REBOOT, 3);
    }

    private void updateShutdown(OSCommand command, int propertyShutdownType) {
        SystemCommander utils = SystemCommanderFactory.getInstance().getSystemCommanderInstance(this.app.getContext());
        if (!utils.isSupported(command)) {
            this.setShutdownProperty(0);
            Swinger.showErrorMessage(this.app.getContext().getResourceMap(), "systemCommandNotSupported", command.toString().toLowerCase());
        } else {
            this.setShutdownProperty(propertyShutdownType);
        }
    }

    @Action
    public void globalLimitSpeedAction() {
        AppPrefs.negateProperty("speedLimitEnabled", false);
    }

    @Action(enabledProperty="refreshProxyListActionEnabled")
    public void refreshProxyList() {
        this.app.getManagerDirector().getClientManager().updateConnectionSettings();
    }

    public void setRefreshProxyListActionEnabled(boolean refreshProxyListActionEnabled) {
        boolean oldValue = this.refreshProxyListActionEnabled;
        this.refreshProxyListActionEnabled = refreshProxyListActionEnabled;
        this.firePropertyChange(REFRESH_PROXY_LIST_ACTION_ENABLED_PROPERTY, oldValue, this.refreshProxyListActionEnabled);
    }

    public boolean isRefreshProxyListActionEnabled() {
        return this.refreshProxyListActionEnabled;
    }
}

