/*
 * Decompiled with CFR 0.152.
 */
package net.sf.portecle;

import java.awt.Toolkit;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Pattern;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import javax.swing.filechooser.FileView;
import net.sf.portecle.FPortecle;
import net.sf.portecle.crypto.KeyStoreType;
import net.sf.portecle.crypto.KeyStoreUtil;
import net.sf.portecle.gui.FileExtFilter;

class FileChooserFactory {
    private static final String KEYSTORE_EXT = "ks";
    private static final String PEM_EXT = "pem";
    private static final String[] PKCS7_EXTS = new String[]{"p7b", "spc"};
    private static final String[] PKIPATH_EXTS = new String[]{"pkipath"};
    private static final String[] X509_EXTS = new String[]{"cer", "crt", "cert", "pem"};
    static final String[] CERT_EXTS = new String[]{X509_EXTS[0], X509_EXTS[1], X509_EXTS[2], "pem", PKCS7_EXTS[0], PKCS7_EXTS[1], PKIPATH_EXTS[0]};
    static final String[] CSR_EXTS = new String[]{"csr", "p10", "pem"};
    static final String[] CRL_EXTS = new String[]{"crl"};
    private static final String X509_FILE_DESC = MessageFormat.format(FPortecle.RB.getString("FileChooseFactory.X509Files"), FileChooserFactory.toWildcards(X509_EXTS));
    private static final String PKCS7_FILE_DESC = MessageFormat.format(FPortecle.RB.getString("FileChooseFactory.Pkcs7Files"), FileChooserFactory.toWildcards(PKCS7_EXTS));
    private static final String PKIPATH_FILE_DESC = MessageFormat.format(FPortecle.RB.getString("FileChooseFactory.PkiPathFiles"), FileChooserFactory.toWildcards(PKIPATH_EXTS));
    private static final String PEM_FILE_DESC = MessageFormat.format(FPortecle.RB.getString("FileChooseFactory.PEMFiles"), FileChooserFactory.toWildcards(new String[]{"pem"}));
    private static final String KEYPAIR_FILE_DESC;
    private static final String CSR_FILE_DESC;
    private static final String CRL_FILE_DESC;
    private static final String CERT_FILE_DESC;
    private static final Pattern FILENAME_FILTER;
    private static final String FILELIST_SEPARATOR = ";";
    static final String CACERTS_FILENAME = "cacerts";

    private FileChooserFactory() {
    }

    public static JFileChooser getKeyStoreFileChooser(KeyStoreType keyStoreType) {
        String string;
        String[] stringArray;
        Object object;
        JFileChooser jFileChooser = new JFileChooser();
        boolean bl = false;
        if (keyStoreType == null) {
            object = new ArrayList();
            ((ArrayList)object).add((String)KEYSTORE_EXT);
            if (KeyStoreUtil.isAvailable(KeyStoreType.JKS)) {
                ((ArrayList)object).addAll(KeyStoreType.JKS.getFilenameExtensions());
            }
            if (KeyStoreUtil.isAvailable(KeyStoreType.JCEKS)) {
                ((ArrayList)object).addAll(KeyStoreType.JCEKS.getFilenameExtensions());
            }
            ((ArrayList)object).addAll(KeyStoreType.PKCS12.getFilenameExtensions());
            ((ArrayList)object).addAll(KeyStoreType.BKS.getFilenameExtensions());
            ((ArrayList)object).addAll(KeyStoreType.UBER.getFilenameExtensions());
            ((ArrayList)object).addAll(KeyStoreType.BCFKS.getFilenameExtensions());
            if (KeyStoreUtil.isAvailable(KeyStoreType.GKR)) {
                ((ArrayList)object).addAll(KeyStoreType.GKR.getFilenameExtensions());
            }
            stringArray = ((ArrayList)object).toArray((String[])new String[((ArrayList)object).size()]);
            String string2 = FileChooserFactory.toWildcards(stringArray) + FILELIST_SEPARATOR + CACERTS_FILENAME;
            string = MessageFormat.format(FPortecle.RB.getString("FileChooseFactory.KeyStoreFiles"), string2);
            bl = true;
        } else {
            object = keyStoreType.getFilenameExtensions();
            stringArray = object.toArray((String[])new String[object.size()]);
            String string3 = FileChooserFactory.toWildcards(stringArray);
            if (keyStoreType == KeyStoreType.JKS) {
                string3 = string3 + ";cacerts";
                bl = true;
            }
            string = MessageFormat.format(FPortecle.RB.getString("FileChooseFactory.KeyStoreFiles." + keyStoreType.name()), string3);
        }
        object = bl ? new FileExtFilter(stringArray, string){

            @Override
            public boolean accept(File file) {
                return super.accept(file) || file.getName().equalsIgnoreCase(FileChooserFactory.CACERTS_FILENAME);
            }
        } : new FileExtFilter(stringArray, string);
        jFileChooser.addChoosableFileFilter((FileFilter)object);
        jFileChooser.setFileFilter((FileFilter)object);
        jFileChooser.setFileView(new PortecleFileView());
        return jFileChooser;
    }

    public static JFileChooser getX509FileChooser(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        FileExtFilter fileExtFilter = new FileExtFilter(X509_EXTS, X509_FILE_DESC);
        jFileChooser.addChoosableFileFilter(fileExtFilter);
        jFileChooser.setFileFilter(fileExtFilter);
        jFileChooser.setSelectedFile(FileChooserFactory.getDefaultFile(string, X509_EXTS[0]));
        jFileChooser.setFileView(new PortecleFileView());
        return jFileChooser;
    }

    public static JFileChooser getPkcs7FileChooser(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        FileExtFilter fileExtFilter = new FileExtFilter(PKCS7_EXTS, PKCS7_FILE_DESC);
        jFileChooser.addChoosableFileFilter(fileExtFilter);
        jFileChooser.setFileFilter(fileExtFilter);
        jFileChooser.setSelectedFile(FileChooserFactory.getDefaultFile(string, PKCS7_EXTS[0]));
        jFileChooser.setFileView(new PortecleFileView());
        return jFileChooser;
    }

    public static JFileChooser getPkiPathFileChooser(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        FileExtFilter fileExtFilter = new FileExtFilter(PKIPATH_EXTS, PKIPATH_FILE_DESC);
        jFileChooser.addChoosableFileFilter(fileExtFilter);
        jFileChooser.setFileFilter(fileExtFilter);
        jFileChooser.setSelectedFile(FileChooserFactory.getDefaultFile(string, PKIPATH_EXTS[0]));
        jFileChooser.setFileView(new PortecleFileView());
        return jFileChooser;
    }

    public static JFileChooser getCertFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        FileExtFilter fileExtFilter = new FileExtFilter(CERT_EXTS, CERT_FILE_DESC);
        jFileChooser.addChoosableFileFilter(fileExtFilter);
        jFileChooser.setFileFilter(fileExtFilter);
        jFileChooser.setFileView(new PortecleFileView());
        return jFileChooser;
    }

    public static JFileChooser getPkcs12FileChooser(String string) {
        JFileChooser jFileChooser = FileChooserFactory.getKeyStoreFileChooser(KeyStoreType.PKCS12);
        Set<String> set = KeyStoreType.PKCS12.getFilenameExtensions();
        assert (set.size() > 1);
        jFileChooser.setSelectedFile(FileChooserFactory.getDefaultFile(string, set.iterator().next()));
        jFileChooser.setFileView(new PortecleFileView());
        return jFileChooser;
    }

    public static JFileChooser getPEMFileChooser(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        FileExtFilter fileExtFilter = new FileExtFilter(PEM_EXT, PEM_FILE_DESC);
        jFileChooser.addChoosableFileFilter(fileExtFilter);
        jFileChooser.setFileFilter(fileExtFilter);
        jFileChooser.setSelectedFile(FileChooserFactory.getDefaultFile(string, PEM_EXT));
        jFileChooser.setFileView(new PortecleFileView());
        return jFileChooser;
    }

    public static JFileChooser getKeyPairFileChooser(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(KeyStoreType.PKCS12.getFilenameExtensions());
        linkedHashSet.add(PEM_EXT);
        FileExtFilter fileExtFilter = new FileExtFilter(linkedHashSet.toArray(new String[linkedHashSet.size()]), KEYPAIR_FILE_DESC);
        jFileChooser.addChoosableFileFilter(fileExtFilter);
        jFileChooser.setFileFilter(fileExtFilter);
        jFileChooser.setSelectedFile(FileChooserFactory.getDefaultFile(string, (String)linkedHashSet.iterator().next()));
        jFileChooser.setFileView(new PortecleFileView());
        return jFileChooser;
    }

    public static JFileChooser getCsrFileChooser(String string) {
        JFileChooser jFileChooser = new JFileChooser();
        FileExtFilter fileExtFilter = new FileExtFilter(CSR_EXTS, CSR_FILE_DESC);
        jFileChooser.addChoosableFileFilter(fileExtFilter);
        jFileChooser.setFileFilter(fileExtFilter);
        jFileChooser.setSelectedFile(FileChooserFactory.getDefaultFile(string, CSR_EXTS[0]));
        jFileChooser.setFileView(new PortecleFileView());
        return jFileChooser;
    }

    public static JFileChooser getCrlFileChooser() {
        JFileChooser jFileChooser = new JFileChooser();
        FileExtFilter fileExtFilter = new FileExtFilter(CRL_EXTS, CRL_FILE_DESC);
        jFileChooser.addChoosableFileFilter(fileExtFilter);
        jFileChooser.setFileFilter(fileExtFilter);
        jFileChooser.setFileView(new PortecleFileView());
        return jFileChooser;
    }

    private static File getDefaultFile(String string, String string2) {
        if (string == null) {
            return null;
        }
        string = FILENAME_FILTER.matcher(string.trim()).replaceAll("_");
        string = string.replaceAll("_+", "_");
        string = string.replaceFirst("^_+", "");
        if (!(string = string.replaceFirst("_+$", "")).isEmpty()) {
            return new File(string + "." + string2);
        }
        return null;
    }

    private static String toWildcards(String[] stringArray) {
        StringBuilder stringBuilder = new StringBuilder();
        for (String string : stringArray) {
            stringBuilder.append("*.").append(string).append(FILELIST_SEPARATOR);
        }
        stringBuilder.setLength(stringBuilder.length() - FILELIST_SEPARATOR.length());
        return stringBuilder.toString();
    }

    static {
        LinkedHashSet<String> linkedHashSet = new LinkedHashSet<String>();
        linkedHashSet.addAll(KeyStoreType.PKCS12.getFilenameExtensions());
        linkedHashSet.add(PEM_EXT);
        KEYPAIR_FILE_DESC = MessageFormat.format(FPortecle.RB.getString("FileChooseFactory.KeyPairFiles"), FileChooserFactory.toWildcards(linkedHashSet.toArray(new String[linkedHashSet.size()])));
        CSR_FILE_DESC = MessageFormat.format(FPortecle.RB.getString("FileChooseFactory.CsrFiles"), FileChooserFactory.toWildcards(CSR_EXTS));
        CRL_FILE_DESC = MessageFormat.format(FPortecle.RB.getString("FileChooseFactory.CrlFiles"), FileChooserFactory.toWildcards(CRL_EXTS));
        CERT_FILE_DESC = MessageFormat.format(FPortecle.RB.getString("FileChooseFactory.CertificateFiles"), FileChooserFactory.toWildcards(CERT_EXTS));
        FILENAME_FILTER = Pattern.compile("[^\\p{L}_\\-]+");
    }

    private static class PortecleFileView
    extends FileView {
        private static final Icon CERTIFICATE_ICON = new ImageIcon(Toolkit.getDefaultToolkit().createImage(FileChooserFactory.class.getResource(FPortecle.RB.getString("FileChooseFactory.CertificateImage"))));
        private static final Icon KEYSTORE_ICON = new ImageIcon(Toolkit.getDefaultToolkit().createImage(FileChooserFactory.class.getResource(FPortecle.RB.getString("FileChooseFactory.KeyStoreImage"))));
        private static final Icon CRL_ICON = new ImageIcon(Toolkit.getDefaultToolkit().createImage(FileChooserFactory.class.getResource(FPortecle.RB.getString("FileChooseFactory.CrlImage"))));
        private static final Icon CSR_ICON = new ImageIcon(Toolkit.getDefaultToolkit().createImage(FileChooserFactory.class.getResource(FPortecle.RB.getString("FileChooseFactory.CsrImage"))));

        private PortecleFileView() {
        }

        @Override
        public Icon getIcon(File file) {
            if (file.isDirectory() || !file.isFile()) {
                return super.getIcon(file);
            }
            String string = file.getName().toLowerCase(Locale.ENGLISH);
            for (String string2 : KeyStoreType.getKeyStoreFilenameExtensions()) {
                if (!string.endsWith("." + string2) && !string.equals(FileChooserFactory.CACERTS_FILENAME)) continue;
                return KEYSTORE_ICON;
            }
            for (String string3 : CERT_EXTS) {
                if (!string.endsWith("." + string3)) continue;
                return CERTIFICATE_ICON;
            }
            for (String string3 : CSR_EXTS) {
                if (!string.endsWith("." + string3)) continue;
                return CSR_ICON;
            }
            for (String string3 : CRL_EXTS) {
                if (!string.endsWith("." + string3)) continue;
                return CRL_ICON;
            }
            return super.getIcon(file);
        }
    }
}

