/* generated by Template::Toolkit - do not edit */

#include "errors.h"
#include "error_func.h"
#include "str.h"
#include <stdio.h>
#include <stdlib.h>

void info_total_errors(void)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "%d errors occurred during assembly", get_num_errors() );
	do_error( ErrInfo, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_read_file(char *filename)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "cannot read file '%s'", filename );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_write_file(char *filename)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "cannot write file '%s'", filename );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_include_recursion(char *filename)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "cannot include file '%s' recursively", filename );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_no_src_file(void)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "source filename missing" );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_illegal_option(char *option)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "illegal option '%s'", option );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_illegal_src_filename(char *filename)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "illegal source filename '%s'", filename );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void warn_symbol_different(char *name, char *used)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "symbol '%s' used as '%s'", name, used );
	do_error( ErrWarn, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_syntax(void)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "syntax error" );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_syntax_expr(void)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "syntax error in expression" );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_invalid_squoted_string(void)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "invalid single quoted character" );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_unclosed_string(void)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "unclosed quoted string" );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_divide_by_zero(void)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "division by zero" );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_missing_block(void)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "missing {} block" );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_missing_close_block(void)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "{} block not closed" );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_unbalanced_struct_at(char *filename, int line_nr)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "unbalanced control structure started at file '%s' line %d", filename, line_nr );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_unbalanced_struct(void)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "unbalanced control structure" );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_not_defined(char *name)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "symbol '%s' not defined", name );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_illegal_ident(void)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "illegal identifier" );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_jr_not_local(void)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "relative jump address must be local" );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_symbol_redefined(char *symbol)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "symbol '%s' already defined", symbol );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_symbol_redefined_module(char *symbol, char *module)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "symbol '%s' already defined in module '%s'", symbol, module );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_symbol_decl_local(char *symbol)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "symbol '%s' already declared local", symbol );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_symbol_redecl(char *symbol)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "re-declaration of '%s' not allowed", symbol );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_max_codesize(long size)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "max. code size of %ld bytes reached", size );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_module_redefined(void)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "module name already defined" );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_org_redefined(void)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "ORG redefined" );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_invalid_org_option(char *org_hex)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "invalid ORG option '%s'", org_hex );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void warn_org_ignored(char *filename, char *section_name)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "--relocatable ignores ORG at file '%s', section '%s'", filename, section_name );
	do_error( ErrWarn, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_not_obj_file(char *filename)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "file '%s' not an object file", filename );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_not_lib_file(char *filename)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "file '%s' not a library file", filename );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
void warn_int_range(long value)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "integer '%ld' out of range", value );
	do_error( ErrWarn, str_data(msg) );
	
	STR_DELETE(msg);
}
void error_int_range(long value)
{
	STR_DEFINE(msg, STR_SIZE);

	str_append_sprintf( msg, "integer '%ld' out of range", value );
	do_error( ErrError, str_data(msg) );
	
	STR_DELETE(msg);
}
