/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.favs;

import java.awt.BorderLayout;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import javax.swing.Action;
import javax.swing.JMenuItem;
import javax.swing.JTree;
import javax.swing.ToolTipManager;
import javax.swing.tree.TreePath;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.fw.gui.BasePopupMenu;
import net.sourceforge.squirrel_sql.plugins.favs.BaseFavouriteAction;
import net.sourceforge.squirrel_sql.plugins.favs.DeleteSavedQueriesFolderAction;
import net.sourceforge.squirrel_sql.plugins.favs.FoldersCache;
import net.sourceforge.squirrel_sql.plugins.favs.NewSavedQueriesFolderAction;
import net.sourceforge.squirrel_sql.plugins.favs.QueryTreeModel;
import net.sourceforge.squirrel_sql.plugins.favs.RenameSavedQueriesFolderAction;

final class QueryTree
extends JTree {
    private static final long serialVersionUID = 1L;
    private IApplication _app;
    private QueryTreeModel _model;
    private MyPopupMenu _popupMenu = new MyPopupMenu();
    private List<BaseFavouriteAction> _actions = new ArrayList<BaseFavouriteAction>();

    public QueryTree(IApplication app, FoldersCache cache) throws IllegalArgumentException {
        super(new QueryTreeModel(app, cache));
        if (app == null) {
            throw new IllegalArgumentException("Null IApplication passed");
        }
        if (cache == null) {
            throw new IllegalArgumentException("Null FolderCache passed");
        }
        this._app = app;
        this._model = (QueryTreeModel)this.getModel();
        this.setRootVisible(false);
        this.setLayout(new BorderLayout());
        this.setShowsRootHandles(true);
        this.setEditable(true);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    QueryTree.this.displayPopupMenu(evt);
                }
            }

            @Override
            public void mouseReleased(MouseEvent evt) {
                if (evt.isPopupTrigger()) {
                    QueryTree.this.displayPopupMenu(evt);
                }
            }
        });
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public String getToolTipText(MouseEvent evt) {
        String tip = null;
        TreePath path = this.getPathForLocation(evt.getX(), evt.getY());
        tip = path != null ? path.getLastPathComponent().toString() : super.getToolTipText();
        return tip;
    }

    QueryTreeModel getTypedModel() {
        return (QueryTreeModel)this.getModel();
    }

    private void displayPopupMenu(MouseEvent evt) {
        int x = evt.getX();
        int y = evt.getY();
        TreePath path = this.getPathForLocation(x, y);
        this._popupMenu.show(evt, path);
    }

    private class MyPopupMenu
    extends BasePopupMenu {
        private static final long serialVersionUID = 1L;
        private boolean _built = false;

        private MyPopupMenu() {
        }

        public void show(MouseEvent evt, TreePath path) {
            if (!this._built) {
                ActionCollection actColl = QueryTree.this._app.getActionCollection();
                this.add(actColl.get(NewSavedQueriesFolderAction.class));
                this.addSeparator();
                this.add(actColl.get(RenameSavedQueriesFolderAction.class));
                this.addSeparator();
                this.add(actColl.get(DeleteSavedQueriesFolderAction.class));
                this._built = true;
            }
            Iterator it = QueryTree.this._actions.iterator();
            while (it.hasNext()) {
                ((BaseFavouriteAction)((Object)it.next())).setTreePath(path);
            }
            super.show(evt);
        }

        public JMenuItem add(Action action) {
            if (action instanceof BaseFavouriteAction) {
                ((BaseFavouriteAction)((Object)action)).setQueryTree(QueryTree.this);
                QueryTree.this._actions.add((BaseFavouriteAction)((Object)action));
            }
            return super.add(action);
        }
    }
}

