/*
 * Decompiled with CFR 0.152.
 */
package com.jtattoo.plaf.graphite;

import com.jtattoo.plaf.AbstractLookAndFeel;
import com.jtattoo.plaf.BaseBorders;
import com.jtattoo.plaf.ColorHelper;
import com.jtattoo.plaf.JTattooUtilities;
import java.awt.AlphaComposite;
import java.awt.Color;
import java.awt.Component;
import java.awt.Composite;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.RenderingHints;
import javax.swing.AbstractButton;
import javax.swing.ButtonModel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.border.AbstractBorder;
import javax.swing.border.Border;
import javax.swing.plaf.ColorUIResource;
import javax.swing.plaf.UIResource;

public class GraphiteBorders
extends BaseBorders {
    public static Border getButtonBorder() {
        if (buttonBorder == null) {
            buttonBorder = new ButtonBorder();
        }
        return buttonBorder;
    }

    public static Border getToggleButtonBorder() {
        return GraphiteBorders.getButtonBorder();
    }

    public static Border getRolloverToolButtonBorder() {
        if (rolloverToolButtonBorder == null) {
            rolloverToolButtonBorder = new RolloverToolButtonBorder();
        }
        return rolloverToolButtonBorder;
    }

    public static Border getMenuItemBorder() {
        if (menuItemBorder == null) {
            menuItemBorder = new MenuItemBorder();
        }
        return menuItemBorder;
    }

    public static Border getPopupMenuBorder() {
        if (popupMenuBorder == null) {
            popupMenuBorder = AbstractLookAndFeel.getTheme().isMenuOpaque() ? new PopupMenuBorder() : new BaseBorders.BasePopupMenuShadowBorder();
        }
        return popupMenuBorder;
    }

    public static Border getInternalFrameBorder() {
        if (internalFrameBorder == null) {
            internalFrameBorder = new InternalFrameBorder();
        }
        return internalFrameBorder;
    }

    public static class InternalFrameBorder
    extends BaseBorders.BaseInternalFrameBorder {
        public Insets getBorderInsets(Component c) {
            return new Insets(this.insets.top, this.insets.left, this.insets.bottom, this.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = this.insets.left;
            borderInsets.top = this.insets.top;
            borderInsets.right = this.insets.right;
            borderInsets.bottom = this.insets.bottom;
            return borderInsets;
        }

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            int th = this.getTitleHeight(c);
            ColorUIResource titleColor = AbstractLookAndFeel.getWindowTitleColorLight();
            ColorUIResource borderColor = AbstractLookAndFeel.getWindowTitleColorDark();
            ColorUIResource frameColor = AbstractLookAndFeel.getWindowBorderColor();
            if (!this.isActive(c)) {
                titleColor = AbstractLookAndFeel.getWindowInactiveTitleColorLight();
                borderColor = AbstractLookAndFeel.getWindowInactiveTitleColorDark();
                frameColor = AbstractLookAndFeel.getWindowInactiveBorderColor();
            }
            g.setColor(titleColor);
            g.fillRect(x, y + 1, w, this.insets.top - 1);
            g.setColor(titleColor);
            g.fillRect(x + 1, y + h - 5, w - 2, 4);
            if (this.isActive(c)) {
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 1, this.insets.top, 5, th + 1);
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), w - 5 - 1, this.insets.top, 5, th + 1);
                g.setColor(borderColor);
                JTattooUtilities.fillInverseHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), 1, this.insets.top + th + 1, 4, h - th - 5);
                JTattooUtilities.fillInverseHorGradient(g, AbstractLookAndFeel.getTheme().getWindowTitleColors(), w - 5, this.insets.top + th + 1, 4, h - th - 5);
            } else {
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, this.insets.top, 5, th + 1);
                JTattooUtilities.fillHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), w - 5 - 1, this.insets.top, 5, th + 1);
                g.setColor(borderColor);
                JTattooUtilities.fillInverseHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), 1, this.insets.top + th + 1, 4, h - th - 5);
                JTattooUtilities.fillInverseHorGradient(g, AbstractLookAndFeel.getTheme().getWindowInactiveTitleColors(), w - 5, this.insets.top + th + 1, 4, h - th - 5);
            }
            g.setColor(frameColor);
            g.drawRect(x, y, w - 1, h - 1);
            g.drawLine(x + 5 - 1, y + this.insets.top + th, x + 5 - 1, y + h - 5);
            g.drawLine(x + w - 5, y + this.insets.top + th, x + w - 5, y + h - 5);
            g.drawLine(x + 5 - 1, y + h - 5, x + w - 5, y + h - 5);
        }
    }

    public static class PopupMenuBorder
    extends BaseBorders.BasePopupMenuBorder {
        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Color borderColor = ColorHelper.darker(AbstractLookAndFeel.getMenuSelectionBackgroundColor(), 20.0);
            if (JTattooUtilities.isLeftToRight(c)) {
                int dx = this.getBorderInsets((Component)c).left;
                ColorUIResource logoColorHi = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColorDark();
                ColorUIResource logoColorLo = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColor();
                Color[] colors = ColorHelper.createColorArr(logoColorHi, logoColorLo, 32);
                JTattooUtilities.fillHorGradient(g, colors, x, y, dx - 1, h - 1);
                this.paintLogo(c, g, x, y, w, h);
                g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getMenuBackgroundColor(), 40.0));
                g.drawLine(x + dx, y + 1, x + w - 2, y + 1);
                g.setColor(borderColor);
                if (this.isMenuBarPopup(c)) {
                    g.drawLine(x + dx - 1, y, x + w, y);
                    g.drawLine(x, y, x, y + h - 1);
                    g.drawLine(x, y + h - 1, x + w, y + h - 1);
                    g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
                } else {
                    g.drawRect(x, y, w - 1, h - 1);
                }
                g.drawLine(x + dx - 1, y + 1, x + dx - 1, y + h - 1);
            } else {
                int dx = this.getBorderInsets((Component)c).right;
                ColorUIResource logoColorHi = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColorDark();
                ColorUIResource logoColorLo = AbstractLookAndFeel.getTheme().getMenuSelectionBackgroundColor();
                Color[] colors = ColorHelper.createColorArr(logoColorHi, logoColorLo, 32);
                JTattooUtilities.fillHorGradient(g, colors, x + w - dx, y, dx, h - 1);
                this.paintLogo(c, g, x, y, w, h);
                g.setColor(ColorHelper.brighter(AbstractLookAndFeel.getMenuBackgroundColor(), 40.0));
                g.drawLine(x + 1, y + 1, x + w - dx - 1, y + 1);
                g.drawLine(x + 1, y + 1, x + 1, y + h - 2);
                g.setColor(borderColor);
                if (this.isMenuBarPopup(c)) {
                    g.drawLine(x, y, x + w - dx, y);
                    g.drawLine(x, y, x, y + h - 1);
                    g.drawLine(x, y + h - 1, x + w, y + h - 1);
                    g.drawLine(x + w - 1, y, x + w - 1, y + h - 1);
                } else {
                    g.drawRect(x, y, w - 1, h - 1);
                }
                g.drawLine(x + w - dx, y + 1, x + w - dx, y + h - 1);
            }
        }
    }

    public static class MenuItemBorder
    extends AbstractBorder
    implements UIResource {
        private static final Insets insets = new Insets(2, 2, 2, 2);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            JMenuItem b = (JMenuItem)c;
            ButtonModel model = b.getModel();
            Color borderColor = ColorHelper.darker(AbstractLookAndFeel.getMenuSelectionBackgroundColor(), 20.0);
            g.setColor(borderColor);
            if (c.getParent() instanceof JMenuBar) {
                if (model.isArmed() || model.isSelected()) {
                    g.drawLine(x, y, x + w - 1, y);
                    g.drawLine(x, y + 1, x, y + h - 1);
                    g.drawLine(x + w - 1, y + 1, x + w - 1, y + h - 1);
                }
            } else if (model.isArmed() || c instanceof JMenu && model.isSelected()) {
                g.drawLine(x, y, x + w - 1, y);
                g.drawLine(x, y + h - 1, x + w - 1, y + h - 1);
            }
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(MenuItemBorder.insets.top, MenuItemBorder.insets.left, MenuItemBorder.insets.bottom, MenuItemBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = MenuItemBorder.insets.left;
            borderInsets.top = MenuItemBorder.insets.top;
            borderInsets.right = MenuItemBorder.insets.right;
            borderInsets.bottom = MenuItemBorder.insets.bottom;
            return borderInsets;
        }
    }

    public static class RolloverToolButtonBorder
    implements Border,
    UIResource {
        private static final Insets insets = new Insets(1, 1, 1, 1);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            AbstractButton button = (AbstractButton)c;
            ButtonModel model = button.getModel();
            Color loColor = ColorHelper.brighter(AbstractLookAndFeel.getFrameColor(), 50.0);
            if (model.isEnabled()) {
                if (model.isPressed() && model.isArmed() || model.isSelected()) {
                    Graphics2D g2D = (Graphics2D)g;
                    Composite composite = g2D.getComposite();
                    g.setColor(loColor);
                    g.drawRect(x, y, w - 1, h - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.15f);
                    g2D.setComposite(alpha);
                    g.setColor(Color.black);
                    g.fillRect(x + 1, y + 1, w - 2, h - 2);
                    g2D.setComposite(composite);
                } else if (model.isRollover()) {
                    Graphics2D g2D = (Graphics2D)g;
                    Composite composite = g2D.getComposite();
                    g.setColor(loColor);
                    g.drawRect(x, y, w - 1, h - 1);
                    AlphaComposite alpha = AlphaComposite.getInstance(3, 0.4f);
                    g2D.setComposite(alpha);
                    g.setColor(Color.white);
                    g.fillRect(x + 1, y + 1, w - 2, h - 2);
                    g2D.setComposite(composite);
                }
            }
        }

        public Insets getBorderInsets(Component c) {
            return new Insets(RolloverToolButtonBorder.insets.top, RolloverToolButtonBorder.insets.left, RolloverToolButtonBorder.insets.bottom, RolloverToolButtonBorder.insets.right);
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = RolloverToolButtonBorder.insets.left;
            borderInsets.top = RolloverToolButtonBorder.insets.top;
            borderInsets.right = RolloverToolButtonBorder.insets.right;
            borderInsets.bottom = RolloverToolButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }

    public static class ButtonBorder
    implements Border,
    UIResource {
        private static final Color defaultColorHi = new Color(220, 230, 245);
        private static final Color defaultColorMed = new Color(212, 224, 243);
        private static final Color defaultColorLo = new Color(200, 215, 240);
        private static final Insets insets = new Insets(3, 8, 3, 8);

        public void paintBorder(Component c, Graphics g, int x, int y, int w, int h) {
            Graphics2D g2D = (Graphics2D)g;
            AbstractButton b = (AbstractButton)c;
            Color frameColor = ColorHelper.brighter(AbstractLookAndFeel.getTheme().getFrameColor(), 30.0);
            if (AbstractLookAndFeel.getTheme().doShowFocusFrame() && b.hasFocus()) {
                frameColor = AbstractLookAndFeel.getTheme().getFocusFrameColor();
            }
            Object savedRederingHint = g2D.getRenderingHint(RenderingHints.KEY_ANTIALIASING);
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            Composite savedComposite = g2D.getComposite();
            AlphaComposite alpha = AlphaComposite.getInstance(3, 0.5f);
            g2D.setComposite(alpha);
            g2D.setColor(Color.white);
            g2D.drawRoundRect(x, y, w - 1, h - 1, 6, 6);
            g2D.setComposite(savedComposite);
            if (b.getRootPane() != null && b.equals(b.getRootPane().getDefaultButton()) && !b.hasFocus()) {
                g2D.setColor(ColorHelper.darker(frameColor, 20.0));
                g2D.drawRoundRect(x, y, w - 1, h - 2, 6, 6);
                if (!b.getModel().isRollover()) {
                    g2D.setColor(defaultColorHi);
                    g2D.drawRoundRect(x + 1, y + 1, w - 3, h - 4, 6, 6);
                    g2D.setColor(defaultColorMed);
                    g2D.drawRoundRect(x + 2, y + 2, w - 5, h - 6, 6, 6);
                    g2D.setColor(defaultColorLo);
                    g2D.drawLine(x + 3, h - 3, w - 3, h - 3);
                    g2D.drawLine(w - 2, y + 4, w - 2, h - 4);
                }
            } else {
                g2D.setColor(frameColor);
                g2D.drawRoundRect(x, y, w - 1, h - 2, 6, 6);
            }
            g2D.setRenderingHint(RenderingHints.KEY_ANTIALIASING, savedRederingHint);
        }

        public Insets getBorderInsets(Component c) {
            return insets;
        }

        public Insets getBorderInsets(Component c, Insets borderInsets) {
            borderInsets.left = ButtonBorder.insets.left;
            borderInsets.top = ButtonBorder.insets.top;
            borderInsets.right = ButtonBorder.insets.right;
            borderInsets.bottom = ButtonBorder.insets.bottom;
            return borderInsets;
        }

        public boolean isBorderOpaque() {
            return true;
        }
    }
}

