/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sqlval;

import com.mimer.ws.validateSQL.SessionData;
import java.rmi.RemoteException;
import javax.xml.namespace.QName;
import javax.xml.rpc.ParameterMode;
import javax.xml.rpc.ServiceException;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServicePreferences;
import net.sourceforge.squirrel_sql.plugins.sqlval.WebServiceSessionProperties;
import org.apache.axis.client.Call;
import org.apache.axis.client.Service;
import org.apache.axis.encoding.DeserializerFactory;
import org.apache.axis.encoding.SerializerFactory;
import org.apache.axis.encoding.XMLType;
import org.apache.axis.encoding.ser.BeanDeserializerFactory;
import org.apache.axis.encoding.ser.BeanSerializerFactory;

public class WebServiceSession {
    private final WebServicePreferences _prefs;
    private final WebServiceSessionProperties _sessionProps;
    private SessionData _sessionData;

    public WebServiceSession(WebServicePreferences prefs, WebServiceSessionProperties sessionProps) {
        if (prefs == null) {
            throw new IllegalArgumentException("WebServicePreferences == null");
        }
        if (sessionProps == null) {
            throw new IllegalArgumentException("WebServiceSessionProperties == null");
        }
        this._prefs = prefs;
        this._sessionProps = sessionProps;
    }

    public boolean isOpen() {
        return this._sessionData != null;
    }

    public void open() throws RemoteException, ServiceException {
        Service l_service = new Service();
        Call l_call = (Call)l_service.createCall();
        l_call.setTargetEndpointAddress("http://sqlvalidator.mimer.com/v1/services");
        l_call.setOperationName(new QName("SQL99Validator", "openSession"));
        l_call.addParameter("a_userName", XMLType.XSD_STRING, ParameterMode.IN);
        l_call.addParameter("a_password", XMLType.XSD_STRING, ParameterMode.IN);
        l_call.addParameter("a_callingProgram", XMLType.XSD_STRING, ParameterMode.IN);
        l_call.addParameter("a_callingProgramVersion", XMLType.XSD_STRING, ParameterMode.IN);
        l_call.addParameter("a_targetDbms", XMLType.XSD_STRING, ParameterMode.IN);
        l_call.addParameter("a_targetDbmsVersion", XMLType.XSD_STRING, ParameterMode.IN);
        l_call.addParameter("a_connectionTechnology", XMLType.XSD_STRING, ParameterMode.IN);
        l_call.addParameter("a_connectionTechnologyVersion", XMLType.XSD_STRING, ParameterMode.IN);
        l_call.addParameter("a_interactive", XMLType.XSD_INT, ParameterMode.IN);
        QName l_qn = new QName("http://sqlvalidator.mimer.com/v1.0", "SessionData");
        l_call.registerTypeMapping(SessionData.class, l_qn, (SerializerFactory)new BeanSerializerFactory(SessionData.class, l_qn), (DeserializerFactory)new BeanDeserializerFactory(SessionData.class, l_qn));
        l_call.setReturnType(l_qn);
        boolean anonLogon = this._prefs.getUseAnonymousLogon();
        boolean anonClient = this._prefs.getUseAnonymousClient();
        boolean anonDBMS = this._sessionProps.getUseAnonymousDBMS();
        Object[] parms = new Object[]{anonLogon ? "anonymous" : this._prefs.getUserName(), anonLogon ? "N/A" : this._prefs.retrievePassword(), anonClient ? "N/A" : this._prefs.getClientName(), anonClient ? "N/A" : this._prefs.getClientVersion(), anonDBMS ? "N/A" : this._sessionProps.getTargetDBMSName(), anonDBMS ? "N/A" : this._sessionProps.getTargetDBMSVersion(), anonDBMS ? "N/A" : this._sessionProps.getConnectionTechnology(), anonDBMS ? "N/A" : this._sessionProps.getConnectionTechnologyVersion(), 1};
        this._sessionData = (SessionData)l_call.invoke(parms);
    }

    public void close() {
        this._sessionData = null;
    }

    String getTargetURL() {
        this.validateState();
        return this._sessionData.getTarget();
    }

    int getSessionID() {
        this.validateState();
        return this._sessionData.getSessionId();
    }

    int getSessionKey() {
        this.validateState();
        return this._sessionData.getSessionKey();
    }

    private void validateState() {
        if (this._sessionData == null) {
            throw new IllegalStateException("Connection to web service has not been opened");
        }
    }
}

