/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.sketch;

import java.awt.Color;
import java.awt.geom.Point2D;
import net.sourceforge.napkinlaf.sketch.TemplateColor;
import org.jdom.DefaultJDOMFactory;
import org.jdom.Element;

public class XMLUtility {
    private XMLUtility() {
    }

    public static Element colorToXML(String name, Color c) {
        DefaultJDOMFactory f = new DefaultJDOMFactory();
        Element ret = f.element(name);
        String colorName = TemplateColor.nameFor(c);
        if (colorName != null) {
            Element which = f.element("which");
            which.addContent(f.text(colorName));
            ret.addContent(which);
        } else {
            Element red = f.element("r");
            Element green = f.element("g");
            Element blue = f.element("b");
            red.addContent(f.text(Integer.toString(c.getRed())));
            green.addContent(f.text(Integer.toString(c.getGreen())));
            blue.addContent(f.text(Integer.toString(c.getBlue())));
            ret.addContent(red);
            ret.addContent(green);
            ret.addContent(blue);
        }
        return ret;
    }

    public static Element pointToXML(String name, Point2D p) {
        DefaultJDOMFactory f = new DefaultJDOMFactory();
        Element ret = f.element(name);
        Element x = f.element("x");
        Element y = f.element("y");
        int xval = (int)Math.round(p.getX());
        int yval = (int)Math.round(p.getY());
        x.addContent(f.text(Integer.toString(xval)));
        y.addContent(f.text(Integer.toString(yval)));
        ret.addContent(x);
        ret.addContent(y);
        return ret;
    }
}

