/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.napkinlaf.shapes;

import java.awt.Insets;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import net.sourceforge.napkinlaf.borders.NapkinBoxBorder;
import net.sourceforge.napkinlaf.shapes.DrawnBoxGenerator;
import net.sourceforge.napkinlaf.shapes.DrawnShapeHolder;

public class DrawnBoxHolder
extends DrawnShapeHolder {
    private Rectangle size;
    private int breakSide = -1;
    private final Point2D begBreak = new Point2D.Double();
    private final Point2D endBreak = new Point2D.Double();

    public DrawnBoxHolder(DrawnBoxGenerator gen) {
        super(gen);
    }

    public DrawnBoxHolder() {
        this(new DrawnBoxGenerator());
    }

    public void shapeUpToDate(Rectangle sz) {
        this.shapeUpToDate(sz, -1, 0.0, 0.0, 0.0, 0.0);
    }

    public void shapeUpToDate(Rectangle sz, int bSide, double begX, double begY, double endX, double endY) {
        if (this.size != null && this.size.width == sz.width && this.size.height == sz.height && bSide == this.breakSide && this.begBreak.getX() == begX && this.begBreak.getY() == begY && this.endBreak.getX() == endX && this.endBreak.getY() == endY) {
            return;
        }
        this.size = (Rectangle)sz.clone();
        this.breakSide = bSide;
        this.begBreak.setLocation(begX, begY);
        this.endBreak.setLocation(endX, endY);
        Insets in = NapkinBoxBorder.getDefaultInsets(sz);
        double borderWidth = sz.getWidth() - (double)NapkinBoxBorder.getWidthDelta(in);
        double borderHeight = sz.getHeight() - (double)NapkinBoxBorder.getHeightDelta(in);
        int cornerX = NapkinBoxBorder.getDelta(in.left);
        int cornerY = NapkinBoxBorder.getDelta(in.top);
        DrawnBoxGenerator dbg = (DrawnBoxGenerator)this.gen;
        dbg.getSize().setMid(borderWidth, borderHeight);
        dbg.getCorner().setMid(cornerX, cornerY);
        AffineTransform matrix = new AffineTransform();
        matrix.translate(cornerX, cornerY);
        if (bSide == -1) {
            dbg.setNoBreak();
        } else {
            dbg.setBreak(bSide, begX, begY, endX, endY);
        }
        this.shape = dbg.generate(matrix);
    }
}

