/*
 * Decompiled with CFR 0.152.
 */
package net.steppschuh.markdowngenerator.list;

import java.util.ArrayList;
import java.util.List;
import net.steppschuh.markdowngenerator.MarkdownElement;
import net.steppschuh.markdowngenerator.MarkdownSerializationException;
import net.steppschuh.markdowngenerator.list.UnorderedListItem;
import net.steppschuh.markdowngenerator.util.StringUtil;

public class UnorderedList<T>
extends MarkdownElement {
    protected List<T> items;
    protected int indentationLevel = 0;

    public UnorderedList() {
        this.items = new ArrayList<T>();
    }

    public UnorderedList(List<T> items) {
        this.items = items;
    }

    @Override
    public String serialize() throws MarkdownSerializationException {
        StringBuilder sb = new StringBuilder();
        for (int itemIndex = 0; itemIndex < this.items.size(); ++itemIndex) {
            T item = this.items.get(itemIndex);
            if (itemIndex > 0) {
                sb.append(StringUtil.fillUpLeftAligned("", "  ", this.indentationLevel * 2));
            } else if (this.indentationLevel > 0) {
                sb.append("  ");
            }
            if (item instanceof UnorderedListItem) {
                sb.append(item);
            } else if (item instanceof UnorderedList) {
                UnorderedList unorderedList = (UnorderedList)item;
                unorderedList.setIndentationLevel(this.indentationLevel + 1);
                sb.append(unorderedList);
            } else {
                sb.append(new UnorderedListItem(item));
            }
            if (itemIndex >= this.items.size() - 1) continue;
            sb.append("\n");
        }
        return sb.toString();
    }

    public List<T> getItems() {
        return this.items;
    }

    public void setItems(List<T> items) {
        this.items = items;
        this.invalidateSerialized();
    }

    public int getIndentationLevel() {
        return this.indentationLevel;
    }

    public void setIndentationLevel(int indentationLevel) {
        this.indentationLevel = indentationLevel;
        this.invalidateSerialized();
    }

    public void incrementIndentationLevel() {
        ++this.indentationLevel;
        this.invalidateSerialized();
    }
}

