/*
 * Decompiled with CFR 0.152.
 */
package org.fife.rtext.optionsdialog;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Container;
import java.awt.Font;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.InputStream;
import java.util.Collection;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SpringLayout;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.fife.rtext.AbstractMainView;
import org.fife.rtext.RText;
import org.fife.rtext.RTextUtilities;
import org.fife.ui.LabelValueComboBox;
import org.fife.ui.OptionsDialog;
import org.fife.ui.OptionsDialogPanel;
import org.fife.ui.RColorSwatchesButton;
import org.fife.ui.SelectableLabel;
import org.fife.ui.UIUtil;
import org.fife.ui.app.ExtendedLookAndFeelInfo;
import org.fife.ui.rsyntaxtextarea.Theme;
import org.fife.ui.rtextarea.IconGroup;
import org.fife.util.SubstanceUtil;

public class UIOptionPanel
extends OptionsDialogPanel
implements ActionListener,
PropertyChangeListener {
    public static final String OPTION_PANEL_ID = "UIOptionPanel";
    private LabelValueComboBox<String, String> themeCombo;
    private JButton applyButton;
    private IconGroup eclipseIconGroup;
    private IconGroup flatIconGroup;
    private int mainViewStyle;
    private int documentSelectionPlacement;
    private int statusBarStyle;
    private JPanel springPanel;
    private JPanel springPanel2;
    private JComboBox<String> viewCombo;
    private JComboBox<String> docSelCombo;
    private LabelValueComboBox<String, String> lnfCombo;
    private JLabel substanceSkinLabel;
    private LabelValueComboBox<String, String> substanceSkinCombo;
    private LabelValueComboBox<String, String> imageLnFCombo;
    private JComboBox<String> statusBarCombo;
    private JCheckBox highlightModifiedCheckBox;
    private RColorSwatchesButton hmColorButton;
    private JCheckBox showHostNameCheckBox;
    private static final String LNF_VALUE_SUBSTANCE = "SUBSTANCE_STUB_VALUE";

    UIOptionPanel(RText rtext, ResourceBundle msg) {
        super(msg.getString("OptUIName"));
        this.setId(OPTION_PANEL_ID);
        Listener listener = new Listener();
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.setBorder(UIUtil.getEmpty5Border());
        this.setLayout(new BorderLayout());
        Box cp = Box.createVerticalBox();
        cp.add(this.createThemePanel(msg, listener));
        cp.add(Box.createVerticalStrut(10));
        cp.add(this.createAppearancePanel(msg, rtext));
        cp.add(this.createLayoutPanel(msg));
        cp.add(this.createOtherPanel(msg));
        this.add(cp, "North");
        this.applyComponentOrientation(orientation);
        this.eclipseIconGroup = rtext.getIconGroupMap().get("Eclipse Icons");
        this.flatIconGroup = rtext.getIconGroupMap().get("IntelliJ Icons (Dark)");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String actionCommand;
        switch (actionCommand = e.getActionCommand()) {
            case "ViewComboBox": {
                this.hasUnsavedChanges = true;
                int old = this.mainViewStyle;
                this.mainViewStyle = this.viewCombo.getSelectedIndex();
                this.firePropertyChange("UIOptionPanel.mainViewStyle", old, this.mainViewStyle);
                break;
            }
            case "DocSelCombo": {
                this.hasUnsavedChanges = true;
                int old = this.documentSelectionPlacement;
                this.documentSelectionPlacement = this.docSelCombo.getSelectedIndex() + 1;
                this.firePropertyChange("UIOptionPanel.documentSelectionPlacement", old, this.documentSelectionPlacement);
                break;
            }
            case "LookAndFeelComboBox": {
                this.hasUnsavedChanges = true;
                this.possiblyUpdateSubstanceThemeWidgets();
                String newLnF = this.getLookAndFeelClassName();
                this.firePropertyChange("UIOptionPanel.lookAndFeel", null, newLnF);
                break;
            }
            case "SubstanceThemeComboBox": {
                this.hasUnsavedChanges = true;
                String newLnF = this.getLookAndFeelClassName();
                this.firePropertyChange("UIOptionPanel.lookAndFeel", null, newLnF);
                break;
            }
            case "IconComboBox": {
                this.hasUnsavedChanges = true;
                String name = (String)this.imageLnFCombo.getSelectedValue();
                this.firePropertyChange("UIOptionPanel.iconStyle", null, name);
                break;
            }
            case "StatusBarComboBox": {
                this.hasUnsavedChanges = true;
                int old = this.statusBarStyle;
                this.statusBarStyle = this.statusBarCombo.getSelectedIndex();
                this.firePropertyChange("UIOptionPanel.statusBarStyle", old, this.statusBarStyle);
                break;
            }
            case "HighlightModifiedCheckBox": {
                boolean highlight = this.highlightModifiedDocumentDisplayNames();
                this.hmColorButton.setEnabled(highlight);
                this.hasUnsavedChanges = true;
                this.firePropertyChange("UIOptionPanel.highlightModified", !highlight, highlight);
                break;
            }
            case "ShowHostNameCB": {
                boolean show = this.getShowHostName();
                this.hasUnsavedChanges = true;
                this.firePropertyChange("UIOptionPanel.showHostName", !show, show);
            }
        }
    }

    private void applySelectedTheme() {
        String theme = (String)this.themeCombo.getSelectedValue();
        String laf = null;
        String editorTheme = null;
        IconGroup iconGroup = this.eclipseIconGroup;
        if ("default".equals(theme)) {
            laf = UIManager.getSystemLookAndFeelClassName();
            editorTheme = "/org/fife/ui/rsyntaxtextarea/themes/default-alt.xml";
        } else if ("eclipse".equals(theme)) {
            laf = UIManager.getSystemLookAndFeelClassName();
            editorTheme = "/org/fife/ui/rsyntaxtextarea/themes/eclipse.xml";
        } else if ("dark".equals(theme)) {
            laf = "com.bulenkov.darcula.DarculaLaf";
            editorTheme = "/org/fife/ui/rsyntaxtextarea/themes/dark.xml";
            iconGroup = this.flatIconGroup;
        } else if ("monokai".equals(theme)) {
            laf = "com.bulenkov.darcula.DarculaLaf";
            editorTheme = "/org/fife/ui/rsyntaxtextarea/themes/monokai.xml";
            iconGroup = this.flatIconGroup;
        }
        RText rtext = (RText)((Object)this.getOptionsDialog().getOwner());
        if (laf != null) {
            RTextUtilities.setLookAndFeel(rtext, laf);
        }
        rtext.setIconGroupByName(iconGroup.getName());
        if (editorTheme != null) {
            try {
                Theme themeObj = Theme.load((InputStream)this.getClass().getResourceAsStream(editorTheme));
                UIOptionPanel.installRstaTheme(rtext, themeObj);
            }
            catch (Exception ioe) {
                rtext.displayException(ioe);
                return;
            }
        }
        OtherColors otherColors = UIOptionPanel.getOtherColorsForTheme(theme);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setModifiedDocumentDisplayNamesColor(otherColors.getModifiedDocumentNameColor());
        OptionsDialog dialog = this.getOptionsDialog();
        this.setValues((Frame)((Object)rtext));
        dialog.getPanelById(OPTION_PANEL_ID).setValues((Frame)((Object)rtext));
        dialog.getPanelById("RTextAreaOptionPanel").setValues((Frame)((Object)rtext));
        dialog.getPanelById("RTextAreaOptionPanel").setValues((Frame)((Object)rtext));
        this.getOptionsDialog().broadcast("appTheme:" + theme);
    }

    private JPanel createAppearancePanel(ResourceBundle msg, RText rtext) {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        JPanel temp = new JPanel(new BorderLayout());
        SelectableLabel label = new SelectableLabel();
        label.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        label.setText(msg.getString("OptAppearanceDesc"));
        temp.add((Component)label, "North");
        this.lnfCombo = UIOptionPanel.createLookAndFeelComboBox(rtext);
        this.lnfCombo.setActionCommand("LookAndFeelComboBox");
        this.lnfCombo.addActionListener((ActionListener)this);
        this.substanceSkinLabel = new JLabel(msg.getString("OptUISubstanceSkin"));
        this.substanceSkinCombo = UIOptionPanel.createSubstanceThemeComboBox();
        this.substanceSkinCombo.setActionCommand("SubstanceThemeComboBox");
        this.substanceSkinCombo.addActionListener((ActionListener)this);
        this.imageLnFCombo = new LabelValueComboBox();
        UIUtil.fixComboOrientation(this.imageLnFCombo);
        this.imageLnFCombo.setActionCommand("IconComboBox");
        this.imageLnFCombo.addActionListener((ActionListener)this);
        Collection<IconGroup> iconGroups = rtext.getIconGroupMap().values();
        for (IconGroup group : iconGroups) {
            this.imageLnFCombo.addLabelValuePair((Object)group.getName(), (Object)group.getName());
        }
        this.statusBarCombo = new JComboBox();
        UIUtil.fixComboOrientation(this.statusBarCombo);
        this.statusBarCombo.setActionCommand("StatusBarComboBox");
        this.statusBarCombo.addActionListener(this);
        this.statusBarCombo.addItem(msg.getString("OptUIW95A"));
        this.statusBarCombo.addItem(msg.getString("OptUIWXPA"));
        this.springPanel2 = new JPanel(new SpringLayout());
        JPanel temp2 = new JPanel(new BorderLayout());
        temp.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptUIAT")));
        if (orientation.isLeftToRight()) {
            this.springPanel2.add(new JLabel(msg.getString("OptUILnFT")));
            this.springPanel2.add((Component)this.lnfCombo);
            this.springPanel2.add(this.substanceSkinLabel);
            this.springPanel2.add((Component)this.substanceSkinCombo);
            this.springPanel2.add(new JLabel(msg.getString("OptUIIAT")));
            this.springPanel2.add((Component)this.imageLnFCombo);
            this.springPanel2.add(new JPanel());
            this.springPanel2.add(new JPanel());
            this.springPanel2.add(new JLabel(msg.getString("OptUISBT")));
            this.springPanel2.add(this.statusBarCombo);
            this.springPanel2.add(new JPanel());
            this.springPanel2.add(new JPanel());
        } else {
            this.springPanel2.add((Component)this.lnfCombo);
            this.springPanel2.add(new JLabel(msg.getString("OptUILnFT")));
            this.springPanel2.add((Component)this.substanceSkinCombo);
            this.springPanel2.add(this.substanceSkinLabel);
            this.springPanel2.add(new JPanel());
            this.springPanel2.add(new JPanel());
            this.springPanel2.add((Component)this.imageLnFCombo);
            this.springPanel2.add(new JLabel(msg.getString("OptUIIAT")));
            this.springPanel2.add(new JPanel());
            this.springPanel2.add(new JPanel());
            this.springPanel2.add(this.statusBarCombo);
            this.springPanel2.add(new JLabel(msg.getString("OptUISBT")));
        }
        temp2.add((Component)this.springPanel2, "Before");
        UIUtil.makeSpringCompactGrid((Container)this.springPanel2, (int)3, (int)4, (int)0, (int)0, (int)5, (int)5);
        temp.add(temp2);
        return temp;
    }

    private JPanel createLayoutPanel(ResourceBundle msg) {
        ComponentOrientation orientation = ComponentOrientation.getOrientation(this.getLocale());
        this.viewCombo = new JComboBox();
        UIUtil.fixComboOrientation(this.viewCombo);
        this.viewCombo.setActionCommand("ViewComboBox");
        this.viewCombo.addActionListener(this);
        this.viewCombo.addItem(msg.getString("OptUITV"));
        this.viewCombo.addItem(msg.getString("OptUISPV"));
        this.viewCombo.addItem(msg.getString("OptUIMDIV"));
        this.docSelCombo = new JComboBox();
        UIUtil.fixComboOrientation(this.docSelCombo);
        this.docSelCombo.setActionCommand("DocSelCombo");
        this.docSelCombo.addActionListener(this);
        this.docSelCombo.addItem(msg.getString("OptUITop"));
        this.docSelCombo.addItem(msg.getString("OptUILeft"));
        this.docSelCombo.addItem(msg.getString("OptUIBottom"));
        this.docSelCombo.addItem(msg.getString("OptUIRight"));
        this.springPanel = new JPanel(new SpringLayout());
        JPanel temp = new JPanel(new BorderLayout());
        temp.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptUILT")));
        if (orientation.isLeftToRight()) {
            this.springPanel.add(new JLabel(msg.getString("OptUIViewT")));
            this.springPanel.add(this.viewCombo);
            this.springPanel.add(new JLabel(msg.getString("OptUIDSPT")));
            this.springPanel.add(this.docSelCombo);
        } else {
            this.springPanel.add(this.viewCombo);
            this.springPanel.add(new JLabel(msg.getString("OptUIViewT")));
            this.springPanel.add(this.docSelCombo);
            this.springPanel.add(new JLabel(msg.getString("OptUIDSPT")));
        }
        temp.add((Component)this.springPanel, "Before");
        UIUtil.makeSpringCompactGrid((Container)this.springPanel, (int)2, (int)2, (int)0, (int)0, (int)5, (int)5);
        return temp;
    }

    private static LabelValueComboBox<String, String> createLookAndFeelComboBox(RText rtext) {
        LabelValueComboBox combo = new LabelValueComboBox();
        UIUtil.fixComboOrientation((JComboBox)combo);
        UIManager.LookAndFeelInfo systemInfo = null;
        for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
            String clazzName = info.getClassName();
            if (!clazzName.equals(UIManager.getSystemLookAndFeelClassName())) continue;
            systemInfo = info;
            break;
        }
        if (systemInfo != null) {
            combo.addLabelValuePair((Object)systemInfo.getName(), (Object)systemInfo.getClassName());
        }
        combo.addLabelValuePair((Object)"Substance", (Object)LNF_VALUE_SUBSTANCE);
        ExtendedLookAndFeelInfo[] info = rtext.get3rdPartyLookAndFeelInfo();
        if (info != null && info.length > 0) {
            for (ExtendedLookAndFeelInfo extendedLookAndFeelInfo : info) {
                combo.addLabelValuePair((Object)extendedLookAndFeelInfo.getName(), (Object)extendedLookAndFeelInfo.getClassName());
            }
        }
        return combo;
    }

    private Container createOtherPanel(ResourceBundle msg) {
        Box temp = Box.createVerticalBox();
        temp.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptOtherTitle")));
        Box modifiedDocsPanel = this.createHorizontalBox();
        this.highlightModifiedCheckBox = new JCheckBox(msg.getString("OptUIHMDN"));
        this.highlightModifiedCheckBox.setActionCommand("HighlightModifiedCheckBox");
        this.highlightModifiedCheckBox.addActionListener(this);
        this.hmColorButton = new RColorSwatchesButton(Color.RED);
        this.hmColorButton.addPropertyChangeListener((PropertyChangeListener)this);
        modifiedDocsPanel.add(this.highlightModifiedCheckBox);
        modifiedDocsPanel.add((Component)this.hmColorButton);
        modifiedDocsPanel.add(Box.createHorizontalGlue());
        temp.add(modifiedDocsPanel);
        JPanel showHostNamePanel = new JPanel(new BorderLayout());
        this.showHostNameCheckBox = new JCheckBox(msg.getString("OptUIShowHostName"));
        this.showHostNameCheckBox.setActionCommand("ShowHostNameCB");
        this.showHostNameCheckBox.addActionListener(this);
        showHostNamePanel.add((Component)this.showHostNameCheckBox, "Before");
        temp.add(showHostNamePanel);
        temp.add(Box.createVerticalGlue());
        return temp;
    }

    private static LabelValueComboBox<String, String> createSubstanceThemeComboBox() {
        LabelValueComboBox combo = new LabelValueComboBox();
        UIUtil.fixComboOrientation((JComboBox)combo);
        String root = "org.pushingpixels.substance.api.skin.Substance";
        combo.addLabelValuePair((Object)"Business", (Object)(root + "BusinessLookAndFeel"));
        combo.addLabelValuePair((Object)"Business Black Steel", (Object)(root + "BusinessBlackSteelLookAndFeel"));
        combo.addLabelValuePair((Object)"Business Blue Steel", (Object)(root + "BusinessBlueSteelLookAndFeel"));
        combo.addLabelValuePair((Object)"Cerulean", (Object)(root + "CeruleanLookAndFeel"));
        combo.addLabelValuePair((Object)"Creme", (Object)(root + "CremeLookAndFeel"));
        combo.addLabelValuePair((Object)"Creme Coffee", (Object)(root + "CremeCoffeeLookAndFeel"));
        combo.addLabelValuePair((Object)"Dust", (Object)(root + "DustLookAndFeel"));
        combo.addLabelValuePair((Object)"Dust Coffee", (Object)(root + "DustCoffeeLookAndFeel"));
        combo.addLabelValuePair((Object)"Gemini", (Object)(root + "GeminiLookAndFeel"));
        combo.addLabelValuePair((Object)"Graphite", (Object)(root + "GraphiteLookAndFeel"));
        combo.addLabelValuePair((Object)"Graphite Aqua", (Object)(root + "GraphiteAquaLookAndFeel"));
        combo.addLabelValuePair((Object)"Graphite Chalk", (Object)(root + "GraphiteChalkLookAndFeel"));
        combo.addLabelValuePair((Object)"Graphite Glass", (Object)(root + "GraphiteGlassLookAndFeel"));
        combo.addLabelValuePair((Object)"Mariner", (Object)(root + "MarinerLookAndFeel"));
        combo.addLabelValuePair((Object)"Mist Aqua", (Object)(root + "MistAquaLookAndFeel"));
        combo.addLabelValuePair((Object)"Mist Silver", (Object)(root + "MistSilverLookAndFeel"));
        combo.addLabelValuePair((Object)"Moderate", (Object)(root + "ModerateLookAndFeel"));
        combo.addLabelValuePair((Object)"Nebula", (Object)(root + "NebulaLookAndFeel"));
        combo.addLabelValuePair((Object)"Nebula Brick Wall", (Object)(root + "NebulaBrickWallLookAndFeel"));
        combo.addLabelValuePair((Object)"Office Black 2007", (Object)(root + "OfficeBlack2007LookAndFeel"));
        combo.addLabelValuePair((Object)"Sahara", (Object)(root + "SaharaLookAndFeel"));
        combo.addLabelValuePair((Object)"Twilight", (Object)(root + "TwilightLookAndFeel"));
        return combo;
    }

    private Container createThemePanel(ResourceBundle msg, Listener listener) {
        Box temp = Box.createVerticalBox();
        temp.setBorder((Border)new OptionsDialogPanel.OptionPanelBorder(msg.getString("OptThemeLabel")));
        SelectableLabel label = new SelectableLabel();
        label.setBorder(BorderFactory.createEmptyBorder(10, 0, 10, 0));
        label.setText(msg.getString("OptThemeDesc"));
        temp.add((Component)label, "North");
        this.themeCombo = new LabelValueComboBox();
        this.themeCombo.addLabelValuePair((Object)"Default", (Object)"default");
        this.themeCombo.addLabelValuePair((Object)"Eclipse", (Object)"eclipse");
        this.themeCombo.addLabelValuePair((Object)"Dark", (Object)"dark");
        this.themeCombo.addLabelValuePair((Object)"Dark (Monokai)", (Object)"monokai");
        UIUtil.fixComboOrientation(this.themeCombo);
        Box temp2 = this.createHorizontalBox();
        temp2.add((Component)this.themeCombo);
        temp2.add(Box.createHorizontalStrut(5));
        this.applyButton = UIUtil.newButton((ResourceBundle)msg, (String)"OptThemeApply", (ActionListener)listener);
        temp2.add(this.applyButton);
        temp2.add(Box.createHorizontalGlue());
        temp.add(temp2);
        return temp;
    }

    protected void doApplyImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setDocumentSelectionPlacement(this.getDocumentSelectionPlacement());
        RTextUtilities.setLookAndFeel(rtext, this.getLookAndFeelClassName());
        rtext.setIconGroupByName(this.getIconGroupName());
        mainView.setHighlightModifiedDocumentDisplayNames(this.highlightModifiedDocumentDisplayNames());
        mainView.setModifiedDocumentDisplayNamesColor(this.getModifiedDocumentDisplayNamesColor());
        rtext.setMainViewStyle(this.getMainViewStyle());
        rtext.getStatusBar().setStyle(this.getStatusBarStyle());
        rtext.setShowHostName(this.getShowHostName());
    }

    protected OptionsDialogPanel.OptionsPanelCheckResult ensureValidInputsImpl() {
        return null;
    }

    private int getDocumentSelectionPlacement() {
        return this.documentSelectionPlacement;
    }

    private String getIconGroupName() {
        return (String)this.imageLnFCombo.getSelectedValue();
    }

    private String getLookAndFeelClassName() {
        String value = (String)this.lnfCombo.getSelectedValue();
        if (LNF_VALUE_SUBSTANCE.equals(value)) {
            return (String)this.substanceSkinCombo.getSelectedValue();
        }
        return value;
    }

    private int getMainViewStyle() {
        return this.mainViewStyle;
    }

    private Color getModifiedDocumentDisplayNamesColor() {
        return this.hmColorButton.getColor();
    }

    private static OtherColors getOtherColorsForTheme(String theme) {
        OtherColors colors = new OtherColors();
        Color darkModifiedDocumentNameColor = new Color(255, 128, 128);
        if ("eclipse".equals(theme)) {
            colors.setModifiedDocumentNameColor(Color.RED);
        } else if ("dark".equals(theme)) {
            colors.setModifiedDocumentNameColor(darkModifiedDocumentNameColor);
        } else if ("monokai".equals(theme)) {
            colors.setModifiedDocumentNameColor(darkModifiedDocumentNameColor);
        } else {
            colors.setModifiedDocumentNameColor(Color.RED);
        }
        return colors;
    }

    private boolean getShowHostName() {
        return this.showHostNameCheckBox.isSelected();
    }

    private int getStatusBarStyle() {
        return this.statusBarStyle;
    }

    public JComponent getTopJComponent() {
        return this.themeCombo;
    }

    private boolean highlightModifiedDocumentDisplayNames() {
        return this.highlightModifiedCheckBox.isSelected();
    }

    private static void installRstaTheme(RText rtext, Theme theme) {
        rtext.setSyntaxScheme(theme.scheme);
        AbstractMainView mainView = rtext.getMainView();
        mainView.setBackgroundObject(theme.bgColor);
        mainView.setCaretColor(theme.caretColor);
        mainView.setCurrentLineHighlightColor(theme.currentLineHighlight);
        mainView.setGutterBorderColor(theme.gutterBorderColor);
        mainView.setHyperlinkColor(theme.hyperlinkFG);
        mainView.setLineNumberColor(theme.lineNumberColor);
        if (theme.lineNumberFont != null) {
            int fontSize = theme.lineNumberFontSize > 0 ? theme.lineNumberFontSize : 11;
            mainView.setLineNumberFont(new Font(theme.lineNumberFont, 0, fontSize));
        }
        mainView.setMarginLineColor(theme.marginLineColor);
        mainView.setMarkAllHighlightColor(theme.markAllHighlightColor);
        mainView.setMarkOccurrencesColor(theme.markOccurrencesColor);
        if (theme.matchedBracketBG != null) {
            mainView.setMatchedBracketBorderColor(theme.matchedBracketFG);
        }
        mainView.setMatchedBracketBGColor(theme.matchedBracketBG);
        if (theme.secondaryLanguages != null) {
            for (int i = 0; i < theme.secondaryLanguages.length; ++i) {
                mainView.setSecondaryLanguageColor(i, theme.secondaryLanguages[i]);
            }
        }
        mainView.setSelectionColor(theme.selectionBG);
        if (theme.selectionFG != null) {
            mainView.setSelectedTextColor(theme.selectionFG);
        }
        mainView.setUseSelectedTextColor(theme.useSelctionFG);
        mainView.setRoundedSelectionEdges(theme.selectionRoundedEdges);
        mainView.setFoldBackground(theme.foldBG);
        mainView.setArmedFoldBackground(theme.armedFoldBG);
    }

    private void possiblyUpdateSubstanceThemeWidgets() {
        boolean substanceSelected = LNF_VALUE_SUBSTANCE.equals(this.lnfCombo.getSelectedValue());
        this.substanceSkinLabel.setVisible(substanceSelected);
        this.substanceSkinCombo.setVisible(substanceSelected);
    }

    @Override
    public void propertyChange(PropertyChangeEvent e) {
        String propName = e.getPropertyName();
        if (propName.equals("RColorButton.colorChanged")) {
            this.hasUnsavedChanges = true;
            this.firePropertyChange("UIOptionPanel." + propName, e.getOldValue(), e.getNewValue());
        }
    }

    private void setDocumentSelectionPlacement(int documentSelectionPlacement) {
        if (documentSelectionPlacement != 2 && documentSelectionPlacement != 4 && documentSelectionPlacement != 1 && documentSelectionPlacement != 3) {
            documentSelectionPlacement = 1;
        }
        if (this.documentSelectionPlacement != documentSelectionPlacement) {
            this.documentSelectionPlacement = documentSelectionPlacement;
            this.docSelCombo.setSelectedIndex(documentSelectionPlacement - 1);
        }
    }

    private void setHighlightModifiedDocumentDisplayNames(boolean highlight) {
        this.highlightModifiedCheckBox.setSelected(highlight);
        this.hmColorButton.setEnabled(highlight);
    }

    private void setIconGroupByName(String name) {
        int count = this.imageLnFCombo.getItemCount();
        for (int i = 0; i < count; ++i) {
            String specialValue = (String)this.imageLnFCombo.getValueAt(i);
            if (!specialValue.equals(name)) continue;
            this.imageLnFCombo.setSelectedIndex(i);
            return;
        }
        this.imageLnFCombo.setSelectedIndex(0);
    }

    private void setLookAndFeelByClassName(String name) {
        if (SubstanceUtil.isASubstanceLookAndFeel((String)name)) {
            for (int i = 0; i < this.substanceSkinCombo.getItemCount(); ++i) {
                if (!name.equals(this.substanceSkinCombo.getValueAt(i))) continue;
                this.substanceSkinCombo.setSelectedIndex(i);
                break;
            }
            name = LNF_VALUE_SUBSTANCE;
        }
        int count = this.lnfCombo.getItemCount();
        for (int i = 0; i < count; ++i) {
            String specialValue = (String)this.lnfCombo.getValueAt(i);
            if (!specialValue.equals(name)) continue;
            this.lnfCombo.setSelectedIndex(i);
            this.possiblyUpdateSubstanceThemeWidgets();
            return;
        }
        this.possiblyUpdateSubstanceThemeWidgets();
        this.lnfCombo.setSelectedIndex(0);
    }

    private void setMainViewStyle(int viewStyle) {
        this.mainViewStyle = viewStyle == 0 || viewStyle == 1 || viewStyle == 2 ? viewStyle : 0;
        this.viewCombo.setSelectedIndex(this.mainViewStyle);
    }

    private void setModifiedDocumentDisplayNamesColor(Color color) {
        if (color == null) {
            throw new NullPointerException();
        }
        this.hmColorButton.setColor(color);
    }

    private void setShowHostName(boolean show) {
        this.showHostNameCheckBox.setSelected(show);
    }

    private void setStatusBarStyle(int style) {
        if (style != 0 && style != 1) {
            style = 1;
        }
        this.statusBarStyle = style;
        this.statusBarCombo.setSelectedIndex(this.statusBarStyle);
    }

    protected void setValuesImpl(Frame owner) {
        RText rtext = (RText)((Object)owner);
        AbstractMainView mainView = rtext.getMainView();
        this.setDocumentSelectionPlacement(mainView.getDocumentSelectionPlacement());
        this.setLookAndFeelByClassName(UIManager.getLookAndFeel().getClass().getName());
        this.setIconGroupByName(rtext.getIconGroup().getName());
        this.setMainViewStyle(rtext.getMainViewStyle());
        this.setHighlightModifiedDocumentDisplayNames(mainView.highlightModifiedDocumentDisplayNames());
        this.setStatusBarStyle(rtext.getStatusBar().getStyle());
        this.setModifiedDocumentDisplayNamesColor(mainView.getModifiedDocumentDisplayNamesColor());
        this.setShowHostName(rtext.getShowHostName());
    }

    public void updateUI() {
        super.updateUI();
        if (this.springPanel != null) {
            UIUtil.makeSpringCompactGrid((Container)this.springPanel, (int)2, (int)2, (int)0, (int)0, (int)5, (int)5);
        }
        if (this.springPanel2 != null) {
            UIUtil.makeSpringCompactGrid((Container)this.springPanel2, (int)3, (int)4, (int)0, (int)0, (int)5, (int)5);
        }
    }

    private static class OtherColors {
        private Color modifiedDocumentNameColor;

        private OtherColors() {
        }

        Color getModifiedDocumentNameColor() {
            return this.modifiedDocumentNameColor;
        }

        void setModifiedDocumentNameColor(Color color) {
            this.modifiedDocumentNameColor = color;
        }
    }

    private class Listener
    implements ActionListener {
        private Listener() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            Object source = e.getSource();
            if (UIOptionPanel.this.applyButton == source) {
                UIOptionPanel.this.applySelectedTheme();
            }
        }
    }
}

