/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.io.Serializable;
import java.util.ArrayList;
import unity.operators.Operator;
import unity.query.LQJoinNode;
import unity.query.LQNode;
import unity.query.LQTreeConstants;
import unity.util.StringFunc;

public class LQTree
implements LQTreeConstants,
Serializable {
    private static final long serialVersionUID = 1L;
    private LQNode lqtroot;
    private ArrayList<LQJoinNode> joinList;

    public LQTree(LQNode lQNode) {
        this.lqtroot = lQNode;
        this.joinList = new ArrayList();
    }

    public LQNode getRoot() {
        return this.lqtroot;
    }

    public ArrayList<LQJoinNode> getJoinList() {
        return this.joinList;
    }

    public void setJoinList(ArrayList<LQJoinNode> arrayList) {
        this.joinList = arrayList;
    }

    public void setRoot(LQNode lQNode) {
        this.lqtroot = lQNode;
    }

    public static void printProgressTree(LQNode lQNode) {
        LQTree.printPTree(lQNode, 1);
    }

    public static void printPTree(LQNode lQNode, int n) {
        int n2;
        long l;
        int n3;
        Operator operator = lQNode.getOperator();
        if (operator != null) {
            n3 = lQNode.numTuples();
            l = lQNode.getOperator().getRowsOutput();
            n2 = 0;
            if (n3 > 0) {
                n2 = (int)(100L * l / (long)n3);
            }
        } else {
            return;
        }
        System.out.println(StringFunc.spaces(n * 4) + lQNode.toString() + " Progress: " + l + " / " + n3 + " (" + n2 + "%)");
        n3 = n;
        if (lQNode.getNumChildren() > 1) {
            ++n3;
        }
        for (int i = 0; i < lQNode.getNumChildren(); ++i) {
            LQTree.printPTree(lQNode.getChild(i), n3);
        }
    }

    public void print() {
        LQTree.printTree(this.lqtroot, 0);
    }

    public static void printTree(LQNode lQNode, int n) {
        System.out.println(StringFunc.spaces(n * 4) + lQNode.toString());
        int n2 = n;
        ++n2;
        for (int i = 0; i < lQNode.getNumChildren(); ++i) {
            LQTree.printTree(lQNode.getChild(i), n2);
        }
    }

    public static void printTree(LQNode lQNode, int n, StringBuilder stringBuilder) {
        stringBuilder.append(StringFunc.spaces(n * 4) + lQNode.toString());
        stringBuilder.append('\n');
        int n2 = n;
        ++n2;
        for (int i = 0; i < lQNode.getNumChildren(); ++i) {
            LQTree.printTree(lQNode.getChild(i), n2, stringBuilder);
        }
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(100);
        LQTree.printTree(this.lqtroot, 0, stringBuilder);
        return stringBuilder.toString();
    }

    public static void validateTree(LQNode lQNode) {
        if (lQNode == null) {
            return;
        }
        for (int i = 0; i < lQNode.getNumChildren(); ++i) {
            LQNode lQNode2 = lQNode.getChild(i);
            lQNode2.parent = lQNode;
            LQTree.validateTree(lQNode2);
        }
    }
}

