/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import unity.engine.Relation;
import unity.mapping.DatabaseFunction;
import unity.mapping.DatabaseMapping;
import unity.operators.Limit;
import unity.operators.Operator;
import unity.query.GQDatabaseRef;
import unity.query.GlobalQuery;
import unity.query.LQNode;
import unity.query.SubQuery;

public class LQLimitNode
extends LQNode {
    private static final long serialVersionUID = 1L;
    private int start;
    private int count;
    private int limitType;
    public static final int TYPE_LIMIT = 1;
    public static final int TYPE_TOP = 2;
    public static final int TYPE_OVER = 3;
    public static final int TYPE_ROWNUM = 4;

    public LQLimitNode(int n, int n2) {
        this.type = 18;
        this.start = n;
        this.count = n2;
    }

    @Override
    public String generateSQL() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.count != 0 && this.count != Integer.MAX_VALUE) {
            stringBuffer.append("LIMIT " + this.count);
        }
        if (this.start != 0) {
            stringBuffer.append(" OFFSET " + this.start);
        }
        return stringBuffer.toString();
    }

    public String generateSQL_Limit() {
        ArrayList<String> arrayList = new ArrayList<String>(2);
        arrayList.add("" + this.count);
        arrayList.add("" + this.start);
        String string = this.getSignature();
        this.limitType = 1;
        String string2 = DatabaseMapping.convert(string, this, arrayList, null);
        if (string2.contains("#")) {
            if (string2.contains("#TOP#")) {
                this.limitType = 2;
                return string2.substring(5);
            }
            if (string2.contains("#TOPO#")) {
                this.limitType = 2;
                return string2.substring(5);
            }
            if (string2.contains("#OVER#")) {
                this.limitType = 3;
                return string2.substring(6);
            }
            if (string2.contains("#ROWNUM#")) {
                this.limitType = 4;
                return string2.substring(6);
            }
        }
        return string2;
    }

    public String getSignature() {
        if (this.start > 0) {
            return "#LIMIT_OFFSET#";
        }
        return "#LIMIT#";
    }

    public boolean hasOffset() {
        return this.start > 0;
    }

    @Override
    public String toString() {
        return this.generateSQL() + super.toString();
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) throws SQLException {
        this.outputRelation = new Relation(operatorArray[0].getOutputRelation());
        Limit limit = new Limit(operatorArray[0], this.start, this.count);
        return limit;
    }

    public int getStart() {
        return this.start;
    }

    public int getCount() {
        return this.count;
    }

    @Override
    protected HashSet<GQDatabaseRef> getDatabaseRefs(GQDatabaseRef gQDatabaseRef, boolean bl) {
        HashSet<GQDatabaseRef> hashSet = new HashSet<GQDatabaseRef>(2);
        DatabaseFunction databaseFunction = DatabaseMapping.getMapping(this.getSignature(), this.getDatabase(), null);
        if (databaseFunction == null) {
            hashSet.add(GQDatabaseRef.UNITYJDBC_DBREF);
        } else {
            String string = databaseFunction.getExprText();
            if (string.contains("#TOPO#")) {
                LQLimitNode lQLimitNode = new LQLimitNode(0, this.getCount() + this.getStart());
                lQLimitNode.addChild(this.getChild(0));
                this.getChild(0).setParent(lQLimitNode);
                lQLimitNode.setDatabase(this.getDatabase());
                lQLimitNode.setParent(this);
                this.removeChild(0);
                this.addChild(lQLimitNode);
                this.setDatabase(GQDatabaseRef.UNITYJDBC_DBREF);
                hashSet.add(lQLimitNode.getDatabase());
                hashSet.add(GQDatabaseRef.UNITYJDBC_DBREF);
            }
        }
        return hashSet;
    }

    public int getLimitType() {
        return this.limitType;
    }

    @Override
    public void computeCost() {
        long l = this.getChild(0).getRows();
        this.cost = (double)l * 1.0;
        this.rows = this.getCount();
    }
}

