/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.io.Serializable;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.regex.Matcher;
import pig.query.PigOperation;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceTable;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.functions.ConstantValue;
import unity.functions.Divide;
import unity.functions.ExprList;
import unity.functions.Expression;
import unity.functions.ExtractAttribute;
import unity.functions.ExtractAttributeParentQuery;
import unity.functions.F_Adddate;
import unity.functions.F_Bitand;
import unity.functions.F_Bitor;
import unity.functions.F_Bitxor;
import unity.functions.F_Cast;
import unity.functions.F_Ceiling;
import unity.functions.F_Datesub;
import unity.functions.F_Length;
import unity.functions.F_Lower;
import unity.functions.F_Substring;
import unity.functions.F_Trim;
import unity.functions.F_Upper;
import unity.functions.Function;
import unity.functions.Interval;
import unity.functions.Minus;
import unity.functions.Modulus;
import unity.functions.Multiply;
import unity.functions.Null;
import unity.functions.Plus;
import unity.functions.SubqueryValue;
import unity.jdbc.UnityDriver;
import unity.mapping.DatabaseMapping;
import unity.mapping.GlobalFunction;
import unity.operators.Operator;
import unity.query.GQDatabaseRef;
import unity.query.GQFieldRef;
import unity.query.GQTableRef;
import unity.query.GlobalQuery;
import unity.query.LQCaseExpr;
import unity.query.LQGroupByNode;
import unity.query.LQNode;
import unity.query.LocalQuery;
import unity.query.Optimizer;
import unity.query.SubQuery;
import unity.util.StringFunc;

public class LQExprNode
extends LQNode
implements Cloneable {
    private static final long serialVersionUID = 1L;
    protected static String[] packages = new String[]{"unity.functions.", ""};

    public LQExprNode() {
    }

    public LQExprNode(LQExprNode lQExprNode) {
        super(lQExprNode);
    }

    public int getOutputType() {
        if (this.type == 101) {
            return 12;
        }
        if (this.type == 104) {
            return 4;
        }
        if (this.type == 105) {
            return 8;
        }
        if (this.type == 140) {
            return 91;
        }
        if (this.type == 141) {
            return 92;
        }
        if (this.type == 142) {
            return 93;
        }
        if (this.type == 100) {
            GQFieldRef gQFieldRef;
            AnnotatedSourceField annotatedSourceField;
            if (this.content != null && this.content instanceof GQFieldRef && (annotatedSourceField = (gQFieldRef = (GQFieldRef)this.content).getField()) != null) {
                return annotatedSourceField.getDataType();
            }
        } else if (this.type != 125 && this.type != 102 && this.type == 126) {
            LQExprNode lQExprNode = (LQExprNode)this.getChild(0);
            LQExprNode lQExprNode2 = (LQExprNode)this.getChild(1);
            int n = lQExprNode.getOutputType();
            int n2 = lQExprNode2.getOutputType();
            if (n == 12 || n2 == 12) {
                return 12;
            }
            return n;
        }
        return 4;
    }

    public boolean isString() {
        int n = this.getOutputType();
        return n == 12 || n == 1;
    }

    public boolean isConstant() {
        return this.type == 101 || this.type == 104 || this.type == 105 || this.type == 127;
    }

    private String processDate() {
        String string = "'";
        string = DatabaseMapping.getMappingText("#DATE_DELIMITER#", this.getDatabase(), this);
        if (!(this.getContent() instanceof Date)) {
            return this.getContent().toString();
        }
        Date date = (Date)this.getContent();
        if (this.type == 140) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd");
            return string + simpleDateFormat.format(date) + string;
        }
        if (this.type == 141) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("HH:mm:ss");
            return string + simpleDateFormat.format(date) + string;
        }
        if (this.type == 142) {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            return string + simpleDateFormat.format(date) + string;
        }
        return "ERROR";
    }

    private String processIdentifier() {
        if (this.database != null && this.database.getDatabase().getDatabaseId() == 97001100) {
            return ((GQFieldRef)this.getContent()).getField().getColumnName();
        }
        if (this.getContent() instanceof GQFieldRef) {
            return ((GQFieldRef)this.getContent()).getLocalName();
        }
        if (this.getContent() instanceof GQTableRef) {
            return ((GQTableRef)this.getContent()).getLocalName();
        }
        if (this.getContent() != null) {
            return this.getContent().toString();
        }
        return "ERROR";
    }

    private String processAsIdentifier() {
        String string = DatabaseMapping.getMappingText("#AS#", this.getDatabase(), this);
        String string2 = this.getChild(1).generateSQL();
        if (StringFunc.isDelimited(string2, '\"')) {
            char c = '\"';
            if (this.getDatabase() != null && this.getDatabase().getDatabase() != null) {
                c = this.getDatabase().getDatabase().getDelimitChar();
            }
            string2 = StringFunc.delimitName(string2, c);
        }
        if (string2.equals("\"\"")) {
            return this.getChild(0).generateSQL();
        }
        return this.getChild(0).generateSQL() + string + string2;
    }

    @Override
    public String generateSQL() {
        if (this.type == 6) {
            return ((GQTableRef)this.getContent()).getLocalName();
        }
        if (this.type == 101) {
            GQDatabaseRef gQDatabaseRef;
            Object object;
            String string = this.getContent().toString();
            if (this.getDatabase() != null && (object = (gQDatabaseRef = this.getDatabase()).getDatabase().getProperty("string_escape_backslash")) != null) {
                String string2 = object.toString();
                string = string.replaceAll("\\\\", Matcher.quoteReplacement('\\' + string2));
            }
            return string;
        }
        if (this.type == 127 || this.type == 104 || this.type == 105 || this.type == 117 || this.type == 130) {
            return this.getContent().toString();
        }
        if (this.type == 140 || this.type == 141 || this.type == 142) {
            return this.processDate();
        }
        if (this.type == 100) {
            return this.processIdentifier();
        }
        if (this.type == 103) {
            return this.processAsIdentifier();
        }
        if (this.type == 120) {
            return ((LQExprNode)this.getContent()).generateSQL();
        }
        if (this.type == 134) {
            if (this.content instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)this.content;
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append('(');
                for (int i = 0; i < arrayList.size() - 1; ++i) {
                    stringBuffer.append(((LQExprNode)arrayList.get(i)).generateSQL() + ", ");
                }
                if (arrayList.size() > 0) {
                    stringBuffer.append(((LQExprNode)arrayList.get(arrayList.size() - 1)).generateSQL());
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
        } else {
            if (this.type == 125 || this.type == 102 || this.type == 124) {
                return DatabaseMapping.convert(this);
            }
            if (this.type == 126) {
                String string = this.getContent().toString();
                LQExprNode lQExprNode = (LQExprNode)this.getChild(0);
                LQExprNode lQExprNode2 = (LQExprNode)this.getChild(1);
                if (string.equals("||") || string.equals("+") && (lQExprNode.isString() || lQExprNode2.isString())) {
                    ArrayList<String> arrayList = new ArrayList<String>(2);
                    if (!lQExprNode.isString() && lQExprNode.database != null && lQExprNode.database.getDatabase() != null && lQExprNode.database.getDatabase().getDatabaseId() == 71150500) {
                        arrayList.add("CAST(" + lQExprNode.generateSQL() + " AS VARCHAR)");
                    } else {
                        arrayList.add(lQExprNode.generateSQL());
                    }
                    if (!lQExprNode2.isString() && lQExprNode2.database != null && lQExprNode2.database.getDatabase() != null && lQExprNode2.database.getDatabase().getDatabaseId() == 71150500) {
                        arrayList.add("CAST(" + lQExprNode2.generateSQL() + " AS VARCHAR)");
                    } else {
                        arrayList.add(lQExprNode2.generateSQL());
                    }
                    String string3 = DatabaseMapping.convertUnity("CONCATENATE", this, arrayList, this);
                    return string3;
                }
                if (string.equals("|") || string.equals("&") || string.equals("^")) {
                    ArrayList<String> arrayList = new ArrayList<String>(2);
                    arrayList.add(lQExprNode.generateSQL());
                    arrayList.add(lQExprNode2.generateSQL());
                    String string4 = DatabaseMapping.convertUnity(string, this, arrayList, this);
                    return string4;
                }
                if (this.parent == null) {
                    return "(" + lQExprNode.generateSQL() + this.getContent() + lQExprNode2.generateSQL() + ")";
                }
                return "(" + lQExprNode.generateSQL() + this.getContent() + lQExprNode2.generateSQL() + ")";
            }
            if (this.type == 131 || this.type == 132) {
                return this.getContent().toString().toUpperCase();
            }
            if (this.type == 129) {
                String string = this.getChild(1).generateSQL();
                string = string.replaceAll("''", "'");
                StringBuffer stringBuffer = new StringBuffer(string);
                return stringBuffer.substring(1, stringBuffer.length() - 1);
            }
            if (this.type == 17) {
                SubQuery subQuery = (SubQuery)this.getContent();
                return "(" + StringFunc.oneLineSQL(Optimizer.buildSQL(subQuery.getLogicalQueryTree().getRoot())) + ')';
            }
        }
        return UnityDriver.i18n.getString("LQExprNode.GenerateSQLError");
    }

    private int findFieldByReferencePig(GQFieldRef gQFieldRef, Relation relation, StringBuilder stringBuilder, boolean bl) {
        for (int i = 0; i < relation.getNumAttributes(); ++i) {
            Object object;
            Attribute attribute = relation.getAttribute(i);
            Object object2 = attribute.getReference();
            if (object2 instanceof GQFieldRef) {
                if (object2 != gQFieldRef) continue;
                if (bl) {
                    object = gQFieldRef.getTable().getAliasName();
                    if (object == null) {
                        object = gQFieldRef.getTable().getLocalName();
                    }
                    if (stringBuilder.length() == 0) {
                        stringBuilder.append((String)object);
                        stringBuilder.append(".");
                    }
                    stringBuilder.append(attribute.getName());
                    return i;
                }
                object = gQFieldRef.getField() != null ? attribute.getName() : "$" + i;
                stringBuilder.append((String)object);
                return i;
            }
            if (object2 instanceof Relation) {
                stringBuilder.append(attribute.getName() + ".");
                return this.findFieldByReferencePig(gQFieldRef, (Relation)object2, stringBuilder, bl);
            }
            if (!attribute.getName().equals("group") || !((object = this.getContent()) instanceof GQFieldRef)) continue;
            String string = ((GQFieldRef)this.getContent()).getField().getColumnName();
            ArrayList arrayList = (ArrayList)relation.getAttribute(0).getReference();
            for (int j = 0; j < arrayList.size(); ++j) {
                LQExprNode lQExprNode = (LQExprNode)arrayList.get(j);
                if (!lQExprNode.getContent().toString().equalsIgnoreCase(string)) continue;
                if (arrayList.size() > 1) {
                    stringBuilder.append("group.$" + j);
                } else {
                    stringBuilder.append("$" + j);
                }
                return i;
            }
        }
        return -1;
    }

    @Override
    public String generatePig(Relation relation) {
        if (this.type == 6) {
            return ((GQTableRef)this.getContent()).getLocalName();
        }
        if (this.type == 127 || this.type == 101 || this.type == 104 || this.type == 105 || this.type == 117 || this.type == 130) {
            return this.getContent().toString();
        }
        if (this.type == 140 || this.type == 141 || this.type == 142) {
            return this.processDate();
        }
        if (this.type == 100) {
            LQNode lQNode = this.getParent();
            boolean bl = lQNode != null && lQNode.getType() == 125;
            StringBuilder stringBuilder = new StringBuilder();
            int n = this.findFieldByReferencePig((GQFieldRef)this.getContent(), relation, stringBuilder, bl);
            if (n >= 0) {
                return stringBuilder.toString();
            }
            return ((GQFieldRef)this.getContent()).getField().getColumnName();
        }
        if (this.type == 103) {
            return this.getChild(0).generatePig(relation);
        }
        if (this.type == 120) {
            return ((LQExprNode)this.getContent()).generatePig(relation);
        }
        if (this.type == 134) {
            if (this.content instanceof ArrayList) {
                ArrayList arrayList = (ArrayList)this.content;
                StringBuffer stringBuffer = new StringBuffer(100);
                stringBuffer.append('(');
                for (int i = 0; i < arrayList.size() - 1; ++i) {
                    stringBuffer.append(((LQExprNode)arrayList.get(i)).generatePig(relation) + ", ");
                }
                if (arrayList.size() > 0) {
                    stringBuffer.append(arrayList.get(arrayList.size() - 1));
                }
                stringBuffer.append(')');
                return stringBuffer.toString();
            }
        } else {
            if (this.type == 125 || this.type == 102 || this.type == 124) {
                StringBuilder stringBuilder;
                int n;
                Object object;
                if (this.type == 125 && this.getContent().toString().equalsIgnoreCase("COUNT") && ((LQNode)(object = (LQExprNode)this.getChild(0))).getContent().toString().equals("*")) {
                    LQGroupByNode lQGroupByNode = (LQGroupByNode)((LQNode)object).getReference();
                    PigOperation pigOperation = (PigOperation)lQGroupByNode.getReference();
                    String string = pigOperation.getText();
                    int n2 = string.indexOf("GROUP");
                    int n3 = string.indexOf("BY");
                    if (n3 < 0) {
                        n3 = string.indexOf("ALL");
                    }
                    String string2 = string.substring(n2 + 6, n3 - 1);
                    return "COUNT_STAR(" + string2 + ")";
                }
                object = this.getReference();
                if (object instanceof GQFieldRef && (n = this.findFieldByReferencePig((GQFieldRef)object, relation, stringBuilder = new StringBuilder(), false)) >= 0) {
                    return stringBuilder.toString();
                }
                return DatabaseMapping.convertPig(this, relation);
            }
            if (this.type == 126) {
                String string = this.getContent().toString();
                LQExprNode lQExprNode = (LQExprNode)this.getChild(0);
                LQExprNode lQExprNode2 = (LQExprNode)this.getChild(1);
                if (string.equals("||") || string.equals("+") && (lQExprNode.isString() || lQExprNode2.isString())) {
                    ArrayList<String> arrayList = new ArrayList<String>(2);
                    if (!lQExprNode.isString() && lQExprNode.database != null && lQExprNode.database.getDatabase() != null && lQExprNode.database.getDatabase().getDatabaseId() == 71150500) {
                        arrayList.add("CAST(" + lQExprNode.generatePig(relation) + " AS VARCHAR)");
                    } else {
                        arrayList.add(lQExprNode.generateSQL());
                    }
                    if (!lQExprNode2.isString() && lQExprNode2.database != null && lQExprNode2.database.getDatabase() != null && lQExprNode2.database.getDatabase().getDatabaseId() == 71150500) {
                        arrayList.add("CAST(" + lQExprNode2.generatePig(relation) + " AS VARCHAR)");
                    } else {
                        arrayList.add(lQExprNode2.generateSQL());
                    }
                    String string3 = DatabaseMapping.convertUnity("CONCATENATE", this, arrayList, this);
                    return string3;
                }
                if (string.equals("|") || string.equals("&") || string.equals("^")) {
                    ArrayList<String> arrayList = new ArrayList<String>(2);
                    arrayList.add(lQExprNode.generateSQL());
                    arrayList.add(lQExprNode2.generateSQL());
                    String string4 = DatabaseMapping.convertUnity(string, this, arrayList, this);
                    return string4;
                }
                if (this.parent == null) {
                    return "(" + lQExprNode.generatePig(relation) + this.getContent() + lQExprNode2.generatePig(relation) + ")";
                }
                return "(" + lQExprNode.generatePig(relation) + this.getContent() + lQExprNode2.generatePig(relation) + ")";
            }
            if (this.type == 131 || this.type == 132) {
                return this.getContent().toString().toUpperCase();
            }
            if (this.type == 129) {
                StringBuffer stringBuffer = new StringBuffer(this.getChild(1).generatePig(relation));
                return stringBuffer.substring(1, stringBuffer.length() - 1);
            }
            if (this.type == 17) {
                SubQuery subQuery = (SubQuery)this.getContent();
                return "(" + Optimizer.buildSQL(subQuery.getLogicalQueryTree().getRoot()) + ')';
            }
        }
        return UnityDriver.i18n.getString("LQExprNode.GeneratePigError");
    }

    @Override
    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(100);
        if (this.type == 129) {
            stringBuffer.append(this.getContent() + "(");
            if (this.getNumChildren() > 0) {
                stringBuffer.append(((LQExprNode)this.getChild(0)).generateSQL());
            }
            for (int i = 1; i < this.getNumChildren(); ++i) {
                stringBuffer.append("," + ((LQExprNode)this.getChild(i)).generateSQL());
            }
            stringBuffer.append(')');
            return stringBuffer.toString();
        }
        if (this.type == 17) {
            SubQuery subQuery = (SubQuery)this.getContent();
            return subQuery.toString();
        }
        stringBuffer.append(this.generateSQL());
        if (this.reference != null) {
            if (this.reference instanceof GQDatabaseRef) {
                stringBuffer.append(" (source: ");
                stringBuffer.append(((GQDatabaseRef)this.reference).getName());
                stringBuffer.append(')');
            } else if (!(this.reference instanceof GlobalFunction)) {
                String string = DatabaseMapping.getMappingText("#AS#", this.getDatabase(), this);
                stringBuffer.append(string);
                stringBuffer.append(this.reference.toString());
            }
        }
        if (this.type == 6) {
            stringBuffer.append(" (size: ");
            stringBuffer.append(((GQTableRef)this.content).getTable().getNumTuples());
            stringBuffer.append(')');
        }
        return stringBuffer.toString();
    }

    @Override
    public Operator buildOperator(Operator[] operatorArray, GlobalQuery globalQuery, SubQuery subQuery) {
        return null;
    }

    public Expression buildExpression(Relation relation, Attribute attribute, GlobalQuery globalQuery, SubQuery subQuery, Operator operator) throws SQLException {
        Expression expression = null;
        int n = this.getType();
        if (n == 100 || n == 120) {
            expression = this.buildIdentifierExpression(relation, attribute, subQuery, operator);
        } else if (n == 103) {
            expression = ((LQExprNode)this.getChild(0)).buildExpression(relation, attribute, globalQuery, subQuery, operator);
            attribute.setName((String)this.getChild(1).getContent());
        } else if (n == 127 || n == 104 || n == 105 || n == 101) {
            ConstantValue constantValue = new ConstantValue(this.getContent());
            expression = constantValue;
            attribute.setType(constantValue.getReturnType());
            expression.setReturnType(attribute.getType());
            attribute.setName("Constant" + globalQuery.getUniqueExprNum());
            attribute.setLength(this.getContent().toString().length());
            attribute.setReference(null);
        } else if (n == 140 || n == 141 || n == 142) {
            ConstantValue constantValue = new ConstantValue(this.getContent());
            if (n == 140) {
                constantValue.setReturnType(91);
            } else if (n == 141) {
                constantValue.setReturnType(92);
            } else {
                constantValue.setReturnType(93);
            }
            expression = constantValue;
            attribute.setType(constantValue.getReturnType());
            expression.setReturnType(attribute.getType());
            attribute.setName("Constant" + globalQuery.getUniqueExprNum());
            if (n == 140 || n == 141) {
                attribute.setLength(10);
            } else {
                attribute.setLength(20);
            }
            attribute.setReference(null);
        } else if (n == 126) {
            expression = this.buildMathExpression(relation, attribute, globalQuery, subQuery, operator);
        } else if (n == 102 || n == 125 || n == 124) {
            expression = this.buildFunctionExpression(relation, attribute, globalQuery, subQuery, operator);
        } else if (this.type == 129) {
            int n2 = this.getNumChildren();
            if (n2 != 3) {
                throw new SQLException(UnityDriver.i18n.getString("LQExprNode.ArgError") + n2 + UnityDriver.i18n.getString("For") + this.toString());
            }
            String string = this.getChild(2).getContent().toString();
            string = string.substring(1, string.length() - 1);
            int n3 = relation.getAttributeIndex(this.getReference());
            if (n3 != -1) {
                expression = new ExtractAttribute(n3);
                Attribute attribute2 = relation.getAttribute(n3);
                expression.setReturnType(attribute2.getType());
                attribute.setType(attribute2.getType());
                attribute.setName(attribute2.getName());
                attribute.setLength(attribute2.getLength());
                attribute.setReference(attribute2.getReference());
            }
        } else if (n == 117) {
            String string = StringFunc.convertSQLPatternToJavaPattern((String)this.getContent());
            expression = new ConstantValue(string);
            expression.setReturnType(attribute.getType());
        } else if (n == 130) {
            expression = new ConstantValue("");
            expression.setReturnType(attribute.getType());
        } else if (n == 134) {
            ArrayList arrayList = (ArrayList)this.getContent();
            Expression[] expressionArray = new Expression[arrayList.size()];
            Attribute attribute3 = new Attribute();
            for (int i = 0; i < arrayList.size(); ++i) {
                expressionArray[i] = ((LQExprNode)arrayList.get(i)).buildExpression(relation, attribute3, globalQuery, subQuery, operator);
            }
            expression = new ExprList(expressionArray);
            expression.setReturnType(attribute.getType());
        } else if (n == 131) {
            Null nullVal = new Null();
            expression = nullVal;
            attribute.setType(12);
            expression.setReturnType(attribute.getType());
            attribute.setName("Expr" + globalQuery.getUniqueExprNum());
            attribute.setLength(4);
            attribute.setReference(null);
        } else if (n == 17) {
            Optimizer optimizer = new Optimizer(globalQuery, globalQuery.getLocalProcessing(), null);
            SubQuery subQuery2 = (SubQuery)this.getContent();
            optimizer.optimizeSubQuery(subQuery2);
            subQuery2.setLocalQueries(new ArrayList<LocalQuery>());
            subQuery2.setOperator(operator);
            subQuery2.setGlobalQuery(globalQuery);
            this.op = Optimizer.buildExecTree(subQuery2.getLogicalQueryTree().getRoot(), subQuery2.getLocalQueries(), subQuery2.getLocalQueryNodes(), globalQuery, subQuery2);
            for (LocalQuery localQuery : subQuery2.getLocalQueries()) {
                globalQuery.addLocalQuery(localQuery);
            }
            expression = new SubqueryValue(this.op, subQuery2);
            attribute.setName("Constant" + globalQuery.getUniqueExprNum());
            attribute.setLength(20);
            attribute.setReference(null);
        }
        if (expression == null) {
            throw new SQLException(UnityDriver.i18n.getString("LQExprNode.ErrorBuildExpression") + this.getContent());
        }
        return expression;
    }

    private Expression buildIdentifierExpression(Relation relation, Attribute attribute, SubQuery subQuery, Operator operator) throws SQLException {
        Serializable serializable;
        Object object;
        Object object2;
        Object object3;
        int n = relation.getAttributeIndex(this.getContent());
        if (n == -1 && (n = relation.getAttributeIndexByName(this.getContent().toString())) != -1) {
            object3 = this.getContent();
            object2 = relation.getAttribute(n).getReference();
            if (object3 != null && object2 != null && object3 instanceof GQFieldRef && object2 instanceof GQFieldRef) {
                object = (GQFieldRef)object3;
                serializable = (GQFieldRef)object2;
                if (((GQFieldRef)object).getTable() != ((GQFieldRef)serializable).getTable()) {
                    n = -1;
                }
            }
        }
        if (n == -1 && subQuery != null && subQuery.isCorrelated()) {
            System.out.println("Looking for field in correlated subquery.");
            object3 = operator.getChild(0).getOutputRelation();
            n = ((Relation)object3).getAttributeIndex(this.getContent());
            if (n != -1) {
                object = object2 = new ExtractAttributeParentQuery(subQuery, n);
                serializable = ((Relation)object3).getAttribute(n);
                ((Expression)object).setReturnType(((Attribute)serializable).getType());
                attribute.setType(((Attribute)serializable).getType());
                attribute.setName(((Attribute)serializable).getName());
                attribute.setLength(((Attribute)serializable).getLength());
                attribute.setReference(((Attribute)serializable).getReference());
                return object;
            }
        }
        if (n != -1) {
            object2 = object3 = new ExtractAttribute(n);
            object = relation.getAttribute(n);
            ((Expression)object2).setReturnType(((Attribute)object).getType());
            attribute.setType(((Attribute)object).getType());
            attribute.setName(((Attribute)object).getName());
            attribute.setLength(((Attribute)object).getLength());
            attribute.setReference(((Attribute)object).getReference());
            return object2;
        }
        throw new SQLException(UnityDriver.i18n.getString("LQExprNode.NoFindAttributeError") + this.toString());
    }

    private Expression buildMathExpression(Relation relation, Attribute attribute, GlobalQuery globalQuery, SubQuery subQuery, Operator operator) throws SQLException {
        Attribute attribute2 = new Attribute();
        Attribute attribute3 = new Attribute();
        Expression expression = ((LQExprNode)this.getChild(0)).buildExpression(relation, attribute2, globalQuery, subQuery, operator);
        Expression expression2 = ((LQExprNode)this.getChild(1)).buildExpression(relation, attribute3, globalQuery, subQuery, operator);
        String string = (String)this.getContent();
        Expression expression3 = null;
        if (string.equals("+") || string.equals("||")) {
            if (expression instanceof Interval || expression2 instanceof Interval) {
                Expression expression4;
                if (!Attribute.isDateType(expression.getReturnType())) {
                    expression4 = new F_Cast(expression, expression.getReturnType(), 91);
                    expression4.setParent(expression.getParent());
                    expression.setParent(expression4);
                    expression = expression4;
                }
                expression3 = expression4 = new F_Adddate(expression, expression2);
            } else {
                Plus plus = new Plus(expression, expression2);
                expression3 = plus;
            }
        } else if (string.equals("-")) {
            if (expression instanceof Interval || expression2 instanceof Interval || Attribute.isDateType(attribute2.getType()) || Attribute.isDateType(attribute3.getType())) {
                F_Datesub f_Datesub = new F_Datesub(expression, expression2);
                expression3 = f_Datesub;
            } else {
                Minus minus = new Minus(expression, expression2);
                expression3 = minus;
            }
        } else if (string.equals("*")) {
            if (expression instanceof Interval || expression2 instanceof Interval) {
                // empty if block
            }
            Multiply multiply = new Multiply(expression, expression2);
            expression3 = multiply;
        } else if (string.equals("/")) {
            if (expression instanceof Interval || expression2 instanceof Interval) {
                // empty if block
            }
            Divide divide = new Divide(expression, expression2);
            expression3 = divide;
        } else if (string.equals("%")) {
            Modulus modulus = new Modulus(expression, expression2);
            expression3 = modulus;
        } else if (string.equals("|")) {
            F_Bitor f_Bitor = new F_Bitor(expression, expression2);
            expression3 = f_Bitor;
        } else if (string.equals("&")) {
            F_Bitand f_Bitand = new F_Bitand(expression, expression2);
            expression3 = f_Bitand;
        } else if (string.equals("^")) {
            F_Bitxor f_Bitxor = new F_Bitxor(expression, expression2);
            expression3 = f_Bitxor;
        } else {
            throw new SQLException(UnityDriver.i18n.getString("LQExprNode.UndefinedOperator") + string);
        }
        attribute.setType(expression3.getReturnType());
        attribute.setName("Expr" + globalQuery.getUniqueExprNum());
        if (expression3.getReturnType() == 12) {
            attribute.setLength(attribute2.getLength() + attribute3.getLength());
        } else {
            attribute.setLength(attribute2.getLength());
        }
        attribute.setReference(null);
        return expression3;
    }

    private Expression buildFunctionExpression(Relation relation, Attribute attribute, GlobalQuery globalQuery, SubQuery subQuery, Operator operator) throws SQLException {
        Class clazz;
        Object object;
        Expression expression = null;
        int n = this.getNumChildren();
        String string = this.generateSQL();
        int n2 = relation.getAttributeIndexByReferenceString(string);
        if (n2 >= 0) {
            ExtractAttribute extractAttribute = new ExtractAttribute(n2);
            expression = extractAttribute;
            Attribute attribute2 = relation.getAttribute(n2);
            expression.setReturnType(attribute2.getType());
            attribute.setType(attribute2.getType());
            attribute.setName(attribute2.getName());
            attribute.setLength(attribute2.getLength());
            attribute.setReference(attribute2.getReference());
            return expression;
        }
        ArrayList<LQNode> arrayList = this.getChildren();
        Expression[] expressionArray = new Expression[n];
        Attribute[] attributeArray = new Attribute[n];
        for (int i = 0; i < n; ++i) {
            object = arrayList.get(i);
            attributeArray[i] = new Attribute();
            expressionArray[i] = ((LQExprNode)object).buildExpression(relation, attributeArray[i], globalQuery, subQuery, operator);
        }
        String string2 = (String)this.getContent();
        object = null;
        string = (String)this.getContent();
        if (string.equals("CONCAT") || string.equals("CONCATENATE")) {
            clazz = new Plus(expressionArray[0], expressionArray[1]);
            for (int i = 2; i < n; ++i) {
                clazz = new Plus((Expression)((Object)clazz), expressionArray[i]);
            }
            expression = clazz;
        } else if (this.type == 102) {
            object = "F_";
            if (string2.equalsIgnoreCase("TRIM") && n >= 1 && n <= 3) {
                expressionArray = Function.validateTypes(string2, F_Trim.getParamListTypes(), expressionArray, n);
                if (n == 1) {
                    expression = new F_Trim(expressionArray[0], "BOTH", null);
                } else {
                    clazz = expressionArray[1].evaluate(null).toString();
                    expression = n == 2 ? (((String)((Object)clazz)).equals("BOTH") || ((String)((Object)clazz)).equals("LEADING") || ((String)((Object)clazz)).equals("TRAILING") ? new F_Trim(expressionArray[0], (String)((Object)clazz), null) : new F_Trim(expressionArray[0], "BOTH", expressionArray[1])) : new F_Trim(expressionArray[0], (String)((Object)clazz), expressionArray[2]);
                }
            } else if (string2.equalsIgnoreCase("LTRIM") && n == 1) {
                expression = new F_Trim(expressionArray[0], "LEADING", null);
            } else if (string2.equalsIgnoreCase("RTRIM") && n == 1) {
                expression = new F_Trim(expressionArray[0], "TRAILING", null);
            } else if (string2.equalsIgnoreCase("UCASE") && n == 1) {
                expression = new F_Upper(expressionArray[0]);
            } else if (string2.equalsIgnoreCase("LCASE") && n == 1) {
                expression = new F_Lower(expressionArray[0]);
            } else if (string2.equalsIgnoreCase("CAST") && n == 2) {
                expression = new F_Cast(expressionArray[0], expressionArray[0].getReturnType(), expressionArray[1].toString());
            } else if (string2.equalsIgnoreCase("SUBSTRING") && (n == 2 || n == 3)) {
                expressionArray = Function.validateTypes(string2, F_Substring.getParamListTypes(), expressionArray, n);
                expression = n == 2 ? new F_Substring(expressionArray[0], expressionArray[1], null) : new F_Substring(expressionArray[0], expressionArray[1], expressionArray[2]);
            }
        } else if (this.type == 125) {
            object = "A_";
        } else if (this.type == 124) {
            object = "D_";
        }
        if (expression == null) {
            try {
                if (!(this.type != 125 && this.type != 124 || Attribute.isNumberType(attributeArray[0].getType()) || !string2.equalsIgnoreCase("SUM") && !string2.equalsIgnoreCase("AVG"))) {
                    throw new SQLException(UnityDriver.i18n.getString("LQExprNode.NoAggregateOnNonNumericType"));
                }
                if (string2.equalsIgnoreCase("LENGTH") || string2.equalsIgnoreCase("CHARACTER_LENGTH") || string2.equalsIgnoreCase("CHAR_LENGTH") || string2.equalsIgnoreCase("LEN")) {
                    clazz = F_Length.class;
                } else if (string2.equalsIgnoreCase("CEIL")) {
                    clazz = F_Ceiling.class;
                } else {
                    string2 = LQExprNode.formatFunctionName(string2);
                    clazz = LQExprNode.findClass((String)object + string2);
                }
                if (clazz != null) {
                    Constructor<?>[] constructorArray = clazz.getConstructors();
                    Constructor<?> constructor = null;
                    int n3 = 0;
                    for (int i = 0; i < constructorArray.length && n != (n3 = (constructor = constructorArray[i]).getParameterTypes().length); ++i) {
                    }
                    if (n != n3) {
                        throw new SQLException(UnityDriver.i18n.getString("LQExprNode.WrongNumParameters") + this.toString() + ' ' + UnityDriver.i18n.getString("LQExprNode.Received") + n3 + ' ' + UnityDriver.i18n.getString("LQExprNode.Expected") + n);
                    }
                    if (this.type == 102) {
                        int[] nArray = (int[])clazz.getMethod("getParamListTypes", null).invoke((Object)null, (Object[])null);
                        expressionArray = Function.validateTypes(string2, nArray, expressionArray);
                    }
                    if (constructor != null) {
                        expression = (Expression)constructor.newInstance(expressionArray);
                    }
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                throw new SQLException(UnityDriver.i18n.getString("LQExprNode.ImproperValidateTypesMethod") + this.toString());
            }
            catch (IllegalAccessException illegalAccessException) {
                throw new SQLException(UnityDriver.i18n.getString("LQExprNode.IllegalFunctionAccess") + this.toString());
            }
            catch (InvocationTargetException invocationTargetException) {
                throw new SQLException(UnityDriver.i18n.getString("LQExprNode.ConstructorException") + this.toString() + "Exception: " + invocationTargetException.getMessage() + ")");
            }
            catch (Exception exception) {
                throw new SQLException(UnityDriver.i18n.getString("LQExprNode.FunctionInitializeError") + this.toString());
            }
        }
        if (expression == null) {
            throw new SQLException(UnityDriver.i18n.getString("LQExprNode.UndefinedFunction") + this.toString());
        }
        attribute.setType(expression.getReturnType());
        attribute.setName("Expr" + globalQuery.getUniqueExprNum());
        if (this.type == 125 || this.type == 102 || this.type == 124) {
            attribute.setLength(5);
            attribute.setReference(this);
        }
        return expression;
    }

    public static String formatFunctionName(String string) {
        char[] cArray = string.toLowerCase().toCharArray();
        cArray[0] = Character.toUpperCase(cArray[0]);
        int n = string.indexOf(32);
        if (n > 0) {
            return new String(cArray, 0, n);
        }
        return new String(cArray);
    }

    public static Class findClass(String string) {
        Class<?> clazz = null;
        for (int i = 0; i < packages.length; ++i) {
            try {
                clazz = UnityDriver.classLoader.loadClass(packages[i] + string);
                return clazz;
            }
            catch (ClassNotFoundException classNotFoundException) {
                continue;
            }
        }
        return null;
    }

    public Attribute buildAttribute(GlobalQuery globalQuery) throws SQLException {
        int n = this.getType();
        Attribute attribute = new Attribute();
        if (n == 100) {
            GQFieldRef gQFieldRef = (GQFieldRef)this.getContent();
            if (gQFieldRef == null) {
                throw new SQLException(UnityDriver.i18n.getString("LQExprNode.UnableProcessField"));
            }
            AnnotatedSourceField annotatedSourceField = gQFieldRef.getField();
            attribute.setType(annotatedSourceField.getJavaDataType());
            attribute.setLength(annotatedSourceField.getByteSize());
            attribute.setName(annotatedSourceField.getColumnName());
            attribute.setReference(gQFieldRef);
        } else if (n == 103) {
            LQExprNode lQExprNode = (LQExprNode)this.getChild(0);
            attribute = lQExprNode.buildAttribute(globalQuery);
            attribute.setName(this.getChild((int)1).content.toString());
        } else if (n == 127 || n == 104 || n == 105 || n == 101) {
            if (n == 104) {
                attribute.setType(4);
            } else if (n == 105) {
                attribute.setType(8);
            } else {
                attribute.setType(12);
            }
            attribute.setLength(this.getContent().toString().length());
            if (this.reference == null) {
                String string = "Constant" + globalQuery.getUniqueExprNum();
                attribute.setName(string);
                GQFieldRef gQFieldRef = new GQFieldRef(null, string, null);
                attribute.setReference(gQFieldRef);
                this.setReference(gQFieldRef);
            } else {
                if (this.reference instanceof GQFieldRef) {
                    attribute.setName(((GQFieldRef)this.reference).getLocalName());
                } else {
                    attribute.setName(this.reference.toString());
                }
                attribute.setReference(this.reference);
            }
        } else if (n == 102) {
            if (this.reference == null || !(this.reference instanceof GlobalFunction)) {
                String string = "Function" + globalQuery.getUniqueExprNum();
                attribute.setName(string);
                GQFieldRef gQFieldRef = new GQFieldRef(null, string, null);
                attribute.setReference(gQFieldRef);
                attribute.setType(12);
                this.setReference(gQFieldRef);
            } else {
                String string = "Function" + globalQuery.getUniqueExprNum();
                attribute.setName(string);
                GQFieldRef gQFieldRef = new GQFieldRef(null, string, null);
                attribute.setReference(this.reference);
                GlobalFunction globalFunction = (GlobalFunction)this.reference;
                int n2 = globalFunction.getReturnType();
                if (n2 == 100) {
                    n2 = 8;
                } else if (n2 > 100 || n2 == 0 || n2 < -20) {
                    n2 = 12;
                }
                attribute.setType(n2);
                this.setReference(gQFieldRef);
            }
        } else if (n == 126 || n == 125) {
            String string = this.getContent().toString();
            if (n == 126) {
                int n3 = ((LQExprNode)this.getChild(0)).getOutputType();
                int n4 = ((LQExprNode)this.getChild(1)).getOutputType();
                if (n3 == 4 && n4 == 4) {
                    attribute.setType(4);
                    attribute.setLength(4);
                } else if (n3 == 12 || n4 == 12) {
                    attribute.setType(12);
                    attribute.setLength(50);
                } else if (n3 == 8 || n4 == 8 || n3 == 6 || n4 == 6) {
                    attribute.setType(8);
                    attribute.setLength(8);
                } else {
                    attribute.setType(12);
                    attribute.setLength(50);
                }
            } else if (string.equals("COUNT")) {
                attribute.setType(4);
                attribute.setLength(4);
            } else if (n == 125) {
                Attribute attribute2 = ((LQExprNode)this.getChild(0)).buildAttribute(globalQuery);
                attribute.setType(attribute2.getType());
                attribute.setLength(attribute2.getLength());
            } else {
                attribute.setType(12);
                attribute.setLength(10);
            }
            if (this.reference == null) {
                String string2 = "Expr" + globalQuery.getUniqueExprNum();
                attribute.setName(string2);
                GQFieldRef gQFieldRef = new GQFieldRef(null, string2, null);
                attribute.setReference(gQFieldRef);
                this.setReference(gQFieldRef);
            } else {
                attribute.setName(((GQFieldRef)this.reference).getLocalName());
                attribute.setReference(this.reference);
            }
        } else if (n == 129) {
            int n5 = this.getNumChildren();
            if (this.getNumChildren() != 3) {
                throw new SQLException(UnityDriver.i18n.getString("LQExprNode.ArgError") + n5 + UnityDriver.i18n.getString("For") + this.toString());
            }
            String string = this.getChild(2).getContent().toString();
            string = string.substring(1, string.length() - 1);
            attribute.setType(Attribute.getTypeBySQLName(string));
            if (this.reference == null || this.reference instanceof GQDatabaseRef) {
                String string3 = "Expr" + globalQuery.getUniqueExprNum();
                attribute.setName(string3);
                GQFieldRef gQFieldRef = new GQFieldRef(null, string3, null);
                attribute.setReference(gQFieldRef);
                this.setReference(gQFieldRef);
            } else {
                attribute.setName(((GQFieldRef)this.reference).getLocalName());
                attribute.setReference(this.reference);
            }
        } else if (n == 120) {
            LQExprNode lQExprNode = (LQExprNode)this.getContent();
            attribute = lQExprNode.buildAttribute(globalQuery);
        } else {
            attribute.setType(12);
            attribute.setLength(10);
            if (this.reference == null) {
                String string = "Expr" + globalQuery.getUniqueExprNum();
                attribute.setName(string);
                GQFieldRef gQFieldRef = new GQFieldRef(null, string, null);
                attribute.setReference(gQFieldRef);
                this.setReference(gQFieldRef);
            } else {
                attribute.setName(((GQFieldRef)this.reference).getLocalName());
                attribute.setReference(this.reference);
            }
        }
        return attribute;
    }

    @Override
    public ArrayList<Object> getRequiredFields() {
        ArrayList<Object> arrayList;
        block11: {
            block10: {
                arrayList = new ArrayList<Object>();
                if (this.getType() != 100) break block10;
                if (!(this.content instanceof GQFieldRef)) break block11;
                arrayList.add(this.content);
                break block11;
            }
            if (this instanceof LQCaseExpr) {
                arrayList.addAll(this.getRequiredFields());
            } else if (this.getType() == 126 || this.getType() == 125 || this.getType() == 102) {
                for (int i = 0; i < this.getNumChildren(); ++i) {
                    LQExprNode lQExprNode = (LQExprNode)this.getChild(i);
                    arrayList.addAll(lQExprNode.getRequiredFields());
                }
            } else if (this.getType() == 129) {
                for (int i = 0; i < this.getNumChildren(); ++i) {
                    LQExprNode lQExprNode = (LQExprNode)this.getChild(i);
                    arrayList.addAll(lQExprNode.getRequiredFields());
                }
                arrayList.add(new GQFieldRef(null, null, null));
            } else if (this.getType() != 17) {
                for (int i = 0; i < this.getNumChildren(); ++i) {
                    LQExprNode lQExprNode = (LQExprNode)this.getChild(i);
                    arrayList.addAll(lQExprNode.getRequiredFields());
                }
            }
        }
        return arrayList;
    }

    @Override
    public int numTuples() {
        if (this.type == 6) {
            GQTableRef gQTableRef = (GQTableRef)this.getContent();
            int n = gQTableRef.getTable().getNumTuples();
            if (n > 0) {
                return n;
            }
            return 1000;
        }
        return -5;
    }

    @Override
    public int tupleSize() {
        int n = 0;
        if (this.type == 6) {
            GQTableRef gQTableRef = (GQTableRef)this.getContent();
            ArrayList<GQFieldRef> arrayList = gQTableRef.getFieldRefs();
            for (int i = 0; i < arrayList.size(); ++i) {
                AnnotatedSourceField annotatedSourceField = arrayList.get(i).getField();
                n += annotatedSourceField.getByteSize();
            }
            return n;
        }
        return -6;
    }

    @Override
    public Object clone() {
        try {
            LQExprNode lQExprNode = (LQExprNode)super.clone();
            if (this.children != null && lQExprNode.getType() != 17) {
                lQExprNode.children = new ArrayList(this.children.size());
                for (int i = 0; i < this.children.size(); ++i) {
                    lQExprNode.children.add((LQNode)((LQNode)this.children.get(i)).clone());
                }
            } else {
                lQExprNode.children = null;
            }
            return lQExprNode;
        }
        catch (Exception exception) {
            System.out.println(UnityDriver.i18n.getString("CloneException") + exception);
            return null;
        }
    }

    @Override
    public HashSet<GQDatabaseRef> getDatabaseRefs(GQDatabaseRef gQDatabaseRef, boolean bl) {
        if (this.type == 6) {
            if (this.reference != null && this.reference instanceof GQDatabaseRef) {
                this.database = (GQDatabaseRef)this.reference;
            }
        } else if (this.type == 129) {
            LQExprNode lQExprNode = (LQExprNode)this.getChild(0);
            if (lQExprNode.reference != null && lQExprNode.reference instanceof GQDatabaseRef) {
                this.database = (GQDatabaseRef)lQExprNode.reference;
            }
        } else if (this.type == 100) {
            if (this.content instanceof GQFieldRef) {
                GQFieldRef gQFieldRef = (GQFieldRef)this.content;
                if (gQFieldRef.getTable() == null) {
                    this.database = gQDatabaseRef;
                } else {
                    GQDatabaseRef gQDatabaseRef2 = gQFieldRef.getTable().getParentDB();
                    if (gQDatabaseRef2 != null) {
                        this.database = gQDatabaseRef2;
                    }
                }
            }
        } else if (this.type == 102 || this.type == 125 || this.type == 126) {
            if (bl && this.type == 102) {
                this.database = GQDatabaseRef.UNITYJDBC_DBREF;
            } else {
                int n;
                if (this.database == null) {
                    this.database = gQDatabaseRef;
                }
                if ((n = DatabaseMapping.isSupported(this.content.toString(), this.database, this)) != 0 && n != 1) {
                    this.database = GQDatabaseRef.UNITYJDBC_DBREF;
                }
            }
        } else if (this.type == 120) {
            LQExprNode lQExprNode = (LQExprNode)this.getContent();
            lQExprNode.setDatabase(gQDatabaseRef, bl);
            this.database = gQDatabaseRef;
        } else {
            this.database = gQDatabaseRef;
        }
        HashSet<GQDatabaseRef> hashSet = new HashSet<GQDatabaseRef>(1);
        hashSet.add(this.database);
        return hashSet;
    }

    @Override
    public void computeCost() {
        long l = 1000L;
        long l2 = 1000L;
        if (this.type == 6 && this.content != null && this.content instanceof GQTableRef) {
            AnnotatedSourceTable annotatedSourceTable = ((GQTableRef)this.content).getTable();
            l = annotatedSourceTable.getNumTuples();
            l2 = annotatedSourceTable.getTupleSize();
        }
        this.cost = (double)(l * l2) * 0.4;
        this.rows = l;
    }
}

