/*
 * Decompiled with CFR 0.152.
 */
package unity.query;

import java.io.Serializable;
import java.util.ArrayList;
import unity.engine.Relation;
import unity.jdbc.UnityConnection;
import unity.operators.Operator;
import unity.query.GQDatabaseRef;
import unity.query.LQNode;
import unity.query.LQTree;
import unity.query.LocalQuery;
import unity.query.SubQuery;

public class GlobalQuery
implements Serializable {
    private static final long serialVersionUID = 3087997720388186192L;
    private LQTree logicalQueryTree;
    private Operator executionTreeRoot;
    private ArrayList<LocalQuery> localQueries;
    private ArrayList<SubQuery> subqueries = new ArrayList();
    private Relation outputRelation;
    private boolean localProcessing;
    private int exprCount = 0;
    private String queryString;
    private transient UnityConnection ucon;

    public void addSubQuery(SubQuery subQuery) {
        this.subqueries.add(subQuery);
    }

    public ArrayList<SubQuery> getSubQueries() {
        return this.subqueries;
    }

    public Relation getOutputRelation() {
        if (this.outputRelation == null) {
            this.outputRelation = this.logicalQueryTree.getRoot().getOutputRelation();
        }
        return this.outputRelation;
    }

    public ArrayList<GQDatabaseRef> getAllDBRefs() {
        ArrayList<GQDatabaseRef> arrayList = new ArrayList<GQDatabaseRef>();
        for (int i = 0; i < this.subqueries.size(); ++i) {
            arrayList.addAll(this.subqueries.get(i).getDBRefs().values());
        }
        return arrayList;
    }

    public GQDatabaseRef getDatabaseRef(String string) {
        for (int i = 0; i < this.subqueries.size(); ++i) {
            SubQuery subQuery = this.subqueries.get(i);
            GQDatabaseRef gQDatabaseRef = subQuery.getDBRef(string);
            if (gQDatabaseRef == null) continue;
            return gQDatabaseRef;
        }
        return null;
    }

    public void setLocalProcessing(boolean bl) {
        this.localProcessing = bl;
    }

    public boolean getLocalProcessing() {
        return this.localProcessing;
    }

    public int getUniqueExprNum() {
        return this.exprCount++;
    }

    public void setLogicalQueryTree(LQTree lQTree) {
        this.logicalQueryTree = lQTree;
    }

    public LQTree getLogicalQueryTree() {
        return this.logicalQueryTree;
    }

    public void setExecutionTree(Operator operator) {
        this.executionTreeRoot = operator;
    }

    public Operator getExecutionTree() {
        return this.executionTreeRoot;
    }

    public void setLocalQueries(ArrayList<LocalQuery> arrayList) {
        this.localQueries = arrayList;
    }

    public ArrayList<LocalQuery> getLocalQueries() {
        return this.localQueries;
    }

    public void addLocalQuery(LocalQuery localQuery) {
        this.localQueries.add(localQuery);
    }

    public ArrayList<LQNode> getLocalQueryRootNodes() {
        ArrayList<LQNode> arrayList = new ArrayList<LQNode>();
        for (int i = 0; i < this.subqueries.size(); ++i) {
            SubQuery subQuery = this.subqueries.get(i);
            ArrayList<LQNode> arrayList2 = subQuery.getLocalQueryNodes();
            if (arrayList2 == null) continue;
            arrayList.addAll(arrayList2);
        }
        return arrayList;
    }

    public void printTree() {
        LQTree.printTree(this.logicalQueryTree.getRoot(), 0);
    }

    public String getQueryString() {
        return this.queryString;
    }

    public void setQueryString(String string) {
        this.queryString = string;
    }

    public UnityConnection getConnection() {
        return this.ucon;
    }

    public void setConnection(UnityConnection unityConnection) {
        this.ucon = unityConnection;
    }
}

