/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.io.FileManager;
import unity.operators.HashBuffer;
import unity.operators.MemoryBuffer;
import unity.operators.Operator;
import unity.predicates.JoinPredicate;
import unity.query.LQNode;
import unity.util.HashFunc;

public class NestedLoopJoin
extends Operator {
    private static final long serialVersionUID = 1L;
    private JoinPredicate pred;
    private Tuple tupleLeft;
    private Tuple tupleRight;
    private MemoryBuffer bufferLeft;
    private HashBuffer hashLeft;
    private boolean isHashLeft;
    private long memorySizeInBytes;
    private long memoryUsedInBytes;
    private int bufferSize;
    private boolean onePass;
    private boolean firstPass;
    private BufferedOutputStream outFile;
    private String rightFileName;
    private BufferedInputStream inFile;
    private boolean isLeftOuterJoin;
    private boolean isRightOuterJoin;
    private Tuple nullRightTuple;
    private Tuple nullLeftTuple;
    private Relation left;
    private Relation right;
    private boolean emptyRight;
    private ArrayList<byte[]> matches;
    private int curLoc;
    private boolean doneLeftJoin;
    private int bufferCount;
    private boolean resetRight;
    private boolean joinDone;
    private ArrayList<BitSet> rightMatches;
    private static int BIT_SET_SIZE = 65536;
    private int tupleIndex;
    private boolean lastPass;
    private Tuple buildTuple;

    public NestedLoopJoin(Operator[] operatorArray, JoinPredicate joinPredicate, int n, LQNode lQNode) {
        this(operatorArray, joinPredicate, n, false, false, lQNode);
    }

    public NestedLoopJoin(Operator[] operatorArray, JoinPredicate joinPredicate, int n, boolean bl, boolean bl2) {
        this(operatorArray, joinPredicate, n, bl, bl2, null);
    }

    public NestedLoopJoin(Operator[] operatorArray, JoinPredicate joinPredicate, int n, boolean bl, boolean bl2, LQNode lQNode) {
        super(operatorArray, 0L);
        Object[] objectArray;
        this.pred = joinPredicate;
        this.queryNode = lQNode;
        this.memorySizeInBytes = n;
        this.bufferSize = 16000;
        this.isLeftOuterJoin = bl;
        this.isRightOuterJoin = bl2;
        this.doneLeftJoin = false;
        this.joinDone = false;
        this.lastPass = false;
        this.left = this.input[0].getOutputRelation();
        this.tupleLeft = new Tuple(this.left);
        this.buildTuple = new Tuple(this.left);
        this.right = this.input[1].getOutputRelation();
        this.tupleRight = new Tuple(this.right);
        Relation relation = new Relation(this.left);
        relation.mergeRelation(this.right);
        this.setOutputRelation(relation);
        if (bl) {
            objectArray = new Object[this.left.getNumAttributes()];
            Arrays.fill(objectArray, null);
            this.nullRightTuple = new Tuple(objectArray, this.right);
        }
        if (bl2) {
            objectArray = new Object[this.left.getNumAttributes()];
            Arrays.fill(objectArray, null);
            this.nullLeftTuple = new Tuple(objectArray, this.left);
        }
    }

    @Override
    public void init() throws SQLException {
        this.input[0].init();
        this.input[1].init();
        boolean bl = this.emptyRight = !this.input[1].next(this.tupleRight);
        if (!this.emptyRight) {
            if (this.pred != null) {
                this.isHashLeft = this.pred.isEquiJoin();
            }
            if (this.isHashLeft) {
                this.hashLeft = new HashBuffer(this.bufferSize, this.pred, this.left);
            } else {
                this.bufferLeft = new MemoryBuffer(this.bufferSize, this.left, this.pred);
            }
            this.onePass = this.fillLeftBuffer();
            this.matches = new ArrayList();
            this.getProbeMatches();
            if (this.onePass) {
                if (this.isRightOuterJoin && this.matches.size() == 0) {
                    this.matches.add(this.nullLeftTuple.getBytes());
                }
            } else {
                this.rightFileName = FileManager.createTempFileName("nlj_rightfile");
                if (this.isRightOuterJoin) {
                    this.rightMatches = new ArrayList(1);
                    BitSet bitSet = new BitSet(BIT_SET_SIZE);
                    this.rightMatches.add(bitSet);
                }
                try {
                    this.outFile = FileManager.openOutputFile(this.rightFileName);
                }
                catch (IOException iOException) {
                    throw new SQLException(iOException);
                }
            }
            this.firstPass = true;
        }
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        if (this.joinDone) {
            return false;
        }
        if (!this.emptyRight) {
            while (true) {
                if (this.curLoc < this.matches.size()) {
                    this.buildTuple.setBytes(this.matches.get(this.curLoc++));
                    tuple.mergeTuple(this.buildTuple, this.tupleRight, this.getOutputRelation(), true);
                    this.incrementRowsOut();
                    return true;
                }
                if (this.onePass) {
                    if (this.input[1].next(this.tupleRight)) {
                        this.getProbeMatches();
                        if (!this.isRightOuterJoin || this.matches.size() != 0) continue;
                        this.matches.add(this.nullLeftTuple.getBytes());
                        continue;
                    }
                    if (!this.doneLeftJoin) {
                        if (this.isLeftOuterJoin) {
                            this.tupleRight = this.nullRightTuple;
                            this.matches.clear();
                            if (this.isHashLeft) {
                                this.hashLeft.getNonMatched(this.matches);
                            } else {
                                this.bufferLeft.getNonMatched(this.matches);
                            }
                            this.curLoc = 0;
                        }
                        this.doneLeftJoin = true;
                        continue;
                    }
                    this.joinDone = true;
                    return false;
                }
                if (this.resetRight) {
                    if (this.isLeftOuterJoin && !this.doneLeftJoin) {
                        this.doneLeftJoin = true;
                        this.matches.clear();
                        if (this.isHashLeft) {
                            this.hashLeft.getNonMatched(this.matches);
                        } else {
                            this.bufferLeft.getNonMatched(this.matches);
                        }
                        if (this.matches.size() > 0) {
                            this.curLoc = 0;
                            this.tupleRight = this.nullRightTuple;
                            continue;
                        }
                    }
                    this.resetRight = false;
                    this.doneLeftJoin = false;
                    try {
                        this.inFile = FileManager.openInputFile(this.rightFileName);
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException);
                    }
                    boolean bl = this.fillLeftBuffer();
                    this.tupleRight = new Tuple(this.right);
                    this.tupleIndex = 0;
                    if (this.bufferCount == 0) {
                        if (this.isRightOuterJoin && !this.lastPass) {
                            this.lastPass = true;
                            continue;
                        }
                        this.joinDone = true;
                        return false;
                    }
                    this.lastPass = bl;
                }
                if (this.firstPass) {
                    this.tupleRight.write(this.outFile);
                    this.incrementIOBytes(this.tupleRight.getSize());
                    if (this.input[1].next(this.tupleRight)) {
                        this.getProbeMatches();
                        ++this.tupleIndex;
                        if (!this.isRightOuterJoin || this.matches.size() <= 0) continue;
                        this.setRightMatchFlag(this.tupleIndex);
                        continue;
                    }
                    this.input[1].close();
                    try {
                        FileManager.closeFile(this.outFile);
                    }
                    catch (IOException iOException) {
                        throw new SQLException(iOException);
                    }
                    this.resetRight = true;
                    this.firstPass = false;
                    continue;
                }
                if (this.tupleRight.read(this.inFile)) {
                    this.getProbeMatches();
                    this.incrementIOBytes(this.tupleRight.getSize());
                    if (this.isRightOuterJoin) {
                        if (this.matches.size() > 0) {
                            this.setRightMatchFlag(this.tupleIndex);
                        } else if (this.lastPass && !this.getRightMatchFlag(this.tupleIndex)) {
                            this.matches.add(this.nullLeftTuple.getBytes());
                        }
                    }
                    ++this.tupleIndex;
                    continue;
                }
                try {
                    FileManager.closeFile(this.inFile);
                }
                catch (IOException iOException) {
                    throw new SQLException(iOException);
                }
                this.resetRight = true;
            }
        }
        if (!this.isLeftOuterJoin) {
            return false;
        }
        if (this.input[0].next(this.tupleLeft)) {
            tuple.mergeTuple(this.tupleLeft, this.nullRightTuple, this.getOutputRelation(), true);
            this.incrementRowsOut();
            return true;
        }
        return false;
    }

    @Override
    public void close() throws SQLException {
        super.close();
        if (this.isHashLeft) {
            this.hashLeft.clear();
        } else {
            this.bufferLeft.clear();
        }
    }

    private BitSet getRightMatchBitSet(int n) {
        BitSet bitSet;
        int n2 = HashFunc.getHighBitValue(n, 16, BIT_SET_SIZE);
        if (n2 >= this.rightMatches.size()) {
            bitSet = new BitSet(BIT_SET_SIZE);
            this.rightMatches.add(bitSet);
        } else {
            bitSet = this.rightMatches.get(n2);
        }
        return bitSet;
    }

    private void setRightMatchFlag(int n) {
        BitSet bitSet = this.getRightMatchBitSet(n);
        bitSet.set(HashFunc.getBucket(n, BIT_SET_SIZE));
    }

    private boolean getRightMatchFlag(int n) {
        BitSet bitSet = this.getRightMatchBitSet(n);
        return bitSet.get(HashFunc.getBucket(n, BIT_SET_SIZE));
    }

    private void getProbeMatches() throws SQLException {
        if (this.isHashLeft) {
            int n = this.pred.getHashKeyInput2(this.tupleRight);
            this.hashLeft.find(n, this.tupleRight, this.matches);
        } else {
            this.bufferLeft.find(this.tupleRight, this.matches);
        }
        this.curLoc = 0;
    }

    private boolean fillLeftBuffer() throws SQLException {
        boolean bl = false;
        this.bufferCount = 0;
        this.memoryUsedInBytes = 0L;
        if (this.isHashLeft) {
            this.hashLeft.clear();
        } else {
            this.bufferLeft.clear();
        }
        do {
            boolean bl2 = bl = !this.input[0].next(this.tupleLeft);
            if (bl) break;
            int n = this.pred.getHashKeyInput1(this.tupleLeft);
            byte[] byArray = new byte[this.tupleLeft.getBytes().length];
            System.arraycopy(this.tupleLeft.getBytes(), 0, byArray, 0, byArray.length);
            this.memoryUsedInBytes += (long)byArray.length;
            ++this.bufferCount;
            if (this.isHashLeft) {
                this.hashLeft.insert(n, byArray);
                continue;
            }
            this.bufferLeft.insert(byArray);
        } while (this.memoryUsedInBytes < this.memorySizeInBytes);
        return bl;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(250);
        stringBuilder.append("NESTED LOOP JOIN: ");
        if (this.pred != null) {
            stringBuilder.append(this.pred.toString(this.input[0].getOutputRelation(), this.input[1].getOutputRelation()));
        } else {
            stringBuilder.append("CROSS-PRODUCT");
        }
        stringBuilder.append("   (BufferSizeInBytes=" + this.memorySizeInBytes + ")");
        return stringBuilder.toString();
    }

    @Override
    public String getName() {
        return "NESTED LOOP JOIN";
    }

    @Override
    public String getDescription() {
        return this.toString();
    }

    @Override
    public double getCost() {
        long l = this.input[0].getRows();
        long l2 = this.input[1].getRows();
        int n = this.input[0].getRowSize();
        double d = 0.0;
        if (l * (long)n <= this.memorySizeInBytes) {
            d += (double)(l * l2) * 1.0;
        } else {
            d += (double)(l * l2) * 1.0;
            d += this.getIO() * 0.005;
        }
        return d;
    }

    @Override
    public double getIO() {
        long l = this.input[0].getRows();
        long l2 = this.input[1].getRows();
        int n = this.input[0].getRowSize();
        int n2 = this.input[1].getRowSize();
        if (l * (long)n < this.MEMORY_SIZE_IN_BYTES) {
            return 0.0;
        }
        return (1.0 + 1.0 * (double)l * (double)n / (double)this.memorySizeInBytes) * (double)(l2 * (long)n2) + (double)n;
    }
}

