/*
 * Decompiled with CFR 0.152.
 */
package unity.operators;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import unity.engine.Attribute;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.operators.Operator;
import unity.operators.ResultSetScan;
import unity.predicates.JoinPredicate;
import unity.query.GlobalQuery;
import unity.query.LQCondNode;
import unity.query.LQExprNode;
import unity.query.LQNode;
import unity.query.LQSelNode;
import unity.query.LocalQuery;
import unity.query.Optimizer;
import unity.util.StringFunc;

public class DistributedJoin
extends Operator {
    private static final long serialVersionUID = 1L;
    protected HashMap<String, ArrayList<Tuple>> buffer;
    protected JoinPredicate pred;
    protected boolean swap;
    protected Relation firstRelation;
    protected Relation secondRelation;
    protected GlobalQuery gq;
    protected int[] firstRelationJoinAttrs;
    protected int[] secondRelationJoinAttrs;
    protected ResultSetScan rs;
    private int currentLoc;
    private Tuple currentTuple;
    private ArrayList<Tuple> currentSmallTuples;
    private boolean hasResults;

    public DistributedJoin(Operator[] operatorArray, JoinPredicate joinPredicate, boolean bl, GlobalQuery globalQuery) {
        super(operatorArray, 0L);
        this.pred = joinPredicate;
        this.swap = bl;
        this.gq = globalQuery;
        Relation relation = this.input[0].getOutputRelation();
        Relation relation2 = this.input[1].getOutputRelation();
        Relation relation3 = new Relation(relation);
        relation3.mergeRelation(relation2);
        this.setOutputRelation(relation3);
        this.firstRelation = relation;
        this.secondRelation = relation2;
        if (bl) {
            Operator operator = this.input[0];
            this.input[0] = this.input[1];
            this.input[1] = operator;
            this.pred = this.pred.inversePredicate();
            this.firstRelation = relation2;
            this.secondRelation = relation;
        }
        this.firstRelationJoinAttrs = JoinPredicate.getAttributeLocs(this.pred, 1);
        this.secondRelationJoinAttrs = JoinPredicate.getAttributeLocs(this.pred, 2);
    }

    @Override
    public void init() throws SQLException {
        this.input[0].init();
        String string = this.buildValueString();
        if (this.buffer.size() == 0) {
            this.currentTuple = null;
            this.hasResults = false;
            return;
        }
        this.hasResults = true;
        Attribute attribute = this.secondRelation.getAttribute(this.secondRelationJoinAttrs[0]);
        ResultSetScan resultSetScan = (ResultSetScan)this.input[1];
        LocalQuery localQuery = resultSetScan.getQuery();
        LQNode lQNode = resultSetScan.getQueryNode();
        LQCondNode lQCondNode = new LQCondNode();
        lQCondNode.setType(114);
        lQCondNode.setContent("IN");
        LQExprNode lQExprNode = new LQExprNode();
        lQExprNode.setType(100);
        lQExprNode.setContent(attribute.getName());
        LQExprNode lQExprNode2 = new LQExprNode();
        lQExprNode2.setContent(string);
        lQExprNode2.setType(101);
        lQCondNode.addChild(lQExprNode);
        lQExprNode.setParent(lQCondNode);
        lQCondNode.addChild(lQExprNode2);
        lQExprNode2.setParent(lQCondNode);
        LQSelNode lQSelNode = new LQSelNode();
        lQSelNode.setCondition(lQCondNode);
        LQNode lQNode2 = lQNode.getChild();
        lQSelNode.addChild(lQNode2);
        lQNode2.setParent(lQSelNode);
        lQNode.setChild(0, lQSelNode);
        lQSelNode.setParent(lQNode);
        localQuery.setSQLQueryString(Optimizer.buildSQL(lQNode));
        resultSetScan.setDelayedExecution(false);
        try {
            localQuery.execute(this.gq.getConnection());
        }
        catch (Exception exception) {
            exception.printStackTrace();
            throw new SQLException("Error executing distributed query. Exception: " + exception);
        }
        this.rs = new ResultSetScan(localQuery.getResultSet());
        this.rs.init();
        this.currentLoc = 0;
        this.currentTuple = new Tuple(this.secondRelation);
    }

    @Override
    public boolean next(Tuple tuple) throws SQLException {
        while (this.hasResults) {
            Object object;
            if (this.currentSmallTuples == null || this.currentLoc >= this.currentSmallTuples.size()) {
                if (!this.rs.next(this.currentTuple)) {
                    this.hasResults = false;
                    return false;
                }
                object = this.currentTuple.getObject(this.secondRelationJoinAttrs[0]);
                this.currentSmallTuples = this.buffer.get(object.toString());
                this.currentLoc = 0;
                continue;
            }
            object = this.currentSmallTuples.get(this.currentLoc++);
            if (this.swap) {
                if (!this.pred.isEqual(this.currentTuple, (Tuple)object)) continue;
                tuple.mergeTuple(this.currentTuple, (Tuple)object, this.outputRelation, true);
                return true;
            }
            if (!this.pred.isEqual((Tuple)object, this.currentTuple)) continue;
            tuple.mergeTuple((Tuple)object, this.currentTuple, this.outputRelation, true);
            return true;
        }
        return this.hasResults;
    }

    protected String buildValueString() throws SQLException {
        this.buffer = new HashMap();
        Tuple tuple = new Tuple(this.firstRelation);
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        boolean bl = true;
        while (this.input[0].next(tuple)) {
            Object object = tuple.getObject(this.firstRelationJoinAttrs[0]);
            ArrayList<Tuple> arrayList = this.buffer.get(object.toString());
            if (arrayList == null) {
                arrayList = new ArrayList(1);
                if (!bl) {
                    stringBuilder.append(", ");
                }
                stringBuilder.append(StringFunc.formatSQLValue(object));
                bl = false;
            }
            Tuple tuple2 = new Tuple();
            tuple2.copy(tuple);
            arrayList.add(tuple2);
            this.buffer.put(object.toString(), arrayList);
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(250);
        stringBuffer.append("DISTRIBUTED JOIN: ");
        if (this.swap) {
            stringBuffer.append(this.pred.toString(this.secondRelation, this.firstRelation));
        } else {
            stringBuffer.append(this.pred.toString(this.firstRelation, this.secondRelation));
        }
        return stringBuffer.toString();
    }

    @Override
    public String getName() {
        return "DISTRIBUTED JOIN";
    }

    @Override
    public String getDescription() {
        return "";
    }
}

