/*
 * Decompiled with CFR 0.152.
 */
package unity.functions;

import java.sql.SQLException;
import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import unity.engine.Relation;
import unity.engine.Tuple;
import unity.functions.Expression;

public class F_Datediff
extends Expression {
    private static final long serialVersionUID = 1L;
    private Expression datepart;
    private Expression startdate;
    private Expression enddate;

    public F_Datediff(Expression expression, Expression expression2, Expression expression3) {
        this.datepart = expression;
        this.startdate = expression2;
        this.enddate = expression3;
    }

    @Override
    public Object evaluate(Tuple tuple) throws SQLException {
        Object object = this.startdate.evaluate(tuple);
        if (object == null) {
            return null;
        }
        Object object2 = this.enddate.evaluate(tuple);
        if (object2 == null) {
            return object;
        }
        Object object3 = this.datepart.evaluate(tuple);
        if (object3 == null) {
            return object;
        }
        GregorianCalendar gregorianCalendar = new GregorianCalendar();
        gregorianCalendar.setTime((Date)object);
        GregorianCalendar gregorianCalendar2 = new GregorianCalendar();
        gregorianCalendar2.setTime((Date)object2);
        long l = gregorianCalendar2.getTimeInMillis() + (long)((Calendar)gregorianCalendar2).getTimeZone().getOffset(gregorianCalendar2.getTimeInMillis());
        long l2 = gregorianCalendar.getTimeInMillis() + (long)((Calendar)gregorianCalendar).getTimeZone().getOffset(gregorianCalendar.getTimeInMillis());
        long l3 = l - l2;
        String string = object3.toString();
        if (string.equals("year") || string.equals("yy")) {
            return gregorianCalendar2.get(1) - gregorianCalendar.get(1);
        }
        if (string.equals("quarter") || string.equals("qq")) {
            int n = gregorianCalendar2.get(1) - gregorianCalendar.get(1);
            int n2 = gregorianCalendar2.get(2) - gregorianCalendar.get(1);
            return n * 4 + n2 / 4;
        }
        if (string.equals("month") || string.equals("mm")) {
            int n = gregorianCalendar2.get(1) - gregorianCalendar.get(1);
            int n3 = gregorianCalendar2.get(2) - gregorianCalendar.get(1);
            return n * 12 + n3;
        }
        if (string.equals("dayofyear") || string.equals("dy") || string.equals("day") || string.equals("dd") || string.equals("dayofweek") || string.equals("dw")) {
            return l3 / 86400000L;
        }
        if (string.equals("week") || string.equals("ww")) {
            return l3 / 604800000L;
        }
        if (string.equals("hour") || string.equals("hh")) {
            return l3 / 3600000L;
        }
        if (string.equals("minute") || string.equals("mm")) {
            return l3 / 60000L;
        }
        if (string.equals("second") || string.equals("ss")) {
            return l3 / 1000L;
        }
        if (string.equals("millisecond") || string.equals("ms")) {
            return l3;
        }
        return null;
    }

    @Override
    public int getReturnType() {
        return 4;
    }

    public static int[] getParamListTypes() {
        return new int[]{12, 91, 91};
    }

    public static String getFunctionName() {
        return "DATEDIFF";
    }

    @Override
    public String toString(Relation relation) {
        return "DATEDIFF(" + this.datepart.toString(relation) + ", " + this.startdate.toString(relation) + ", " + this.enddate.toString(relation) + ")";
    }
}

