/*
 * Decompiled with CFR 0.152.
 */
package unity.engine;

import java.io.BufferedOutputStream;
import java.io.IOException;
import java.sql.SQLException;
import unity.engine.Relation;
import unity.engine.Tuple;

public class Page {
    private byte[][] tuples;
    private int maxTuples;
    private int curTuples;

    public Page(int n, Relation relation) {
        this.maxTuples = n;
        this.curTuples = 0;
        this.tuples = new byte[n][];
    }

    public int addTuple(int n, Tuple tuple) throws SQLException {
        if (this.curTuples == this.maxTuples) {
            return -1;
        }
        this.tuples[this.curTuples] = tuple.getBytes();
        return this.tuples[this.curTuples++].length;
    }

    public boolean hasSpace() {
        return this.curTuples < this.maxTuples;
    }

    public int write(BufferedOutputStream bufferedOutputStream) throws SQLException {
        try {
            int n = 0;
            for (int i = 0; i < this.curTuples; ++i) {
                n += this.tuples[i].length;
                bufferedOutputStream.write(this.tuples[i]);
            }
            return n;
        }
        catch (IOException iOException) {
            throw new SQLException(iOException);
        }
    }

    public byte[] getTuple(int n) {
        return this.tuples[n];
    }

    public int getCount() {
        return this.curTuples;
    }
}

