/*
 * Decompiled with CFR 0.152.
 */
package snow.jdbc;

import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.ResourceBundle;
import snow.conn.ServerConnection;
import snow.jdbc.SNowDatabaseMetaData;
import snow.jdbc.SNowPreparedStatement;
import snow.jdbc.SNowStatement;
import unity.generic.jdbc.ConnectionImpl;
import unity.jdbc.UnityDriver;

public class SNowConnection
extends ConnectionImpl {
    public SNowConnection(String string, Properties properties) throws SQLException {
        this.url = string;
        this.clientInfo = properties;
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        if (UnityDriver.DEBUG) {
            System.out.println("Database to connect to:.  URL:  " + string);
        }
        this.connection = new ServerConnection(this.url, this);
        this.connection.connect(this.clientInfo);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n == 1005) {
            throw new SQLException(resources.getString("nosupportScrollSensitive"));
        }
        if (n2 == 1008) {
            throw new SQLException(resources.getString("nosupportConcurUpdatable"));
        }
        if (this.currentStatement != null) {
            this.currentStatement.close();
        }
        this.currentStatement = new SNowStatement(this, this.connection, n, n2);
        return this.currentStatement;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new SNowDatabaseMetaData(this, this.connection);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return new SNowPreparedStatement(this, this.connection, n, n2, string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return new SNowPreparedStatement(this, this.connection, n, n2, string);
    }

    static {
        resources = ResourceBundle.getBundle("resources/snow/SNowConnection", locale);
    }
}

