/*
 * Decompiled with CFR 0.152.
 */
package mongodb.jdbc;

import java.sql.Array;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Properties;
import java.util.ResourceBundle;
import mongodb.conn.ServerConnection;
import mongodb.jdbc.MongoArray;
import mongodb.jdbc.MongoDatabaseMetaData;
import mongodb.jdbc.MongoPreparedStatement;
import mongodb.jdbc.MongoStatement;
import unity.engine.Attribute;
import unity.generic.jdbc.ConnectionImpl;
import unity.jdbc.UnityDriver;

public class MongoConnection
extends ConnectionImpl {
    public MongoConnection(String string, String string2, int n, String string3, Properties properties) throws SQLException {
        this.url = string;
        this.clientInfo = properties;
        if (this.clientInfo == null) {
            this.clientInfo = new Properties();
        }
        String string4 = string3;
        if (this.clientInfo.containsKey("dbname")) {
            string4 = this.clientInfo.getProperty("dbname");
        }
        if (UnityDriver.DEBUG) {
            System.out.println("Database to connect to:.  URL:  " + string2 + " Port: " + n + " Database name: " + string3);
        }
        this.connection = new ServerConnection(string2, n, string4, this.url, this);
        this.connection.connect(this.clientInfo);
    }

    @Override
    public Statement createStatement(int n, int n2, int n3) throws SQLException {
        if (n == 1005) {
            throw new SQLException(resources.getString("nosupportScrollSensitive"));
        }
        if (n2 == 1008) {
            throw new SQLException(resources.getString("nosupportConcurUpdatable"));
        }
        if (this.currentStatement != null) {
            this.currentStatement.close();
        }
        this.currentStatement = new MongoStatement(this, this.connection, n, n2);
        return this.currentStatement;
    }

    @Override
    public DatabaseMetaData getMetaData() throws SQLException {
        return new MongoDatabaseMetaData(this, this.connection);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2) throws SQLException {
        return new MongoPreparedStatement(this, this.connection, n, n2, string);
    }

    @Override
    public PreparedStatement prepareStatement(String string, int n, int n2, int n3) throws SQLException {
        return new MongoPreparedStatement(this, this.connection, n, n2, string);
    }

    @Override
    public Array createArrayOf(String string, Object[] objectArray) throws SQLException {
        MongoArray mongoArray = null;
        mongoArray = Attribute.getType(string) == 2003 ? new MongoArray(objectArray) : (Attribute.getType(string) == -1 ? new MongoArray(objectArray) : (Attribute.getType(string) == 12 ? new MongoArray(objectArray) : new MongoArray(objectArray)));
        return mongoArray;
    }

    public void rebuildSchema() throws SQLException {
        ((ServerConnection)this.connection).buildSchema();
    }

    static {
        resources = ResourceBundle.getBundle("resources/mongo/MongoConnection", locale);
    }
}

