/*
 * Decompiled with CFR 0.152.
 */
package mongodb.conn;

import com.mongodb.BasicDBObject;
import com.mongodb.DB;
import com.mongodb.DBCollection;
import com.mongodb.DBCursor;
import com.mongodb.DBObject;
import com.mongodb.MongoClient;
import com.mongodb.ServerAddress;
import com.mongodb.WriteConcern;
import com.mongodb.WriteResult;
import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.UnknownHostException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import mongodb.conn.MongoExecutor;
import mongodb.jdbc.MongoStatement;
import mongodb.query.MongoBuilder;
import mongodb.query.MongoBuilderUpstreamException;
import mongodb.query.MongoQuery;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceDatabase;
import unity.annotation.SourceField;
import unity.annotation.SourceTable;
import unity.engine.Attribute;
import unity.engine.IServerConnection;
import unity.engine.Tuple;
import unity.io.FileManager;
import unity.jdbc.LocalResultSet;
import unity.jdbc.UnityConnection;
import unity.jdbc.UnityDriver;
import unity.jdbc.UnityStatement;
import unity.parser.GlobalParser;
import unity.query.GlobalQuery;
import unity.query.GlobalUpdate;
import unity.query.LQTree;
import unity.util.StringFunc;

public class ServerConnection
implements IServerConnection {
    private String url;
    private String serverName;
    private int port;
    private int fetchSize;
    private HashMap<Integer, MongoExecutor> executors;
    private int lastStatementId = 0;
    private String userName;
    private String password;
    private Properties properties;
    private MongoClient mongoClient;
    private DB db;
    private String databaseName;
    private UnityConnection uconn;
    private SourceDatabase database;
    private GlobalSchema schema;
    private String validation;
    private String schemaLocation;
    private Connection connection;

    public ServerConnection(String string, int n, String string2, String string3, Connection connection) {
        this.serverName = string;
        this.url = string3;
        this.port = n;
        this.databaseName = string2;
        this.uconn = null;
        this.connection = connection;
        this.executors = new HashMap();
    }

    @Override
    public void connect(Properties properties) throws SQLException {
        try {
            this.properties = properties;
            try {
                this.mongoClient = new MongoClient(this.serverName + ":" + this.port);
            }
            catch (UnknownHostException unknownHostException) {
                throw new SQLException(unknownHostException);
            }
            this.db = this.mongoClient.getDB(this.databaseName);
            this.db.setWriteConcern(WriteConcern.ACKNOWLEDGED);
            this.userName = properties.getProperty("user");
            this.password = properties.getProperty("password");
            if (this.userName != null && this.password != null) {
                if (UnityDriver.DEBUG) {
                    System.out.println("Using MongoDB authentication: userName: " + this.userName + " password: " + this.password);
                }
                this.db.authenticate(this.userName, this.password.toCharArray());
            }
            Object object = this.properties.get("rebuildschema");
            this.schemaLocation = (String)this.properties.get("schema");
            boolean bl = false;
            if (object != null && object.toString().equalsIgnoreCase("true")) {
                this.buildSchema();
                this.saveSchema(this.schemaLocation);
                bl = true;
            }
            Object object2 = this.properties.get("validation");
            this.validation = (String)object2;
            if (object2 != null && !bl) {
                if (object2.toString().equalsIgnoreCase("strict")) {
                    if (!this.loadSchema(this.schemaLocation)) {
                        this.buildSchema();
                        this.saveSchema(this.schemaLocation);
                    }
                } else if (object2.toString().equalsIgnoreCase("flex")) {
                    this.loadSchema(this.schemaLocation);
                }
            }
        }
        catch (SQLException sQLException) {
            throw new SQLException(sQLException);
        }
    }

    public void saveSchema(String string) throws SQLException {
        if (string.contains("mongo:")) {
            HashMap<String, String> hashMap = this.parseMongoLocation(string);
            String string2 = hashMap.get("url");
            String string3 = hashMap.get("dbname");
            String string4 = hashMap.get("collection");
            MongoClient mongoClient = null;
            try {
                mongoClient = new MongoClient(string2);
            }
            catch (UnknownHostException unknownHostException) {
                throw new SQLException("Error while saving schema: " + unknownHostException);
            }
            DB dB = mongoClient.getDB(string3);
            if (this.userName != null && this.password != null) {
                dB.authenticate(this.userName, this.password.toCharArray());
            }
            DBCollection dBCollection = dB.getCollection(string4);
            BasicDBObject basicDBObject = new BasicDBObject();
            BasicDBObject basicDBObject2 = new BasicDBObject();
            basicDBObject2.append("schema", (Object)this.database.exportXML());
            dBCollection.update((DBObject)basicDBObject, (DBObject)basicDBObject2, true, false);
        } else {
            try {
                File file = new File(string);
                this.database.exportXML(file);
            }
            catch (IOException iOException) {
                throw new SQLException("Error while saving schema to file: " + iOException);
            }
        }
    }

    private HashMap<String, String> parseMongoLocation(String string) throws SQLException {
        HashMap<String, String> hashMap = new HashMap<String, String>();
        String string2 = string;
        int n = (string2 = string2.substring(6)).indexOf("/");
        if (n < 0) {
            throw new SQLException("Invalid Mongo URL (bad URL): " + string);
        }
        String string3 = string2.substring(0, n);
        hashMap.put("url", string3);
        string2 = string2.substring(n + 1);
        n = string2.indexOf("/");
        if (n < 0) {
            throw new SQLException("Invalid Mongo URL (expecting database name): " + string);
        }
        String string4 = string2.substring(0, n);
        hashMap.put("dbname", string4);
        string2 = string2.substring(n + 1);
        hashMap.put("collection", string2);
        return hashMap;
    }

    public boolean loadSchema(String string) throws SQLException {
        if (string.contains("mongo:")) {
            DBCollection dBCollection;
            DBCursor dBCursor;
            HashMap<String, String> hashMap = this.parseMongoLocation(string);
            String string2 = hashMap.get("url");
            String string3 = hashMap.get("dbname");
            String string4 = hashMap.get("collection");
            MongoClient mongoClient = null;
            try {
                mongoClient = new MongoClient(new ServerAddress(string2));
            }
            catch (UnknownHostException unknownHostException) {
                throw new SQLException("Error while saving schema: " + unknownHostException);
            }
            this.db = mongoClient.getDB(string3);
            if (this.userName != null && this.password != null) {
                this.db.authenticate(this.userName, this.password.toCharArray());
            }
            if (!(dBCursor = (dBCollection = this.db.getCollection(string4)).find()).hasNext()) {
                return false;
            }
            DBObject dBObject = dBCursor.next();
            String string5 = (String)dBObject.get("schema");
            if (this.schema == null) {
                this.schema = new GlobalSchema();
            }
            this.database = this.schema.importSchema(new ByteArrayInputStream(string5.getBytes()));
            this.schema.addDatabase(this.database);
            return true;
        }
        try {
            BufferedInputStream bufferedInputStream = FileManager.openInputFile(string);
            this.database = this.schema.importSchema(bufferedInputStream);
            this.schema.addDatabase(this.database);
            return true;
        }
        catch (Exception exception) {
            return false;
        }
    }

    public ResultSet getMoreResults(int n, MongoStatement mongoStatement) throws SQLException {
        try {
            return null;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    private ResultSet processMongoWithUnity(String string, GlobalSchema globalSchema) throws SQLException {
        Serializable serializable;
        if (UnityDriver.DEBUG) {
            System.out.println("Processing query in UnityJDBC not handled by MongoDB.");
        }
        if (this.uconn == null) {
            try {
                Class.forName("unity.jdbc.UnityDriver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new SQLException(classNotFoundException);
            }
            serializable = new Properties();
            this.uconn = (UnityConnection)DriverManager.getConnection("jdbc:unity://virtual", (Properties)serializable);
        }
        this.uconn.setGlobalSchema(globalSchema);
        serializable = globalSchema.getDB(this.databaseName);
        ((SourceDatabase)serializable).setProperty("usecatalog", "false");
        this.uconn.setConnection(this.databaseName, this.connection);
        UnityStatement unityStatement = (UnityStatement)this.uconn.createStatement();
        GlobalQuery globalQuery = unityStatement.parseQuery(string, true);
        return unityStatement.executeQuery(globalQuery);
    }

    public ResultSet executeQuery(String string, int n, MongoStatement mongoStatement) throws SQLException {
        try {
            if (string.trim().equals("SELECT 1")) {
                ArrayList<ArrayList<Object>> arrayList = new ArrayList<ArrayList<Object>>();
                ArrayList<Integer> arrayList2 = new ArrayList<Integer>(1);
                arrayList2.add(1);
                arrayList.add(arrayList2);
                ArrayList<SourceField> arrayList3 = new ArrayList<SourceField>(1);
                arrayList3.add(new SourceField(null, null, null, "Field1", 4, "INT", 4, 0, 0, 0, "", null, 0, 1, "YES"));
                return new LocalResultSet(arrayList, new String[]{"Field1"}, arrayList3);
            }
            MongoExecutor mongoExecutor = new MongoExecutor(this.db, ++this.lastStatementId);
            this.executors.put(this.lastStatementId, mongoExecutor);
            try {
                return mongoExecutor.execute(string, n, mongoStatement, this.schema, this);
            }
            catch (MongoBuilderUpstreamException mongoBuilderUpstreamException) {
                return this.processMongoWithUnity(string, this.schema);
            }
            catch (SQLException sQLException) {
                return this.processMongoWithUnity(string, this.schema);
            }
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    public int executeUpdate(String string, MongoStatement mongoStatement) throws SQLException {
        try {
            GlobalParser globalParser = new GlobalParser(false, false);
            GlobalUpdate globalUpdate = globalParser.parseUpdate(string, this.schema);
            globalUpdate.setStatement(string);
            LQTree lQTree = globalUpdate.getPlan().getLogicalQueryTree();
            MongoBuilder mongoBuilder = new MongoBuilder(lQTree.getRoot(), this.schema);
            MongoQuery mongoQuery = mongoBuilder.toMongoQuery();
            mongoStatement.setQuery(mongoQuery);
            Object object = mongoQuery.run(this.db);
            if (object instanceof WriteResult) {
                return ((WriteResult)object).getN();
            }
            if (object instanceof Integer) {
                return (Integer)object;
            }
            return 0;
        }
        catch (Exception exception) {
            if (exception.getLocalizedMessage().contains("Invalid reference: current_time") || exception.getLocalizedMessage().contains("Invalid reference: current_timestamp") || exception.getLocalizedMessage().contains("Invalid reference: current_date")) {
                throw new SQLException("java.lang.Throwable: JDBC for MongoDB Driver: Mongo JDBC Driver only supports INSERT with constant values (no expressions or functions)");
            }
            if (exception.getLocalizedMessage().contains("Delete only supports subqueries of the form: attr [not] in (subquery)")) {
                throw new SQLException("java.lang.Throwable: JDBC for MongoDB Driver: FUNCTION in projections is not supported.");
            }
            throw new SQLException(exception.getLocalizedMessage());
        }
    }

    @Override
    public boolean next(int n, Tuple tuple) throws SQLException {
        MongoExecutor mongoExecutor = this.executors.get(n);
        if (mongoExecutor == null) {
            return false;
        }
        return mongoExecutor.next(tuple);
    }

    @Override
    public boolean get(int n, int n2, Tuple tuple) throws SQLException {
        try {
            return false;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public int getLast(int n) throws SQLException {
        try {
            return 0;
        }
        catch (Exception exception) {
            throw new SQLException(exception);
        }
    }

    @Override
    public void setFetchSize(int n, int n2) {
        this.fetchSize = n;
    }

    @Override
    public void close() throws SQLException {
    }

    @Override
    public String getUserName() {
        return this.userName;
    }

    @Override
    public SourceDatabase getDatabase() {
        if (this.database == null) {
            this.buildSchema();
        }
        return this.database;
    }

    public GlobalSchema getSchema() {
        if (this.database == null) {
            this.buildSchema();
        }
        return this.schema;
    }

    public void buildSchema() {
        this.database = this.buildSourceDatabase();
        this.schema = new GlobalSchema();
        this.schema.addDatabase(this.database);
        if (this.validation != null && this.validation.equalsIgnoreCase("flex")) {
            try {
                this.saveSchema(this.schemaLocation);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public SourceDatabase buildSourceDatabase() {
        String string = this.db.getName();
        if (StringFunc.delimitedIdentifier(string)) {
            string = StringFunc.delimitName(string, '\"');
        }
        AnnotatedSourceDatabase annotatedSourceDatabase = new AnnotatedSourceDatabase(string, string, "MongoDB", this.db.getMongo().getVersion(), "jdbc:mongo://" + this.serverName + "/" + this.databaseName, "mongodb.jdbc.MongoDriver", '\"');
        annotatedSourceDatabase.setJavaDriverClassName("mongodb.jdbc.MongoDriver");
        annotatedSourceDatabase.setDatabaseId(80020202);
        LinkedHashMap<String, SourceTable> linkedHashMap = new LinkedHashMap<String, SourceTable>();
        for (String string2 : this.db.getCollectionNames()) {
            DBCollection dBCollection = this.db.getCollection(string2);
            HashMap<String, SourceField> hashMap = this.getHashMapFromAttributes(MongoExecutor.getSchema(dBCollection), string2);
            String string3 = string2;
            if (StringFunc.delimitedIdentifier(string3)) {
                string3 = StringFunc.delimitName(string3, '\"');
            }
            AnnotatedSourceTable annotatedSourceTable = new AnnotatedSourceTable(string, null, string3, null, hashMap, null);
            annotatedSourceTable.setParentDatabase(annotatedSourceDatabase);
            annotatedSourceTable.setNumTuples((int)dBCollection.count());
            linkedHashMap.put(string2, annotatedSourceTable);
        }
        annotatedSourceDatabase.setSourceTables(linkedHashMap);
        return annotatedSourceDatabase;
    }

    private HashMap<String, SourceField> getHashMapFromAttributes(Attribute[] attributeArray, String string) {
        HashMap<String, SourceField> hashMap = new HashMap<String, SourceField>();
        int n = 1;
        if (attributeArray != null) {
            for (Attribute attribute : attributeArray) {
                if (attribute == null) {
                    System.out.println("Issue with a NULL attribute.");
                    continue;
                }
                AnnotatedSourceField annotatedSourceField = new AnnotatedSourceField();
                annotatedSourceField.setColumnName(attribute.getName());
                annotatedSourceField.setDataTypeName(Attribute.getTypeName(attribute.getType()));
                annotatedSourceField.setTableName(string);
                annotatedSourceField.setDataType(attribute.getType());
                annotatedSourceField.setOrdinalPosition(n++);
                annotatedSourceField.setColumnSize(0);
                annotatedSourceField.setCharacterOctetLength(25);
                hashMap.put(attribute.getName(), annotatedSourceField);
            }
        }
        return hashMap;
    }
}

