/*
 * Decompiled with CFR 0.152.
 */
package com.unityjdbc.sourcebuilder;

import com.unityjdbc.sourcebuilder.HelpFrame;
import com.unityjdbc.sourcebuilder.MyDataModel;
import com.unityjdbc.sourcebuilder.SourceFrame;
import com.unityjdbc.sourcebuilder.SourceGroupFrame;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTable;
import javax.swing.JTextArea;
import javax.swing.JTextPane;
import javax.swing.JTree;
import javax.swing.border.BevelBorder;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultStyledDocument;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import javax.swing.text.StyleContext;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.TreeNode;
import javax.swing.tree.TreePath;
import unity.annotation.AnnotatedSourceDatabase;
import unity.annotation.AnnotatedSourceField;
import unity.annotation.AnnotatedSourceTable;
import unity.annotation.GlobalSchema;
import unity.annotation.SourceDatabase;
import unity.annotation.SourceField;
import unity.annotation.SourceTable;
import unity.io.FileManager;
import unity.jdbc.UnityDriver;
import unity.util.StringFunc;

public class SourceBuilder
extends JFrame {
    private static final long serialVersionUID = 1L;
    private static int FrameWidth = 800;
    private static int FrameHeight = 600;
    private static String baseUnityURL = "jdbc:unity://";
    private ViewTree schemaTree;
    private DataTable dataTable;
    private JTextPane queryBox;
    private JTextPane messageBox;
    private JButton execButton;
    private JButton clearButton;
    private MyDataModel dataSource;
    private boolean queryExecuting;
    private QueryThread qt;
    private String urlUnity = "";
    private String sourceFileName = null;
    private static JScrollPane treeView;
    private JSplitPane splitPane;
    private JScrollPane dataView;
    private JPanel dataPanel;
    private SourceGroupFrame sgf;
    private SourceFrame sf;
    private Menu menu;
    private DefaultMutableTreeNode lastSelectedNode = null;
    private boolean canUpdate = true;
    private JScrollPane scrollPane;
    private JScrollPane scrollPane_1;
    private HelpFrame hf;
    private DefaultStyledDocument querydoc;
    private DefaultStyledDocument messagedoc;
    private String db_password;

    public static void main(String[] stringArray) throws IOException, NoSuchFieldException, IllegalArgumentException, IllegalAccessException {
        SourceBuilder sourceBuilder = new SourceBuilder("");
        sourceBuilder.setSize(FrameWidth, FrameHeight);
        sourceBuilder.setTitle(UnityDriver.i18n.getString("SourceBuilder.frameTitle"));
        sourceBuilder.setDefaultCloseOperation(3);
        sourceBuilder.setLocationRelativeTo(sourceBuilder.getRootPane());
        sourceBuilder.sgf = new SourceGroupFrame(sourceBuilder);
        sourceBuilder.sf = new SourceFrame(sourceBuilder);
        sourceBuilder.setExtendedState(6);
        sourceBuilder.setVisible(true);
        sourceBuilder.focusQueryBox();
    }

    public boolean isExecuting() {
        return this.queryExecuting;
    }

    public SourceBuilder(String string) throws IOException {
        this.setIconImage(Toolkit.getDefaultToolkit().getImage(SourceBuilder.class.getResource("/resources/unityIcon.png")));
        this.hf = new HelpFrame();
        this.setFont(new Font("Arial", 1, 12));
        this.addWindowListener(new WindowCloser());
        this.addMouseListener(new PopupListener());
        Container container = this.getContentPane();
        BorderFactory.createEtchedBorder(1);
        Font font = new Font("SansSerif", 0, 12);
        JPanel jPanel = new JPanel();
        GridBagLayout gridBagLayout = new GridBagLayout();
        gridBagLayout.columnWidths = new int[]{535, 0};
        gridBagLayout.rowHeights = new int[]{14, 100, 33, 14, 150, 0, 18, 0};
        gridBagLayout.columnWeights = new double[]{1.0, Double.MIN_VALUE};
        gridBagLayout.rowWeights = new double[]{0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 1.0, Double.MIN_VALUE};
        jPanel.setLayout(gridBagLayout);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        JLabel jLabel = new JLabel(UnityDriver.i18n.getString("SourceBuilder.queryButton"), 2);
        jLabel.setFont(new Font("Tahoma", 1, 13));
        jPanel.add((Component)jLabel, gridBagConstraints);
        this.scrollPane = new JScrollPane();
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 1;
        gridBagConstraints2.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints2.gridx = 0;
        gridBagConstraints2.gridy = 1;
        jPanel.add((Component)this.scrollPane, gridBagConstraints2);
        StyleContext styleContext = new StyleContext();
        this.querydoc = new DefaultStyledDocument(styleContext);
        this.queryBox = new JTextPane(this.querydoc);
        this.scrollPane.setViewportView(this.queryBox);
        this.queryBox.setBorder(new BevelBorder(1, null, null, null, null));
        this.queryBox.setFont(font);
        this.queryBox.setText("");
        this.queryBox.setCaretPosition(0);
        this.queryBox.addMouseListener(new PopupListener());
        this.clearButton = new JButton(UnityDriver.i18n.getString("SourceBuilder.clearButton"));
        this.clearButton.setFont(new Font("Tahoma", 1, 13));
        this.execButton = new JButton(UnityDriver.i18n.getString("SourceBuilder.executeButton"));
        this.execButton.setFont(new Font("Tahoma", 1, 13));
        this.execButton.setForeground(Color.green);
        this.execButton.addActionListener(new ButtonListener());
        this.clearButton.addActionListener(new ButtonListener());
        JPanel jPanel2 = new JPanel();
        jPanel2.add(this.execButton);
        jPanel2.add(this.clearButton);
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints3.gridx = 0;
        gridBagConstraints3.gridy = 2;
        jPanel.add((Component)jPanel2, gridBagConstraints3);
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints4.gridx = 0;
        gridBagConstraints4.gridy = 3;
        JLabel jLabel2 = new JLabel(UnityDriver.i18n.getString("SourceBuilder.messagesLabel"));
        jLabel2.setFont(new Font("Tahoma", 1, 13));
        jPanel.add((Component)jLabel2, gridBagConstraints4);
        this.scrollPane_1 = new JScrollPane();
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.insets = new Insets(0, 0, 5, 0);
        gridBagConstraints5.gridx = 0;
        gridBagConstraints5.gridy = 4;
        jPanel.add((Component)this.scrollPane_1, gridBagConstraints5);
        this.messagedoc = new DefaultStyledDocument(styleContext);
        this.messageBox = new JTextPane(this.messagedoc);
        this.messageBox.setContentType("text/html");
        this.scrollPane_1.setViewportView(this.messageBox);
        this.messageBox.setEditable(false);
        this.messageBox.setBorder(new BevelBorder(1, null, null, null, null));
        this.messageBox.setFont(font);
        JLabel jLabel3 = new JLabel(UnityDriver.i18n.getString("SourceBuilder.resultsLabel"));
        jLabel3.setFont(new Font("Tahoma", 1, 13));
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.fill = 2;
        gridBagConstraints6.insets = new Insets(0, 5, 5, 0);
        gridBagConstraints6.gridx = 0;
        gridBagConstraints6.gridy = 5;
        jPanel.add((Component)jLabel3, gridBagConstraints6);
        jLabel3.setHorizontalAlignment(2);
        this.updateDataModel();
        this.dataPanel = new JPanel();
        this.dataPanel.setLayout(new BoxLayout(this.dataPanel, 1));
        this.dataView = new JScrollPane(this.dataTable);
        this.dataView.setBorder(new BevelBorder(1, null, null, null, null));
        this.dataPanel.add(this.dataView);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.fill = 1;
        gridBagConstraints7.gridx = 0;
        gridBagConstraints7.gridy = 6;
        jPanel.add((Component)this.dataPanel, gridBagConstraints7);
        treeView = new JScrollPane(this.schemaTree);
        this.splitPane = new JSplitPane(1);
        this.splitPane.setLeftComponent(treeView);
        this.splitPane.setRightComponent(jPanel);
        this.splitPane.setDividerLocation(240);
        treeView.setMinimumSize(new Dimension(200, 200));
        container.add(this.splitPane);
        this.queryExecuting = false;
        this.menu = new Menu();
        this.setJMenuBar(this.menu);
    }

    public void setUnityURL(String string) {
        this.urlUnity = string;
    }

    public void updateDataModel() {
        try {
            this.messageBox.setText(UnityDriver.i18n.getString("SourceBuilder.messageText"));
            this.messageBox.setCaretPosition(0);
            this.queryBox.setText("");
            this.dataSource = new MyDataModel();
            this.dataTable = new DataTable(this.dataSource);
            if (!this.urlUnity.equals("")) {
                this.dataSource.makeDBConnection(this.urlUnity);
            }
        }
        catch (SQLException sQLException) {
            this.messageBox.setText(UnityDriver.i18n.getString("SourceBuilder.errorConnection") + sQLException);
        }
    }

    public void reInit(String string) throws IOException {
        this.canUpdate = true;
        String string2 = string;
        if (string2 == null || string2.equals("")) {
            return;
        }
        int n = (string2 = string2.substring(string2.toLowerCase().indexOf(baseUnityURL) + 13)).indexOf("?");
        if (n > 0) {
            string2 = string2.substring(0, n);
        }
        if (this.canUpdate || this.urlUnity.equals("")) {
            String string3 = FileManager.getXMLFile(string2, this.getClass().getClassLoader());
            if (string3.contains("jar:")) {
                string3 = string3.substring(0, string3.length() - 4) + "JAR.xml";
                this.canUpdate = false;
            } else {
                this.canUpdate = true;
            }
            if (string3.indexOf("jdbc:unity://") < 0) {
                string3 = "jdbc:unity://" + string3 + "?debug=true";
            }
            if (this.db_password != null) {
                string3 = string3 + "&password=" + this.db_password;
            }
            System.out.println(string3);
            this.setUnityURL(string3);
        }
        this.updateDataModel();
        this.dataTable.setModel(this.dataSource);
        this.dataView.setViewportView(this.dataTable);
        this.schemaTree = this.buildTree();
        treeView.setViewportView(this.schemaTree);
    }

    public void focusQueryBox() {
    }

    private ViewTree buildTree() {
        DefaultMutableTreeNode defaultMutableTreeNode = new DefaultMutableTreeNode("Databases (Virtualized)");
        ArrayList<SourceDatabase> arrayList = this.dataSource.getDatabases();
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                AnnotatedSourceDatabase annotatedSourceDatabase = (AnnotatedSourceDatabase)arrayList.get(i);
                DefaultMutableTreeNode defaultMutableTreeNode2 = new DefaultMutableTreeNode(annotatedSourceDatabase.getDatabaseName());
                defaultMutableTreeNode.add(defaultMutableTreeNode2);
                ArrayList<SourceTable> arrayList2 = annotatedSourceDatabase.getSourceTablesByName();
                for (SourceTable sourceTable : arrayList2) {
                    DefaultMutableTreeNode defaultMutableTreeNode3 = new DefaultMutableTreeNode(sourceTable.getFullName());
                    defaultMutableTreeNode2.add(defaultMutableTreeNode3);
                    ArrayList<SourceField> arrayList3 = sourceTable.getSourceFieldsByName();
                    for (SourceField sourceField : arrayList3) {
                        DefaultMutableTreeNode defaultMutableTreeNode4 = new DefaultMutableTreeNode(sourceField.getColumnName());
                        defaultMutableTreeNode3.add(defaultMutableTreeNode4);
                    }
                }
            }
        }
        return new ViewTree(defaultMutableTreeNode);
    }

    public static void append(JTextComponent jTextComponent, String string) {
        if (jTextComponent instanceof JTextArea) {
            ((JTextArea)jTextComponent).append(string);
        } else if (jTextComponent instanceof JTextPane) {
            JTextPane jTextPane = (JTextPane)jTextComponent;
            Document document = jTextPane.getDocument();
            try {
                document.insertString(document.getLength(), string, null);
            }
            catch (BadLocationException badLocationException) {
                badLocationException.printStackTrace();
            }
        }
    }

    public void execute() {
        if (this.queryExecuting) {
            this.messageBox.setText("User stopped query.\n");
            this.execButton.setText(UnityDriver.i18n.getString("SourceBuilder.executeButton"));
            this.execButton.setForeground(Color.green);
            this.queryExecuting = false;
        } else {
            this.messageBox.setText("Executing query...<br/>\n");
            this.execButton.setText(UnityDriver.i18n.getString("SourceBuilder.stopButton"));
            this.execButton.setForeground(Color.red);
            this.qt = new QueryThread(this.queryBox.getText());
            this.qt.start();
        }
        this.execButton.repaint();
    }

    public void setQueryText(String string) {
        this.queryBox.setText(string);
    }

    public String getUrlUnity() {
        return this.urlUnity;
    }

    public String getPassword() {
        return this.db_password;
    }

    public GlobalSchema getSchema() {
        if (this.dataSource == null) {
            return null;
        }
        return this.dataSource.getSchema();
    }

    private class Menu
    extends JMenuBar {
        private static final long serialVersionUID = 1L;
        private JPopupMenu popupMenu;
        private JMenuItem addSource;
        private JMenuItem removeSource;
        private JMenuItem updateSource;
        private JMenuItem removeTable;
        private JMenuItem removeField;
        private JMenuItem mnuRefresh;
        private JMenuItem mnuHelp;
        private JMenuItem mnuHelpStart;
        String[] fileItems = new String[]{"New Source Group", "Load Source Group", "New Source", "Remove Source", "Remove Table", "Refresh", "Set Password", "Exit"};
        String[] menuLabel = new String[]{"Cross-Database Join Test", "ORDER BY Test", "Optimizer Test (Distributed Join)", "Expression Test", "GROUP BY test", "Performance Benchmark Test"};
        String[] queries = new String[]{"SELECT L.l_extendedprice, P.p_retailprice, L.l_partkey\n FROM OrderDB.Lineitem L, PartDB.Part P\n WHERE P.p_partkey = L.l_partkey AND L.l_partkey < 10;", "SELECT PartDB.Part.p_name, OrderDB.LineItem.l_orderkey\n FROM PartDB.Part, OrderDB.Lineitem\n WHERE PartDB.Part.p_partkey = OrderDB.Lineitem.l_partkey AND OrderDB.Lineitem.l_linenumber > 6\n ORDER BY PartDB.Part.p_name;", "SELECT P.p_name, L.l_orderkey, S.s_name\n FROM PartDB.PART P, OrderDB.LINEITEM L, PartDB.SUPPLIER S\n WHERE S.s_suppkey = 3 AND P.p_partkey = L.l_partkey AND S.s_suppkey = L.l_suppkey;", "SELECT N.N_nationkey+5 AS MyAttrName\n FROM orderDB.nation as N, partDB.region as R\n WHERE N.n_nationkey +10 < 20 and R.r_regionkey = N.n_regionkey;", "SELECT COUNT(N.n_nationkey)\n FROM orderDB.nation N, partDB.region R\n WHERE R.r_regionkey = N.n_regionkey\n GROUP BY N.n_regionkey;", "SELECT L.L_ExtendedPrice, P.p_retailprice, L.l_partkey\n FROM OrderDB.LINEITEM L, PartDB.Part P, OrderDB.Orders O\n WHERE P.p_partkey = L.l_partkey and L.l_orderkey = O.o_orderkey and L.l_orderkey < 1000000;"};
        String[] english = new String[]{"A Unity test containing a large client-side join.", "This query demonstrates the capability to order the results of a query on the client-side.", "Demonstrates Optimizer Selecting a Distributed Query and Pushing Selection Down to Source.\nPushing down the selection S.s_suppkey = 3 allows the system to execute the joins of\n SUPPLIER, LINEITEM, and PART in a staged fashion.\nThis increases performance as the entire LINEITEM or PART table does not have to be retrieved from the source.\nThis results in up to 10 times speed improvement!", "Shows expressions in SELECT clause executed on client-side.", "Shows GROUP BY clause executed on client-side.", "Performance test requiring large client-side joins on 100 MB TPC-H database.\nShows benefit of fast hash join implementation."};
        String[] sources = new String[]{"jdbc:Unity://test/xspec/UnityDemo.xml", "jdbc:Unity://test/xspec/UnityDemo.xml", "jdbc:Unity://test/xspec/UnityDemo.xml", "jdbc:Unity://test/xspec/UnityDemo.xml", "jdbc:Unity://test/xspec/UnityDemo.xml", "jdbc:Unity://test/xspec/UnityDemo.xml"};
        String[] menuSource = new String[]{"Unity Demo"};
        String[] menuSources = new String[]{"jdbc:Unity://test/xspec/UnityDemo.xml"};
        HashMap<String, String> query = new HashMap();
        HashMap<String, String> eng = new HashMap();
        HashMap<String, String> source = new HashMap();
        HashMap<String, String> integrations = new HashMap();

        public Menu() {
            JMenuItem jMenuItem;
            int n;
            int n2;
            JMenu jMenu = new JMenu("File");
            JMenu jMenu2 = new JMenu("Demonstration");
            JMenu jMenu3 = new JMenu("Help");
            JMenu jMenu4 = new JMenu("Queries");
            JMenu jMenu5 = new JMenu("Sources");
            for (n2 = 0; n2 < this.menuSource.length; ++n2) {
                this.integrations.put(this.menuSource[n2], this.menuSources[n2]);
            }
            for (n2 = 0; n2 < this.menuLabel.length; ++n2) {
                this.query.put(this.menuLabel[n2], this.queries[n2]);
                this.eng.put(this.menuLabel[n2], this.english[n2]);
                this.source.put(this.menuLabel[n2], this.sources[n2]);
            }
            MenuListener menuListener = new MenuListener();
            for (n = 0; n < this.fileItems.length; ++n) {
                jMenuItem = new JMenuItem(this.fileItems[n]);
                jMenuItem.addActionListener(menuListener);
                jMenu.add(jMenuItem);
            }
            for (n = 0; n < this.menuLabel.length; ++n) {
                jMenuItem = new JMenuItem(this.menuLabel[n]);
                jMenuItem.addActionListener(menuListener);
                jMenu4.add(jMenuItem);
            }
            for (n = 0; n < this.menuSource.length; ++n) {
                jMenuItem = new JMenuItem(this.menuSource[n]);
                jMenuItem.addActionListener(menuListener);
                jMenu5.add(jMenuItem);
            }
            jMenu2.add(jMenu4);
            jMenu2.add(jMenu5);
            this.add(jMenu);
            this.add(jMenu2);
            this.mnuHelpStart = new JMenuItem("Getting Started");
            this.mnuHelpStart.addActionListener(menuListener);
            jMenu3.add(this.mnuHelpStart);
            this.mnuHelp = new JMenuItem("About");
            this.mnuHelp.addActionListener(menuListener);
            jMenu3.add(this.mnuHelp);
            this.add(jMenu3);
            this.popupMenu = new JPopupMenu();
            this.addSource = new JMenuItem("Add Source");
            this.addSource.addActionListener(menuListener);
            this.popupMenu.add(this.addSource);
            this.removeSource = new JMenuItem("Remove Source");
            this.removeSource.addActionListener(menuListener);
            this.popupMenu.add(this.removeSource);
            this.updateSource = new JMenuItem("Update Source");
            this.updateSource.addActionListener(menuListener);
            this.popupMenu.add(this.updateSource);
            this.removeTable = new JMenuItem("Remove Table");
            this.removeTable.addActionListener(menuListener);
            this.popupMenu.add(this.removeTable);
            this.removeField = new JMenuItem("Remove Field");
            this.removeField.addActionListener(menuListener);
            this.popupMenu.add(this.removeField);
            this.mnuRefresh = new JMenuItem("Refresh");
            this.mnuRefresh.addActionListener(menuListener);
            this.popupMenu.add(this.mnuRefresh);
        }

        public void popup(MouseEvent mouseEvent) {
            if (SourceBuilder.this.lastSelectedNode == null || SourceBuilder.this.lastSelectedNode.getLevel() == 0) {
                this.removeSource.setVisible(false);
                this.updateSource.setVisible(false);
                this.removeTable.setVisible(false);
                this.removeField.setVisible(false);
                this.popupMenu.setPopupSize(200, 50);
                this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (SourceBuilder.this.lastSelectedNode.getLevel() == 1) {
                this.removeSource.setVisible(true);
                this.updateSource.setVisible(true);
                this.removeTable.setVisible(false);
                this.removeField.setVisible(false);
                this.popupMenu.setPopupSize(200, 100);
                this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (SourceBuilder.this.lastSelectedNode.getLevel() == 2) {
                this.removeTable.setVisible(true);
                this.updateSource.setVisible(true);
                this.removeField.setVisible(false);
                this.popupMenu.setPopupSize(200, 125);
                this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            } else if (SourceBuilder.this.lastSelectedNode.getLevel() == 3) {
                this.removeTable.setVisible(true);
                this.updateSource.setVisible(true);
                this.removeField.setVisible(true);
                this.popupMenu.setPopupSize(200, 150);
                this.popupMenu.show(mouseEvent.getComponent(), mouseEvent.getX(), mouseEvent.getY());
            }
        }

        private class MenuListener
        implements ActionListener {
            private MenuListener() {
            }

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                block39: {
                    String string = actionEvent.getActionCommand();
                    Object object = actionEvent.getSource();
                    try {
                        if (string.equals("Exit")) {
                            System.exit(0);
                            break block39;
                        }
                        if (string.equals("About")) {
                            String string2 = UnityDriver.getVersion();
                            String string3 = "Trial License";
                            try {
                                UnityDriver unityDriver = new UnityDriver();
                                string3 = unityDriver.getLicense();
                            }
                            catch (SQLException sQLException) {
                                // empty catch block
                            }
                            JOptionPane.showMessageDialog(null, string2 + "\n" + string3, "About UnityJDBC", -1);
                            return;
                        }
                        if (string.equals("Set Password")) {
                            String string4 = JOptionPane.showInputDialog(null, "Enter password: ", "Enter Password for System", -1);
                            if (string4 != null && !string4.equals("")) {
                                SourceBuilder.this.db_password = string4;
                            }
                            break block39;
                        }
                        if (string.equals("Getting Started")) {
                            SourceBuilder.this.hf.setSize(750, 650);
                            SourceBuilder.this.hf.setLocationRelativeTo(Menu.this.getRootPane());
                            SourceBuilder.this.hf.setVisible(true);
                            return;
                        }
                        if (string.equals("New Source Group")) {
                            SourceBuilder.this.sgf.setVisible(true);
                            String string5 = SourceBuilder.this.sgf.getFileName();
                            if (string5 != null && !string5.equals(SourceBuilder.this.sourceFileName)) {
                                SourceBuilder.this.dataSource.createEmptySourceGroup(string5, SourceBuilder.this.getPassword());
                                SourceBuilder.this.sourceFileName = string5;
                                SourceBuilder.this.urlUnity = baseUnityURL + string5;
                                SourceBuilder.this.reInit(SourceBuilder.this.urlUnity);
                            }
                            break block39;
                        }
                        if (string.equals("Load Source Group")) {
                            SourceBuilder.this.sgf.setVisible(true);
                            String string6 = SourceBuilder.this.sgf.getFileName();
                            if (string6 != null && !string6.equals(SourceBuilder.this.sourceFileName)) {
                                SourceBuilder.this.sourceFileName = string6;
                                SourceBuilder.this.urlUnity = baseUnityURL + string6;
                                SourceBuilder.this.reInit(SourceBuilder.this.urlUnity);
                            }
                            break block39;
                        }
                        if (string.equals("New Source") || object == Menu.this.addSource) {
                            if (!SourceBuilder.this.canUpdate) {
                                JOptionPane.showMessageDialog(null, "You cannot update the demo source in the UnityJDBC.jar.", "Error: Unable to modify source", 0);
                                return;
                            }
                            if (SourceBuilder.this.sourceFileName == null || SourceBuilder.this.sourceFileName.equals("")) {
                                JOptionPane.showMessageDialog(null, "You must create a source group before adding sources.", "Error: Unable to add source", 0);
                                return;
                            }
                            SourceBuilder.this.sf.setDatabase(null);
                            SourceBuilder.this.sf.setSourcesFile(SourceBuilder.this.sourceFileName);
                            SourceBuilder.this.sf.setupDisplay();
                            SourceBuilder.this.sf.clearForNewSource();
                            SourceBuilder.this.sf.setVisible(true);
                            SourceBuilder.this.reInit(SourceBuilder.this.urlUnity);
                            break block39;
                        }
                        if (string.equals("Refresh")) {
                            SourceBuilder.this.reInit(SourceBuilder.this.urlUnity);
                            break block39;
                        }
                        if (string.equals("Remove Source")) {
                            if (!SourceBuilder.this.canUpdate) {
                                JOptionPane.showMessageDialog(null, "You cannot update the demo source in the UnityJDBC.jar.", "Error: Unable to modify source", 0);
                                return;
                            }
                            String string7 = SourceBuilder.this.schemaTree.getSelectedText();
                            if (string7 == null) {
                                return;
                            }
                            String[] stringArray = StringFunc.divideIdentifier(string7);
                            if (stringArray.length != 1) {
                                return;
                            }
                            SourceBuilder.this.dataSource.removeDatabase(stringArray[0]);
                            SourceBuilder.this.reInit(SourceBuilder.this.urlUnity);
                            break block39;
                        }
                        if (string.equals("Update Source") || object == Menu.this.updateSource) {
                            if (!SourceBuilder.this.canUpdate) {
                                JOptionPane.showMessageDialog(null, "You cannot update the demo source in the UnityJDBC.jar.", "Error: Unable to modify source", 0);
                                return;
                            }
                            String string8 = SourceBuilder.this.schemaTree.getSelectedText();
                            if (string8 == null) {
                                return;
                            }
                            String[] stringArray = StringFunc.divideIdentifier(string8);
                            GlobalSchema globalSchema = SourceBuilder.this.dataSource.getSchema();
                            AnnotatedSourceDatabase annotatedSourceDatabase = globalSchema.getDB(stringArray[0]);
                            if (annotatedSourceDatabase == null) {
                                return;
                            }
                            SourceBuilder.this.sf.setDatabase(annotatedSourceDatabase);
                            SourceBuilder.this.sf.setupDisplay();
                            SourceBuilder.this.sf.setSourcesFile(SourceBuilder.this.sourceFileName);
                            SourceBuilder.this.sf.clearForNewSource();
                            SourceBuilder.this.sf.setVisible(true);
                            SourceBuilder.this.reInit(SourceBuilder.this.urlUnity);
                            break block39;
                        }
                        if (string.equals("Remove Table")) {
                            if (!SourceBuilder.this.canUpdate) {
                                JOptionPane.showMessageDialog(null, "You cannot update the demo source in the UnityJDBC.jar.", "Error: Unable to modify source", 0);
                                return;
                            }
                            String string9 = SourceBuilder.this.schemaTree.getSelectedText();
                            if (string9 == null) {
                                return;
                            }
                            System.out.println(string9);
                            String[] stringArray = StringFunc.divideIdentifier(string9);
                            if (stringArray.length != 2) {
                                return;
                            }
                            SourceBuilder.this.dataSource.removeTable(stringArray[0], stringArray[1]);
                            SourceBuilder.this.reInit(SourceBuilder.this.urlUnity);
                            break block39;
                        }
                        if (object == Menu.this.removeField) {
                            if (!SourceBuilder.this.canUpdate) {
                                JOptionPane.showMessageDialog(null, "You cannot update the demo source in the UnityJDBC.jar.", "Error: Unable to modify source", 0);
                                return;
                            }
                            String string10 = SourceBuilder.this.schemaTree.getSelectedText();
                            if (string10 == null) {
                                return;
                            }
                            System.out.println(string10);
                            String[] stringArray = StringFunc.divideIdentifier(string10);
                            if (stringArray.length != 3) {
                                return;
                            }
                            SourceBuilder.this.dataSource.removeField(stringArray[0], stringArray[1], stringArray[2]);
                            SourceBuilder.this.reInit(SourceBuilder.this.urlUnity);
                            break block39;
                        }
                        if (Menu.this.integrations.get(string) != null) {
                            SourceBuilder.this.sourceFileName = "";
                            SourceBuilder.this.reInit(Menu.this.integrations.get(string));
                            break block39;
                        }
                        String string11 = Menu.this.query.get(string);
                        if (string11 == null) {
                            SourceBuilder.this.messageBox.setText("");
                            return;
                        }
                        SourceBuilder.this.reInit(Menu.this.source.get(string));
                        SourceBuilder.this.queryBox.setText(string11);
                        String string12 = Menu.this.eng.get(string);
                        SourceBuilder.this.sourceFileName = UnityDriver.getURLFilePath(Menu.this.source.get(string));
                        try {
                            Class.forName("org.hsqldb.jdbcDriver");
                            Connection connection = DriverManager.getConnection("jdbc:hsqldb:hsql://localhost/tpch");
                            Statement statement = connection.createStatement();
                            statement.executeQuery("SELECT * FROM Nation");
                            statement.close();
                            connection.close();
                        }
                        catch (Exception exception) {
                            SourceBuilder.this.messageBox.setText("Test database not started.  Make sure to start the database using the script in the installation directory.");
                            return;
                        }
                        if (string12 == null) {
                            SourceBuilder.this.messageBox.setText("");
                        } else {
                            SourceBuilder.this.messageBox.setText(string12);
                        }
                    }
                    catch (IOException iOException) {
                        SourceBuilder.this.messageBox.setText(iOException.toString());
                    }
                }
            }
        }
    }

    private class ViewTree
    extends JTree {
        private static final long serialVersionUID = 1L;
        private String lastSelectedText;

        public ViewTree(DefaultMutableTreeNode defaultMutableTreeNode) {
            super(defaultMutableTreeNode);
            this.lastSelectedText = null;
            this.getSelectionModel().setSelectionMode(1);
            this.addTreeSelectionListener(new MyTreeListener());
            this.setRootVisible(true);
            this.expandTree();
            this.addMouseListener(new PopupListener());
            this.setCellRenderer(new TreeCellRenderer());
        }

        public void expandTree() {
            Enumeration<TreeNode> enumeration = ((DefaultMutableTreeNode)this.getModel().getRoot()).children();
            while (enumeration.hasMoreElements()) {
                TreePath treePath = new TreePath(((DefaultMutableTreeNode)enumeration.nextElement()).getPath());
                this.setExpandedState(treePath, true);
            }
        }

        public String getSelectedText() {
            return this.lastSelectedText;
        }

        private class MyTreeListener
        implements TreeSelectionListener {
            private MyTreeListener() {
            }

            @Override
            public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
                Object object;
                DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)ViewTree.this.getLastSelectedPathComponent();
                if (defaultMutableTreeNode == null) {
                    return;
                }
                SourceBuilder.this.lastSelectedNode = defaultMutableTreeNode;
                ViewTree.this.lastSelectedText = defaultMutableTreeNode.toString();
                Object object2 = defaultMutableTreeNode.getUserObject();
                int n = defaultMutableTreeNode.getDepth();
                GlobalSchema globalSchema = SourceBuilder.this.dataSource.getSchema();
                switch (n) {
                    case 3: {
                        StringBuffer stringBuffer = new StringBuffer("<h3>Virtual Databases Summary</h3>");
                        object = globalSchema.getAnnotatedDatabases();
                        stringBuffer.append("Number of databases: " + ((ArrayList)object).size());
                        SourceBuilder.this.messageBox.setText(stringBuffer.toString());
                        break;
                    }
                    case 2: {
                        StringBuffer stringBuffer = new StringBuffer("<h3>Database: " + object2.toString() + "</h3>");
                        AnnotatedSourceDatabase annotatedSourceDatabase = globalSchema.getDB(object2.toString());
                        if (annotatedSourceDatabase != null) {
                            stringBuffer.append("<table border=1><tr><th>Attribute</th><th>Value</th></tr>");
                            stringBuffer.append("<tr><td>Name</td><td>" + annotatedSourceDatabase.getDatabaseName() + "</td></tr>");
                            stringBuffer.append("<tr><td>System name</td><td>" + annotatedSourceDatabase.getSystemDatabaseName() + "</td></tr>");
                            stringBuffer.append("<tr><td>Product name</td><td>" + annotatedSourceDatabase.getDatabaseProductName() + "</td></tr>");
                            stringBuffer.append("<tr><td>Version</td><td>" + annotatedSourceDatabase.getDatabaseProductVersion() + "</td></tr>");
                            stringBuffer.append("<tr><td>Database id</td><td>" + annotatedSourceDatabase.getDatabaseId() + "</td></tr>");
                            stringBuffer.append("<tr><td>Driver name</td><td>" + annotatedSourceDatabase.getDriverName() + "</td></tr>");
                            stringBuffer.append("<tr><td>URL</td><td>" + annotatedSourceDatabase.getURL() + "</td></tr>");
                            stringBuffer.append("<tr><td>User id</td><td>" + annotatedSourceDatabase.getUserId() + "</td></tr>");
                            stringBuffer.append("<tr><td>Schema file</td><td>" + annotatedSourceDatabase.getSchemaFile() + "</td></tr>");
                            stringBuffer.append("</table>");
                        }
                        SourceBuilder.this.messageBox.setText(stringBuffer.toString());
                        break;
                    }
                    case 1: {
                        AnnotatedSourceTable annotatedSourceTable;
                        StringBuffer stringBuffer = new StringBuffer("<h3>Table: " + object2.toString() + "</h3>");
                        AnnotatedSourceDatabase annotatedSourceDatabase = globalSchema.getDB(defaultMutableTreeNode.getParent().toString());
                        if (annotatedSourceDatabase != null && (annotatedSourceTable = (AnnotatedSourceTable)annotatedSourceDatabase.getTable(object2.toString())) != null) {
                            stringBuffer.append("<table border=1><tr><th>Attribute</th><th>Value</th></tr>");
                            stringBuffer.append("<tr><td>Name</td><td>" + annotatedSourceTable.getTableName() + "</td></tr>");
                            stringBuffer.append("<tr><td># fields</td><td>" + annotatedSourceTable.getNumFields() + "</td></tr>");
                            stringBuffer.append("<tr><td>Reference name</td><td>" + annotatedSourceTable.getUnityFullSQLTableName() + "</td></tr>");
                            stringBuffer.append("</table>");
                        }
                        SourceBuilder.this.messageBox.setText(stringBuffer.toString());
                        break;
                    }
                    case 0: {
                        AnnotatedSourceField annotatedSourceField;
                        AnnotatedSourceTable annotatedSourceTable;
                        StringBuffer stringBuffer = new StringBuffer("<h3>Field: " + object2.toString() + "</h3>");
                        if (defaultMutableTreeNode.getParent() == null || defaultMutableTreeNode.getParent().getParent() == null) break;
                        AnnotatedSourceDatabase annotatedSourceDatabase = globalSchema.getDB(defaultMutableTreeNode.getParent().getParent().toString());
                        if (annotatedSourceDatabase != null && (annotatedSourceTable = (AnnotatedSourceTable)annotatedSourceDatabase.getTable(defaultMutableTreeNode.getParent().toString())) != null && (annotatedSourceField = (AnnotatedSourceField)annotatedSourceTable.getField(object2.toString())) != null) {
                            stringBuffer.append("<table border=1><tr><th>Attribute</th><th>Value</th></tr>");
                            stringBuffer.append("<tr><td>Name</td><td>" + annotatedSourceField.getColumnName() + "</td></tr>");
                            stringBuffer.append("<tr><td>Type</td><td>" + annotatedSourceField.getDataType() + "</td></tr>");
                            stringBuffer.append("<tr><td>Type Name</td><td>" + annotatedSourceField.getDataTypeName() + "</td></tr>");
                            stringBuffer.append("<tr><td>Size</td><td>" + annotatedSourceField.getColumnSize() + "</td></tr>");
                            stringBuffer.append("<tr><td>Comment</td><td>" + annotatedSourceField.getRemarks() + "</td></tr>");
                            stringBuffer.append("</table>");
                        }
                        SourceBuilder.this.messageBox.setText(stringBuffer.toString());
                        break;
                    }
                }
                SourceBuilder.this.messageBox.setCaretPosition(0);
                if (defaultMutableTreeNode.getDepth() > 1) {
                    return;
                }
                object = defaultMutableTreeNode.toString();
                for (defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent(); defaultMutableTreeNode != null && defaultMutableTreeNode.getParent() != null; defaultMutableTreeNode = (DefaultMutableTreeNode)defaultMutableTreeNode.getParent()) {
                    object = defaultMutableTreeNode.toString() + "." + (String)object;
                }
                try {
                    SourceBuilder.this.querydoc.insertString(SourceBuilder.this.queryBox.getCaretPosition(), (String)object + " ", null);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                SourceBuilder.this.focusQueryBox();
                ViewTree.this.lastSelectedText = (String)object;
            }
        }
    }

    private class TreeCellRenderer
    extends DefaultTreeCellRenderer {
        private static final long serialVersionUID = 1L;
        private ImageIcon viewIcon = new ImageIcon(SourceBuilder.class.getResource("/resources/iconview.png"));
        private ImageIcon dbIcon = new ImageIcon(SourceBuilder.class.getResource("/resources/icondb.png"));
        private ImageIcon tableIcon = new ImageIcon(SourceBuilder.class.getResource("/resources/icontable.png"));
        private ImageIcon fieldIcon = new ImageIcon(SourceBuilder.class.getResource("/resources/iconfield.png"));
        private Font heading1 = new Font("Arial", 1, 14);
        private Font basicFont = new Font("Arial", 0, 11);

        @Override
        public Component getTreeCellRendererComponent(JTree jTree, Object object, boolean bl, boolean bl2, boolean bl3, int n, boolean bl4) {
            super.getTreeCellRendererComponent(jTree, object, bl, bl2, bl3, n, bl4);
            int n2 = ((DefaultMutableTreeNode)object).getLevel();
            switch (n2) {
                case 0: {
                    this.setIcon(this.viewIcon);
                    this.setFont(this.heading1);
                    break;
                }
                case 1: {
                    this.setIcon(this.dbIcon);
                    this.setFont(this.heading1);
                    break;
                }
                case 2: {
                    this.setIcon(this.tableIcon);
                    this.setFont(this.basicFont);
                    break;
                }
                default: {
                    this.setIcon(this.fieldIcon);
                    this.setFont(this.basicFont);
                }
            }
            return this;
        }
    }

    static class DecimalFormatRenderer
    extends DefaultTableCellRenderer {
        private static final long serialVersionUID = 1L;
        private static final DecimalFormat formatter = new DecimalFormat("#.#########");

        DecimalFormatRenderer() {
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            object = formatter.format((Number)object);
            return super.getTableCellRendererComponent(jTable, object, bl, bl2, n, n2);
        }
    }

    private class DataTable
    extends JTable {
        private static final long serialVersionUID = 1L;
        MyDataModel dataModel;

        public DataTable(MyDataModel myDataModel) {
            super(myDataModel);
            this.getTableHeader().addMouseListener(new HeaderSortListener());
            this.dataModel = myDataModel;
            this.setRowHeight(20);
        }

        @Override
        public TableCellRenderer getCellRenderer(int n, int n2) {
            Object object = this.dataModel.getValueAt(n, n2);
            if (object instanceof Float || object instanceof Double) {
                return new DecimalFormatRenderer();
            }
            try {
                return super.getCellRenderer(n, n2);
            }
            catch (Exception exception) {
                return null;
            }
        }

        @Override
        public TableCellEditor getCellEditor(int n, int n2) {
            Object object = this.dataModel.getValueAt(n, n2);
            if (object == null) {
                return super.getCellEditor(n, n2);
            }
            return super.getCellEditor(n, n2);
        }

        private class HeaderSortListener
        extends MouseAdapter {
            private HeaderSortListener() {
            }

            @Override
            public void mouseClicked(MouseEvent mouseEvent) {
                TableColumnModel tableColumnModel = DataTable.this.getColumnModel();
                int n = tableColumnModel.getColumnIndexAtX(mouseEvent.getX());
                if (mouseEvent.getClickCount() == 1 && n != -1) {
                    DataTable.this.dataModel.sortColumn(n);
                }
            }
        }
    }

    private class PopupListener
    extends MouseAdapter {
        private PopupListener() {
        }

        @Override
        public void mousePressed(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        @Override
        public void mouseReleased(MouseEvent mouseEvent) {
            this.maybeShowPopup(mouseEvent);
        }

        private void maybeShowPopup(MouseEvent mouseEvent) {
            if (mouseEvent.isPopupTrigger()) {
                SourceBuilder.this.menu.popup(mouseEvent);
            }
        }
    }

    private class ButtonListener
    implements ActionListener {
        private ButtonListener() {
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            Object object = actionEvent.getSource();
            if (object == SourceBuilder.this.execButton) {
                SourceBuilder.this.execute();
            } else if (object == SourceBuilder.this.clearButton) {
                SourceBuilder.this.messageBox.setText("<p></p>");
                SourceBuilder.this.queryBox.setText("");
                SourceBuilder.this.focusQueryBox();
            }
        }
    }

    private class QueryThread
    extends Thread {
        private String query;

        public QueryThread(String string) {
            this.query = string;
        }

        @Override
        public void run() {
            SourceBuilder.this.queryExecuting = true;
            long l = System.currentTimeMillis();
            if (this.query.toLowerCase().trim().startsWith("select") || this.query.toLowerCase().trim().startsWith("explain") || this.query.toLowerCase().trim().startsWith("translate")) {
                SourceBuilder.this.dataSource.doQuery(this.query, l, SourceBuilder.this.messageBox, SourceBuilder.this);
                long l2 = System.currentTimeMillis();
                SourceBuilder.append(SourceBuilder.this.messageBox, "Number of results: " + SourceBuilder.this.dataSource.getRowCount() + "\n");
                SourceBuilder.append(SourceBuilder.this.messageBox, "Query complete.\n");
                long l3 = l2 - l;
                SourceBuilder.append(SourceBuilder.this.messageBox, "Query Exection time is " + l3 + " ms.");
            } else {
                SourceBuilder.this.dataSource.doExecuteUpdate(this.query, l, SourceBuilder.this.messageBox);
                long l4 = System.currentTimeMillis();
                SourceBuilder.append(SourceBuilder.this.messageBox, "Execution complete.\n");
                long l5 = l4 - l;
                SourceBuilder.append(SourceBuilder.this.messageBox, "Execution time is " + l5 + " ms.");
            }
            SourceBuilder.this.queryExecuting = false;
            SourceBuilder.this.execButton.setText(UnityDriver.i18n.getString("SourceBuilder.executeButton"));
            SourceBuilder.this.execButton.setForeground(Color.green);
        }
    }

    private class WindowCloser
    extends WindowAdapter {
        private WindowCloser() {
        }

        @Override
        public void windowClosing(WindowEvent windowEvent) {
            SourceBuilder.this.dataSource.closeDBConnection();
            System.exit(0);
        }
    }
}

