/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.greenplum;

import net.sourceforge.squirrel_sql.client.plugin.DefaultSessionPlugin;
import net.sourceforge.squirrel_sql.client.plugin.IPlugin;
import net.sourceforge.squirrel_sql.client.plugin.PluginException;
import net.sourceforge.squirrel_sql.client.plugin.PluginQueryTokenizerPreferencesManager;
import net.sourceforge.squirrel_sql.client.plugin.PluginSessionCallback;
import net.sourceforge.squirrel_sql.client.session.IObjectTreeAPI;
import net.sourceforge.squirrel_sql.client.session.ISession;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.INodeExpanderFactory;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.expanders.SchemaExpander;
import net.sourceforge.squirrel_sql.client.session.mainpanel.objecttree.tabs.IObjectTab;
import net.sourceforge.squirrel_sql.fw.dialects.DialectFactory;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.preferences.BaseQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.preferences.IQueryTokenizerPreferenceBean;
import net.sourceforge.squirrel_sql.fw.sql.DatabaseObjectType;
import net.sourceforge.squirrel_sql.fw.sql.ISQLDatabaseMetaData;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.plugins.greenplum.exp.GreenplumExtTableInodeExpanderFactory;
import net.sourceforge.squirrel_sql.plugins.greenplum.tab.GreenplumExternalTableDetailsTab;

public class GreenplumPlugin
extends DefaultSessionPlugin {
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(GreenplumPlugin.class);
    private static ILogger s_log = LoggerController.createLogger(GreenplumPlugin.class);
    private PluginQueryTokenizerPreferencesManager _prefsManager = null;

    public String getAuthor() {
        return "Adam Winn";
    }

    public String getDescriptiveName() {
        return "Greenplum External Tables Plugin";
    }

    public String getInternalName() {
        return "greenplum";
    }

    public String getVersion() {
        return "0.01";
    }

    public String getChangeLogFileName() {
        return "changes.txt";
    }

    public String getHelpFileName() {
        return "";
    }

    public String getLicenceFileName() {
        return "licence.txt";
    }

    public boolean allowsSessionStartedInBackground() {
        return true;
    }

    protected boolean isPluginSession(ISession session) {
        return DialectFactory.isGreenplum((ISQLDatabaseMetaData)session.getMetaData());
    }

    public void initialize() throws PluginException {
        this._prefsManager = new PluginQueryTokenizerPreferencesManager();
        this._prefsManager.initialize((IPlugin)this, (IQueryTokenizerPreferenceBean)new BaseQueryTokenizerPreferenceBean());
    }

    public PluginSessionCallback sessionStarted(final ISession session) {
        if (!DialectFactory.isGreenplum((ISQLDatabaseMetaData)session.getMetaData())) {
            return null;
        }
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                GreenplumPlugin.this.updateObjectTree(session.getObjectTreeAPIOfActiveSessionWindow());
            }
        });
        return null;
    }

    private void updateObjectTree(IObjectTreeAPI objTree) {
        objTree.addExpander(DatabaseObjectType.SCHEMA, (INodeExpander)new SchemaExpander((INodeExpanderFactory)new GreenplumExtTableInodeExpanderFactory(), DatabaseObjectType.TABLE_TYPE_DBO));
        objTree.addDetailTab(DatabaseObjectType.TABLE_TYPE_DBO, (IObjectTab)new GreenplumExternalTableDetailsTab());
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    static interface i18n {
        public static final String PREFS_HINT = GreenplumPlugin.access$000().getString("GreenplumPlugin.prefsHint");
    }
}

