/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres.types;

import java.sql.ResultSet;
import java.sql.SQLException;
import net.sourceforge.squirrel_sql.client.session.SessionManager;
import net.sourceforge.squirrel_sql.fw.datasetviewer.ColumnDisplayDefinition;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponent;
import net.sourceforge.squirrel_sql.fw.datasetviewer.cellcomponent.IDataTypeComponentFactory;
import net.sourceforge.squirrel_sql.fw.dialects.DialectType;
import net.sourceforge.squirrel_sql.plugins.postgres.types.PostgreSqlGeometryTypeDataTypeComponent;
import org.apache.commons.lang.builder.EqualsBuilder;

public class PostgreSqlGeometryTypeDataTypeComponentFactory
implements IDataTypeComponentFactory {
    private final SessionManager sessionManager;

    public PostgreSqlGeometryTypeDataTypeComponentFactory(SessionManager sessionManager) {
        this.sessionManager = sessionManager;
    }

    public IDataTypeComponent constructDataTypeComponent() {
        return new PostgreSqlGeometryTypeDataTypeComponent(this);
    }

    public DialectType getDialectType() {
        return DialectType.POSTGRES;
    }

    int fetchSrid(ColumnDisplayDefinition _colDef) throws SQLException {
        String[] parts = _colDef.getFullTableColumnName().split(":");
        String sql = "SELECT ST_SRID(" + _colDef.getColumnName() + ") FROM " + parts[3] + " LIMIT 1;";
        ResultSet resultSet = this.sessionManager.getActiveSession().getSQLConnection().createStatement().executeQuery(sql);
        if (resultSet.next()) {
            return resultSet.getInt(1);
        }
        return 0;
    }

    public boolean matches(DialectType dialectType, int sqlType, String sqlTypeName) {
        return new EqualsBuilder().append((Object)this.getDialectType(), (Object)dialectType).append(1111, sqlType).append((Object)"geometry", (Object)sqlTypeName).isEquals();
    }
}

