/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.postgres.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import net.sourceforge.squirrel_sql.fw.gui.GUIUtils;
import net.sourceforge.squirrel_sql.fw.util.StringManager;
import net.sourceforge.squirrel_sql.fw.util.StringManagerFactory;
import net.sourceforge.squirrel_sql.plugins.postgres.gui.AbstractPostgresDialog;

public class MessageDialog
extends JDialog {
    protected JTextArea _messageTextArea;
    protected JScrollPane scrollPane;
    protected JButton _closeButton;
    protected boolean _autoScrolling = true;
    private static final StringManager s_stringMgr = StringManagerFactory.getStringManager(AbstractPostgresDialog.class);

    public MessageDialog() {
        this.init();
    }

    protected void init() {
        this.setModal(true);
        this.setSize(500, 250);
        Container contentPane = super.getContentPane();
        contentPane.setLayout(new BorderLayout());
        this._messageTextArea = new JTextArea();
        this._messageTextArea.setLineWrap(true);
        this._messageTextArea.setEditable(false);
        this.scrollPane = new JScrollPane(this._messageTextArea);
        contentPane.add((Component)this.scrollPane, "Center");
        this._closeButton = new JButton(i18n.CLOSE_BUTTON_LABEL);
        this._closeButton.setEnabled(false);
        this.replaceCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                MessageDialog.this.setVisible(false);
            }
        });
        contentPane.add((Component)this._closeButton, "South");
    }

    public void replaceCloseListener(ActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("ActionListener cannot be null");
        }
        for (ActionListener l : (ActionListener[])this._closeButton.getListeners(ActionListener.class)) {
            this._closeButton.removeActionListener(l);
        }
        this._closeButton.addActionListener(listener);
    }

    public void writeLine(String text) {
        this._messageTextArea.append(text + "\n");
        if (this._autoScrolling) {
            this.scrollToBottom();
        }
    }

    public void writeEmptyLine() {
        this._messageTextArea.append("\n");
        if (this._autoScrolling) {
            this.scrollToBottom();
        }
    }

    public void enableCloseButton() {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageDialog.this._closeButton.setEnabled(true);
            }
        });
    }

    public void setAutoScrolling(boolean autoScrolling) {
        this._autoScrolling = autoScrolling;
    }

    public void scrollToBottom() {
        GUIUtils.processOnSwingEventThread((Runnable)new Runnable(){

            @Override
            public void run() {
                MessageDialog.this._messageTextArea.setCaretPosition(MessageDialog.this._messageTextArea.getText().length());
            }
        });
    }

    public static void main(String[] args) {
        final MessageDialog dialog = new MessageDialog();
        dialog.replaceCloseListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                System.exit(0);
            }
        });
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                dialog.setVisible(true);
            }
        });
        dialog.setAutoScrolling(false);
        for (int i = 1; i <= 15; ++i) {
            dialog.writeLine("A line of text. (" + i + ")");
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        dialog.scrollToBottom();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        dialog.setAutoScrolling(true);
        for (int i = 16; i <= 20; ++i) {
            dialog.writeLine("A line of text. (" + i + ")");
            try {
                Thread.sleep(100L);
                continue;
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        dialog.enableCloseButton();
    }

    static /* synthetic */ StringManager access$000() {
        return s_stringMgr;
    }

    protected static interface i18n {
        public static final String CLOSE_BUTTON_LABEL = MessageDialog.access$000().getString("MessageDialog.closeButtonLabel");
    }
}

