/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.sessionscript;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import net.sourceforge.squirrel_sql.fw.id.IHasIdentifier;
import net.sourceforge.squirrel_sql.fw.sql.ISQLAlias;
import net.sourceforge.squirrel_sql.fw.util.DuplicateObjectException;
import net.sourceforge.squirrel_sql.fw.util.log.ILogger;
import net.sourceforge.squirrel_sql.fw.util.log.LoggerController;
import net.sourceforge.squirrel_sql.fw.xml.XMLException;
import net.sourceforge.squirrel_sql.fw.xml.XMLObjectCache;
import net.sourceforge.squirrel_sql.plugins.sessionscript.AliasScript;
import net.sourceforge.squirrel_sql.plugins.sessionscript.SessionScriptPlugin;

public class AliasScriptCache {
    private static ILogger s_log = LoggerController.createLogger(AliasScriptCache.class);
    private SessionScriptPlugin _plugin;
    private XMLObjectCache<AliasScript> _cache = new XMLObjectCache();
    private String _scriptsFileName;

    public AliasScriptCache(SessionScriptPlugin plugin) throws IOException {
        if (plugin == null) {
            throw new IllegalArgumentException("Null SessionScriptPlugin passed");
        }
        this._plugin = plugin;
        this._scriptsFileName = this._plugin.getPluginUserSettingsFolder().getAbsolutePath() + File.separator + "session-scripts.xml";
    }

    public synchronized AliasScript get(ISQLAlias alias) {
        if (alias == null) {
            throw new IllegalArgumentException("ISQLALias == null");
        }
        AliasScript script = (AliasScript)this._cache.get(AliasScript.class, alias.getIdentifier());
        if (script == null) {
            script = new AliasScript(alias);
            try {
                this._cache.add((IHasIdentifier)script);
            }
            catch (DuplicateObjectException ex) {
                throw new InternalError(ex.getMessage());
            }
        }
        return script;
    }

    public synchronized void load() {
        try {
            this._cache.load(this._scriptsFileName, this.getClass().getClassLoader());
        }
        catch (FileNotFoundException fileNotFoundException) {
        }
        catch (XMLException ex) {
            String msg = "Error loading scripts file: " + this._scriptsFileName;
            s_log.error((Object)msg, (Throwable)ex);
            this._plugin.getApplication().showErrorDialog(msg, (Throwable)ex);
        }
        catch (DuplicateObjectException ex) {
            String msg = "Error loading scripts file: " + this._scriptsFileName;
            s_log.error((Object)msg, (Throwable)ex);
            this._plugin.getApplication().showErrorDialog(msg, (Throwable)ex);
        }
    }

    public synchronized void save() {
        try {
            this._cache.save(this._scriptsFileName);
        }
        catch (IOException ex) {
            String msg = "Error occurred saving scripts to " + this._scriptsFileName;
            s_log.error((Object)msg, (Throwable)ex);
            this._plugin.getApplication().showErrorDialog(msg, (Throwable)ex);
        }
        catch (XMLException ex) {
            String msg = "Error occurred saving scripts to " + this._scriptsFileName;
            s_log.error((Object)msg, (Throwable)ex);
            this._plugin.getApplication().showErrorDialog(msg, (Throwable)ex);
        }
    }
}

