/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rtextfilechooser;

import java.awt.Component;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.io.File;
import java.util.Map;
import javax.swing.Icon;
import javax.swing.JTable;
import javax.swing.SwingUtilities;
import javax.swing.table.DefaultTableCellRenderer;
import org.fife.ui.UIUtil;
import org.fife.ui.rtextfilechooser.FileTypeInfo;
import org.fife.ui.rtextfilechooser.RTextFileChooser;

class DetailsViewFileNameRenderer
extends DefaultTableCellRenderer {
    private RTextFileChooser chooser;
    private Rectangle paintTextR = new Rectangle();
    private Rectangle paintIconR = new Rectangle();
    private Rectangle paintViewR = new Rectangle();
    private boolean isAlreadyOpened;

    public DetailsViewFileNameRenderer(RTextFileChooser chooser) {
        this.chooser = chooser;
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
        File file = (File)value;
        String fileName = file.getName();
        this.isAlreadyOpened = this.chooser.isOpenedFile(file);
        this.setText(fileName);
        FileTypeInfo info = this.chooser.getFileTypeInfoFor(file);
        this.setIcon(info.icon);
        if (!isSelected) {
            if (this.chooser.getShowHiddenFiles() && file.isHidden()) {
                this.setForeground(this.chooser.getHiddenFileColor());
            } else {
                this.setForeground(info.labelTextColor);
            }
        }
        return this;
    }

    public void paintComponent(Graphics g) {
        String text = this.getText();
        Icon icon = this.getIcon();
        FontMetrics fm = g.getFontMetrics();
        this.paintViewR.y = 0;
        this.paintViewR.x = 0;
        this.paintViewR.width = this.getWidth();
        this.paintViewR.height = this.getHeight();
        g.setColor(this.getBackground());
        g.fillRect(this.paintViewR.x, this.paintViewR.y, this.paintViewR.width, this.paintViewR.height);
        this.paintIconR.height = 0;
        this.paintIconR.width = 0;
        this.paintIconR.y = 0;
        this.paintIconR.x = 0;
        this.paintTextR.height = 0;
        this.paintTextR.width = 0;
        this.paintTextR.y = 0;
        this.paintTextR.x = 0;
        String clippedText = SwingUtilities.layoutCompoundLabel(this, fm, text, icon, this.getVerticalAlignment(), this.getHorizontalAlignment(), this.getVerticalTextPosition(), this.getHorizontalTextPosition(), this.paintViewR, this.paintIconR, this.paintTextR, this.getIconTextGap());
        if (icon != null) {
            icon.paintIcon(this, g, this.paintIconR.x, this.paintIconR.y);
        }
        if (text != null) {
            Map old = UIUtil.setNativeRenderingHints((Graphics2D)g);
            int textX = this.paintTextR.x;
            int textY = this.paintTextR.y + fm.getAscent();
            g.setColor(this.getForeground());
            g.drawString(clippedText, textX, textY);
            if (this.isAlreadyOpened && this.chooser.getStyleOpenFiles()) {
                g.drawLine(textX, textY + 2, textX + this.paintTextR.width, textY + 2);
            }
            if (old != null) {
                ((Graphics2D)g).addRenderingHints(old);
            }
        }
    }
}

