/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.breadcrumbbar;

import java.awt.Color;
import javax.swing.AbstractButton;
import javax.swing.JTextField;
import javax.swing.UIManager;

class BreadcrumbBarButtonColorSet {
    public Color defaultFG;
    public Color rolloverC1;
    public Color rolloverC2;
    public Color rolloverFG;
    public Color pressedC1;
    public Color pressedC2;
    public Color pressedFG;
    public Color nonArrowArrowArmedC1;
    public Color nonArrowArrowArmedC2;
    public Color borderColor;
    private static final float BRIGHTNESS_FACTOR = 0.15f;

    BreadcrumbBarButtonColorSet() {
    }

    public static final Color brighter(Color c) {
        int r = c.getRed();
        int g = c.getGreen();
        int b = c.getBlue();
        int i = 6;
        if (r == 0 && g == 0 && b == 0) {
            return new Color(i, i, i);
        }
        if (r > 0 && r < i) {
            r = i;
        }
        if (g > 0 && g < i) {
            g = i;
        }
        if (b > 0 && b < i) {
            b = i;
        }
        return new Color(Math.min((int)((float)r / 0.85f), 255), Math.min((int)((float)g / 0.85f), 255), Math.min((int)((float)b / 0.85f), 255));
    }

    public static final Color darker(Color c) {
        float factor = 0.85f;
        float r = (float)c.getRed() * 0.85f;
        float g = (float)c.getGreen() * 0.85f;
        float b = (float)c.getBlue() * 0.85f;
        return new Color((int)r, (int)g, (int)b);
    }

    public void initialize(AbstractButton b) {
        JTextField textField = new JTextField();
        Color highlight = textField.getSelectionColor();
        this.rolloverC1 = BreadcrumbBarButtonColorSet.brighter(highlight);
        this.rolloverC2 = highlight;
        this.pressedC1 = highlight;
        this.pressedC2 = BreadcrumbBarButtonColorSet.darker(this.pressedC1);
        this.rolloverFG = this.pressedFG = textField.getSelectedTextColor();
        this.nonArrowArrowArmedC1 = this.rolloverC1;
        this.nonArrowArrowArmedC2 = this.rolloverC2;
        this.borderColor = BreadcrumbBarButtonColorSet.darker(this.pressedC2);
        this.defaultFG = textField.getForeground();
        if (BreadcrumbBarButtonColorSet.needsExtraBrightening(textField)) {
            this.rolloverC1 = BreadcrumbBarButtonColorSet.brighter(this.rolloverC1);
            this.rolloverC2 = BreadcrumbBarButtonColorSet.brighter(this.rolloverC2);
            this.pressedC1 = BreadcrumbBarButtonColorSet.brighter(this.pressedC1);
            this.pressedC2 = BreadcrumbBarButtonColorSet.brighter(this.pressedC2);
            this.nonArrowArrowArmedC1 = BreadcrumbBarButtonColorSet.brighter(this.nonArrowArrowArmedC1);
            this.nonArrowArrowArmedC2 = BreadcrumbBarButtonColorSet.brighter(this.nonArrowArrowArmedC2);
        }
    }

    private static final boolean needsExtraBrightening(JTextField textField) {
        String laf = UIManager.getLookAndFeel().getClass().getName();
        return laf.endsWith(".WindowsLookAndFeel") && Color.white.equals(textField.getBackground()) || laf.endsWith(".NimbusLookAndFeel");
    }
}

