/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.squirrel_sql.plugins.syntax;

import java.util.HashMap;
import javax.swing.Action;
import javax.swing.KeyStroke;
import net.sourceforge.squirrel_sql.client.IApplication;
import net.sourceforge.squirrel_sql.client.action.ActionCollection;
import net.sourceforge.squirrel_sql.client.gui.session.ToolsPopupAccessor;
import net.sourceforge.squirrel_sql.client.session.ISQLEntryPanel;
import net.sourceforge.squirrel_sql.client.session.ISQLPanelAPI;
import net.sourceforge.squirrel_sql.client.shortcut.ShortcutUtil;
import net.sourceforge.squirrel_sql.plugins.syntax.CommentAction;
import net.sourceforge.squirrel_sql.plugins.syntax.ConfigureAutoCorrectAction;
import net.sourceforge.squirrel_sql.plugins.syntax.DuplicateLineAction;
import net.sourceforge.squirrel_sql.plugins.syntax.FindAction;
import net.sourceforge.squirrel_sql.plugins.syntax.FindSelectedAction;
import net.sourceforge.squirrel_sql.plugins.syntax.GoToLineAction;
import net.sourceforge.squirrel_sql.plugins.syntax.MarkSelectedAction;
import net.sourceforge.squirrel_sql.plugins.syntax.RepeatLastFindAction;
import net.sourceforge.squirrel_sql.plugins.syntax.ReplaceAction;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPlugin;
import net.sourceforge.squirrel_sql.plugins.syntax.SyntaxPluginResources;
import net.sourceforge.squirrel_sql.plugins.syntax.UncommentAction;
import net.sourceforge.squirrel_sql.plugins.syntax.UnmarkAction;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirreLRSyntaxTextAreaUI;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.SquirrelRSyntaxTextArea;
import net.sourceforge.squirrel_sql.plugins.syntax.rsyntax.action.SquirrelCopyAsRtfAction;

public class ToolsPopupHandler {
    private SyntaxPlugin _syntaxPugin;

    ToolsPopupHandler(SyntaxPlugin syntaxPugin) {
        this._syntaxPugin = syntaxPugin;
    }

    void initToolsPopup(HashMap<String, Object> props, ISQLEntryPanel isqlEntryPanel) {
        ToolsPopupAccessor tpa = (ToolsPopupAccessor)props.get(ToolsPopupAccessor.class.getName());
        if (null == tpa) {
            return;
        }
        SyntaxPluginResources rsrc = this._syntaxPugin.getResources();
        IApplication app = this._syntaxPugin.getApplication();
        tpa.addToToolsPopup(SyntaxPlugin.i18n.FIND, (Action)((Object)new FindAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.FIND_SELECTED, (Action)((Object)new FindSelectedAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.REPEAT_LAST_FIND, (Action)((Object)new RepeatLastFindAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.MARK_SELECTED, (Action)((Object)new MarkSelectedAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.REPLACE, (Action)((Object)new ReplaceAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.UNMARK, (Action)((Object)new UnmarkAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.GO_TO_LINE, (Action)((Object)new GoToLineAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.AUTO_CORR, (Action)((Object)new ConfigureAutoCorrectAction(app, rsrc, this._syntaxPugin)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.DUP_LINE, (Action)((Object)new DuplicateLineAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.COMMENT, (Action)((Object)new CommentAction(app, rsrc, isqlEntryPanel)));
        tpa.addToToolsPopup(SyntaxPlugin.i18n.UNCOMMENT, (Action)((Object)new UncommentAction(app, rsrc, isqlEntryPanel)));
        if (isqlEntryPanel.getTextComponent() instanceof SquirrelRSyntaxTextArea) {
            SquirrelRSyntaxTextArea rsEdit = (SquirrelRSyntaxTextArea)((Object)isqlEntryPanel.getTextComponent());
            Action toUpperAction = SquirreLRSyntaxTextAreaUI.getActionForName(rsEdit, "RTA.UpperCaseAction");
            toUpperAction.putValue("SQuirreLAcceleratorString", ShortcutUtil.getKeystrokeString((KeyStroke)SquirreLRSyntaxTextAreaUI.getToUpperCaseKeyStroke()));
            tpa.addToToolsPopup(SyntaxPlugin.i18n.TO_UPPER_CASE, toUpperAction);
            Action toLowerAction = SquirreLRSyntaxTextAreaUI.getActionForName(rsEdit, "RTA.LowerCaseAction");
            toLowerAction.putValue("SQuirreLAcceleratorString", ShortcutUtil.getKeystrokeString((KeyStroke)SquirreLRSyntaxTextAreaUI.getToLowerCaseKeyStroke()));
            tpa.addToToolsPopup(SyntaxPlugin.i18n.TO_LOWER_CASE, toLowerAction);
            tpa.addToToolsPopup(SyntaxPlugin.i18n.COPY_AS_RTF, this._syntaxPugin.getApplication().getActionCollection().get(SquirrelCopyAsRtfAction.class));
        }
    }

    void initToolsPopup(ActionCollection coll, ISQLPanelAPI sqlPanelAPI) {
        sqlPanelAPI.addToToolsPopUp(SyntaxPlugin.i18n.FIND, coll.get(FindAction.class));
        sqlPanelAPI.addToToolsPopUp(SyntaxPlugin.i18n.FIND_SELECTED, coll.get(FindSelectedAction.class));
        sqlPanelAPI.addToToolsPopUp(SyntaxPlugin.i18n.REPEAT_LAST_FIND, coll.get(RepeatLastFindAction.class));
        sqlPanelAPI.addToToolsPopUp(SyntaxPlugin.i18n.MARK_SELECTED, coll.get(MarkSelectedAction.class));
        sqlPanelAPI.addToToolsPopUp(SyntaxPlugin.i18n.REPLACE, coll.get(ReplaceAction.class));
        sqlPanelAPI.addToToolsPopUp(SyntaxPlugin.i18n.UNMARK, coll.get(UnmarkAction.class));
        sqlPanelAPI.addToToolsPopUp(SyntaxPlugin.i18n.GO_TO_LINE, coll.get(GoToLineAction.class));
        sqlPanelAPI.addToToolsPopUp(SyntaxPlugin.i18n.AUTO_CORR, coll.get(ConfigureAutoCorrectAction.class));
        sqlPanelAPI.addToToolsPopUp(SyntaxPlugin.i18n.DUP_LINE, coll.get(DuplicateLineAction.class));
        sqlPanelAPI.addToToolsPopUp(SyntaxPlugin.i18n.COMMENT, coll.get(CommentAction.class));
        sqlPanelAPI.addToToolsPopUp(SyntaxPlugin.i18n.UNCOMMENT, coll.get(UncommentAction.class));
        if (sqlPanelAPI.getSQLEntryPanel().getTextComponent() instanceof SquirrelRSyntaxTextArea) {
            SquirrelRSyntaxTextArea rsEdit = (SquirrelRSyntaxTextArea)((Object)sqlPanelAPI.getSQLEntryPanel().getTextComponent());
            Action toUpperAction = SquirreLRSyntaxTextAreaUI.getActionForName(rsEdit, "RTA.UpperCaseAction");
            toUpperAction.putValue("SQuirreLAcceleratorString", ShortcutUtil.getKeystrokeString((KeyStroke)SquirreLRSyntaxTextAreaUI.getToUpperCaseKeyStroke()));
            sqlPanelAPI.addToToolsPopUp(SyntaxPlugin.i18n.TO_UPPER_CASE, toUpperAction);
            Action toLowerAction = SquirreLRSyntaxTextAreaUI.getActionForName(rsEdit, "RTA.LowerCaseAction");
            toLowerAction.putValue("SQuirreLAcceleratorString", ShortcutUtil.getKeystrokeString((KeyStroke)SquirreLRSyntaxTextAreaUI.getToLowerCaseKeyStroke()));
            sqlPanelAPI.addToToolsPopUp(SyntaxPlugin.i18n.TO_LOWER_CASE, toLowerAction);
            sqlPanelAPI.addToToolsPopUp(SyntaxPlugin.i18n.COPY_AS_RTF, this._syntaxPugin.getApplication().getActionCollection().get(SquirrelCopyAsRtfAction.class));
        }
    }
}

